/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextProcessorExtension;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import com.ibm.pdp.pacbase.extension.matching.TextAnalyzerAnalysisData;
import java.util.HashMap;
import java.util.Stack;

public abstract class PacSpecificTextAnalyzer
implements ITextAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String CR = System.getProperty("line.separator");
    protected static final String PROC_DIV = String.valueOf(CR) + "       PROCEDURE DIVISION";
    protected static final String GENERATED_FUNCTION_CST = "gen_function";
    protected IGeneratedInfo _generatedInfo;
    protected CharSequence _text;
    protected IEditTree _editTree;
    protected ITextProcessor _textProcessor;
    protected TextAnalyzerAnalysisData _textAnalyzerAnalysisData;
    protected HashMap<String, String> _generatedFunctionsToDiscard;
    protected HashMap<String, String> _generatedFunctionsTagNames;
    private String _textAnalyzed_InCommonAnalyzer;
    private HashMap<String, String> _functionsLevels;
    ITextProcessorExtension _textProcessorExtension;
    private Stack<Integer> _levels;

    public PacSpecificTextAnalyzer(ITextProcessorExtension textProcessorExtension) {
        this._textProcessorExtension = textProcessorExtension;
        if (textProcessorExtension != null) {
            this._generatedInfo = textProcessorExtension.getGeneratedInfo();
        }
        this._textAnalyzerAnalysisData = new TextAnalyzerAnalysisData();
    }

    public void setGeneratedInfo(IGeneratedInfo genInfo) {
        this._generatedInfo = genInfo;
    }

    public IEditTree getEditTree() {
        return this._editTree;
    }

    public CharSequence getText() {
        return this._text;
    }

    public abstract ITextScanner newScanner(int var1, int var2);

    public void setEditTree(IEditTree newEditTree) {
        this._editTree = newEditTree;
        this._textProcessor = newEditTree.getTextProcessor();
        if (this._textProcessor.getGeneratedInfo() != this._generatedInfo) {
            this.setGeneratedInfo(this._textProcessor.getGeneratedInfo());
        }
    }

    public void setText(CharSequence newText) {
        this._text = newText;
        if (!this._text.toString().equals(this._textAnalyzed_InCommonAnalyzer)) {
            this.determineFunctionsLevels();
            this._textAnalyzed_InCommonAnalyzer = this._text.toString();
        }
    }

    public void textChanged(int index, int nbRemoved, int nbAdded) {
        this.determineFunctionsLevels();
        this._textAnalyzed_InCommonAnalyzer = this._text.toString();
    }

    public ITextProcessor getTextProcessor() {
        return this._textProcessor;
    }

    protected void updateLevelsMap(String label, String level) {
        String a;
        if (Trace.traceOn && (a = this._functionsLevels.get(label)) != null) {
            Trace.errPrintln((String)("PacSpecificTextAnalyzer.updateLevelsMap(String, String) : Duplicate function " + label + " (level=" + level + ")"));
        }
        this._functionsLevels.put(label, level);
    }

    protected void setLevel(PacLabel label, String currentLine) {
        String level;
        String string = level = currentLine.length() < 72 ? null : currentLine.subSequence(72, currentLine.length()).toString().replace("\r", "").replace("\n", "").trim();
        if (level != null && level.startsWith("lv")) {
            level = level.substring(2, level.length());
            try {
                int newLevel = Integer.parseInt(level);
                if (!this._levels.isEmpty()) {
                    this._levels.pop();
                }
                this._levels.push(newLevel);
                this.updateLevelsMap(label.getPacLabel(), level);
            }
            catch (NumberFormatException numberFormatException) {
                level = this.getLevel();
            }
        } else {
            level = this.getLevel();
        }
    }

    private String getLevel() {
        if (this._levels.isEmpty()) {
            return "05";
        }
        int level = this._levels.peek();
        if (level < 10) {
            return String.valueOf('0') + Integer.toString(level);
        }
        return Integer.toString(level);
    }

    protected void incLevel(PacLabel pacLabel) {
        if (this._levels.isEmpty()) {
            if (pacLabel.getPacLabel().length() == 3) {
                this._levels.push(5);
            } else {
                this._levels.push(10);
            }
        } else if (pacLabel.getPacLabel().length() == 3) {
            this._levels.clear();
            this._levels.push(5);
        } else {
            int level = this._levels.peek() + 5;
            this._levels.push(level);
        }
    }

    protected void decLevel(PacLabel pacLabel) {
        if (pacLabel.getPacLabel().length() == 3 && !pacLabel.isBeginningLabel()) {
            this._levels.clear();
            return;
        }
        if (!this._levels.isEmpty()) {
            this._levels.pop();
        }
    }

    protected void determineFunctionsLevels() {
        long a = System.currentTimeMillis();
        String text = this._text.toString();
        int counter = 0;
        int beginIndex = text.indexOf(PROC_DIV);
        if (beginIndex != -1) {
            counter = beginIndex;
        }
        this._levels = new Stack();
        this._functionsLevels = new HashMap();
        while (counter < text.length()) {
            int endLineOffset = PdpTool.getLineEndOffset((CharSequence)text, (int)counter);
            String line = text.subSequence(counter, endLineOffset).toString();
            PacLabel label = BasicPacLabelRecognizer.findPacbaseLabelInLine(line);
            if (label == null) {
                counter = endLineOffset;
                continue;
            }
            if (label.isBeginningLabel) {
                this.incLevel(label);
                this.setLevel(label, line);
            } else {
                this.decLevel(label);
            }
            counter = endLineOffset;
        }
        this._textAnalyzerAnalysisData.setFunctionsLevels(this._functionsLevels);
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("PacSpecificTextAnalyzer.determineFunctionsLevels() Elapsed : " + (b - a)));
        }
    }
}

