/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.draft.api.PdpTextProcessor;
import com.ibm.pdp.engine.extension.ITextProcessorExtension;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import com.ibm.pdp.pacbase.extension.matching.PacSpecificScreenTextWrappingScanner;
import com.ibm.pdp.pacbase.extension.matching.PacSpecificTextAnalyzer;
import java.util.HashMap;
import java.util.Iterator;

public class PacSpecificScreenTextAnalyzer
extends PacSpecificTextAnalyzer {
    private static final String _PROCEDURE = "PROCEDURE";
    private String _textAnalyzed_InScreenAnalyzer;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacSpecificScreenTextAnalyzer(ITextProcessorExtension textProcessorExtension) {
        super(textProcessorExtension);
    }

    @Override
    public ITextScanner newScanner(int beginIdx, int endIdx) {
        PacSpecificScreenTextWrappingScanner stws = new PacSpecificScreenTextWrappingScanner(this._generatedInfo, this, beginIdx, endIdx, this._textAnalyzerAnalysisData);
        return stws;
    }

    @Override
    public void setText(CharSequence newText) {
        super.setText(newText);
        if (!this._text.toString().equals(this._textAnalyzed_InScreenAnalyzer)) {
            this.searchForGeneratedFunctions();
            this._textAnalyzed_InScreenAnalyzer = this._text.toString();
        }
    }

    @Override
    public void setGeneratedInfo(IGeneratedInfo genInfo) {
        super.setGeneratedInfo(genInfo);
        this.searchForTagNames();
    }

    private boolean isFunction(IGeneratedTag tag) {
        if (tag == null) {
            return false;
        }
        String level = tag.getProperty("level");
        if (level == null) {
            return false;
        }
        if (level.equals("05")) {
            return false;
        }
        return level.indexOf(46) == -1;
    }

    private void buildTagsList(IGeneratedTag parent) {
        if (parent == null) {
            return;
        }
        String name = parent.getName();
        if (this.isFunction(parent) && name.length() > 3 && (name.startsWith("F20") || name.startsWith("F25") || name.startsWith("F35") || name.startsWith("F60") || name.startsWith("F65"))) {
            String text = this._generatedInfo.getText().subSequence(parent.getBeginIndex(), parent.getEndIndex()).toString();
            int counter = 0;
            while (counter < text.length()) {
                int endLineOffset = PdpTool.getLineEndOffset((CharSequence)text, (int)counter);
                String line = text.subSequence(counter, endLineOffset).toString();
                PacLabel aLbl = BasicPacLabelRecognizer.findPacbaseLabelInLine(line);
                if (aLbl != null) {
                    if (aLbl.getPacLabel().equals(name)) break;
                    this._generatedFunctionsTagNames.put(aLbl.getPacLabel(), name);
                    break;
                }
                counter = endLineOffset;
            }
        }
        Iterator sons = parent.sons();
        IGeneratedTag aTag = null;
        while (sons.hasNext()) {
            aTag = (IGeneratedTag)sons.next();
            this.buildTagsList(aTag);
        }
    }

    private IGeneratedTag getProcDivTag(IGeneratedTag parent) {
        if (parent == null) {
            return null;
        }
        IGeneratedTag aTag = null;
        Iterator sons = parent.sons();
        while (sons.hasNext()) {
            aTag = (IGeneratedTag)sons.next();
            if (!aTag.getName().equals(_PROCEDURE)) continue;
            return aTag;
        }
        return null;
    }

    private void searchForTagNames() {
        long a = System.currentTimeMillis();
        this._generatedFunctionsTagNames = new HashMap();
        if (this._generatedInfo == null) {
            return;
        }
        IGeneratedTag pdTag = this.getProcDivTag(this._generatedInfo.getRootTag());
        if (pdTag == null) {
            return;
        }
        this._generatedFunctionsTagNames = new HashMap();
        this.buildTagsList(pdTag);
        this._textAnalyzerAnalysisData.setGeneratedFunctionsTagNames(this._generatedFunctionsTagNames);
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("PacSpecificScreenTextAnalyzer.searchForTagNames() Elapsed : " + (b - a)));
        }
    }

    private void searchForGeneratedFunctions() {
    }

    public static void main(String[] args) {
        PacSpecificScreenTextAnalyzer x = new PacSpecificScreenTextAnalyzer(null);
        String s = PdpTool.readFileContents((String)"D:/tmp/TesteursAnalyseurSpecifiques/VR00CV.cbl");
        new PdpTextProcessor();
        x.setText(s);
        int endIdx = s.length();
        ITextScanner z = x.newScanner(0, endIdx);
        while (z.scan()) {
            System.out.println("label :" + z.getTagName());
        }
        System.out.println("Termin\u00e9");
    }
}

