/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.extension.matching.PacProgramCommentsDetection;

public class PacScreenCommentsDetection {
    private static String[] SPECIAL_FUNCTIONS = new String[]{"01", "05", "10", "15", "20", "25", "30", "35", "40", "50", "55", "60", "65", "70", "8Z", "80", "81"};
    private static String COMMENT_START = "      *           *";
    private static String REPLACE = "      *@REPLACE";
    private static String BEFORE = "      *@BEFORE";
    private static String AFTER = "      *@AFTER";
    private static String BEGINNING = "      *@BEGINNING";
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static boolean belongsToSpecialFunctions(String functionName) {
        int i = 0;
        while (i < SPECIAL_FUNCTIONS.length) {
            if (SPECIAL_FUNCTIONS[i].equals(functionName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int[] searchForRelativeTag(int debut, String pacLabel, CharSequence text, int counter, int begin, int end) {
        int[] result = new int[2];
        if (debut > begin) {
            String line;
            int a = PdpTool.getLineStartOffset((CharSequence)text, (int)(debut - 2));
            int b = PdpTool.getLineEndOffset((CharSequence)text, (int)a);
            if (a >= begin && (line = text.subSequence(a, b).toString()).length() > 12 && (line.startsWith(REPLACE) || line.startsWith(AFTER) || line.startsWith(BEFORE) || line.startsWith(BEGINNING))) {
                result[0] = a;
                result[1] = b;
                return result;
            }
        }
        return new int[0];
    }

    public static int[] searchForAComment(String pacLabel, CharSequence text, int counter, int begin, int end) {
        int[] result = PacProgramCommentsDetection.searchForAComment(pacLabel, text, counter, begin, end);
        int debut = -1;
        if (result != null && result.length == 2) {
            debut = result[0];
            int[] result2 = PacScreenCommentsDetection.searchForRelativeTag(debut, pacLabel, text, counter, begin, end);
            if (result2.length > 0) {
                return result2;
            }
            return result;
        }
        debut = counter - 2;
        int[] result2 = PacScreenCommentsDetection.searchForRelativeTag(debut, pacLabel, text, counter, begin, end);
        if (result2.length > 0) {
            return result2;
        }
        String functionNum = pacLabel.substring(1, 3);
        if (!PacScreenCommentsDetection.belongsToSpecialFunctions(functionNum)) {
            return new int[0];
        }
        result = new int[2];
        int idx = counter - 2;
        int endLineOffset = -1;
        int nbOfLinesStepped = 0;
        while (idx >= begin) {
            String line;
            idx = PdpTool.getLineStartOffset((CharSequence)text, (int)idx);
            endLineOffset = PdpTool.getLineEndOffset((CharSequence)text, (int)idx);
            if (idx < begin || (line = text.subSequence(idx, endLineOffset).toString()).length() <= 20 || !line.startsWith(COMMENT_START)) break;
            result[0] = idx;
            result[1] = endLineOffset;
            idx -= 2;
            if (++nbOfLinesStepped >= 5) break;
        }
        if (nbOfLinesStepped > 0) {
            return result;
        }
        return new int[0];
    }
}

