/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.extension.ConstraintType;
import com.ibm.pdp.engine.extension.ITextMatcher;
import com.ibm.pdp.engine.extension.ITextMatcherConstraints;
import com.ibm.pdp.engine.extension.ITextMatcherContext;
import com.ibm.pdp.mdl.link.design.Util;
import com.ibm.pdp.pacbase.extension.matching.ITagExtremity2;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PacSQLPlacementCalculator
implements ITextMatcher {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ITextMatcherContext _context;
    protected List<ITagExtremity2> _tagsList;
    private ArrayList<ExecMark> execMarks;
    private static final String EXEC = "EXEC";
    private static final String END_EXEC = "END-EXEC";
    private static final String SQL = "SQL";

    public PacSQLPlacementCalculator(List<ITagExtremity2> tagsList, ITextMatcherContext context) {
        this._context = context;
        this._tagsList = tagsList;
    }

    public void determineConstraints(ITextMatcherContext context, ITextMatcherConstraints constraints) {
        String textPart = context.getAllText().subSequence(context.getTextBeginIndex(), context.getTextEndIndex()).toString();
        ArrayList<int[]> execLines = this.buildExecLines(textPart);
        if (execLines.size() == 0) {
            return;
        }
        this.buildExecMarks(context, textPart, execLines);
        this.filterSQLExecMarks();
        this.analyse(context, constraints);
    }

    private void analyse(ITextMatcherContext context, ITextMatcherConstraints constraints) {
        if (this.execMarks == null || this.execMarks.size() == 0 || this._tagsList == null || this._tagsList.size() == 0) {
            return;
        }
        context.getAllText().subSequence(context.getTextBeginIndex(), context.getTextEndIndex()).toString();
        if (this.execMarks.size() == 1) {
            if (this._tagsList.size() == 1) {
                if (!this._tagsList.get(0).isTagStart() && !this.execMarks.get(0)._isExec) {
                    constraints.setTagExtremity(this._tagsList.get(0).getTag(), false, this.execMarks.get(0)._lineEndOffset + context.getTextBeginIndex(), ConstraintType.Equal);
                    return;
                }
                if (this._tagsList.get(0).isTagStart() && this.execMarks.get(0).isExec()) {
                    constraints.setTagExtremity(this._tagsList.get(0).getTag(), true, this.execMarks.get(0)._lineStartOffset + context.getTextBeginIndex(), ConstraintType.Equal);
                    return;
                }
                return;
            }
            if (!this.execMarks.get(0)._isExec) {
                ITagExtremity2 currentCandidate = null;
                for (ITagExtremity2 extremity : this._tagsList) {
                    if (extremity.isTagStart()) continue;
                    if (currentCandidate != null) {
                        currentCandidate = null;
                        break;
                    }
                    currentCandidate = extremity;
                }
                if (currentCandidate != null) {
                    constraints.setTagExtremity(currentCandidate.getTag(), false, this.execMarks.get(0)._lineEndOffset + context.getTextBeginIndex(), ConstraintType.Equal);
                    return;
                }
            } else {
                ITagExtremity2 currentCandidate = null;
                for (ITagExtremity2 extremity : this._tagsList) {
                    if (!extremity.isTagStart()) continue;
                    if (currentCandidate != null) {
                        currentCandidate = null;
                        break;
                    }
                    currentCandidate = extremity;
                }
                if (currentCandidate != null) {
                    constraints.setTagExtremity(currentCandidate.getTag(), true, this.execMarks.get(0)._lineEndOffset + context.getTextBeginIndex(), ConstraintType.Equal);
                    return;
                }
            }
            return;
        }
        if (this._tagsList.size() == 1) {
            if (this._tagsList.get(0).isTagStart()) {
                ExecMark currentCandidate = null;
                for (ExecMark mark : this.execMarks) {
                    if (!mark.isExec()) continue;
                    if (currentCandidate != null) {
                        currentCandidate = null;
                        break;
                    }
                    currentCandidate = mark;
                }
                if (currentCandidate != null) {
                    constraints.setTagExtremity(this._tagsList.get(0).getTag(), true, context.getTextBeginIndex(), ConstraintType.LowerThan);
                }
            } else {
                ExecMark currentCandidate = null;
                for (ExecMark mark : this.execMarks) {
                    if (mark.isExec()) continue;
                    if (currentCandidate != null) {
                        currentCandidate = null;
                        break;
                    }
                    currentCandidate = mark;
                }
                if (currentCandidate != null) {
                    constraints.setTagExtremity(this._tagsList.get(0).getTag(), false, currentCandidate._lineEndOffset + context.getTextBeginIndex(), ConstraintType.Equal);
                }
            }
            return;
        }
        if (this._tagsList.size() == 2 && this.execMarks.size() == 2) {
            if (this._tagsList.get(0).isTagStart() && this.execMarks.get(0).isExec() && !this._tagsList.get(1).isTagStart() && !this.execMarks.get(1)._isExec) {
                constraints.setTagExtremity(this._tagsList.get(0).getTag(), false, this.execMarks.get(1)._lineEndOffset + context.getTextBeginIndex(), ConstraintType.Equal);
            }
            return;
        }
    }

    private ArrayList<int[]> buildExecLines(String textPart) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int execIndex = textPart.indexOf(EXEC);
        while (execIndex != -1) {
            int[] line = new int[2];
            int lineStartOffset = Util.getLineStartOffset((CharSequence)textPart, (int)execIndex);
            int lineEndOffset = Util.getLineEndOffset((CharSequence)textPart, (int)execIndex);
            line[0] = lineStartOffset;
            line[1] = lineEndOffset;
            result.add(line);
            execIndex = textPart.indexOf(EXEC, lineEndOffset);
        }
        return result;
    }

    private void filterSQLExecMarks() {
        if (this.execMarks == null || this.execMarks.size() == 0) {
            return;
        }
        int i = this.execMarks.size() - 1;
        while (i >= 0) {
            if (!this.execMarks.get(i).isSQL()) {
                this.execMarks.remove(i);
            }
            --i;
        }
    }

    private void buildExecMarks(ITextMatcherContext context, String textPart, ArrayList<int[]> execLines) {
        this.execMarks = new ArrayList();
        boolean isJustAfterExec = false;
        for (int[] execLine : execLines) {
            String[] tokens;
            String line = textPart.substring(execLine[0], execLine[1]);
            String[] stringArray = tokens = this.getTokens(line);
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token.equals(EXEC)) {
                    this.execMarks.add(new ExecMark(execLine[0], execLine[1], true));
                    isJustAfterExec = true;
                } else if (token.equals(END_EXEC)) {
                    ExecMark end_execMark = new ExecMark(execLine[0], execLine[1], false);
                    if (this.execMarks.size() == 0) {
                        ExecMark execMarkBeforeWorkingArea = this.getExecMarkBeforeWorkingArea(context);
                        if (execMarkBeforeWorkingArea != null) {
                            end_execMark.setSQL(execMarkBeforeWorkingArea.isSQL());
                        }
                    } else {
                        ExecMark lastExecMark = this.execMarks.get(this.execMarks.size() - 1);
                        if (lastExecMark.isExec() && lastExecMark.isSQL()) {
                            end_execMark.setSQL(true);
                        }
                    }
                    this.execMarks.add(end_execMark);
                    isJustAfterExec = false;
                } else if (token.equals(SQL)) {
                    if (isJustAfterExec) {
                        this.execMarks.get(this.execMarks.size() - 1).setSQL(true);
                        isJustAfterExec = false;
                    }
                } else {
                    isJustAfterExec = false;
                }
                ++n2;
            }
            if (!isJustAfterExec) continue;
            int nextLineEndOffset = Util.getLineEndOffset((CharSequence)textPart, (int)execLine[1]);
            line = textPart.substring(execLine[1], nextLineEndOffset);
            if (line.length() > 72) {
                line = line.substring(0, 72);
            }
            if (!line.trim().startsWith(SQL)) continue;
            this.execMarks.get(this.execMarks.size() - 1).setSQL(true);
            isJustAfterExec = false;
        }
    }

    private ExecMark getExecMarkBeforeWorkingArea(ITextMatcherContext context) {
        String textPart = context.getAllText().subSequence(0, this._context.getTextBeginIndex()).toString();
        int execIndex = textPart.lastIndexOf(EXEC);
        ArrayList<int[]> execLines = new ArrayList<int[]>();
        while (execIndex != -1) {
            int[] line = new int[2];
            int lineStartOffset = Util.getLineStartOffset((CharSequence)textPart, (int)execIndex);
            int lineEndOffset = Util.getLineEndOffset((CharSequence)textPart, (int)execIndex);
            line[0] = lineStartOffset;
            line[1] = lineEndOffset;
            execLines.add(line);
            execIndex = textPart.lastIndexOf(EXEC, lineStartOffset);
        }
        if (execLines.size() == 0) {
            return null;
        }
        ExecMark result = null;
        boolean isJustAfterExec = false;
        boolean isCommandFound = false;
        for (int[] execLine : execLines) {
            String[] tokens;
            String line = textPart.substring(execLine[0], execLine[1]);
            String[] stringArray = tokens = this.getTokens(line);
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token.equals(EXEC)) {
                    result = new ExecMark(execLine[0], execLine[1], true);
                    isJustAfterExec = true;
                    isCommandFound = true;
                } else if (token.equals(END_EXEC)) {
                    isCommandFound = true;
                    result = null;
                } else if (token.equals(SQL)) {
                    if (isJustAfterExec) {
                        result.setSQL(true);
                        isJustAfterExec = false;
                    }
                } else {
                    isJustAfterExec = false;
                }
                ++n2;
            }
            if (isJustAfterExec) {
                int nextLineEndOffset = Util.getLineEndOffset((CharSequence)textPart, (int)execLine[1]);
                line = textPart.substring(execLine[1], nextLineEndOffset);
                if (line.length() > 72) {
                    line = line.substring(0, 72);
                }
                if (line.trim().startsWith(SQL)) {
                    result.setSQL(true);
                    isJustAfterExec = false;
                }
            }
            if (!isCommandFound) continue;
            return result;
        }
        return result;
    }

    private String[] getTokens(String line) {
        if (line.length() > 72) {
            line = line.substring(0, 72);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        String allDelims = " ().\r\n";
        String delimsToExclude = " \r\n";
        StringTokenizer st = new StringTokenizer(line, allDelims, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (delimsToExclude.indexOf(token) != -1) continue;
            tokens.add(token);
        }
        String[] emptyList = new String[]{};
        return tokens.toArray(emptyList);
    }

    class ExecMark {
        private int _lineStartOffset;
        private int _lineEndOffset;
        private boolean _isExec;
        private boolean _isSql;

        ExecMark(int lineStartOffset, int lineEndOffset, boolean isExec) {
            this._lineStartOffset = lineStartOffset;
            this._lineEndOffset = lineEndOffset;
            this.setExec(isExec);
        }

        public boolean isExec() {
            return this._isExec;
        }

        public void setExec(boolean _isExec) {
            this._isExec = _isExec;
        }

        boolean isSQL() {
            return this._isSql;
        }

        void setSQL(boolean isSQL) {
            this._isSql = isSQL;
        }
    }
}

