/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.framework.PdpTool;

public class PacProgramCommentsDetection {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static int[] processFunction05(String functionNum, CharSequence text, int counter, int begin, int end) {
        if (!functionNum.equals("05")) {
            throw new RuntimeException("PacProgramCommentsDetection.processFunction05 called with function " + functionNum);
        }
        int[] result = new int[2];
        int idx = counter - 2;
        if ((idx = PdpTool.getLineStartOffset((CharSequence)text, (int)idx)) < begin) {
            return new int[0];
        }
        String s = text.subSequence(idx + 6, idx + 23).toString();
        if (s.equalsIgnoreCase("*          NOTE *")) {
            result[0] = idx;
            result[1] = PdpTool.getLineEndOffset((CharSequence)text, (int)idx);
            return result;
        }
        String s2 = text.subSequence(idx + 6, idx + 13).toString().trim();
        if (s2.length() <= 0 || s2.charAt(0) != '*') {
            return new int[0];
        }
        int nbOfLinesStepped = 0;
        idx -= 2;
        while (idx >= begin) {
            if ((idx = PdpTool.getLineStartOffset((CharSequence)text, (int)idx)) < begin || (s = text.subSequence(idx + 6, idx + 7).toString().trim()).length() <= 0 || s.charAt(0) != '*') break;
            result[0] = idx;
            result[1] = PdpTool.getLineEndOffset((CharSequence)text, (int)idx);
            idx -= 2;
            ++nbOfLinesStepped;
        }
        if (nbOfLinesStepped > 0) {
            return result;
        }
        return new int[0];
    }

    public static int[] searchForAComment(String pacLabel, CharSequence text, int counter, int begin, int end) {
        int[] result = new int[2];
        String functionNum = pacLabel.substring(1);
        if (functionNum.equals("05")) {
            return PacProgramCommentsDetection.processFunction05(functionNum, text, counter, begin, end);
        }
        for (int idx = counter - 2; idx >= begin; idx -= 2) {
            if ((idx = PdpTool.getLineStartOffset((CharSequence)text, (int)idx)) >= begin) {
                String s = text.subSequence(idx + 6, idx + 13).toString().trim();
                if (s.startsWith("*N" + functionNum)) {
                    result[0] = idx;
                    result[1] = PdpTool.getLineEndOffset((CharSequence)text, (int)idx);
                    return result;
                }
                if (s.length() > 0 && s.charAt(0) == '*') {
                    continue;
                }
                return new int[0];
            }
            return new int[0];
        }
        return new int[0];
    }
}

