/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.CobolKeywordHandler;
import com.ibm.pdp.pacbase.extension.matching.ConfigurationSectionHandler;
import com.ibm.pdp.pacbase.extension.matching.DataDivisionHandler;
import com.ibm.pdp.pacbase.extension.matching.EnvironmentDivisionHandler;
import com.ibm.pdp.pacbase.extension.matching.FileSectionHandler;
import com.ibm.pdp.pacbase.extension.matching.GenTextScannerResult;
import com.ibm.pdp.pacbase.extension.matching.IdentificationDivisionHandler;
import com.ibm.pdp.pacbase.extension.matching.InputOutputSectionHandler;
import com.ibm.pdp.pacbase.extension.matching.LinkageSectionHandler;
import com.ibm.pdp.pacbase.extension.matching.OccurrenceHandler;
import com.ibm.pdp.pacbase.extension.matching.PacFunctionHandler;
import com.ibm.pdp.pacbase.extension.matching.PacGeneratedTextScanner;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import com.ibm.pdp.pacbase.extension.matching.ProcedureDivisionHandler;
import com.ibm.pdp.pacbase.extension.matching.StartPacFunctionHandler;
import com.ibm.pdp.pacbase.extension.matching.WorkingStorageSectionHandler;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.strings.search.SearchCursor;
import com.ibm.pdp.util.strings.search.SubSequenceFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PacGeneratedTextAnalyzer
implements ITextAnalyzer {
    private static final String IDENTIFICATION_DIVISION = " IDENTIFICATION DIVISION.";
    private static final String ENVIRONMENT_DIVISION = " ENVIRONMENT DIVISION.";
    private static final String CONFIGURATION_SECTION = " CONFIGURATION SECTION.";
    private static final String INPUT_OUTPUT_SECTION = " INPUT-OUTPUT SECTION.";
    private static final String DATA_DIVISION = " DATA DIVISION.";
    private static final String FILE_SECTION = " FILE SECTION.";
    private static final String WORKING_STORAGE_SECTION = " WORKING-STORAGE SECTION.";
    private static final String LINKAGE_SECTION = " LINKAGE SECTION.";
    private static final String PROCEDURE_DIVISION = " PROCEDURE DIVISION";
    public static final String IDENTIFICATION_DIVISION_TAGNAME = "IDENTIFICATION";
    public static final String ENVIRONMENT_DIVISION_TAGNAME = "ENVIRONMENT";
    public static final String CONFIGURATION_SECTION_TAGNAME = "CONFIGURATION";
    public static final String INPUT_OUTPUT_SECTION_TAGNAME = "IOSEC-FILECTRL";
    public static final String DATA_DIVISION_TAGNAME = "DATA";
    public static final String FILE_SECTION_TAGNAME = "FILE";
    public static final String WORKING_STORAGE_SECTION_TAGNAME = "WORKING";
    public static final String LINKAGE_SECTION_TAGNAME = "LINKAGE";
    public static final String PROCEDURE_DIVISION_TAGNAME = "PROCEDURE";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String PROC_DIV_LABEL_STARTLINE = String.valueOf(LINE_SEPARATOR) + "      " + " PROCEDURE DIVISION";
    private static final String LINKAGE_LABEL_STARTLINE = String.valueOf(LINE_SEPARATOR) + "      " + " LINKAGE SECTION.";
    protected IGeneratedInfo _generatedInfo;
    protected CharSequence _text;
    protected IEditTree _editTree;
    protected SubSequenceFinder<OccurrenceHandler> _finder;
    protected SearchCursor<OccurrenceHandler> _subSequencesCursor;
    protected ITextProcessor _textProcessor;
    protected boolean _isPreprocessed = false;
    protected boolean _hasReachedProcedureDivision = false;
    protected boolean _isPgmOfNatureD = false;
    protected boolean _isPgmOfNatureF = false;
    protected boolean _isPgmOfNatureS = false;
    protected boolean _isPgmOfVariantC = false;
    protected boolean _isPgmOfVariantC_Or_NatureSDF = false;
    protected String _tagName;
    protected List<GenTextScannerResult> _resultsCache;
    private Map<String, Integer> _duplicates;
    private boolean _isWorkingEncountered = false;
    private boolean _isLinkageEncountered = false;
    private boolean _isProcedureEncountered = false;
    private boolean _isWorkingClosed = false;
    private boolean _isLinkageClosed = false;
    private boolean _isDataDivClosed = false;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void setGeneratedInfo(IGeneratedInfo genInfo) {
        String prop2;
        this._generatedInfo = genInfo;
        String prop = this._generatedInfo.getProperty("variant");
        if (prop != null && PacProgramVariantValues.get((String)prop) == PacProgramVariantValues._C_LITERAL) {
            this._isPgmOfVariantC = true;
        }
        if ((prop2 = this._generatedInfo.getProperty("nature")) != null) {
            if (PacProgramStructureValues.get((String)prop2) == PacProgramStructureValues._D_LITERAL) {
                this._isPgmOfNatureD = true;
            } else if (PacProgramStructureValues.get((String)prop2) == PacProgramStructureValues._F_LITERAL) {
                this._isPgmOfNatureF = true;
            } else if (PacProgramStructureValues.get((String)prop2) == PacProgramStructureValues._S_LITERAL) {
                this._isPgmOfNatureS = true;
            }
        }
        boolean bl = this._isPgmOfVariantC_Or_NatureSDF = this._isPgmOfNatureD || this._isPgmOfNatureF || this._isPgmOfNatureS || this._isPgmOfVariantC;
        if (this._finder == null) {
            this._finder = Strings.newSubSequenceFinder();
        } else {
            this._finder.removeAllSubSequenceToFind();
        }
        this.loadGeneratedTags();
        this._isPreprocessed = false;
    }

    protected abstract PacFunctionHandler getOccurrenceHandlerForStartPacFunctionWithComments(String var1, IGeneratedTag var2);

    private void addTagToFinder(IGeneratedTag tag) {
        PacFunctionHandler pfh = null;
        String tagName = tag.getName();
        PacLabel label = BasicPacLabelRecognizer.findPacbaseLabelInTag(tagName);
        if (label != null && label.isFunction() && label.isBeginningLabel()) {
            tag.sons();
            boolean precededByAComment = true;
            if (precededByAComment) {
                pfh = this.getOccurrenceHandlerForStartPacFunctionWithComments(tagName, tag);
                this._finder.addSubSequenceToFind((CharSequence)(" " + tagName + "."), (Object)pfh);
                this._finder.addSubSequenceToFind((CharSequence)(" " + tagName.toLowerCase() + "."), (Object)pfh);
            } else {
                String tagTxt = tag.getGeneratedInfo().getText().subSequence(tag.getBeginIndex(), tag.getEndIndex()).toString();
                if (tagTxt.startsWith(tagName, 7)) {
                    pfh = new StartPacFunctionHandler(tagName, tag);
                    this._finder.addSubSequenceToFind((CharSequence)(" " + tagName + "."), (Object)pfh);
                    this._finder.addSubSequenceToFind((CharSequence)(" " + tagName.toLowerCase() + "."), (Object)pfh);
                }
            }
        }
    }

    private String getUpperOrLowerCaseValueOf(String aString, boolean isUppercase) {
        if (isUppercase) {
            return aString;
        }
        return aString.toLowerCase();
    }

    private void loadGenTags(IGeneratedTag parent) {
        CobolKeywordHandler oh = null;
        if (parent == null) {
            return;
        }
        String tagName = parent.getName();
        if (this._hasReachedProcedureDivision) {
            if (!tagName.endsWith("-BODY")) {
                this.addTagToFinder(parent);
            }
        } else if (tagName.equalsIgnoreCase(IDENTIFICATION_DIVISION_TAGNAME)) {
            oh = new IdentificationDivisionHandler(IDENTIFICATION_DIVISION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(IDENTIFICATION_DIVISION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(IDENTIFICATION_DIVISION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(ENVIRONMENT_DIVISION_TAGNAME)) {
            oh = new EnvironmentDivisionHandler(ENVIRONMENT_DIVISION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(ENVIRONMENT_DIVISION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(ENVIRONMENT_DIVISION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(CONFIGURATION_SECTION_TAGNAME)) {
            oh = new ConfigurationSectionHandler(CONFIGURATION_SECTION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(CONFIGURATION_SECTION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(CONFIGURATION_SECTION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(INPUT_OUTPUT_SECTION_TAGNAME)) {
            oh = new InputOutputSectionHandler(INPUT_OUTPUT_SECTION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(INPUT_OUTPUT_SECTION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(INPUT_OUTPUT_SECTION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(DATA_DIVISION_TAGNAME)) {
            oh = new DataDivisionHandler(DATA_DIVISION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(DATA_DIVISION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(DATA_DIVISION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(FILE_SECTION_TAGNAME)) {
            oh = new FileSectionHandler(FILE_SECTION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(FILE_SECTION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(FILE_SECTION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(WORKING_STORAGE_SECTION_TAGNAME)) {
            oh = new WorkingStorageSectionHandler(WORKING_STORAGE_SECTION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(WORKING_STORAGE_SECTION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(WORKING_STORAGE_SECTION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(LINKAGE_SECTION_TAGNAME)) {
            oh = new LinkageSectionHandler(LINKAGE_SECTION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(LINKAGE_SECTION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(LINKAGE_SECTION, false), (Object)oh);
        } else if (tagName.equalsIgnoreCase(PROCEDURE_DIVISION_TAGNAME)) {
            oh = new ProcedureDivisionHandler(PROCEDURE_DIVISION_TAGNAME, parent);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(PROCEDURE_DIVISION, true), (Object)oh);
            this._finder.addSubSequenceToFind((CharSequence)this.getUpperOrLowerCaseValueOf(PROCEDURE_DIVISION, false), (Object)oh);
            this._hasReachedProcedureDivision = true;
        }
        Iterator tags = parent.sons();
        while (tags.hasNext()) {
            IGeneratedTag child = (IGeneratedTag)tags.next();
            this.loadGenTags(child);
        }
    }

    private void loadGeneratedTags() {
        long l1 = 0L;
        if (Trace.traceOn) {
            l1 = System.currentTimeMillis();
        }
        IGeneratedTag root = this._generatedInfo.getRootTag();
        this._hasReachedProcedureDivision = false;
        this.loadGenTags(root);
        if (Trace.traceOn) {
            long l2 = System.currentTimeMillis();
            Trace.outPrintln((String)("PacGeneratedTextAnalyzer.loadGeneratedTags elapsed : " + (l2 - l1)));
        }
    }

    public IEditTree getEditTree() {
        return this._editTree;
    }

    public CharSequence getText() {
        return this._text;
    }

    public ITextScanner newScanner(int beginIdx, int endIdx) {
        if (!this._isPreprocessed) {
            this.doPreTreatment();
        }
        return new PacGeneratedTextScanner(this, beginIdx, endIdx, this._resultsCache);
    }

    private void dealWithDataDivisionPeculiarSections(OccurrenceHandler oh) {
        String tagName = oh.get_tagName();
        Integer anInt = this._duplicates.get(tagName);
        anInt = anInt == null ? new Integer(1) : Integer.valueOf(anInt + 1);
        this._duplicates.put(tagName, anInt);
        if (tagName.equalsIgnoreCase(WORKING_STORAGE_SECTION_TAGNAME)) {
            IGeneratedTag previousSectionTag = this.getTagFromName(FILE_SECTION_TAGNAME);
            if (previousSectionTag != null) {
                this.addToCache(previousSectionTag, previousSectionTag.getName(), false, oh.index(), -1, null);
            }
            this.addToCache(oh.get_tag(), oh.get_tagName(), oh.isBeginIndex(), oh.index(), -1, null);
            this._isWorkingEncountered = true;
        } else if (tagName.equalsIgnoreCase(LINKAGE_SECTION_TAGNAME)) {
            IGeneratedTag previousSectionTag = this.getTagFromName(WORKING_STORAGE_SECTION_TAGNAME);
            if (previousSectionTag == null) {
                previousSectionTag = this.getTagFromName(FILE_SECTION_TAGNAME);
            }
            if (previousSectionTag != null) {
                if (previousSectionTag.getName().equals(WORKING_STORAGE_SECTION_TAGNAME)) {
                    this._isWorkingClosed = true;
                }
                this.addToCache(previousSectionTag, previousSectionTag.getName(), false, oh.index(), -1, null);
            }
            this.addToCache(oh.get_tag(), oh.get_tagName(), oh.isBeginIndex(), oh.index(), -1, null);
            this._isLinkageEncountered = true;
        } else if (tagName.equalsIgnoreCase(PROCEDURE_DIVISION_TAGNAME)) {
            IGeneratedTag previousSectionTag = this.getTagFromName(LINKAGE_SECTION_TAGNAME);
            if (previousSectionTag == null && !this._isLinkageEncountered && (previousSectionTag = this.getTagFromName(WORKING_STORAGE_SECTION_TAGNAME)) == null && !this._isWorkingEncountered) {
                previousSectionTag = this.getTagFromName(FILE_SECTION_TAGNAME);
            }
            if (previousSectionTag != null) {
                if (previousSectionTag.getName().equals(WORKING_STORAGE_SECTION_TAGNAME)) {
                    this._isWorkingClosed = true;
                }
                if (previousSectionTag.getName().equals(LINKAGE_SECTION_TAGNAME)) {
                    this._isLinkageClosed = true;
                }
                this.addToCache(previousSectionTag, previousSectionTag.getName(), false, oh.index(), -1, null);
            }
            String dataDivTagName = DATA_DIVISION_TAGNAME;
            IGeneratedTag dataDivTag = this.getTagFromName(DATA_DIVISION_TAGNAME);
            this.addToCache(dataDivTag, dataDivTagName, false, oh.index(), -1, null);
            this._isDataDivClosed = true;
            this.addToCache(oh.get_tag(), oh.get_tagName(), oh.isBeginIndex(), oh.index(), -1, null);
            this._isProcedureEncountered = true;
        }
    }

    private IGeneratedTag getTagFromName(String name) {
        IGeneratedTag tag = PdpTool.getTagFromTagName((IGeneratedInfo)this._generatedInfo, (String)name);
        return tag;
    }

    private void closeNotCLosedTags() {
        if (!this._isProcedureEncountered) {
            IGeneratedTag atag;
            int pdOffset = this._text.toString().indexOf(PROC_DIV_LABEL_STARTLINE);
            if (pdOffset != -1) {
                IGeneratedTag atag2;
                pdOffset += LINE_SEPARATOR.length();
                int linkageOffset = this._text.toString().indexOf(LINKAGE_LABEL_STARTLINE);
                if (linkageOffset != -1) {
                    linkageOffset += LINE_SEPARATOR.length();
                    IGeneratedTag linkagetag = this.getTagFromName(LINKAGE_SECTION_TAGNAME);
                    if (linkagetag != null) {
                        IGeneratedTag atag3 = this.getTagFromName(WORKING_STORAGE_SECTION_TAGNAME);
                        if (atag3 != null) {
                            this._tagName = WORKING_STORAGE_SECTION_TAGNAME;
                            this.addToCache(atag3, this._tagName, false, linkageOffset, -1, null);
                        }
                        this._tagName = LINKAGE_SECTION_TAGNAME;
                        this.addToCache(linkagetag, this._tagName, false, pdOffset, -1, null);
                    } else {
                        IGeneratedTag atag4 = this.getTagFromName(WORKING_STORAGE_SECTION_TAGNAME);
                        if (atag4 != null) {
                            this._tagName = WORKING_STORAGE_SECTION_TAGNAME;
                            this.addToCache(atag4, this._tagName, false, pdOffset, -1, null);
                        }
                    }
                } else {
                    atag2 = this.getTagFromName(WORKING_STORAGE_SECTION_TAGNAME);
                    if (atag2 != null) {
                        this._tagName = WORKING_STORAGE_SECTION_TAGNAME;
                        this.addToCache(atag2, this._tagName, false, pdOffset, -1, null);
                    }
                }
                atag2 = this.getTagFromName(DATA_DIVISION_TAGNAME);
                if (atag2 != null) {
                    this._tagName = DATA_DIVISION_TAGNAME;
                    this.addToCache(atag2, this._tagName, false, pdOffset, -1, null);
                }
                return;
            }
            if (this._isWorkingEncountered && !this._isWorkingClosed && (atag = this.getTagFromName(WORKING_STORAGE_SECTION_TAGNAME)) != null) {
                this._tagName = WORKING_STORAGE_SECTION_TAGNAME;
                this.addToCache(atag, this._tagName, false, this._text.length(), -1, null);
            }
            if (this._isLinkageEncountered && !this._isLinkageClosed && (atag = this.getTagFromName(LINKAGE_SECTION_TAGNAME)) != null) {
                this._tagName = LINKAGE_SECTION_TAGNAME;
                this.addToCache(atag, this._tagName, false, this._text.length(), -1, null);
            }
            if ((atag = this.getTagFromName(DATA_DIVISION_TAGNAME)) != null) {
                this._tagName = DATA_DIVISION_TAGNAME;
                this.addToCache(atag, this._tagName, false, this._text.length(), -1, null);
            }
        }
    }

    private void preProcessData() {
        long aa = System.currentTimeMillis();
        this._resultsCache = new ArrayList<GenTextScannerResult>();
        this._duplicates = new HashMap<String, Integer>();
        ArrayList<String> toRemoveAtEndOfMethod = new ArrayList<String>();
        this._isWorkingEncountered = false;
        this._isLinkageEncountered = false;
        this._isProcedureEncountered = false;
        this._isWorkingClosed = false;
        this._isLinkageClosed = false;
        this._isDataDivClosed = false;
        while (this._subSequencesCursor.search()) {
            int i1 = this._subSequencesCursor.getSubSequenceBeginIndex();
            int i2 = this._subSequencesCursor.getSubSequenceEndIndex();
            if (!((OccurrenceHandler)this._subSequencesCursor.getValue()).processOccurrence(this, i1, i2)) continue;
            OccurrenceHandler oh = (OccurrenceHandler)this._subSequencesCursor.getValue();
            this._tagName = oh.get_tagName();
            Integer anInt = this._duplicates.get(this._tagName);
            if (anInt != null && anInt > 0) {
                toRemoveAtEndOfMethod.add(this._tagName);
                continue;
            }
            if ((this._tagName.equalsIgnoreCase(PROCEDURE_DIVISION_TAGNAME) || this._tagName.equalsIgnoreCase(WORKING_STORAGE_SECTION_TAGNAME) || this._tagName.equalsIgnoreCase(LINKAGE_SECTION_TAGNAME)) && !this._isPgmOfNatureS && !this._isPgmOfVariantC) {
                this.dealWithDataDivisionPeculiarSections(oh);
                continue;
            }
            this.addToCache(oh.get_tag(), oh.get_tagName(), oh.isBeginIndex(), oh.index(), -1, null);
            anInt = this._duplicates.get(oh.get_tagName());
            anInt = anInt == null ? new Integer(1) : Integer.valueOf(anInt + 1);
            this._duplicates.put(oh.get_tagName(), anInt);
        }
        this.closeNotCLosedTags();
        IGeneratedTag atag = this.getTagFromName(PROCEDURE_DIVISION_TAGNAME);
        if (atag != null) {
            this._tagName = PROCEDURE_DIVISION_TAGNAME;
            this.addToCache(atag, this._tagName, false, this._text.length(), -1, null);
        }
        int i = 0;
        while (i < toRemoveAtEndOfMethod.size()) {
            int idxToRemove;
            String s = (String)toRemoveAtEndOfMethod.get(i);
            if (s.equals(LINKAGE_SECTION_TAGNAME)) {
                int idxToRemove2 = this.findElem(this._resultsCache, WORKING_STORAGE_SECTION_TAGNAME, 2);
                if (idxToRemove2 > -1) {
                    this._resultsCache.remove(idxToRemove2);
                }
            } else if (s.equals(WORKING_STORAGE_SECTION_TAGNAME)) {
                int idxToRemove3 = this.findElem(this._resultsCache, FILE_SECTION_TAGNAME, 2);
                if (idxToRemove3 > -1) {
                    this._resultsCache.remove(idxToRemove3);
                }
            } else if (s.equals(PROCEDURE_DIVISION_TAGNAME)) {
                int idxToRemove4 = this.findElem(this._resultsCache, FILE_SECTION_TAGNAME, 2);
                if (idxToRemove4 > -1) {
                    this._resultsCache.remove(idxToRemove4);
                }
                if ((idxToRemove4 = this.findElem(this._resultsCache, WORKING_STORAGE_SECTION_TAGNAME, 2)) > -1) {
                    this._resultsCache.remove(idxToRemove4);
                }
                if ((idxToRemove4 = this.findElem(this._resultsCache, LINKAGE_SECTION_TAGNAME, 2)) > -1) {
                    this._resultsCache.remove(idxToRemove4);
                }
                if ((idxToRemove4 = this.findElem(this._resultsCache, DATA_DIVISION_TAGNAME, 2)) > -1) {
                    this._resultsCache.remove(idxToRemove4);
                }
            }
            if ((idxToRemove = this.findElem(this._resultsCache, s, 0)) > -1) {
                this._resultsCache.remove(idxToRemove);
            }
            ++i;
        }
        long bb = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("PacGeneratedTextAnalyzer.preProcessData() elapsed = " + (bb - aa)));
        }
    }

    private int findElem(List<GenTextScannerResult> list, String elem, int processExtremity) {
        int i = 0;
        while (i < list.size()) {
            GenTextScannerResult gtr = list.get(i);
            if (elem.equalsIgnoreCase(gtr.getTagName()) && (processExtremity == 0 || processExtremity == 1 && gtr.isBeginIndex() || processExtremity == 2 && !gtr.isBeginIndex)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean addToCache(IGeneratedTag tag, String tagName, boolean isBeginIndex, int beginIdx, int endIdx, Map<String, String> properties) {
        GenTextScannerResult tsr = new GenTextScannerResult(tag, tagName, isBeginIndex, beginIdx, -1, null);
        this._resultsCache.add(tsr);
        return true;
    }

    protected void doPreTreatment() {
        if (this._finder == null) {
            this._finder = Strings.newSubSequenceFinder();
        }
        this._subSequencesCursor = this._finder.newSearchCursor(this.getText());
        this.preProcessData();
        this._isPreprocessed = true;
    }

    public void setEditTree(IEditTree newEditTree) {
        this._editTree = newEditTree;
        this._textProcessor = newEditTree.getTextProcessor();
        if (this._textProcessor.getGeneratedInfo() != this._generatedInfo) {
            this.setGeneratedInfo(this._textProcessor.getGeneratedInfo());
        }
    }

    public void setText(CharSequence newText) {
        if (this._text != null && this._text.length() == newText.length() && this._text.equals(newText)) {
            return;
        }
        this._text = newText;
        this._isPreprocessed = false;
    }

    public void textChanged(int index, int nbRemoved, int nbAdded) {
        if (this._textProcessor.getGeneratedInfo() != this._generatedInfo) {
            this.setGeneratedInfo(this._textProcessor.getGeneratedInfo());
        }
        this.setText(this._textProcessor.getText());
    }

    public SearchCursor<OccurrenceHandler> getSubSequencesCursor() {
        return this._subSequencesCursor;
    }

    public ITextProcessor getTextProcessor() {
        return this._textProcessor;
    }
}

