/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.ConstraintType;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextMatcher;
import com.ibm.pdp.engine.extension.ITextMatcherConstraints;
import com.ibm.pdp.engine.extension.ITextMatcherContext;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.ITagExtremity2;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PacFunctionsPlacementCalculator
implements ITextMatcher {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String CR = PdpTool.EOL;
    protected static final String DASH_FN = "-FN";
    protected static final String EMPTY_STRING = "";
    protected static final String ZERO_TIMES3 = "000";
    protected static final String ZERO_TIMES3_FN = "000-FN";
    protected ITextMatcherContext _context;
    protected ITextMatcherConstraints _constraints;
    protected List<ITagExtremity2> _tagsList;
    protected ITextAnalyzer _textAnalyzer;
    protected List<ITagExtremity2> _filteredTagsList;
    List<PacUserFunctionExtremity> _userPacFuncList;
    protected Map<String, Integer> _allFunctions;
    protected String _patternName;
    protected boolean _isBatch = false;
    protected boolean _isServer = false;
    protected boolean _isDialogOrClient = false;
    private boolean specificPlacementForF9099 = false;
    private List<String> allSubFunctionsAlreadySeen = new ArrayList<String>();

    public PacFunctionsPlacementCalculator(List<ITagExtremity2> tagsList, ITextAnalyzer textAnalyzer, Map<String, Integer> allFunctions, ITextMatcherContext context) {
        this._tagsList = tagsList;
        this._textAnalyzer = textAnalyzer;
        this._allFunctions = allFunctions;
        this._context = context;
        IGeneratedInfo genInfo = this._context.getGeneratedInfo();
        this._patternName = genInfo.getProperty("pattern");
        if ("com.ibm.pdp.pacbase.batch".equals(this._patternName)) {
            this._isBatch = true;
        } else if ("com.ibm.pdp.pacbase.csserver".equals(this._patternName)) {
            this._isServer = true;
        } else if ("com.ibm.pdp.pacbase.dialog".equals(this._patternName) || "com.ibm.pdp.pacbase.csclient".equals(this._patternName)) {
            this._isDialogOrClient = true;
        }
    }

    private List<ITagExtremity2> clean(List<ITagExtremity2> tagsList) {
        ArrayList<ITagExtremity2> result = new ArrayList<ITagExtremity2>();
        int i = 0;
        while (i < tagsList.size()) {
            block18: {
                ITagExtremity2 tagExt;
                block19: {
                    PacLabel pl;
                    String tagName;
                    IGeneratedTag tag;
                    block17: {
                        String parentTagName;
                        tagExt = tagsList.get(i);
                        tag = tagExt.getTag();
                        if (this._isBatch && "F9099".equals(tag.getName()) && !(parentTagName = tag.getParent().getName()).equals("F90")) {
                            this.specificPlacementForF9099 = true;
                        }
                        if ((tagName = tag.getName()).charAt(0) != 'N') break block17;
                        if (tagName.length() > 3) break block18;
                        tagName = "F" + tagName.substring(1);
                    }
                    if (tagName.endsWith(ZERO_TIMES3) && tagName.length() == 6) {
                        tagName = tagName.substring(0, tagName.length() - ZERO_TIMES3.length());
                    }
                    if (tagName.endsWith(ZERO_TIMES3_FN) && tagName.length() == 9) {
                        tagName = tagName.substring(0, tagName.length() - ZERO_TIMES3_FN.length());
                    }
                    if ((tagName.length() == 8 || tagName.length() == 11) && PdpTool.isStringNumeric((String)tagName.substring(5))) {
                        tagName = tagName.substring(0, 5);
                    }
                    if ((tagName.length() == 6 || tagName.length() == 9) && PdpTool.isStringNumeric((String)tagName.substring(3))) {
                        tagName = tagName.substring(0, 3);
                    }
                    if ((pl = BasicPacLabelRecognizer.findPacbaseLabelInTag(tagName)) != null) break block19;
                    boolean keepCurrentTag = true;
                    if (this._isDialogOrClient || this._isServer) {
                        boolean f80tagToKeep = tagName.startsWith("F80-");
                        if (f80tagToKeep) {
                            boolean bl = f80tagToKeep = tagName.length() == 8 && "09.5".equals(tag.getProperty("level"));
                            if (!f80tagToKeep) {
                                boolean bl2 = f80tagToKeep = tagName.length() > 9 && tagName.indexOf("-", 4) != -1;
                                if (!f80tagToKeep) {
                                    keepCurrentTag = false;
                                }
                            }
                        } else if (tag.getProperty("level") == null) {
                            keepCurrentTag = false;
                        }
                    } else {
                        keepCurrentTag = false;
                    }
                    if (!keepCurrentTag && tag.getProperty("mp") == null) break block18;
                }
                result.add(tagExt);
            }
            ++i;
        }
        return result;
    }

    public void determineConstraints(ITextMatcherContext context, ITextMatcherConstraints constraints) {
        this.specificPlacementForF9099 = false;
        this._context = context;
        this._constraints = constraints;
        int beginIdx = this._context.getTextBeginIndex();
        int endIdx = this._context.getTextEndIndex();
        CharSequence text = this._context.getAllText();
        List<PacUserFunctionExtremity> userPacTitles = this.retrieveUserPacTitles(text, beginIdx, endIdx);
        List<PacUserFunctionExtremity> userPacFunc = this.retrieveUserPacFunctions(text, beginIdx, endIdx);
        this.analysePacTitles(text, userPacTitles, userPacFunc, this._tagsList);
        if (userPacFunc.size() == 0) {
            return;
        }
        List<ITagExtremity2> tagsList2 = this.clean(this._tagsList);
        if (tagsList2.size() == 0) {
            this.processFamilySubFunctions(userPacFunc, context, constraints);
            return;
        }
        this._filteredTagsList = tagsList2;
        this._userPacFuncList = userPacFunc;
        this.analyse();
        this.processFamilySubFunctions(userPacFunc, context, constraints);
    }

    private void processFamilySubFunctions(List<PacUserFunctionExtremity> userPacFunc, ITextMatcherContext context, ITextMatcherConstraints constraints) {
        int i = userPacFunc.size() - 1;
        while (i >= 0) {
            PacUserFunctionExtremity pfe = userPacFunc.get(i);
            String pfeFunctionName = pfe.getFuncName();
            if (!pfe.isBeginTag()) {
                String tagName;
                CharSequence allText;
                int beginingIndex;
                if (pfeFunctionName.endsWith(DASH_FN)) {
                    pfeFunctionName = pfeFunctionName.substring(0, pfeFunctionName.lastIndexOf(DASH_FN));
                }
                boolean foundBegining = false;
                int j = i - 1;
                while (j >= 0) {
                    PacUserFunctionExtremity otherPfe = userPacFunc.get(j);
                    if (otherPfe.getFuncName().equals(pfeFunctionName)) {
                        foundBegining = true;
                        break;
                    }
                    --j;
                }
                if (!foundBegining && (beginingIndex = (allText = context.getAllText()).toString().lastIndexOf("       " + pfeFunctionName + ".", pfe.getOffset() - 1)) != -1 && (tagName = context.searchTagNameForIndex(beginingIndex)) != null) {
                    for (ITagExtremity2 te : this._tagsList) {
                        if (!te.getTagName().equals(tagName) || te.isTagStart()) continue;
                        this.tracePlacementResults(pfe, true, pfe.getOffset(), te, ConstraintType.GreaterOrEqual);
                        this.addConstraint(te, pfe.getOffset(), ConstraintType.GreaterOrEqual);
                        break;
                    }
                }
            }
            --i;
        }
    }

    private void analysePacTitles(CharSequence text, List<PacUserFunctionExtremity> userPacTitles, List<PacUserFunctionExtremity> userPacFunctions, List<ITagExtremity2> generatedPacTitle) {
        int userPacFuncListSize = userPacTitles.size();
        if (userPacFuncListSize == 0) {
            return;
        }
        boolean lastUserPacFunctionFound = false;
        int i = 0;
        while (i < generatedPacTitle.size()) {
            ITagExtremity2 nextTageExt;
            ITagExtremity2 tagExt = generatedPacTitle.get(i);
            boolean constraintfound = false;
            int j = 0;
            while (j < userPacFuncListSize) {
                PacUserFunctionExtremity aUserFunctionExt = userPacTitles.get(j);
                if (aUserFunctionExt.getFuncName().equals(tagExt.getTagName()) && tagExt.isTagStart()) {
                    this.tracePlacementResults(aUserFunctionExt, false, aUserFunctionExt.getOffset(), tagExt, ConstraintType.Equal);
                    this.addConstraint(tagExt, aUserFunctionExt.getOffset(), ConstraintType.Equal);
                    constraintfound = true;
                    if (i == userPacFuncListSize - 1) {
                        lastUserPacFunctionFound = true;
                    }
                }
                if (aUserFunctionExt.getFuncName().equals(tagExt.getTagName()) && !tagExt.isTagStart()) {
                    int endOfLine = PdpTool.getLineEndOffset((CharSequence)text, (int)aUserFunctionExt.getOffset());
                    this.tracePlacementResults(aUserFunctionExt, true, endOfLine, tagExt, ConstraintType.Equal);
                    this.addConstraint(tagExt, endOfLine, ConstraintType.Equal);
                    constraintfound = true;
                    if (i == userPacFuncListSize - 1) {
                        lastUserPacFunctionFound = true;
                    }
                }
                ++j;
            }
            if (!constraintfound && tagExt.isTagStart() && i + 1 < generatedPacTitle.size() && (nextTageExt = generatedPacTitle.get(i + 1)).getTagName().equals(tagExt.getTagName()) && !nextTageExt.isTagStart()) {
                String function = "F" + tagExt.getTagName().substring(1);
                int k = 0;
                while (k < userPacFunctions.size()) {
                    PacUserFunctionExtremity aUserFunctionExt = userPacFunctions.get(k);
                    if (aUserFunctionExt.getFuncName().equals(function) && aUserFunctionExt.isBeginTag()) {
                        this.tracePlacementResults(aUserFunctionExt, false, aUserFunctionExt.getOffset(), tagExt, ConstraintType.Equal);
                        this.addConstraint(tagExt, aUserFunctionExt.getOffset(), ConstraintType.Equal);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (!lastUserPacFunctionFound && this._context.isAfterTag_aBeginExtremity()) {
            PacUserFunctionExtremity aUserFunctionExt;
            String userFunction;
            IGeneratedTag tag = this._context.getAfterTag();
            if (tag == null) {
                return;
            }
            String functionTagName = "F" + tag.getName().substring(1);
            if (functionTagName.equals(userFunction = "F" + (aUserFunctionExt = userPacTitles.get(userPacFuncListSize - 1)).getFuncName().substring(1))) {
                ITagExtremity2 lastTagOfInterval = generatedPacTitle.get(generatedPacTitle.size() - 1);
                this.tracePlacementResults(aUserFunctionExt, false, aUserFunctionExt.getOffset(), lastTagOfInterval, ConstraintType.LowerOrEqual);
                this.addConstraint(lastTagOfInterval, aUserFunctionExt.getOffset(), ConstraintType.LowerOrEqual);
            }
        }
    }

    private List<ITagExtremity2> filterGeneratedPacTitle(List<ITagExtremity2> tagsList) {
        ArrayList<ITagExtremity2> result = new ArrayList<ITagExtremity2>();
        int i = 0;
        while (i < tagsList.size()) {
            ITagExtremity2 tagExt = tagsList.get(i);
            IGeneratedTag tag = tagExt.getTag();
            String tagName = tag.getName();
            if (tagName.charAt(0) != 'N' || tagName.length() >= 5) {
                result.add(tagExt);
            }
            ++i;
        }
        return result;
    }

    private List<PacUserFunctionExtremity> retrieveUserPacTitles(CharSequence text, int beginIdx, int endIdx) {
        ArrayList<PacUserFunctionExtremity> result = new ArrayList<PacUserFunctionExtremity>();
        int counter = beginIdx;
        while (counter < endIdx) {
            CharSequence title;
            int lineEnding;
            int lineBegining = PdpTool.getLineStartOffset((CharSequence)text, (int)counter);
            CharSequence line = text.subSequence(lineBegining, lineEnding = PdpTool.getLineEndOffset((CharSequence)text, (int)counter));
            if (line.length() >= 13 && (title = line.subSequence(6, 13)).charAt(0) == '*' && title.charAt(1) == 'N' && title.charAt(6) == '.') {
                PacUserFunctionExtremity pufe = new PacUserFunctionExtremity();
                pufe.setFuncName(title.toString().substring(1, 6));
                pufe.setOffset(lineBegining);
                result.add(pufe);
            }
            counter = lineEnding;
        }
        return result;
    }

    private void tracePlacementResults(PacUserFunctionExtremity aUserFunctionExt, ITagExtremity2 tagExt, int comparisonResult) {
        if (!Trace.traceOn) {
            return;
        }
        String tagExtTagName = tagExt.getTagName();
        if (!tagExt.isTagStart()) {
            tagExtTagName = String.valueOf(tagExtTagName) + DASH_FN;
        }
        String ordre = " [UNKNOWN VALUE : " + comparisonResult + "]";
        if (comparisonResult == -1) {
            ordre = " is after ";
        } else if (comparisonResult == -2) {
            ordre = " is strictly after ";
        } else if (comparisonResult == 1) {
            ordre = " is before ";
        } else if (comparisonResult == 2) {
            ordre = " is strictly before ";
        } else if (comparisonResult == 0) {
            ordre = " is at the same place as ";
        } else if (comparisonResult == 999) {
            ordre = " cannot decide regarding ";
        }
        Trace.outPrintln((String)("PacFunctionsPlacementCalculator : Tag " + tagExtTagName + ordre + aUserFunctionExt.getFuncName() + " (" + aUserFunctionExt.getOffset() + ")"));
    }

    private void tracePlacementResults(PacUserFunctionExtremity aUserFunctionExt, boolean endOfLine, int offset, ITagExtremity2 tagExt, ConstraintType type) {
        if (!Trace.traceOn) {
            return;
        }
        String tagExtTagName = tagExt.getTagName();
        if (!tagExt.isTagStart()) {
            tagExtTagName = String.valueOf(tagExtTagName) + DASH_FN;
        }
        String ordre = EMPTY_STRING;
        if (type == ConstraintType.LowerOrEqual) {
            ordre = " is before ";
        } else if (type == ConstraintType.LowerThan) {
            ordre = " is strictly before ";
        } else if (type == ConstraintType.GreaterOrEqual) {
            ordre = " is after ";
        } else if (type == ConstraintType.GreaterThan) {
            ordre = " is strictly after ";
        } else if (type == ConstraintType.Equal) {
            ordre = " is at the same place as ";
        }
        Trace.outPrintln((String)("PacFunctionsPlacementCalculator : Tag " + tagExtTagName + ordre + aUserFunctionExt.getFuncName() + " (" + offset + ")" + (endOfLine ? "(end of line)" : EMPTY_STRING)));
    }

    protected void analyse() {
        int userPacFuncListSize = this._userPacFuncList.size();
        int i = 0;
        while (i < this._filteredTagsList.size()) {
            ITagExtremity2 tagExt = this._filteredTagsList.get(i);
            int j = 0;
            while (j < userPacFuncListSize) {
                int offset;
                PacUserFunctionExtremity aUserFunctionExt = this._userPacFuncList.get(j);
                int comparisonResult = this.compare(aUserFunctionExt, tagExt);
                if (comparisonResult == -2) {
                    this.tracePlacementResults(aUserFunctionExt, tagExt, comparisonResult);
                    this.addConstraint(tagExt, aUserFunctionExt.getOffset(), ConstraintType.GreaterOrEqual);
                } else if (comparisonResult == -1) {
                    this.tracePlacementResults(aUserFunctionExt, tagExt, comparisonResult);
                    this.addConstraint(tagExt, aUserFunctionExt.getOffset(), ConstraintType.GreaterOrEqual);
                } else if (comparisonResult == 0) {
                    this.tracePlacementResults(aUserFunctionExt, tagExt, comparisonResult);
                    this.addConstraint(tagExt, aUserFunctionExt.getOffset(), ConstraintType.Equal);
                } else if (comparisonResult == 1) {
                    offset = aUserFunctionExt.getOffset();
                    if (!aUserFunctionExt.isBeginTag()) {
                        offset = PdpTool.getLineStartOffset((CharSequence)this._context.getAllText(), (int)(offset - CR.length()));
                    }
                    this.tracePlacementResults(aUserFunctionExt, false, offset, tagExt, ConstraintType.LowerOrEqual);
                    this.addConstraint(tagExt, offset, ConstraintType.LowerOrEqual);
                } else if (comparisonResult == 2) {
                    offset = aUserFunctionExt.getOffset();
                    if (!aUserFunctionExt.isBeginTag()) {
                        offset = PdpTool.getLineStartOffset((CharSequence)this._context.getAllText(), (int)(offset - CR.length()));
                    }
                    this.tracePlacementResults(aUserFunctionExt, tagExt, comparisonResult);
                    this.addConstraint(tagExt, offset, ConstraintType.LowerOrEqual);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void addConstraint(ITagExtremity2 genTag, int offset, ConstraintType type) {
        this._constraints.setTagExtremity(genTag.getTag(), genTag.isTagStart(), offset, type);
    }

    protected void log(ITagExtremity2 tagExt, int index, ConstraintType type) {
        if (Trace.traceOn) {
            Trace.outPrintln((String)"========Constraint set================");
            String inter = "[" + tagExt.getIndex() + " ; " + tagExt.getIndex() + "]";
            Trace.outPrintln((String)("GenTag name = " + tagExt.getTagName() + inter));
            if (tagExt.isTagStart()) {
                Trace.outPrintln((String)("Begin Index is " + type + " " + index));
            } else {
                Trace.outPrintln((String)("End Index is " + type + " " + index));
            }
            Trace.outPrintln((String)"========Constraint set================");
        }
    }

    protected int compareWithDetailedLine(PacUserFunctionExtremity userFunc_v, ITagExtremity2 genFunc_v, String s1, String s2) {
        String s2Part1 = String.valueOf('F') + (s2.length() == 9 ? s2.substring(1, 3) : s2.substring(1, 5));
        Integer i1 = this._allFunctions.get(s1);
        Integer i2 = this._allFunctions.get(s2Part1);
        if (i1 != null && i2 != null) {
            if (i1 < i2) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 999;
        }
        return 999;
    }

    protected int compareWithFunctionDetailedLine(PacUserFunctionExtremity userFunc_v, ITagExtremity2 genFunc_v, String s1, String s2) {
        String s2Part1 = String.valueOf('F') + s2.substring(1, 3);
        Integer i1 = this._allFunctions.get(s1);
        Integer i2 = this._allFunctions.get(s2Part1);
        if (i1 != null && i2 != null) {
            if (i1 < i2) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 999;
        }
        return 999;
    }

    private boolean isAFunctionCommentOrTitle(String s1, String s2) {
        return s2.endsWith(ZERO_TIMES3) || s2.endsWith(ZERO_TIMES3_FN);
    }

    private boolean isBatchOrDialogOutsideRelativeFunctions(String subfunctionName) {
        if (this._isBatch) {
            return true;
        }
        if (this._isServer) {
            return false;
        }
        if (this._isDialogOrClient) {
            int s2F;
            String s2Func = subfunctionName.substring(1, 3);
            return !Character.isDigit(s2Func.charAt(0)) || !Character.isDigit(s2Func.charAt(1)) || (s2F = Integer.parseInt(s2Func)) != 20 && s2F != 25 && s2F != 30 && s2F != 35 && s2F != 60 && s2F != 65 && s2F != 80;
        }
        return false;
    }

    private int compareWithDeletedSubFunctions(PacUserFunctionExtremity userFunc_v, ITagExtremity2 genFunc_v) {
        boolean b;
        String s1 = userFunc_v.getFuncName();
        String s2 = genFunc_v.getTagName();
        if (!genFunc_v.isTagStart() && !genFunc_v.getTagName().endsWith(DASH_FN)) {
            s2 = String.valueOf(s2) + DASH_FN;
        }
        boolean bl = b = s2.length() >= 5 && s2.charAt(0) == 'F';
        if (!b) {
            return 999;
        }
        boolean currentTagFound = false;
        boolean otherEndFound = false;
        int i = 0;
        while (i < this._filteredTagsList.size()) {
            ITagExtremity2 elem = this._filteredTagsList.get(i);
            if (elem == genFunc_v) {
                currentTagFound = true;
            } else if (elem.getTagName().equals(genFunc_v.getTagName()) && elem != genFunc_v) {
                otherEndFound = true;
            }
            if (otherEndFound && currentTagFound) break;
            ++i;
        }
        if (!otherEndFound || !currentTagFound) {
            return 999;
        }
        boolean compareWithEndExtremity = s1.length() == 8 && s1.charAt(0) == 'F' && s1.endsWith(DASH_FN);
        boolean compareWithBeginExtremity = s1.length() == 5 && s1.charAt(0) == 'F' && s2.endsWith(DASH_FN);
        boolean bl2 = b = compareWithEndExtremity || compareWithBeginExtremity;
        if (!b) {
            return 999;
        }
        int a = Ebcdic.stringCompare(s1, s2);
        if (compareWithEndExtremity && a < 0) {
            if (this.isBatchOrDialogOutsideRelativeFunctions(s2)) {
                int x2;
                PacUserFunctionExtremity nextUserExt = null;
                int i2 = 0;
                while (i2 < this._userPacFuncList.size()) {
                    PacUserFunctionExtremity elem = this._userPacFuncList.get(i2);
                    if (elem.getFuncName().equals(s1)) {
                        if (i2 + 1 < this._userPacFuncList.size()) {
                            nextUserExt = this._userPacFuncList.get(i2 + 1);
                        }
                    } else if (nextUserExt != null) {
                        int x22;
                        if (nextUserExt.isBeginTag() && (x22 = Ebcdic.stringCompare(nextUserExt.getFuncName(), s2)) < 0) {
                            return 999;
                        }
                        nextUserExt = i2 + 1 < this._userPacFuncList.size() ? this._userPacFuncList.get(i2 + 1) : null;
                    }
                    ++i2;
                }
                PacUserFunctionExtremity previousUserExt = null;
                int i3 = this._userPacFuncList.size() - 1;
                while (i3 >= 0) {
                    PacUserFunctionExtremity elem = this._userPacFuncList.get(i3);
                    if (elem.getFuncName().equals(s1)) {
                        if (i3 - 1 >= 0) {
                            previousUserExt = this._userPacFuncList.get(i3 - 1);
                        }
                    } else if (previousUserExt != null) {
                        if (previousUserExt.isBeginTag()) break;
                        return 999;
                    }
                    --i3;
                }
                if (nextUserExt != null && (x2 = Ebcdic.stringCompare(nextUserExt.getFuncName(), s2)) < 0) {
                    return 999;
                }
            } else {
                int i4 = 0;
                while (i4 < this._userPacFuncList.size()) {
                    PacUserFunctionExtremity elem = this._userPacFuncList.get(i4);
                    if (!elem.getFuncName().equals(s1) && !elem.isBeginTag() && Ebcdic.stringCompare(elem.getFuncName(), s1) >= 0 && Ebcdic.stringCompare(s2, elem.getFuncName()) >= 0) {
                        return 999;
                    }
                    ++i4;
                }
            }
            int wantedOffset = PdpTool.getLineStartOffset((CharSequence)this._context.getAllText(), (int)(userFunc_v.getOffset() - CR.length()));
            this.tracePlacementResults(userFunc_v, false, wantedOffset, genFunc_v, ConstraintType.Equal);
            this.addConstraint(genFunc_v, wantedOffset, ConstraintType.Equal);
            return 999;
        }
        if (compareWithBeginExtremity && a > 0) {
            if (!this.isBatchOrDialogOutsideRelativeFunctions(s2)) {
                return 999;
            }
            int wantedOffset = PdpTool.getLineStartOffset((CharSequence)this._context.getAllText(), (int)userFunc_v.getOffset());
            this.tracePlacementResults(userFunc_v, false, wantedOffset, genFunc_v, ConstraintType.LowerOrEqual);
            this.addConstraint(genFunc_v, wantedOffset, ConstraintType.LowerOrEqual);
            return 999;
        }
        return 999;
    }

    protected int compareWithTitle(PacUserFunctionExtremity userFunc_v, ITagExtremity2 genFunc_v, String s1, String s2) {
        if (s2.length() == 6 && s2.endsWith(ZERO_TIMES3) || s2.length() == 9 && s2.endsWith(ZERO_TIMES3_FN)) {
            int toRemove = s2.endsWith(ZERO_TIMES3) ? 3 : 6;
            int comp = Ebcdic.stringCompare(s1.substring(1), s2.substring(1, s2.length() - toRemove));
            if (comp > 0) {
                return 1;
            }
            if (comp < 0) {
                return -1;
            }
            if (!s1.endsWith(EMPTY_STRING)) {
                return 1;
            }
            return 0;
        }
        if (s1.subSequence(1, 3).equals(s2.subSequence(1, 3)) && this.isBatchOrDialogOutsideRelativeFunctions(s1) && !genFunc_v.isTagStart() && s2.length() == 8 && s2.endsWith(ZERO_TIMES3) && !s1.endsWith(DASH_FN)) {
            int comp = Ebcdic.stringCompare(s1.substring(1), s2.substring(1, s2.length() - 3));
            if (comp > 0) {
                return 1;
            }
            if (comp < 0) {
                return -1;
            }
        }
        return 999;
    }

    private boolean isEnglobingSubFunctionDeleted(PacUserFunctionExtremity userFunc_v, ITagExtremity2 genFunc_v) {
        boolean currentTagFound = false;
        boolean otherEndFound = false;
        int i = 0;
        while (i < this._filteredTagsList.size()) {
            ITagExtremity2 elem = this._filteredTagsList.get(i);
            if (elem == genFunc_v) {
                currentTagFound = true;
            } else if (elem.getTagName().equals(genFunc_v.getTagName()) && elem != genFunc_v) {
                otherEndFound = true;
            }
            if (otherEndFound && currentTagFound) break;
            ++i;
        }
        return otherEndFound && currentTagFound;
    }

    protected int compare(PacUserFunctionExtremity userFunc_v, ITagExtremity2 genFunc_v) {
        String s2Func;
        int val;
        if (genFunc_v.getTag().getProperty("mp") != null && !this.isEnglobingSubFunctionDeleted(userFunc_v, genFunc_v)) {
            if (genFunc_v.isTagStart()) {
                return -1;
            }
            return 1;
        }
        String s1 = userFunc_v.getFuncName();
        String s2 = genFunc_v.getTagName();
        if (s2.charAt(0) == 'N') {
            if (this._isServer || s1.endsWith(DASH_FN)) {
                return 999;
            }
            if (s2.length() == 3) {
                int comp = Ebcdic.stringCompare(s1.substring(1, 3), s2.substring(1));
                if (comp > 0) {
                    return 1;
                }
                if (comp < 0) {
                    return -1;
                }
                if (s1.length() == 5) {
                    return 1;
                }
                if (s1.length() == 3) {
                    return 0;
                }
            }
            return 999;
        }
        if (this.isAFunctionCommentOrTitle(s1, s2)) {
            return this.compareWithTitle(userFunc_v, genFunc_v, s1, s2);
        }
        if (BasicPacLabelRecognizer.isLabelAMacroDetailedLine(s2) && (val = this.compareWithDetailedLine(userFunc_v, genFunc_v, s1, s2)) != 999) {
            return val;
        }
        if (BasicPacLabelRecognizer.isLabelAFunctionMacroDetailedLine(s2) && (val = this.compareWithFunctionDetailedLine(userFunc_v, genFunc_v, s1, s2)) != 999) {
            return val;
        }
        if (!genFunc_v.isTagStart() && !genFunc_v.getTagName().endsWith(DASH_FN)) {
            s2 = String.valueOf(s2) + DASH_FN;
        }
        Integer i1 = this._allFunctions.get(s1);
        Integer i2 = this._allFunctions.get(s2);
        if (i1 != null && i2 != null) {
            if (i1 < i2) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
        String s1Func = s1.substring(1, 3);
        if (!s1Func.equals(s2Func = s2.substring(1, 3))) {
            if (this._isServer) {
                return 999;
            }
            int a = Ebcdic.stringCompare(s1Func, s2Func);
            if (a < 0) {
                return -2;
            }
            if (a > 0) {
                return 2;
            }
        }
        boolean f80AlreadyDone = false;
        if ((this._isDialogOrClient || this._isServer) && s1.startsWith("F80") && s2.startsWith("F80") && genFunc_v.getTagName().indexOf("-") != -1) {
            String ref;
            f80AlreadyDone = true;
            String segment = genFunc_v.getTagName().substring(genFunc_v.getTagName().indexOf("-") + 1);
            String access = null;
            int index = segment.indexOf("-");
            if (index != -1) {
                access = segment.substring(index + 1);
                segment = segment.substring(0, index);
            }
            if ((ref = userFunc_v.getTagProperties().get("TagName")) == null && !userFunc_v.isBeginTag()) {
                ref = this.searchSomethingInBeginningFunction("ref", s1);
            }
            if (ref != null) {
                String refSeg = ref = ref.trim();
                String refAccess = null;
                int indexBlank = ref.indexOf(" ");
                if (indexBlank != -1) {
                    refSeg = ref.substring(0, indexBlank);
                    refAccess = ref.substring(indexBlank + 1);
                }
                if (segment.equals(refSeg)) {
                    if (access != null && access.equals(refAccess) || access == null && refAccess == null) {
                        if (genFunc_v.isTagStart() == userFunc_v.isBeginTag()) {
                            return 0;
                        }
                        if (userFunc_v.isBeginTag()) {
                            return -1;
                        }
                        return 1;
                    }
                    String orders = "_R_RU_P_RN_W_RW_D_UN_CL_";
                    int order = orders.indexOf("_" + access + "_");
                    int refOrder = orders.indexOf("_" + refAccess + "_");
                    if (order != -1 && refOrder != -1) {
                        if (order > refOrder) {
                            return -1;
                        }
                        return 1;
                    }
                }
            }
        }
        if (!f80AlreadyDone && !this.isBatchOrDialogOutsideRelativeFunctions(s1)) {
            String refGen = genFunc_v.getTag().getProperty("ref");
            if (refGen != null) {
                refGen = refGen.trim();
            }
            if (genFunc_v.getTag().getProperty("msp") != null) {
                refGen = null;
            }
            String refUser = this.searchSomethingInBeginningFunction("TagName", s1);
            if (refGen != null && refUser != null && !refGen.equals(refUser)) {
                String newRefGen = refGen;
                String newRefUser = refUser;
                if (refGen.indexOf(" ") != -1) {
                    newRefGen = newRefGen.substring(0, refGen.indexOf(" "));
                }
                if (refUser.indexOf(" ") != -1) {
                    newRefUser = newRefUser.substring(0, refUser.indexOf(" "));
                }
                if (newRefUser.equals(newRefGen)) {
                    refGen = newRefGen;
                    refUser = newRefUser;
                }
            }
            if (refGen != null && refGen.equals(refUser)) {
                String refPosition = this.searchSomethingInBeginningFunction("TagPosition", s1);
                String levSpe = userFunc_v.getTagProperties().get("level");
                String levGen = genFunc_v.getTag().getProperty("level");
                if ("B".equals(refPosition)) {
                    if (userFunc_v.isBeginTag()) {
                        return -1;
                    }
                    if (levGen != null && levSpe != null) {
                        int comp = levGen.compareTo(levSpe);
                        if (comp <= 0) {
                            return -1;
                        }
                        return 999;
                    }
                } else if ("A".equals(refPosition)) {
                    if (genFunc_v.isTagStart()) {
                        return 1;
                    }
                    if (levGen != null && levSpe != null) {
                        int comp = levGen.compareTo(levSpe);
                        if (comp < 0) {
                            return 999;
                        }
                        return 1;
                    }
                } else if ("R".equals(refPosition)) {
                    return 0;
                }
            } else if (refGen != null && refUser != null) {
                this.searchSomethingInBeginningFunction("TagPosition", s1);
                if (this.isSpecificRefInGeneratedTags(refUser)) {
                    int i = 0;
                    while (i < this._filteredTagsList.size()) {
                        String tnFirstWord;
                        ITagExtremity2 elem = this._filteredTagsList.get(i);
                        String tn = elem.getTag().getProperty("ref");
                        if (tn != null) {
                            tn = tn.trim();
                        }
                        if ((tnFirstWord = tn).indexOf(" ") != -1) {
                            tnFirstWord = tnFirstWord.substring(0, tnFirstWord.indexOf(" "));
                        }
                        if (refGen.equals(tn) || refGen.startsWith(tnFirstWord)) {
                            if (elem.isTagStart()) {
                                return 1;
                            }
                            if (!userFunc_v.isBeginTag()) {
                                return 1;
                            }
                            return 999;
                        }
                        if (refUser.equals(tn) || refUser.startsWith(tnFirstWord)) {
                            return -1;
                        }
                        ++i;
                    }
                }
            }
            if (genFunc_v.getTag().getProperty("msp") == null && this.isEnglobingSubFunctionDeleted(userFunc_v, genFunc_v) && !genFunc_v.getTagName().startsWith("F2599")) {
                if (userFunc_v.isBeginTag()) {
                    this.allSubFunctionsAlreadySeen.add(userFunc_v.getFuncName());
                    return 1;
                }
                String begLabel = userFunc_v.getFuncName();
                if (begLabel.endsWith(DASH_FN)) {
                    begLabel = begLabel.substring(0, begLabel.length() - 3);
                }
                if (this.allSubFunctionsAlreadySeen.contains(begLabel)) {
                    return 999;
                }
                if (genFunc_v.getTag().getProperty("mp") == null && genFunc_v.isTagStart()) {
                    return -1;
                }
            }
        }
        String s1Suffix = s1.substring(3);
        String s2Suffix = s2.substring(3);
        if (s2.equals("F9099") && this.specificPlacementForF9099) {
            return -1;
        }
        if (EMPTY_STRING.equals(s1Suffix) && !EMPTY_STRING.equals(s2Suffix)) {
            return -1;
        }
        if (!EMPTY_STRING.equals(s1Suffix) && EMPTY_STRING.equals(s2Suffix)) {
            return 1;
        }
        if (DASH_FN.equals(s1Suffix) && !EMPTY_STRING.equals(s2Suffix) && !DASH_FN.equals(s2Suffix)) {
            return 1;
        }
        if (!EMPTY_STRING.equals(s1Suffix) && !DASH_FN.equals(s1Suffix) && DASH_FN.equals(s2Suffix)) {
            String l1 = userFunc_v.getTagProperties().get("level");
            if (l1 != null) {
                try {
                    int level1 = Integer.parseInt(l1);
                    if (level1 <= 5) {
                        return 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return -1;
        }
        if (s1Suffix.length() == 2 && s2Suffix.length() == 5) {
            if (s1Suffix.equals(s2Suffix.substring(0, 2)) && DASH_FN.equals(s2Suffix.substring(2))) {
                return -1;
            }
        } else if (s1Suffix.length() == 5 && s2Suffix.length() == 2 && s1Suffix.substring(0, 2).equals(s2Suffix) && DASH_FN.equals(s1Suffix.substring(2))) {
            return 1;
        }
        this.compareWithDeletedSubFunctions(userFunc_v, genFunc_v);
        if (!s1.endsWith(DASH_FN) && !s2.endsWith(DASH_FN) && this.isBatchOrDialogOutsideRelativeFunctions(s1)) {
            int val2 = Ebcdic.stringCompare(s1.substring(1), s2.substring(1));
            if (val2 > 0) {
                return 1;
            }
            if (val2 < 0) {
                return -1;
            }
            return 0;
        }
        return 999;
    }

    private boolean isSpecificRefInGeneratedTags(String refUser) {
        String secondRefUser = EMPTY_STRING;
        if (refUser.indexOf(" ") != -1) {
            secondRefUser = refUser.substring(0, refUser.indexOf(" "));
        }
        int i = 0;
        while (i < this._filteredTagsList.size()) {
            ITagExtremity2 elem = this._filteredTagsList.get(i);
            String refGen = elem.getTag().getProperty("ref");
            if (refUser.equals(refGen) || secondRefUser.equals(refGen)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String searchSomethingInBeginningFunction(String property, String fnName) {
        String ref = null;
        Iterator<PacUserFunctionExtremity> itpufe = this._userPacFuncList.iterator();
        while (itpufe.hasNext() && ref == null) {
            PacUserFunctionExtremity pufe = itpufe.next();
            if (!pufe.isBeginTag() || !fnName.startsWith(pufe.getFuncName())) continue;
            ref = pufe.getTagProperties().get(property);
        }
        return ref;
    }

    protected List<PacUserFunctionExtremity> retrieveUserPacFunctions(CharSequence text, int beginIdx, int endIdx) {
        ArrayList<PacUserFunctionExtremity> result = new ArrayList<PacUserFunctionExtremity>();
        ITextScanner its = this._textAnalyzer.newScanner(beginIdx, endIdx);
        while (its.scan()) {
            String tagName;
            if (!its.foundTag() || !(tagName = its.getTagName()).startsWith("F")) continue;
            PacUserFunctionExtremity pl = new PacUserFunctionExtremity();
            if (its.isBeginIndex()) {
                pl.setFuncName(tagName);
            } else {
                pl.setFuncName(String.valueOf(tagName) + DASH_FN);
            }
            pl.setOffset(its.index());
            Map map = its.getTagProperties();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    pl.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            result.add(pl);
        }
        return result;
    }

    protected static class PacUserFunctionExtremity {
        private String funcName;
        private int offset;
        private Map<String, String> _tagProperties;

        protected PacUserFunctionExtremity() {
        }

        public String getFuncName() {
            return this.funcName;
        }

        public void setFuncName(String funcName) {
            this.funcName = funcName;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public boolean isBeginTag() {
            return !this.getFuncName().endsWith(PacFunctionsPlacementCalculator.DASH_FN);
        }

        public Map<String, String> getTagProperties() {
            if (this._tagProperties == null) {
                this._tagProperties = new HashMap<String, String>();
            }
            return this._tagProperties;
        }

        public void setProperty(String key, String value) {
            this.getTagProperties().put(key, value);
        }

        public String toString() {
            return String.valueOf(this.funcName) + " @ " + this.offset;
        }
    }
}

