/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.icu.lang.UCharacter;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.pacbase.extension.matching.PacGeneratedTextAnalyzer;

public abstract class OccurrenceHandler {
    protected String _tagName;
    protected IGeneratedTag _tag;
    protected int _lineStartOffset;
    protected int _lineEndOffset;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public OccurrenceHandler(String tagName, IGeneratedTag tag) {
        this._tagName = tagName;
        this._tag = tag;
    }

    protected boolean processOccurrence(PacGeneratedTextAnalyzer textAnalyzer, int beginIdx, int endIdx) {
        CharSequence text = textAnalyzer.getText();
        int counter = beginIdx - 1;
        int maxSteps = 0;
        int positionOfFirstNonBlankChar = -1;
        while (counter >= 0 && maxSteps <= 9) {
            char c = text.charAt(counter);
            if (c == '\n') break;
            if (!UCharacter.isWhitespace((int)c) && positionOfFirstNonBlankChar == -1) {
                positionOfFirstNonBlankChar = counter;
            }
            --counter;
            ++maxSteps;
        }
        if (maxSteps > 9) {
            return false;
        }
        if (positionOfFirstNonBlankChar != -1 && positionOfFirstNonBlankChar - ++counter > 5) {
            return false;
        }
        this._lineStartOffset = counter;
        return true;
    }

    protected boolean checkThereIsNoSignificantCharAfter(CharSequence text, int endIdx, int lineStartOffset) {
        int counter = endIdx;
        int positionOfFirstNonBlankChar = -1;
        int length = text.length();
        while (counter < length) {
            char c = text.charAt(counter);
            if (c == '\n') {
                if (++counter < length) {
                    this._lineEndOffset = counter;
                    break;
                }
                this._lineEndOffset = counter - 1;
                break;
            }
            if (c == '\r') {
                if (++counter < length) {
                    c = text.charAt(counter);
                    if (c == '\n') {
                        if (++counter < length) {
                            this._lineEndOffset = counter;
                            break;
                        }
                        this._lineEndOffset = counter - 1;
                        break;
                    }
                    return false;
                }
                return false;
            }
            if (!UCharacter.isWhitespace((int)c) && positionOfFirstNonBlankChar == -1) {
                positionOfFirstNonBlankChar = counter;
            }
            ++counter;
        }
        return positionOfFirstNonBlankChar == -1 || positionOfFirstNonBlankChar - lineStartOffset >= 72;
    }

    public String get_tagName() {
        return this._tagName;
    }

    protected int get_lineStartOffset() {
        return this._lineStartOffset;
    }

    protected int get_lineEndOffset() {
        return this._lineEndOffset;
    }

    public IGeneratedTag get_tag() {
        return this._tag;
    }

    public boolean isBeginIndex() {
        return true;
    }

    public int index() {
        if (this.isBeginIndex()) {
            return this.get_lineStartOffset();
        }
        return this.get_lineEndOffset();
    }
}

