/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.pacbase.extension.matching.ITagExtremity2;
import com.ibm.pdp.util.RandomBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GenInfoTagExtremitiesExtractor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String TAB = "  ";
    private boolean _startingPointReached;
    private IGeneratedTag findTagResult;

    private void addBeginExtremity(IGeneratedTag tag, List<ITagExtremity2> extremitiesList) {
        if (!this._startingPointReached) {
            return;
        }
        TagExtremity ite = new TagExtremity(tag, tag.getBeginIndex(), true);
        extremitiesList.add(ite);
    }

    private void addEndExtremity(IGeneratedTag tag, List<ITagExtremity2> extremitiesList) {
        if (!this._startingPointReached) {
            return;
        }
        TagExtremity ite = new TagExtremity(tag, tag.getEndIndex(), false);
        extremitiesList.add(ite);
    }

    private void addExtremity(ITagExtremity2 ext, List<ITagExtremity2> extremitiesList, boolean takeOnlyMPTagsAndSQLTag) {
        String property;
        if (takeOnlyMPTagsAndSQLTag && (property = ext.getTag().getProperty("mp")) == null && !ext.getTag().getName().startsWith("SQL-")) {
            return;
        }
        extremitiesList.add(ext);
    }

    /*
     * Unable to fully structure code
     */
    public List<ITagExtremity2> getAllTagExtremities(IGeneratedTag root, IGeneratedTag beginTag, IGeneratedTag endTag, boolean beginTagBeginExt, boolean endTagBeginExt, boolean takeOnlyMPTagsAndSQLTag) {
        result = new ArrayList<ITagExtremity2>();
        if (beginTag == endTag && beginTagBeginExt == endTagBeginExt) {
            if (takeOnlyMPTagsAndSQLTag && (property = beginTag.getProperty("mp")) == null && !beginTag.getName().startsWith("SQL-")) {
                return result;
            }
            index = beginTagBeginExt != false ? beginTag.getBeginIndex() : beginTag.getEndIndex();
            ite = new TagExtremity(beginTag, index, beginTagBeginExt);
            result.add(ite);
            return result;
        }
        commonAncestor = this.getCommonAncestor(beginTag, endTag);
        this._startingPointReached = false;
        allNodes = this.getAllTagExtremitiesBetween(commonAncestor, beginTag, endTag);
        i = 0;
        ext = null;
        while (i < allNodes.size()) {
            ext = allNodes.get(i);
            if (ext.getTag() == beginTag && ext.isTagStart() && beginTagBeginExt || ext.getTag() == beginTag && !ext.isTagStart() && !beginTagBeginExt) break;
            ++i;
        }
        if (i < allNodes.size()) ** GOTO lbl31
        return Collections.EMPTY_LIST;
lbl-1000:
        // 1 sources

        {
            ext = allNodes.get(i);
            if (ext.getTag() == endTag && ext.isTagStart() && endTagBeginExt) {
                this.addExtremity(ext, result, takeOnlyMPTagsAndSQLTag);
                break;
            }
            if (ext.getTag() == endTag && !ext.isTagStart() && !endTagBeginExt) {
                this.addExtremity(ext, result, takeOnlyMPTagsAndSQLTag);
                break;
            }
            this.addExtremity(ext, result, takeOnlyMPTagsAndSQLTag);
            ++i;
lbl31:
            // 2 sources

            ** while (i < allNodes.size())
        }
lbl32:
        // 3 sources

        return result;
    }

    private IGeneratedTag getCommonAncestor(IGeneratedTag beginTag, IGeneratedTag endTag) {
        if (beginTag == endTag) {
            return endTag;
        }
        IGeneratedTag tag = beginTag;
        ArrayList<IGeneratedTag> beginTagAncestors = new ArrayList<IGeneratedTag>();
        while (tag != null) {
            beginTagAncestors.add(tag);
            tag = tag.getParent();
        }
        tag = endTag;
        ArrayList<IGeneratedTag> endTagAncestors = new ArrayList<IGeneratedTag>();
        while (tag != null) {
            endTagAncestors.add(tag);
            tag = tag.getParent();
        }
        boolean ancestorIsEqual = true;
        int i = beginTagAncestors.size() - 1;
        int j = endTagAncestors.size() - 1;
        IGeneratedTag smallestAncestor = null;
        while (ancestorIsEqual && i >= 0 && j >= 0) {
            IGeneratedTag endElem;
            IGeneratedTag beginElem = (IGeneratedTag)beginTagAncestors.get(i);
            boolean bl = ancestorIsEqual = beginElem == (endElem = (IGeneratedTag)endTagAncestors.get(j));
            if (!ancestorIsEqual) continue;
            smallestAncestor = beginElem;
            --i;
            --j;
        }
        return smallestAncestor;
    }

    private List<ITagExtremity2> getAllTagExtremitiesBetween(IGeneratedTag root, IGeneratedTag beginTag, IGeneratedTag endTag) {
        ArrayList<ITagExtremity2> nodes = new ArrayList<ITagExtremity2>();
        this.getAllTagExtremitiesBetween2(root, beginTag, endTag, nodes);
        return nodes;
    }

    private void getAllTagExtremitiesBetween2(IGeneratedTag root, IGeneratedTag beginTag, IGeneratedTag endTag, List<ITagExtremity2> nodesList) {
        if (root == null) {
            return;
        }
        if (root == beginTag || beginTag == null) {
            this._startingPointReached = true;
        }
        if (root.getBeginIndex() > endTag.getEndIndex()) {
            return;
        }
        this.addBeginExtremity(root, nodesList);
        Iterator sons = root.sons();
        while (sons.hasNext()) {
            IGeneratedTag aSon = (IGeneratedTag)sons.next();
            this.getAllTagExtremitiesBetween2(aSon, beginTag, endTag, nodesList);
        }
        this.addEndExtremity(root, nodesList);
    }

    private void findTag(IGeneratedTag tag, String name) {
        if (tag.getName().equalsIgnoreCase(name)) {
            this.findTagResult = tag;
            return;
        }
        this.findTagResult = null;
        Iterator sons = tag.sons();
        while (sons.hasNext() && this.findTagResult == null) {
            IGeneratedTag aSon = (IGeneratedTag)sons.next();
            this.findTag(aSon, name);
        }
    }

    private IGeneratedTag findLastTag(IGeneratedTag tag) {
        if (tag.nbOfSons() == 0) {
            return tag;
        }
        Iterator sons = tag.sons();
        IGeneratedTag aSon = null;
        while (sons.hasNext()) {
            aSon = (IGeneratedTag)sons.next();
        }
        return this.findLastTag(aSon);
    }

    private void test_displayTagExtremities(List<ITagExtremity2> tagsExtremities) {
        Trace.outPrintln((String)"*****************************************************");
        int i = 0;
        while (i < tagsExtremities.size()) {
            ITagExtremity2 tag = tagsExtremities.get(i);
            Trace.outPrintln((String)(String.valueOf(tag.getTagName()) + " [" + tag.getIndex() + ", " + (tag.isTagStart() ? "begin]" : "end]")));
            ++i;
        }
        Trace.outPrintln((String)"*****************************************************");
    }

    private void test_displayGenTags(IGeneratedTag start, int level) {
        if (start == null) {
            return;
        }
        String tabul = this.getTabul(level);
        Trace.outPrintln((String)(String.valueOf(tabul) + start.getName() + " [" + start.getBeginIndex() + ", " + start.getEndIndex() + "]"));
        Iterator sons = start.sons();
        while (sons.hasNext()) {
            this.test_displayGenTags((IGeneratedTag)sons.next(), level + 1);
        }
    }

    private String getTabul(int level) {
        String result = "";
        int i = 0;
        while (i < level) {
            result = String.valueOf(result) + TAB;
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        GenInfoTagExtremitiesExtractor x = new GenInfoTagExtremitiesExtractor();
        System.out.println("Begin of Test in method main");
        Trace.traceOn = true;
        int complexity = 80;
        System.out.println("Creation of the GeneratedInfo....");
        GeneratedInfoUtil util = new GeneratedInfoUtil();
        IGeneratedInfo genInfo = util.makeGeneratedInfo(complexity);
        x.test_displayGenTags(genInfo.getRootTag(), 0);
        System.out.println("Fetching ALL the IGeneratedTags in a List....");
        x.findTag(genInfo.getRootTag(), "T23");
        IGeneratedTag begin = x.findTagResult;
        x.findTag(genInfo.getRootTag(), "T36");
        IGeneratedTag end = x.findTagResult;
        long a = System.currentTimeMillis();
        List<ITagExtremity2> ext = x.getAllTagExtremities(genInfo.getRootTag(), begin, end, false, false, false);
        long b = System.currentTimeMillis();
        Trace.outPrintln((String)("GenInfoTagExtremitiesExtractor.getTagExtremities elapsed =" + (b - a)));
        x.test_displayTagExtremities(ext);
    }

    private static class GeneratedInfoUtil {
        private RandomBuilder random;
        private long seed;

        private GeneratedInfoUtil() {
        }

        private void putProperties(IGeneratedInfoFactory factory) {
            if (this.random.nextInt(10) == 0) {
                factory.setProperty("msp", this.random.nextBoolean() ? "MSPA" : "MSPB");
            }
            if (this.random.nextInt(5) == 0) {
                factory.setProperty("ignoreCase", this.random.nextBoolean() ? "true" : "false");
            }
            if (this.random.nextInt(5) == 0) {
                factory.setProperty("changeControl", this.random.nextBoolean() ? "Allow" : (this.random.nextBoolean() ? "Warning" : "Error"));
            }
        }

        public IGeneratedInfo makeGeneratedInfo(int complexity) {
            this.random = new RandomBuilder(this.seed);
            IEngineFactory engine = PdpTool.getEngineFactory();
            IGeneratedInfoFactory factory = engine.newGeneratedInfoFactory();
            factory.setProperty("ignoreCase", this.random.nextBoolean() ? "true" : "false");
            factory.setProperty("changeControl", this.random.nextBoolean() ? "Allow" : (this.random.nextBoolean() ? "Warning" : "Error"));
            factory.beginTag("T0");
            this.putProperties(factory);
            this.makeSubTags(factory, 1, complexity, 0);
            factory.endTag();
            return factory.createGeneratedInfo();
        }

        private int makeSubTags(IGeneratedInfoFactory factory, int level, int complexity, int tagCount) {
            String enclosingTag = "T" + tagCount;
            if (complexity == 0) {
                this.appendText(factory, level, enclosingTag, enclosingTag, enclosingTag);
                return tagCount;
            }
            String fromTag = enclosingTag;
            String toTag = "T" + ++tagCount;
            this.appendText(factory, level, enclosingTag, fromTag, toTag);
            int t = 0;
            while (t < complexity - 1) {
                factory.beginTag(toTag);
                this.putProperties(factory);
                tagCount = this.makeSubTags(factory, level + 1, complexity / 4, tagCount);
                factory.endTag();
                fromTag = toTag;
                toTag = "T" + ++tagCount;
                this.appendText(factory, level, enclosingTag, fromTag, toTag);
                ++t;
            }
            factory.beginTag(toTag);
            this.putProperties(factory);
            tagCount = this.makeSubTags(factory, level + 1, complexity / 4, tagCount);
            factory.endTag();
            this.appendText(factory, level, enclosingTag, toTag, enclosingTag);
            return tagCount;
        }

        protected void appendText(IGeneratedInfoFactory factory, int level, String enclosingTag, String fromTag, String toTag) {
            if (this.random.nextInt(4) == 0) {
                if (this.random.nextBoolean()) {
                    factory.appendText((CharSequence)"     ");
                }
                return;
            }
            boolean fromEqualsTo = fromTag.equals(toTag);
            if (enclosingTag.equals(fromTag)) {
                if (fromEqualsTo) {
                    factory.appendText((CharSequence)"[Tag ");
                    factory.appendText((CharSequence)enclosingTag);
                    factory.appendText((CharSequence)"]");
                } else {
                    factory.appendText((CharSequence)"[First part of ");
                    factory.appendText((CharSequence)enclosingTag);
                    factory.appendText((CharSequence)" before ");
                    factory.appendText((CharSequence)toTag);
                    factory.appendText((CharSequence)"\n");
                    this.indent(factory, level);
                }
            } else if (enclosingTag.equals(toTag)) {
                factory.appendText((CharSequence)"\n");
                this.indent(factory, level);
                factory.appendText((CharSequence)"Last part of ");
                factory.appendText((CharSequence)enclosingTag);
                factory.appendText((CharSequence)" after ");
                factory.appendText((CharSequence)fromTag);
                factory.appendText((CharSequence)"]");
            } else {
                factory.appendText((CharSequence)"\n");
                this.indent(factory, level);
                factory.appendText((CharSequence)"Middle part of ");
                factory.appendText((CharSequence)enclosingTag);
                factory.appendText((CharSequence)" between ");
                factory.appendText((CharSequence)fromTag);
                factory.appendText((CharSequence)" and ");
                factory.appendText((CharSequence)toTag);
                factory.appendText((CharSequence)"\n");
                this.indent(factory, level);
            }
        }

        private void indent(IGeneratedInfoFactory factory, int level) {
            int i = 0;
            while (i < level) {
                factory.appendText((CharSequence)"    ");
                ++i;
            }
        }
    }

    private static class TagExtremity
    implements ITagExtremity2 {
        String tagName;
        int index;
        boolean isTagStart;
        IGeneratedTag tag;

        public TagExtremity(IGeneratedTag tag_, int idx, boolean start) {
            this.tag = tag_;
            this.tagName = this.tag.getName();
            this.index = idx;
            this.isTagStart = start;
        }

        @Override
        public IGeneratedTag getTag() {
            return this.tag;
        }

        public void setTag(IGeneratedTag tag_) {
            this.tag = tag_;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isTagStart() {
            return this.isTagStart;
        }

        public void setTagStart(boolean isTagStart) {
            this.isTagStart = isTagStart;
        }

        public String toString() {
            return String.valueOf(this.tagName) + " @ " + this.index + (this.isTagStart ? "(startExt)" : "(endExt)");
        }
    }
}

