/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.ConstraintType;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextMatcher;
import com.ibm.pdp.engine.extension.ITextMatcherConstraints;
import com.ibm.pdp.engine.extension.ITextMatcherContext;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.framework.cobol.micropattern.MicroPatternExtractor;
import com.ibm.pdp.framework.cobol.micropattern.MicroPatternMark;
import com.ibm.pdp.pacbase.extension.matching.GenInfoTagExtremitiesExtractor;
import com.ibm.pdp.pacbase.extension.matching.ITagExtremity2;
import com.ibm.pdp.pacbase.extension.matching.PacFunctionsPlacementCalculator;
import com.ibm.pdp.pacbase.extension.matching.PacSQLPlacementCalculator;
import com.ibm.pdp.pacbase.extension.matching.PacSpecificProgramTextAnalyzer;
import com.ibm.pdp.pacbase.extension.matching.PacSpecificScreenTextAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CobolTextMatcher
implements ITextMatcher {
    private static String WORKING_TAGNAME = "WORKING";
    private static String LINKAGE_TAGNAME = "LINKAGE";
    private static String DATA_DIV_TAGNAME = "DATA";
    private static String PROC_TAGNAME = "PROCEDURE";
    private static String PROC_DIV_TAGNAME = "PROCEDURE-DIVISION";
    private static String PROC_DIV_LABEL = "       PROCEDURE DIVISION";
    private static String PROC_DIV = String.valueOf(PdpTool.EOL) + PROC_DIV_LABEL;
    private static final String DASH_FN = "-FN";
    static final String SQL_TAG = "SQL-";
    protected ITextMatcherContext _context;
    protected ITextMatcherConstraints _constraints;
    protected boolean _isBeginTag_Opening;
    protected boolean _isEndTag_Opening;
    protected ITextAnalyzer _textAnalyser;
    protected boolean _isPatternServer = false;
    protected boolean _isPatternDialogOrClient = false;
    protected boolean _isPatternBatch = false;
    protected Map<String, Integer> _allFunctions;
    private int firstFunctionOffset = -1;
    private String _patternName;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private void init() {
        CharSequence cs;
        if (this._textAnalyser != null && (cs = this._context.getAllText()).toString().equals(this._textAnalyser.getText())) {
            return;
        }
        IGeneratedInfo genInfo = this._context.getGeneratedInfo();
        this._patternName = genInfo.getProperty("pattern");
        if ("com.ibm.pdp.pacbase.batch".equals(this._patternName)) {
            this._isPatternBatch = true;
            this._textAnalyser = new PacSpecificProgramTextAnalyzer(null);
        } else if ("com.ibm.pdp.pacbase.dialog".equals(this._patternName) || "com.ibm.pdp.pacbase.csclient".equals(this._patternName)) {
            this._isPatternDialogOrClient = true;
            this._textAnalyser = new PacSpecificScreenTextAnalyzer(null);
        } else {
            this._isPatternServer = true;
            this._textAnalyser = new PacSpecificScreenTextAnalyzer(null);
        }
        this._textAnalyser.setText(this._context.getAllText());
        this._allFunctions = this.retrieveAllPacFunctions(this._context.getAllText(), 0, this._context.getAllText().length());
    }

    private void processMatchingForMicroPatterns() {
        List mpMarks = MicroPatternExtractor.findMPMarks((CharSequence)this._context.getAllText(), (int)this._context.getTextBeginIndex(), (int)this._context.getTextEndIndex());
        if (mpMarks.size() == 0) {
            return;
        }
        IGeneratedTag beginTag = this._context.getBeginGeneratedTag();
        IGeneratedTag endTag = this._context.getEndGeneratedTag();
        this._isBeginTag_Opening = this._context.isBeginGeneratedTag_aBeginExtremity();
        this._isEndTag_Opening = this._context.isEndGeneratedTag_aBeginExtremity();
        if (!this.isConsistencyCheckOK(beginTag, endTag)) {
            return;
        }
        GenInfoTagExtremitiesExtractor git2 = new GenInfoTagExtremitiesExtractor();
        IGeneratedTag root = this._context.getGeneratedInfo().getRootTag();
        List<ITagExtremity2> tagsList = git2.getAllTagExtremities(root, beginTag, endTag, this._isBeginTag_Opening, this._isEndTag_Opening, true);
        if (tagsList.size() == 0) {
            return;
        }
        this.analyzeData(mpMarks, tagsList);
    }

    private void processMatchingForPacFunctions() {
        IGeneratedTag beginTag = this._context.getBeginGeneratedTag();
        IGeneratedTag endTag = this._context.getEndGeneratedTag();
        this._isBeginTag_Opening = this._context.isBeginGeneratedTag_aBeginExtremity();
        this._isEndTag_Opening = this._context.isEndGeneratedTag_aBeginExtremity();
        IGeneratedTag root = this._context.getGeneratedInfo().getRootTag();
        IGeneratedTag holdingTag = this.findCobolDivisionOf(endTag, root);
        if (holdingTag == null || !holdingTag.getName().equals("PROCEDURE")) {
            return;
        }
        GenInfoTagExtremitiesExtractor git2 = new GenInfoTagExtremitiesExtractor();
        List<ITagExtremity2> tagsList = git2.getAllTagExtremities(root, beginTag, endTag, this._isBeginTag_Opening, this._isEndTag_Opening, false);
        PacFunctionsPlacementCalculator pfpc = null;
        pfpc = new PacFunctionsPlacementCalculator(tagsList, this._textAnalyser, this._allFunctions, this._context);
        pfpc.determineConstraints(this._context, this._constraints);
    }

    private void processMatchingForSQLTagInWorkingSection() {
        IGeneratedTag beginTag = this._context.getBeginGeneratedTag();
        IGeneratedTag endTag = this._context.getEndGeneratedTag();
        IGeneratedTag root = this._context.getGeneratedInfo().getRootTag();
        IGeneratedTag holdingTag = this.findCobolDivisionOf(beginTag, root);
        if (holdingTag == null || holdingTag.getName().equals(PROC_TAGNAME)) {
            return;
        }
        GenInfoTagExtremitiesExtractor git2 = new GenInfoTagExtremitiesExtractor();
        List<ITagExtremity2> tagsList = git2.getAllTagExtremities(root, beginTag, endTag, this._isBeginTag_Opening, this._isEndTag_Opening, false);
        this.filterSQLTag(tagsList);
        if (tagsList == null || tagsList.size() == 0) {
            return;
        }
        PacSQLPlacementCalculator pSQLpc = new PacSQLPlacementCalculator(tagsList, this._context);
        pSQLpc.determineConstraints(this._context, this._constraints);
    }

    private void filterSQLTag(List<ITagExtremity2> tagsList) {
        if (tagsList == null || tagsList.size() == 0) {
            return;
        }
        int i = tagsList.size() - 1;
        while (i >= 0) {
            ITagExtremity2 tagExtremity = tagsList.get(i);
            if (!tagExtremity.getTag().getName().startsWith(SQL_TAG)) {
                tagsList.remove(i);
            }
            --i;
        }
    }

    public void determineConstraints(ITextMatcherContext context, ITextMatcherConstraints constraints) {
        this._context = context;
        this._constraints = constraints;
        this.init();
        boolean finished = this.processMatchingForWSSContinuationEndExtremity();
        if (finished) {
            return;
        }
        this.processMatchingForProcDiv();
        this.processMatchingForSQLTagInWorkingSection();
        this.processMatchingForPacFunctions();
        this.processMatchingForMicroPatterns();
    }

    private void closeDataDivisionTags(ITagExtremity2 extremity, int offset) {
        IGeneratedTag linkageTag = PdpTool.getTagFromTagName((IGeneratedInfo)extremity.getTag().getGeneratedInfo(), (String)LINKAGE_TAGNAME);
        if (linkageTag != null) {
            this._constraints.setTagExtremity(linkageTag, false, offset, ConstraintType.Equal);
        } else {
            IGeneratedTag wkTag = PdpTool.getTagFromTagName((IGeneratedInfo)extremity.getTag().getGeneratedInfo(), (String)WORKING_TAGNAME);
            if (wkTag != null) {
                this._constraints.setTagExtremity(wkTag, false, offset, ConstraintType.Equal);
            }
        }
        IGeneratedTag dataDivTag = PdpTool.getTagFromTagName((IGeneratedInfo)extremity.getTag().getGeneratedInfo(), (String)DATA_DIV_TAGNAME);
        if (dataDivTag != null) {
            this._constraints.setTagExtremity(dataDivTag, false, offset, ConstraintType.Equal);
        }
    }

    private void processMatchingForProcDiv() {
        IGeneratedTag beginTag = this._context.getBeginGeneratedTag();
        IGeneratedTag endTag = this._context.getEndGeneratedTag();
        this._isBeginTag_Opening = this._context.isBeginGeneratedTag_aBeginExtremity();
        this._isEndTag_Opening = this._context.isEndGeneratedTag_aBeginExtremity();
        String aStr = this._context.getAllText().subSequence(this._context.getTextBeginIndex(), this._context.getTextEndIndex()).toString();
        int relativeOffset = aStr.indexOf(PROC_DIV_LABEL);
        if (relativeOffset == -1) {
            return;
        }
        GenInfoTagExtremitiesExtractor git2 = new GenInfoTagExtremitiesExtractor();
        IGeneratedTag root = this._context.getGeneratedInfo().getRootTag();
        List<ITagExtremity2> tagsList = git2.getAllTagExtremities(root, beginTag, endTag, this._isBeginTag_Opening, this._isEndTag_Opening, false);
        for (ITagExtremity2 extremity : tagsList) {
            int offset;
            if (extremity.getTag().getName().equals(PROC_DIV_TAGNAME)) {
                offset = this._context.getTextBeginIndex() + relativeOffset;
                if (extremity.isTagStart()) {
                    this.closeDataDivisionTags(extremity, offset);
                    IGeneratedTag parent = extremity.getTag().getParent();
                    if (parent.getName().equals(PROC_TAGNAME)) {
                        this._constraints.setTagExtremity(parent, true, offset, ConstraintType.Equal);
                    }
                    this._constraints.setTagExtremity(extremity.getTag(), true, offset, ConstraintType.Equal);
                } else if (this.firstFunctionOffset != -1 && this.firstFunctionOffset >= this._context.getTextBeginIndex() && this._context.getTextEndIndex() >= this.firstFunctionOffset) {
                    this._constraints.setTagExtremity(extremity.getTag(), false, this.firstFunctionOffset, ConstraintType.Equal);
                } else {
                    this._constraints.setTagExtremity(extremity.getTag(), false, offset, ConstraintType.GreaterOrEqual);
                }
            }
            if (!extremity.getTag().getName().equals(PROC_TAGNAME)) continue;
            offset = this._context.getTextBeginIndex() + relativeOffset;
            if (!extremity.isTagStart()) continue;
            this.closeDataDivisionTags(extremity, offset);
            this._constraints.setTagExtremity(extremity.getTag(), true, offset, ConstraintType.Equal);
        }
    }

    private boolean processMatchingForWSSContinuationEndExtremity() {
        IGeneratedTag beginTag = this._context.getBeginGeneratedTag();
        IGeneratedTag endTag = this._context.getEndGeneratedTag();
        this._isBeginTag_Opening = this._context.isBeginGeneratedTag_aBeginExtremity();
        this._isEndTag_Opening = this._context.isEndGeneratedTag_aBeginExtremity();
        if (this._isBeginTag_Opening || !endTag.getName().equals("WORKING") && !endTag.getName().equals("GENERATED-WORKING") && !endTag.getName().equals("WSS-CONTIUNUATION")) {
            return false;
        }
        GenInfoTagExtremitiesExtractor git2 = new GenInfoTagExtremitiesExtractor();
        IGeneratedTag root = this._context.getGeneratedInfo().getRootTag();
        List<ITagExtremity2> tagsList = git2.getAllTagExtremities(root, beginTag, endTag, this._isBeginTag_Opening, this._isEndTag_Opening, false);
        for (ITagExtremity2 extremity : tagsList) {
            if (!extremity.getTag().getName().equals("WSS-CONTINUATION")) continue;
            this._constraints.setTagExtremity(extremity.getTag(), false, this._context.getTextEndIndex(), ConstraintType.Equal);
            return true;
        }
        return false;
    }

    private IGeneratedTag findCobolDivisionOf(IGeneratedTag startTag, IGeneratedTag root) {
        IGeneratedTag previous = null;
        IGeneratedTag tag = startTag;
        while (tag != null && tag != root) {
            previous = tag;
            tag = tag.getParent();
        }
        return previous;
    }

    private void addConstraint(ITagExtremity2 genTag, MicroPatternMark mpMark) {
        ConstraintType type;
        int indexInText;
        boolean isBeginIndex;
        if (genTag.isTagStart()) {
            isBeginIndex = true;
            indexInText = mpMark.getBeginOffset();
            type = ConstraintType.GreaterThan;
        } else {
            isBeginIndex = false;
            indexInText = mpMark.getBeginOffset();
            type = ConstraintType.LowerOrEqual;
        }
        this._constraints.setTagExtremity(genTag.getTag(), isBeginIndex, indexInText, type);
    }

    protected Map<String, Integer> retrieveAllPacFunctions(CharSequence text, int beginIdx, int endIdx) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int idx = text.toString().indexOf(PROC_DIV);
        if (idx == -1) {
            return result;
        }
        ITextScanner its = this._textAnalyser.newScanner(idx + PdpTool.EOL.length(), endIdx);
        Integer counter = 0;
        this.firstFunctionOffset = -1;
        while (its.scan()) {
            String tagName;
            if (!its.foundTag() || !(tagName = its.getTagName()).startsWith("F")) continue;
            String name = null;
            name = its.isBeginIndex() ? tagName : String.valueOf(tagName) + DASH_FN;
            result.put(name, new Integer(counter));
            if (counter == 0) {
                this.firstFunctionOffset = its.index();
            }
            counter = counter + 1;
        }
        return result;
    }

    private void displayFunctions(Map<String, Integer> result) {
        String[] functions = new String[result.size()];
        for (String aName : result.keySet()) {
            Integer i = result.get(aName);
            functions[i.intValue()] = aName;
        }
        int i = 0;
        while (i < functions.length) {
            System.out.println(String.valueOf(functions[i]) + " => " + i);
            ++i;
        }
    }

    protected void analyzeData(List<MicroPatternMark> mpMarks, List<ITagExtremity2> genTags) {
        if (mpMarks.size() == 1 && genTags.size() == 1) {
            this.processOneTagExtAndOneMPDecl(mpMarks, genTags);
            return;
        }
        if (mpMarks.size() == 1 && genTags.size() == 2) {
            this.processTwoTagExtAndOneMPDecl(mpMarks, genTags);
            return;
        }
        if (mpMarks.size() == 2 && genTags.size() == 2) {
            this.processTwoTagExtAndTwoMPDecl(mpMarks, genTags);
            return;
        }
        if (this.areTagExtAlternate(genTags)) {
            this.processGeneralCase(mpMarks, genTags);
            return;
        }
    }

    private boolean areTagExtAlternate(List<ITagExtremity2> tags) {
        if (tags.size() < 2) {
            return true;
        }
        ITagExtremity2 previous = tags.get(0);
        int i = 1;
        while (i < tags.size()) {
            ITagExtremity2 tag = tags.get(i);
            if (previous.isTagStart() == tag.isTagStart()) {
                return false;
            }
            previous = tag;
            ++i;
        }
        return true;
    }

    private boolean areTagExtremitiesInClassicOrder(List<ITagExtremity2> tags) {
        int i = 0;
        while (i < tags.size()) {
            ITagExtremity2 tag = tags.get(i);
            if (i % 2 == 0 ? !tag.isTagStart() : tag.isTagStart()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean areTagExtremitiesInClassicOrder2(List<ITagExtremity2> tags) {
        if (tags.size() < 2) {
            return true;
        }
        ITagExtremity2 tag = tags.get(0);
        boolean firstTagExtIsBeginDecl = tag.isTagStart();
        int i = 0;
        while (i < tags.size()) {
            tag = tags.get(i);
            if (i % 2 == 0 ? tag.isTagStart() != firstTagExtIsBeginDecl : tag.isTagStart() == firstTagExtIsBeginDecl) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void placeTagsExtremities(List<ITagExtremity2> tagsList, List<MicroPatternMark> mpMarks) {
        if (tagsList.size() < 3 || tagsList.size() + mpMarks.size() > 21) {
            return;
        }
        long a = System.currentTimeMillis();
        List<Interval> intervals = this.determineIntervals(tagsList);
        if (intervals.size() < 2) {
            return;
        }
        boolean trouve = false;
        int i = 0;
        while (i < intervals.size()) {
            Interval interval = intervals.get(i);
            if (interval.isHasMPProperty()) {
                trouve = true;
                break;
            }
            ++i;
        }
        if (!trouve) {
            long b = System.currentTimeMillis();
            if (Trace.traceOn) {
                Trace.outPrintln((String)("CobolTextMatcher stop. No constraint could be set. Elapsed = " + (b - a)));
            }
            return;
        }
        List<Possibility> possibilities = this.createAndTestAllPossibilities(mpMarks, intervals);
        Possibility bestPossibility = this.selectBestSolution(possibilities);
        if (bestPossibility == null) {
            long b = System.currentTimeMillis();
            if (Trace.traceOn) {
                Trace.outPrintln((String)("CobolTextMatcher stop. No constraint could be set. Elapsed = " + (b - a)));
            }
            return;
        }
        this.setConstraints(bestPossibility);
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("CobolTextMatcher stop. Elapsed = " + (b - a)));
        }
    }

    protected boolean isConsistencyCheckOK(IGeneratedTag beginTag, IGeneratedTag endTag) {
        return true;
    }

    private void convertNumIntoRealValues(int[] places, int maxNbOfElem, int index, List<MicroPatternMark> mpMarks, List<Interval> intervals, List<Possibility> possibilitiesList) {
        ArrayList<Couple> couples = new ArrayList<Couple>();
        int marksIdx = 0;
        int i = 0;
        while (i < places.length) {
            Interval interval = intervals.get(i);
            int x = places[i];
            ArrayList<MicroPatternMark> list = new ArrayList<MicroPatternMark>();
            int j = 0;
            while (j < x) {
                list.add(mpMarks.get(marksIdx + j));
                ++j;
            }
            marksIdx += x;
            Couple c = new Couple(interval, list);
            couples.add(c);
            ++i;
        }
        Possibility aPossibility = new Possibility(couples);
        if (this.testValidity(aPossibility)) {
            possibilitiesList.add(aPossibility);
        }
    }

    private void displayPlaces(int[] places) {
        if (Trace.traceOn) {
            int i = 0;
            while (i < places.length) {
                Trace.outPrint((String)(String.valueOf(places[i]) + ","));
                ++i;
            }
            Trace.outPrintln((String)"");
        }
    }

    private void m(int[] places, int maxNbOfElem, int index, List<MicroPatternMark> mpMarks, List<Interval> intervals, List<Possibility> possibilitiesList) {
        if (index == places.length) {
            return;
        }
        int i = maxNbOfElem;
        while (i >= 0) {
            places[index] = i;
            if (this.sum(places, maxNbOfElem) <= maxNbOfElem) {
                if (index == places.length - 1) {
                    if (this.sum(places, maxNbOfElem) == maxNbOfElem) {
                        this.convertNumIntoRealValues(places, maxNbOfElem, index, mpMarks, intervals, possibilitiesList);
                    }
                } else {
                    this.m(places, maxNbOfElem, index + 1, mpMarks, intervals, possibilitiesList);
                }
            }
            --i;
        }
    }

    protected List<Possibility> createAndTestAllPossibilities(List<MicroPatternMark> mpMarks, List<Interval> intervals) {
        ArrayList<Possibility> possibilitiesList = new ArrayList<Possibility>();
        int[] places = new int[intervals.size()];
        this.m(places, mpMarks.size(), 0, mpMarks, intervals, possibilitiesList);
        return possibilitiesList;
    }

    protected List<Interval> determineIntervals(List<ITagExtremity2> tagsList) {
        if (tagsList.size() < 3) {
            return new ArrayList<Interval>(0);
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        Interval interval = null;
        IGeneratedTag enclosingTag = null;
        int i = 0;
        while (i < tagsList.size() - 1) {
            ITagExtremity2 tagExt1 = tagsList.get(i);
            ITagExtremity2 tagExt2 = tagsList.get(i + 1);
            enclosingTag = tagExt1.isTagStart() ? tagExt1.getTag() : (tagExt2.isTagStart() ? tagExt1.getTag().getParent() : tagExt2.getTag());
            interval = new Interval(i, tagExt1, tagExt2, enclosingTag, this.hasTheMPProperty(enclosingTag));
            intervals.add(interval);
            ++i;
        }
        return intervals;
    }

    private boolean hasTheMPProperty(IGeneratedTag tag) {
        String property = tag.getProperty("mp");
        return property != null;
    }

    private void processTwoTagExtAndOneMPDecl(List<MicroPatternMark> mpMarks, List<ITagExtremity2> genTags) {
        MicroPatternMark mpMark = mpMarks.get(0);
        ITagExtremity2 genTag1 = genTags.get(0);
        ITagExtremity2 genTag2 = genTags.get(1);
        if (genTag1.isTagStart()) {
            this.addConstraint(genTag1, mpMark);
        } else {
            this.addConstraint(genTag1, mpMark);
            this.addConstraint(genTag2, mpMark);
        }
    }

    private void processTwoTagExtAndTwoMPDecl(List<MicroPatternMark> mpMarks, List<ITagExtremity2> genTags) {
        MicroPatternMark mpMark1 = mpMarks.get(0);
        MicroPatternMark mpMark2 = mpMarks.get(1);
        ITagExtremity2 genTag1 = genTags.get(0);
        ITagExtremity2 genTag2 = genTags.get(1);
        this.addConstraint(genTag1, mpMark1);
        this.addConstraint(genTag2, mpMark2);
    }

    protected void processOneTagExtAndOneMPDecl(List<MicroPatternMark> mpMarks, List<ITagExtremity2> genTags) {
        MicroPatternMark mpMark = mpMarks.get(0);
        ITagExtremity2 genTag = genTags.get(0);
        this.addConstraint(genTag, mpMark);
    }

    protected void processGeneralCase(List<MicroPatternMark> mpMarks, List<ITagExtremity2> genTags) {
        int i = 0;
        int j = 0;
        int mpMarksSize = mpMarks.size();
        int tagExtsSise = genTags.size();
        i = genTags.get(0).isTagStart() ? 0 : 1;
        while (j < mpMarksSize) {
            if (i < tagExtsSise) {
                if (i > 0) {
                    this.addConstraint(genTags.get(i - 1), mpMarks.get(j));
                }
                this.addConstraint(genTags.get(i), mpMarks.get(j));
                i += 2;
                ++j;
                continue;
            }
            if (genTags.get(tagExtsSise - 1).isTagStart()) {
                this.addConstraint(genTags.get(tagExtsSise - 1), mpMarks.get(mpMarksSize - 1));
                break;
            }
            this.addConstraint(genTags.get(tagExtsSise - 1), mpMarks.get(j));
            break;
        }
    }

    private List<Integer> getPositionsOfMPTag(Possibility aPossibility) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<Couple> couples = aPossibility.getCouples();
        int couplesSize = couples.size();
        int i = 0;
        while (i < couplesSize) {
            Couple aCouple = couples.get(i);
            if (aCouple.getInterval().isHasMPProperty()) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    private MicroPatternMark getLastMPDeclaration(Couple aCouple) {
        if (aCouple == null) {
            return null;
        }
        List<MicroPatternMark> mpMarks = aCouple.getMpMarks();
        MicroPatternMark lastMark = null;
        int mpMarksSize = mpMarks.size();
        if (mpMarksSize > 0) {
            lastMark = mpMarks.get(mpMarksSize - 1);
        }
        return lastMark;
    }

    private MicroPatternMark getFirstMPDeclaration(Couple aCouple) {
        if (aCouple == null) {
            return null;
        }
        List<MicroPatternMark> mpMarks = aCouple.getMpMarks();
        if (mpMarks.size() > 0) {
            return mpMarks.get(0);
        }
        return null;
    }

    protected Possibility selectBestSolution(List<Possibility> possibilities) {
        if (possibilities.size() == 0) {
            return null;
        }
        Possibility best = null;
        ArrayList<Possibility> bestPossibilities = new ArrayList<Possibility>();
        Possibility possibility = possibilities.get(0);
        List<Integer> positions = this.getPositionsOfMPTag(possibility);
        if (positions.size() > 0) {
            Couple aCoupleAvant = null;
            int possibilitiesSize = possibilities.size();
            int i = 0;
            while (i < possibilitiesSize) {
                Possibility aPossibility = possibilities.get(i);
                List<Couple> couples = aPossibility.getCouples();
                boolean toTake = true;
                int j = 0;
                while (j < positions.size()) {
                    MicroPatternMark lastMpMarkBefore;
                    aCoupleAvant = null;
                    int pos = positions.get(j);
                    if (pos > 0) {
                        aCoupleAvant = couples.get(pos - 1);
                    }
                    if ((lastMpMarkBefore = this.getLastMPDeclaration(aCoupleAvant)) == null) {
                        toTake = false;
                    } else {
                        int i1 = aCoupleAvant.getInterval().getTagExt1().getIndex();
                        int i2 = aCoupleAvant.getInterval().getTagExt2().getIndex();
                        CharSequence text = aCoupleAvant.getInterval().getEnclosingTag().getGeneratedInfo().getText();
                        text.subSequence(i1, i2).toString();
                        this._context.getAllText().subSequence(lastMpMarkBefore.getBeginOffset(), lastMpMarkBefore.getEndOffset());
                    }
                    ++j;
                }
                if (toTake) {
                    bestPossibilities.add(aPossibility);
                }
                ++i;
            }
        }
        if (bestPossibilities.size() > 0) {
            best = (Possibility)bestPossibilities.get(0);
        }
        return best;
    }

    protected void setConstraints(Possibility bestPossibility) {
        List<Couple> couples = bestPossibility.getCouples();
        MicroPatternMark mark2 = null;
        int couplesSize = couples.size();
        int i = 0;
        while (i < couplesSize) {
            Couple couple = couples.get(i);
            Interval interval = couple.getInterval();
            List<MicroPatternMark> marks = couple.getMpMarks();
            int marksSize = marks.size();
            ITagExtremity2 tagExt1 = interval.getTagExt1();
            ITagExtremity2 tagExt2 = interval.getTagExt2();
            if (marksSize > 0) {
                ConstraintType type;
                int indexInText;
                MicroPatternMark mark;
                if (i == 0) {
                    mark = marks.get(marksSize - 1);
                    indexInText = mark.getEndOffset();
                    type = ConstraintType.GreaterOrEqual;
                    this._constraints.setTagExtremity(tagExt2.getTag(), tagExt2.isTagStart(), indexInText, type);
                } else if (i == couplesSize - 1) {
                    mark = marks.get(0);
                    indexInText = mark.getBeginOffset();
                    type = ConstraintType.LowerOrEqual;
                    this._constraints.setTagExtremity(tagExt1.getTag(), tagExt1.isTagStart(), indexInText, type);
                } else {
                    MicroPatternMark mark1 = marks.get(0);
                    int indexInText1 = mark1.getBeginOffset();
                    ConstraintType type1 = ConstraintType.LowerOrEqual;
                    this._constraints.setTagExtremity(tagExt1.getTag(), tagExt1.isTagStart(), indexInText1, type1);
                    mark2 = marks.get(marksSize - 1);
                    int indexInText2 = mark2.getEndOffset();
                    ConstraintType type2 = ConstraintType.GreaterOrEqual;
                    this._constraints.setTagExtremity(tagExt2.getTag(), tagExt2.isTagStart(), indexInText2, type2);
                }
            }
            ++i;
        }
    }

    private void log(ITagExtremity2 tagExt, int index, ConstraintType type) {
        if (Trace.traceOn) {
            Trace.outPrintln((String)"========Constraint set================");
            String inter = "[" + tagExt.getIndex() + " ; " + tagExt.getIndex() + "]";
            Trace.outPrintln((String)("GenTag name = " + tagExt.getTagName() + inter));
            if (tagExt.isTagStart()) {
                Trace.outPrintln((String)("Begin Index is " + type + " " + index));
            } else {
                Trace.outPrintln((String)("End Index is " + type + " " + index));
            }
            Trace.outPrintln((String)"========Constraint set================");
        }
    }

    private int sum(int[] places, int max) {
        int sum = 0;
        int i = 0;
        while (i < places.length) {
            if ((sum += places[i]) > max) {
                return sum;
            }
            ++i;
        }
        return sum;
    }

    protected boolean testValidity(Possibility aPossibility) {
        List<Couple> couples = aPossibility.getCouples();
        int couplesSize = couples.size();
        int i = 0;
        while (i < couplesSize) {
            Couple aCouple = couples.get(i);
            List<MicroPatternMark> mpMarks = aCouple.getMpMarks();
            IGeneratedTag tag = aCouple.getInterval().getEnclosingTag();
            if (this.hasTheMPProperty(tag) && mpMarks.size() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class Couple {
        Interval interval;
        List<MicroPatternMark> mpMarks;

        public Couple(Interval interval, List<MicroPatternMark> mpMarks) {
            this.interval = interval;
            this.mpMarks = mpMarks;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public List<MicroPatternMark> getMpMarks() {
            return this.mpMarks;
        }
    }

    private static class Interval {
        int number;
        ITagExtremity2 tagExt1;
        ITagExtremity2 tagExt2;
        IGeneratedTag enclosingTag;
        boolean hasMPProperty;

        public Interval(int number, ITagExtremity2 tagExt1, ITagExtremity2 tagExt2, IGeneratedTag enclosingTag, boolean hasMPProperty) {
            this.number = number;
            this.tagExt1 = tagExt1;
            this.tagExt2 = tagExt2;
            this.enclosingTag = enclosingTag;
            this.hasMPProperty = hasMPProperty;
        }

        public ITagExtremity2 getTagExt1() {
            return this.tagExt1;
        }

        public ITagExtremity2 getTagExt2() {
            return this.tagExt2;
        }

        public IGeneratedTag getEnclosingTag() {
            return this.enclosingTag;
        }

        public boolean isHasMPProperty() {
            return this.hasMPProperty;
        }

        public int getNumber() {
            return this.number;
        }
    }

    private static class Possibility {
        List<Couple> couples;

        public Possibility(List<Couple> couplesList) {
            this.couples = couplesList;
        }

        public List<Couple> getCouples() {
            if (this.couples == null) {
                this.couples = new ArrayList<Couple>();
            }
            return this.couples;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.couples.size()) {
                Couple aCouple = this.couples.get(i);
                Interval interval = aCouple.getInterval();
                ITagExtremity2 ext1 = interval.getTagExt1();
                sb.append(ext1.isTagStart() ? "[" : "]");
                List<MicroPatternMark> mpm = aCouple.getMpMarks();
                for (MicroPatternMark aMPM : mpm) {
                    sb.append(aMPM.isBeginDeclaration() ? " D " : " F ");
                }
                if (i == this.couples.size() - 1) {
                    ITagExtremity2 ext2 = interval.getTagExt2();
                    sb.append(ext2.isTagStart() ? "[" : "]");
                }
                sb.append("  ");
                ++i;
            }
            return sb.toString();
        }
    }
}

