/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.icu.lang.UCharacter;
import com.ibm.pdp.engine.draft.changes.MatchingContext;
import com.ibm.pdp.engine.draft.changes.MatchingExtension;
import com.ibm.pdp.engine.extension.IPatternAnalyzer;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextMatcher;
import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.framework.cobol.matching.CobolFullLinePartitioner;
import com.ibm.pdp.pacbase.extension.matching.CobolTextMatcher;
import java.io.Serializable;

public class CobolMatchingExtension
implements MatchingExtension,
Serializable {
    protected MatchingContext context;
    protected transient long[] significantBitsRef;
    protected transient int nbComputedBitsRef;
    protected transient long[] significantBits;
    protected transient int nbComputedBits;
    protected ITextMatcher textMatcher;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void setMatchingContext(MatchingContext newContext) {
        this.nbComputedBitsRef = 0;
        this.nbComputedBits = 0;
        this.context = newContext;
    }

    public boolean isSignificantChar(int idx) {
        if (idx >= this.nbComputedBits) {
            this.computeSignificantBits();
        }
        return (this.significantBits[idx / 64] & 1L << idx % 64) == 0L;
    }

    protected void computeSignificantBits() {
        CharSequence text = this.context.getText();
        this.significantBits = this.computeBits(this.nbComputedBits, this.significantBits, text);
        this.nbComputedBits = text.length();
    }

    public boolean isSignificantReferenceChar(int refIdx) {
        if (refIdx >= this.nbComputedBitsRef) {
            this.computeSignificantRefBits();
        }
        return (this.significantBitsRef[refIdx / 64] & 1L << refIdx % 64) == 0L;
    }

    protected void computeSignificantRefBits() {
        CharSequence text = this.context.getReferenceText();
        this.significantBitsRef = this.computeBits(this.nbComputedBitsRef, this.significantBitsRef, text);
        this.nbComputedBitsRef = text.length();
    }

    protected long[] computeBits(int alreadyComputedBits, long[] bits, CharSequence text) {
        int textLength = text.length();
        int arrayMinimumLength = (textLength + 63) / 64;
        if (bits == null) {
            bits = new long[1 + arrayMinimumLength];
        } else if (bits.length < arrayMinimumLength) {
            long[] newBits = new long[1 + arrayMinimumLength];
            System.arraycopy(bits, 0, newBits, 0, (alreadyComputedBits + 63) / 64);
            bits = newBits;
        }
        int beginIdx = this.findLineBeginIdx(alreadyComputedBits, text);
        this.computeBits(0, beginIdx, textLength, bits, text);
        return bits;
    }

    protected int findLineBeginIdx(int idx, CharSequence text) {
        while (idx > 0) {
            char c = text.charAt(idx);
            if (c == '\r' || c == '\n') {
                return idx;
            }
            --idx;
        }
        return idx;
    }

    protected int computeBits(int column, int beginIdx, int endIdx, long[] bits, CharSequence text) {
        int idx = beginIdx / 64;
        int shift = beginIdx % 64;
        int i = beginIdx;
        while (i < endIdx) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                int n = idx;
                bits[n] = bits[n] | 1L << shift;
                column = -1;
            } else if (UCharacter.isWhitespace((int)c)) {
                int n = idx;
                bits[n] = bits[n] | 1L << shift;
            } else {
                int n = idx;
                bits[n] = bits[n] & (1L << shift ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (++shift == 64) {
                ++idx;
                shift = 0;
            }
            ++column;
            ++i;
        }
        return column;
    }

    protected int computeBitsInitial(int column, int beginIdx, int endIdx, long[] bits, CharSequence text) {
        int idx = beginIdx / 64;
        int shift = beginIdx % 64;
        boolean ignoreToEndOfLine = false;
        int i = beginIdx;
        while (i < endIdx) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                int n = idx;
                bits[n] = bits[n] | 1L << shift;
                ignoreToEndOfLine = false;
                column = -1;
            } else if (column == 6) {
                if (c == '*') {
                    ignoreToEndOfLine = true;
                }
                int n = idx;
                bits[n] = bits[n] & (1L << shift ^ 0xFFFFFFFFFFFFFFFFL);
            } else if (ignoreToEndOfLine || column < 6 || column > 71 || UCharacter.isWhitespace((int)c)) {
                int n = idx;
                bits[n] = bits[n] | 1L << shift;
            } else {
                int n = idx;
                bits[n] = bits[n] & (1L << shift ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (++shift == 64) {
                ++idx;
                shift = 0;
            }
            ++column;
            ++i;
        }
        return column;
    }

    protected boolean isColumnIgnored(int column) {
        return column < 6 || column > 71;
    }

    public void referenceTextChanged(int beginIdx, CharSequence oldText, CharSequence newText) {
        if (beginIdx < this.nbComputedBitsRef) {
            this.nbComputedBitsRef = beginIdx;
        }
    }

    public void textChanged(int beginIdx, CharSequence oldText, CharSequence newText) {
        if (beginIdx < this.nbComputedBits) {
            this.nbComputedBits = beginIdx;
        }
    }

    public ITextPartitioner newTextPartitioner() {
        return new CobolFullLinePartitioner();
    }

    public IPatternAnalyzer newPatternAnalyser() {
        return null;
    }

    public ITextAnalyzer newTextAnalyzer() {
        return null;
    }

    public ITextMatcher newTextMatcher() {
        if (this.textMatcher == null) {
            this.textMatcher = new CobolTextMatcher();
        }
        return this.textMatcher;
    }
}

