/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.extension.TextToken;

public class CobolLinePartitioner
implements ITextPartitioner {
    protected static final byte OTHER_CHR = 0;
    protected static final byte SPECIAL_CHR = 1;
    protected static final byte UPPERCASE_CHR = 2;
    protected static final byte LOWERCASE_CHR = 3;
    protected static final byte WHITE_CHR = 4;
    protected static final byte EOL_CHR = 5;
    protected static final byte QUOTE_CHR = 6;
    protected static final char[] specials = new char[]{'/', '.', ',', ';', ':', '+', '*', '!', '#', '%', '&', '?', '|', '~', '<', '>', '=', '(', ')', '[', ']', '{', '}', '\\', '\u00b0'};
    protected static final char[] uppercases = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    protected static final char[] whites = new char[]{' '};
    protected static final char[] eols = new char[]{'\n', '\r'};
    protected static final char[] quotes = new char[]{'\"', '\''};
    protected static final int STANDARD = 0;
    protected static final int COMMENT = 1;
    protected static byte[] charCategory;
    protected static char minRegisteredChar;
    protected static char maxRegisteredChar;
    protected CharSequence text;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        minRegisteredChar = (char)65535;
        maxRegisteredChar = '\u0000';
        CobolLinePartitioner.updateMinMaxChar(specials);
        CobolLinePartitioner.updateMinMaxChar(uppercases);
        CobolLinePartitioner.updateMinMaxChar(whites);
        CobolLinePartitioner.updateMinMaxChar(eols);
        CobolLinePartitioner.updateMinMaxChar(quotes);
        charCategory = new byte[maxRegisteredChar - minRegisteredChar + 1];
        CobolLinePartitioner.setCategory(specials, (byte)1);
        CobolLinePartitioner.setCategory(uppercases, (byte)2);
        CobolLinePartitioner.setCategory(whites, (byte)4);
        CobolLinePartitioner.setCategory(eols, (byte)5);
        CobolLinePartitioner.setCategory(quotes, (byte)6);
    }

    protected static void updateMinMaxChar(char[] chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < minRegisteredChar) {
                minRegisteredChar = c;
            } else if (c > maxRegisteredChar) {
                maxRegisteredChar = c;
            }
            ++n2;
        }
    }

    protected static void setCategory(char[] chars, byte category) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            CobolLinePartitioner.charCategory[c - CobolLinePartitioner.minRegisteredChar] = category;
            ++n2;
        }
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence newText) {
        this.text = newText;
    }

    public TextToken newToken() {
        return new CobolLineToken();
    }

    public TextToken newToken(int beginIndex, int endIndex, int category, boolean ignoreCase, int hash) {
        return new CobolLineToken(beginIndex, endIndex, category, ignoreCase, hash);
    }

    public boolean nextToken(TextToken token) {
        CharSequence txt = this.text;
        int length = txt.length();
        int idx = token.endIdx;
        while (idx < length) {
            block12: {
                boolean foundVisibleChar;
                int multiplier;
                int hash;
                int chr = txt.charAt(idx);
                while (chr == 13 || chr == 10) {
                    if (++idx == length) {
                        return false;
                    }
                    chr = this.text.charAt(idx);
                }
                int column = 1;
                int beginIdx = idx;
                do {
                    if (++idx == length) {
                        return false;
                    }
                    chr = txt.charAt(idx);
                    if (chr == 13 || chr == 10) break block12;
                } while (++column < 7);
                if (chr == 42) {
                    hash = chr;
                    multiplier = 31;
                    while (++idx < length) {
                        chr = txt.charAt(idx);
                        if (chr == 13 || chr == 10) break;
                        if (chr == 32 || ++column > 72) continue;
                        hash += multiplier * chr;
                        multiplier = (multiplier << 5) - multiplier;
                    }
                    token.beginIdx = beginIdx;
                    token.endIdx = idx;
                    token.category = 1;
                    token.hash = hash;
                    token.ignoreCase = false;
                    return true;
                }
                hash = 0;
                multiplier = 1;
                boolean bl = foundVisibleChar = chr != 32;
                if (foundVisibleChar) {
                    if (chr >= 65 && chr <= 90) {
                        chr = (char)(chr | 0x20);
                    }
                    hash = chr;
                    multiplier = 31;
                }
                while (++idx < length) {
                    chr = txt.charAt(idx);
                    if (chr == 13 || chr == 10) break;
                    if (chr == 32 || ++column > 72) continue;
                    foundVisibleChar = true;
                    if (chr >= 65 && chr <= 90) {
                        chr = (char)(chr | 0x20);
                    }
                    hash += multiplier * chr;
                    multiplier = (multiplier << 5) - multiplier;
                }
                if (foundVisibleChar) {
                    token.beginIdx = beginIdx;
                    token.endIdx = idx;
                    token.category = 0;
                    token.hash = hash;
                    token.ignoreCase = true;
                    return true;
                }
            }
            ++idx;
        }
        return false;
    }

    protected static int category(char c) {
        return c >= minRegisteredChar && c <= maxRegisteredChar ? charCategory[c - minRegisteredChar] : 0;
    }

    public void textChanged(int index, int nbRemoved, int nbAdded) {
    }

    protected static class CobolLineToken
    extends TextToken {
        protected CobolLineToken() {
        }

        protected CobolLineToken(int beginIdx, int endIdx, int category, boolean ignoreCase, int hash) {
            super(beginIdx, endIdx, category, ignoreCase, hash);
        }

        public boolean match(CharSequence text, int wordCategory, boolean wordIgnoreCase, int wordHash, CharSequence wordText) {
            if (wordHash != this.hash || wordCategory != this.category || wordIgnoreCase != this.ignoreCase) {
                return false;
            }
            return wordCategory != 1 ? this.matchStandardLine(text, wordText) : this.matchCommentLine(text, wordText);
        }

        /*
         * Unable to fully structure code
         */
        public boolean matchStandardLine(CharSequence left, CharSequence right) {
            leftIdx = this.beginIdx + 6;
            leftStopIdx = Math.min(this.endIdx, this.beginIdx + 72);
            rightIdx = 6;
            rightStopIdx = Math.min(right.length(), 72);
            standardLeftChar = false;
            standardRightChar = false;
            quote = '\u0000';
            block0: while (rightIdx < rightStopIdx && leftIdx < leftStopIdx) {
                leftChr = left.charAt(leftIdx++);
                if (quote == '\u0000') {
                    while (leftChr == ' ') {
                        if (leftIdx == leftStopIdx) break block0;
                        standardLeftChar = false;
                        leftChr = left.charAt(leftIdx++);
                    }
                }
                rightChr = right.charAt(rightIdx++);
                if (quote == '\u0000') {
                    while (rightChr == ' ') {
                        if (rightIdx == rightStopIdx) break block0;
                        standardRightChar = false;
                        rightChr = right.charAt(rightIdx++);
                    }
                }
                v0 = standardChar = (rightCat = CobolLinePartitioner.category(rightChr)) == 0 || rightCat == 2;
                if (standardLeftChar != standardRightChar && standardChar) {
                    return false;
                }
                leftCat = CobolLinePartitioner.category(leftChr);
                if (rightCat != leftCat && quote == '\u0000') {
                    if (rightCat == 2) {
                        rightChr = (char)(rightChr | 32);
                    } else if (leftCat == 2) {
                        leftChr = (char)(leftChr | 32);
                    }
                }
                if (rightChr != leftChr) {
                    return false;
                }
                if (rightCat == 6) {
                    if (quote == '\u0000') {
                        quote = rightChr;
                    } else if (quote == rightChr) {
                        quote = '\u0000';
                    }
                }
                standardLeftChar = standardRightChar = standardChar;
            }
            if (quote == '\u0000') ** GOTO lbl47
            return leftIdx == leftStopIdx && rightIdx == rightStopIdx;
lbl-1000:
            // 1 sources

            {
                if (left.charAt(leftIdx++) == ' ') continue;
                return false;
lbl47:
                // 2 sources

                ** while (leftIdx < leftStopIdx)
            }
lbl48:
            // 2 sources

            while (rightIdx < rightStopIdx) {
                if (right.charAt(rightIdx++) == ' ') continue;
                return false;
            }
            return true;
        }

        public boolean matchCommentLine(CharSequence left, CharSequence right) {
            int leftIdx = this.beginIdx + 6;
            int leftStopIdx = Math.min(this.endIdx, this.beginIdx + 72);
            int rightIdx = 6;
            int rightStopIdx = Math.min(right.length(), 72);
            block0: while (rightIdx < rightStopIdx && leftIdx < leftStopIdx) {
                char leftChr = left.charAt(leftIdx++);
                while (leftChr == ' ') {
                    if (leftIdx == leftStopIdx) break block0;
                    leftChr = left.charAt(leftIdx++);
                }
                char rightChr = right.charAt(rightIdx++);
                while (rightChr == ' ') {
                    if (rightIdx == rightStopIdx) break block0;
                    rightChr = right.charAt(rightIdx++);
                }
                if (rightChr == leftChr) continue;
                return false;
            }
            while (leftIdx < leftStopIdx) {
                if (left.charAt(leftIdx++) == ' ') continue;
                return false;
            }
            while (rightIdx < rightStopIdx) {
                if (right.charAt(rightIdx++) == ' ') continue;
                return false;
            }
            return true;
        }
    }
}

