/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.matching;

import com.ibm.icu.lang.UCharacter;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.extension.matching.CobolLabel;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import java.util.List;

public class BasicPacLabelRecognizer {
    private static final String SEVEN_SPACES = "       ";
    private static final String SECTION = " SECTION.";
    private static final int MARGE_B_Idx = 11;
    private static final String[] SPECIAL_KEYWORDS = new String[]{" DECLARATIVES.", " END DECLARATIVES.", " MAIN SECTION.", " END-OF-DISPLAY.", " END-OF-RECEPTION."};
    private static String[] samples = new String[]{"      *N01.      NOTE *************************************.            JOINCOID", "\t   *               *                                   *             JOINCOID", "\t   *               *INITIALISATIONS                    *             JOINCOID", "\t   *               *                                   *             JOINCOID", "\t   *               *************************************.            JOINCOID", "       F01.      EXIT.                                                  JOINCOID", "\t   *N01CO.    NOTE *INITIALISATION FICHIER  CO-FICHIER *.            JOINCOID", "\t    F01CO.    OPEN OUTPUT                   CO-FICHIER.              JOINCOID", "\t    F01CO-FN. EXIT.                                                  JOINCOID", "       F2210.    EXIT.", "       F2210-FN. EXIT", "       F23.      EXIT.", "                 IF A = 1 GO TO NEXT SENTENCE ELSE GO TO F23-FN.", "                 DISPLAY \"F23.\".", "       F23-FN.   EXIT.", "       F40.      EXIT.", "       F40AB.    IF A = 1 GO TO NEXT SENTENCE", "                               ELSE GO TO F40AB-FN.", "       F40AB100. DISPLAY \"message\".", "      *F40BB.    IF A = 1 NEXT SENTENCE ELSE GO TO F40BB-FN.", "       F40BB\u00e9.    IF A = 1 NEXT SENTENCE ELSE GO TO F40BB-FN.", "       F40BB.    IF A = 1 NEXT SENTENCE ELSE GO TO F40BB-FN.", "      *F40BB100. DISPLAY \"message\".", "       F40BB-FN. EXIT.", "       F40CB.    IF A = 1 NEXT SENTENCE ELSE GO TO F40CB-FN.", "       F40CB100. DISPLAY \"message\"."};
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static PacLabel createPacLabel(String tagName, boolean isBeginLabel) {
        PacLabel pl = new PacLabel();
        if (isBeginLabel) {
            pl.setPacLabel(tagName);
        } else {
            pl.setPacLabel(tagName.substring(0, tagName.length() - 3));
        }
        pl.setPosInLine(0);
        pl.setBeginningLabel(isBeginLabel);
        pl.setFunction(true);
        pl.setComment(false);
        return pl;
    }

    private static CobolLabel createCobolLabel(String tagName, int positionInLine) {
        CobolLabel cl = new CobolLabel();
        cl.setPacLabel(tagName);
        cl.setPosInLine(positionInLine);
        return cl;
    }

    public static boolean isLabelAMacroDetailedLine(String inputLabel) {
        if (inputLabel == null || inputLabel.length() < 8) {
            return false;
        }
        String part1 = String.valueOf('F') + inputLabel.substring(1, 5);
        if (BasicPacLabelRecognizer.findPacbaseLabelInTag(part1) == null) {
            return false;
        }
        String part2 = inputLabel.substring(5, 8);
        return PdpTool.isStringNumeric((String)part2);
    }

    public static boolean isLabelAFunctionMacroDetailedLine(String inputLabel) {
        if (inputLabel == null || inputLabel.length() < 6) {
            return false;
        }
        String part1 = String.valueOf('F') + inputLabel.substring(1, 3);
        if (BasicPacLabelRecognizer.findPacbaseLabelInTag(part1) == null) {
            return false;
        }
        String part2 = inputLabel.substring(3, 6);
        if (!PdpTool.isStringNumeric((String)part2)) {
            return false;
        }
        if (inputLabel.length() > 6) {
            String part3 = inputLabel.substring(6);
            if (part3.length() != 3) {
                return false;
            }
            if (!PdpTool.isStringNumeric((String)part3)) {
                return false;
            }
        }
        return true;
    }

    private static PacLabel getPacbaseFunction(String tagName) {
        int length = tagName.length();
        if (length < 3 || length > 8) {
            return null;
        }
        char c1 = tagName.charAt(1);
        char c2 = tagName.charAt(2);
        if (!UCharacter.isLetterOrDigit((int)c1) && c1 != '-') {
            return null;
        }
        if (!UCharacter.isLetterOrDigit((int)c2) && c2 != '-') {
            return null;
        }
        if (length == 3) {
            return BasicPacLabelRecognizer.createPacLabel(tagName, true);
        }
        if (length < 5) {
            return null;
        }
        char c3 = tagName.charAt(3);
        if (c3 == '-' && tagName.substring(4).equalsIgnoreCase("FN")) {
            return BasicPacLabelRecognizer.createPacLabel(tagName, false);
        }
        char c4 = tagName.charAt(4);
        if (!UCharacter.isLetterOrDigit((int)c3) && c3 != '-') {
            return null;
        }
        if (!UCharacter.isLetterOrDigit((int)c4) && c4 != '-') {
            return null;
        }
        if (length == 5) {
            return BasicPacLabelRecognizer.createPacLabel(tagName, true);
        }
        if (length < 8) {
            return null;
        }
        char c5 = tagName.charAt(5);
        if (c5 == '-') {
            if (!tagName.substring(6).equalsIgnoreCase("FN")) {
                return null;
            }
            return BasicPacLabelRecognizer.createPacLabel(tagName, false);
        }
        return null;
    }

    public static CobolLabel findCobolLabelInTag(String tagName) {
        StringBuilder sb = new StringBuilder(8 + tagName.length());
        sb.append(SEVEN_SPACES);
        sb.append(tagName);
        sb.append('.');
        return BasicPacLabelRecognizer.findCobolLabelInLine(sb.toString());
    }

    private static int findSpecialKeywordInLine(String line) {
        int i = 0;
        while (i < SPECIAL_KEYWORDS.length) {
            int idx = line.indexOf(SPECIAL_KEYWORDS[i], 6);
            if (idx != -1 && idx < 11) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static CobolLabel findLabelInLine(String line) {
        if (line == null || line.length() < 10 || line.charAt(6) == '*' || line.charAt(6) == '-') {
            return null;
        }
        idx = BasicPacLabelRecognizer.findSpecialKeywordInLine(line);
        if (idx != -1) {
            label = BasicPacLabelRecognizer.createCobolLabel(line.substring(7, BasicPacLabelRecognizer.SPECIAL_KEYWORDS[idx].length() + 5), 7);
            label.setSpecialKeyword(true);
            return label;
        }
        i = 7;
        while (i < line.length()) {
            if (!UCharacter.isWhitespace((int)line.charAt(i))) break;
            ++i;
        }
        if (i < 11) ** GOTO lbl27
        return null;
lbl-1000:
        // 1 sources

        {
            c = line.charAt(i);
            if (UCharacter.isWhitespace((int)c)) {
                if (line.length() > i + 8 && line.indexOf(" SECTION.", i) != -1) {
                    label = BasicPacLabelRecognizer.createCobolLabel(line.substring(7, i + 8), 7);
                    label.setSpecialKeyword(true);
                    return label;
                }
                return null;
            }
            if (c == '.') {
                label = BasicPacLabelRecognizer.createCobolLabel(line.substring(7, i), 7);
                label.setSpecialKeyword(false);
                return label;
            }
            ++i;
lbl27:
            // 2 sources

            ** while (i < line.length())
        }
lbl28:
        // 1 sources

        return null;
    }

    public static CobolLabel findCobolLabelInLine(String line) {
        if (line == null || line.length() < 10 || line.charAt(6) == '*' || line.charAt(6) == '-') {
            return null;
        }
        int i = 7;
        int areaAMaxPosition = 11;
        int length = line.length();
        int c = 32;
        boolean found = false;
        while (i < length && i < areaAMaxPosition) {
            c = line.charAt(i);
            if (c == 70 || c == 102) {
                found = true;
                break;
            }
            if (!UCharacter.isWhitespace((int)c)) break;
            ++i;
        }
        if (!found) {
            return null;
        }
        int j = i + 1;
        found = false;
        while (j < length) {
            c = line.charAt(j);
            if (c == 46) {
                found = true;
                break;
            }
            if (UCharacter.isWhitespace((int)c)) break;
            ++j;
        }
        if (!found) {
            return null;
        }
        CobolLabel label = BasicPacLabelRecognizer.createCobolLabel(line.substring(i, j), i);
        return label;
    }

    public static PacLabel findPacbaseLabelInLine(String line) {
        CobolLabel cl = BasicPacLabelRecognizer.findCobolLabelInLine(line);
        if (cl == null) {
            return null;
        }
        PacLabel label = BasicPacLabelRecognizer.getPacbaseFunction(cl.getPacLabel());
        if (label != null) {
            label.setPosInLine(cl.getPosInLine());
        }
        return label;
    }

    public static PacLabel findPacbaseLabelInTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        if (tagName.length() < 3) {
            return null;
        }
        char c = tagName.charAt(0);
        if (c == 'F' || c == 'f') {
            return BasicPacLabelRecognizer.getPacbaseFunction(tagName);
        }
        return null;
    }

    public static void main(String[] args) {
        int counter = 0;
        List aList = PdpTool.readFileContents((String)"C:\\Workspaces\\RDZ75_Runtime\\D350Loc.GEN\\DOC\\GEN\\DI00RE.cbl", (int)1, (int)-1);
        samples = new String[aList.size()];
        aList.toArray(samples);
        int i = 0;
        while (i < samples.length) {
            PacLabel pl = BasicPacLabelRecognizer.findPacbaseLabelInLine(samples[i]);
            if (pl != null) {
                ++counter;
                if (pl.isBeginningLabel()) {
                    System.out.println(pl.getPacLabel());
                } else {
                    System.out.println(String.valueOf(pl.getPacLabel()) + "-FN");
                }
            }
            ++i;
        }
        System.out.println("Number of labels found : " + counter);
    }
}

