/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.pacbase.extension.ProcedureLine;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import com.ibm.pdp.pacbase.extension.ServerTags;
import org.eclipse.jface.viewers.TreePath;

public class TagsAndLabels
implements ProcedureLineConstants {
    private int tagType;
    private String visibleTag;
    private int levelWithinProc;
    private boolean isServerFuncAndFunc;
    private boolean isCSServer;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TagsAndLabels(int sc, String lab, boolean forCSServer) {
        this.isCSServer = forCSServer;
        this.visibleTag = lab;
        this.tagType = TagsAndLabels.getType(sc, this.getVisibleTag(), forCSServer);
        this.isServerFuncAndFunc = forCSServer && ServerTags.isServerFunctionAndFunction(this.visibleTag);
        this.levelWithinProc = TagsAndLabels.getLevelWithinProc(this.tagType);
        if (this.tagType == 9) {
            this.levelWithinProc = sc - 2;
        }
        if ("F80-OKKO".equals(this.visibleTag) || "F80-OK".equals(this.visibleTag)) {
            this.levelWithinProc = 2;
        }
    }

    public TagsAndLabels(TreePath tp, boolean forCSServer) {
        this.isCSServer = forCSServer;
        int segmentCount = tp.getSegmentCount();
        this.visibleTag = ((ITextNode)tp.getSegment(segmentCount - 1)).getLabel().toString();
        if (segmentCount == 2 && !this.visibleTag.equals("PROCEDURE")) {
            this.tagType = -1;
        } else if (segmentCount == 1 || 1 < segmentCount && !((ITextNode)tp.getSegment(1)).getLabel().equals("PROCEDURE")) {
            this.tagType = -1;
        } else {
            this.tagType = TagsAndLabels.getType(segmentCount, this.getVisibleTag(), forCSServer);
            this.isServerFuncAndFunc = forCSServer && segmentCount == 3 && ServerTags.isServerFunctionAndFunction(this.visibleTag);
            this.levelWithinProc = TagsAndLabels.getLevelWithinProc(this.tagType);
            if (this.tagType == 9) {
                this.levelWithinProc = segmentCount - 2;
            }
            if ("F80-OKKO".equals(this.visibleTag) || "F80-OK".equals(this.visibleTag)) {
                this.levelWithinProc = 2;
            }
        }
    }

    public boolean isWithinProcedure() {
        return this.tagType != -1;
    }

    public String getLongVisibleTag() {
        return this.visibleTag;
    }

    public String getVisibleTag() {
        if (this.visibleTag == null) {
            return "";
        }
        int index = this.visibleTag.indexOf(".");
        return index > -1 ? this.visibleTag.substring(0, index) : this.visibleTag;
    }

    public int getType() {
        return this.tagType;
    }

    public int getLevelWithinProc() {
        return this.levelWithinProc;
    }

    public String getFunctionCode() {
        if (this.tagType == -1 || this.tagType == 22) {
            return "";
        }
        if ("F80-OKKO".equals(this.visibleTag)) {
            return "80";
        }
        if (this.visibleTag == null) {
            return "";
        }
        int len = this.visibleTag.length();
        return len > 0 ? this.visibleTag.substring(1, Math.min(3, len)) : "";
    }

    public String getSubFunctionCode() {
        if (this.tagType == -1 || this.tagType == 22) {
            return "";
        }
        if ("F80-OKKO".equals(this.visibleTag)) {
            return "99";
        }
        if (this.visibleTag == null) {
            return "";
        }
        int len = this.visibleTag.length();
        if (6 < len && this.visibleTag.charAt(4) == '-') {
            return this.visibleTag.substring(5, 7);
        }
        if (5 < len && this.visibleTag.charAt(3) == '-') {
            return this.visibleTag.substring(4, 6);
        }
        return 2 < len ? this.visibleTag.substring(3, Math.min(5, len)) : "";
    }

    private static int getType(int sc, String label, boolean forCSServer) {
        boolean noTiret;
        boolean bl = noTiret = label.indexOf("-") == -1;
        if (sc == 2 && label.equals("PROCEDURE")) {
            return 0;
        }
        if (sc == 3 && label.equals("PROCEDURE-DIVISION")) {
            return 0;
        }
        if (sc == 4 && label.equals("F80-OKKO")) {
            return 10;
        }
        if (sc == 4 && label.equals("F80-OK")) {
            return 10;
        }
        if (sc == 3 && (label.equals("F3999") || label.equals("F6999") || label.equals("F9099"))) {
            return 10;
        }
        if (sc == 3 && (label.equals("END-OF-DISPLAY") || label.equals("END-OF-RECEPTION") || label.equals("FEND-PGM"))) {
            return 11;
        }
        if (forCSServer && sc == 3 && ServerTags.isServerFunction(label)) {
            return 17;
        }
        if (forCSServer && sc == 4 && ServerTags.isServerSubFunction(label)) {
            return 18;
        }
        if (forCSServer && sc == 5 && ServerTags.isServerSub3LevelFunction(label)) {
            return 19;
        }
        if (forCSServer && sc == 6 && ServerTags.isServerSub4LevelFunction(label)) {
            return 20;
        }
        if (forCSServer && sc == 7 && ServerTags.isServerSub5LevelFunction(label)) {
            return 21;
        }
        if (sc == 1 && noTiret && label.length() == 3 && label.charAt(0) == 'F') {
            return 1;
        }
        if (sc == 3 && noTiret && label.length() == 3 && label.charAt(0) == 'F') {
            return 1;
        }
        if (sc == 4 && noTiret && label.length() == 3 && label.charAt(0) == 'N') {
            return 3;
        }
        if (sc == 3 && noTiret && label.length() == 5 && label.charAt(0) == 'F') {
            return 5;
        }
        if (sc >= 4 && noTiret && label.length() == 5 && label.charAt(0) == 'F') {
            return 2;
        }
        if ((sc == 4 || sc == 5) && noTiret && label.length() == 5 && label.charAt(0) == 'N') {
            return 4;
        }
        if (sc == 4 && noTiret && label.length() == 4 && label.charAt(0) == 'F') {
            return 6;
        }
        if (sc == 4 && !noTiret && label.charAt(0) == 'F') {
            return 7;
        }
        if (sc == 5 && !noTiret && label.charAt(0) == 'F') {
            return 8;
        }
        if (sc >= 6 && !noTiret && label.charAt(0) == 'F') {
            return 9;
        }
        if (sc == 3 && noTiret && label.length() == 6 && label.charAt(0) == 'F') {
            return 12;
        }
        if (sc == 4 && noTiret && label.length() == 6 && label.charAt(0) == 'F') {
            return 13;
        }
        if (sc == 3 && noTiret && label.length() == 8 && label.charAt(0) == 'F') {
            return 14;
        }
        if ((sc == 4 || sc >= 5) && noTiret && label.length() == 8 && label.charAt(0) == 'F') {
            return 15;
        }
        if (sc == 3 && noTiret && label.length() == 5 && label.charAt(0) == 'F') {
            return 16;
        }
        return 22;
    }

    private static int getLevelWithinProc(int type) {
        if (type == 0) {
            return 0;
        }
        if (type == 1) {
            return 1;
        }
        if (type == 5) {
            return 1;
        }
        if (type == 3) {
            return 2;
        }
        if (type == 2) {
            return 2;
        }
        if (type == 4) {
            return 3;
        }
        if (type == 6) {
            return 2;
        }
        if (type == 7) {
            return 2;
        }
        if (type == 8) {
            return 3;
        }
        if (type == 10) {
            return 1;
        }
        if (type == 11) {
            return 1;
        }
        if (type == 13) {
            return 1;
        }
        if (type == 15) {
            return 2;
        }
        if (type == 16) {
            return 1;
        }
        return 0;
    }

    private static boolean isTagEqLabel(int type) {
        if (type == 0) {
            return true;
        }
        if (type == 1) {
            return true;
        }
        if (type == 5) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == 6) {
            return true;
        }
        if (type == 13) {
            return true;
        }
        if (type == 15) {
            return true;
        }
        if (type == 16) {
            return true;
        }
        return type == 11;
    }

    private boolean isTagEqLabel() {
        return TagsAndLabels.isTagEqLabel(this.tagType);
    }

    private static boolean isBalanced(int type) {
        if (type == 1) {
            return true;
        }
        if (type == 5) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == 6) {
            return true;
        }
        if (type == 7) {
            return true;
        }
        if (type == 8) {
            return true;
        }
        return type == 16;
    }

    public boolean isBalanced() {
        if (-1 < this.visibleTag.indexOf("F80")) {
            return false;
        }
        return TagsAndLabels.isBalanced(this.tagType);
    }

    public String[] getLabels() {
        if (TagsAndLabels.isBalanced(this.tagType) && this.isTagEqLabel()) {
            String[] labs = new String[]{this.visibleTag, String.valueOf(this.visibleTag) + "-FN"};
            return labs;
        }
        if (this.tagType == 10) {
            if ("F3999".equals(this.visibleTag) || "F6999".equals(this.visibleTag)) {
                String[] labs = new String[]{String.valueOf(this.visibleTag) + "-ITER-FI", String.valueOf(this.visibleTag) + "-ITER-FT", String.valueOf(this.visibleTag) + "-FN"};
                return labs;
            }
            if ("F9099".equals(this.visibleTag)) {
                String[] labs = new String[]{String.valueOf(this.visibleTag) + "-ITER-FN"};
                return labs;
            }
            if ("F80-OKKO".equals(this.visibleTag)) {
                String[] labs = new String[]{"F80-OK", "F80-KO", "F8099-FN"};
                return labs;
            }
            return new String[0];
        }
        if (this.tagType == 11 || this.tagType == 3 || this.tagType == 4) {
            String[] labs = new String[]{this.visibleTag};
            return labs;
        }
        return new String[0];
    }

    private static boolean isProcedure(int type) {
        return type == 0;
    }

    public boolean isBeginProcedure() {
        return TagsAndLabels.isProcedure(this.tagType);
    }

    private static boolean isFunction(int type) {
        return type == 1;
    }

    public boolean isFunction() {
        return TagsAndLabels.isFunction(this.tagType);
    }

    public boolean isFunctionNote() {
        return this.tagType == 3;
    }

    public boolean isSubFunctionNote() {
        return this.tagType == 4;
    }

    private static boolean isSub(int type) {
        return type == 6 || type == 2 || type == 7 || type == 8;
    }

    private static boolean isVariableSub(int type) {
        return type == 7 || type == 8;
    }

    private static boolean isFixedSub(int type) {
        return type == 6 || type == 2;
    }

    public boolean isSubFunction() {
        return TagsAndLabels.isSub(this.tagType);
    }

    public boolean isVariableSubFunction() {
        return TagsAndLabels.isVariableSub(this.tagType);
    }

    public boolean isVariableSubFromReservedFunction() {
        if (this.tagType != 7 && this.tagType != 8 && this.tagType != 9) {
            return false;
        }
        if (this.visibleTag.length() < 6) {
            return false;
        }
        if (this.visibleTag.charAt(0) != 'F') {
            return false;
        }
        boolean ok = false;
        int f = 0;
        while (f < functionsWithSeveralSubLevels.length) {
            if (this.visibleTag.indexOf(functionsWithSeveralSubLevels[f]) == 1) {
                ok = true;
            }
            ++f;
        }
        if (!ok) {
            return false;
        }
        int c = 0;
        while (c < categories.length) {
            if (this.visibleTag.charAt(3) == categories[c]) {
                ok = true;
            }
            ++c;
        }
        if (!ok) {
            return false;
        }
        return this.visibleTag.charAt(4) == '-';
    }

    public boolean isFixedSubFunction() {
        return TagsAndLabels.isFixedSub(this.tagType);
    }

    private static boolean isHeadSub(int type) {
        return type == 16 || type == 5;
    }

    public boolean isHeadSubFunction() {
        return TagsAndLabels.isHeadSub(this.tagType) || "F3999".equals(this.visibleTag) || "F6999".equals(this.visibleTag) || "F9099".equals(this.visibleTag);
    }

    public boolean is80xxxx2Level() {
        if (this.visibleTag.equals("F80-ssss") || this.visibleTag.equals("F80-VWER") || this.visibleTag.equals("F80-ER")) {
            return true;
        }
        int pos = this.visibleTag.indexOf("F80-");
        int len = this.visibleTag.length();
        if (pos != 0 || len != 4 + "F80-".length()) {
            return false;
        }
        return ProcedureLine.isZoneAlphaNum(this.visibleTag, "F80-".length(), len);
    }

    public boolean is80xxxx3Level() {
        int i;
        if (this.visibleTag.indexOf("F80-HELP-") == 0) {
            int i2 = 0;
            while (i2 < F80Ends.length) {
                if (this.visibleTag.length() == "F80-HELP-".length() + F80Ends[i2].length() - 1 && this.visibleTag.indexOf(F80Ends[i2]) > -1) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        if (this.visibleTag.indexOf("F80-") == 0) {
            i = 0;
            while (i < F80Ends.length) {
                if (this.visibleTag.length() == 4 + "F80-".length() + F80Ends[i].length() && this.visibleTag.indexOf(F80Ends[i]) > -1) {
                    return true;
                }
                ++i;
            }
            if (!this.isCSServer) {
                return false;
            }
        }
        if (this.isCSServer && this.visibleTag.indexOf("F80-") == 0) {
            i = 0;
            while (i < F80Ends.length) {
                int j = 0;
                while (j < F80ServerEnds.length) {
                    if (this.visibleTag.length() == 4 + "F80-".length() + F80Ends[i].length() + F80ServerEnds[j].length() && this.visibleTag.indexOf(F80Ends[i]) > -1 && this.visibleTag.indexOf(F80ServerEnds[j]) > -1) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    private static boolean isDetailedHeadFunc(int type) {
        return type == 12;
    }

    public boolean isDetailedHeadFunc() {
        return TagsAndLabels.isDetailedHeadFunc(this.tagType);
    }

    private static boolean isDetailedFunc(int type) {
        return type == 13;
    }

    public boolean isDetailedFunction() {
        return TagsAndLabels.isDetailedFunc(this.tagType);
    }

    private static boolean isDetailedHeadSub(int type) {
        return type == 14;
    }

    public boolean isDetailedHeadSub() {
        return TagsAndLabels.isDetailedHeadSub(this.tagType);
    }

    private static boolean isDetailedSub(int type) {
        return type == 15;
    }

    public boolean isDetailedSubFunction() {
        return TagsAndLabels.isDetailedSub(this.tagType);
    }

    public boolean labelOnly() {
        return this.tagType == 11;
    }

    public boolean isIter() {
        return this.tagType == 10;
    }

    public boolean hasIterFunctionAfter() {
        return this.tagType == 10 && !"F80-OKKO".equals(this.visibleTag) && !"F80-OK".equals(this.visibleTag) && this.levelWithinProc == 1;
    }

    public boolean hasIterSubFunctionAfter() {
        return this.tagType == 10 && this.levelWithinProc == 2;
    }

    public boolean hasIterInside() {
        return this.tagType == 10 && !"F80-OKKO".equals(this.visibleTag) && !"F80-OK".equals(this.visibleTag) && !"F9099".equals(this.visibleTag);
    }

    public boolean hasIterOK() {
        return this.tagType == 10 && ("F80-OKKO".equals(this.visibleTag) || "F80-OK".equals(this.visibleTag));
    }

    public boolean hasIterKO() {
        return this.tagType == 10 && ("F80-OKKO".equals(this.visibleTag) || "F80-OK".equals(this.visibleTag));
    }

    public boolean isServerFunction() {
        return this.tagType == 17;
    }

    public boolean isServerSubFunction() {
        return this.tagType == 18;
    }

    public boolean isServerSub3LevelFunction() {
        return this.tagType == 19;
    }

    public boolean isServerSub4LevelFunction() {
        return this.tagType == 20;
    }

    public boolean isServerSub5LevelFunction() {
        return this.tagType == 21;
    }

    public boolean isServerFunctionAndFunction() {
        return this.isServerFuncAndFunc;
    }

    private static boolean isForCE(int type, String label) {
        return -1 < label.indexOf("F20R");
    }

    public boolean isForCE() {
        if (this.tagType == -1) {
            return false;
        }
        return TagsAndLabels.isForCE(this.tagType, this.visibleTag);
    }

    private static boolean isForCS(int type, String label) {
        if (-1 < label.indexOf("F25R") || -1 < label.indexOf("F35R") || -1 < label.indexOf("F60R")) {
            return true;
        }
        return -1 < label.indexOf("F80-") && !label.equals("F80-OKKO");
    }

    public boolean isForCS() {
        if (this.tagType == -1) {
            return false;
        }
        return TagsAndLabels.isForCS(this.tagType, this.visibleTag);
    }
}

