/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class TagsAndDetails
implements ProcedureLineConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static boolean is3Digits(String str, int pos, boolean atEnd) {
        if (str == null) {
            return false;
        }
        if (atEnd && str.length() != pos + 3) {
            return false;
        }
        if (!atEnd && str.length() < pos + 3) {
            return false;
        }
        if (str.charAt(pos) < '0' || '9' < str.charAt(pos)) {
            return false;
        }
        if (str.charAt(pos + 1) < '0' || '9' < str.charAt(pos + 1)) {
            return false;
        }
        return str.charAt(pos + 2) >= '0' && '9' >= str.charAt(pos + 2);
    }

    private static boolean is3Tiret3Digits(String tag, int pos) {
        if (tag == null || tag.length() != pos + 7) {
            return false;
        }
        return TagsAndDetails.is3Digits(tag, pos, false) && TagsAndDetails.is3Digits(tag, pos + 4, true) && tag.charAt(pos + 3) == '-';
    }

    public static boolean hasTagDetails(ITextProcessor textProc, String tag) {
        if (tag == null || tag.length() == 0) {
            return false;
        }
        IGeneratedTag rt = textProc.getGeneratedInfo().getRootTag();
        Iterator iters = rt.sons();
        while (iters.hasNext()) {
            IGeneratedTag gt = (IGeneratedTag)iters.next();
            if (!gt.getName().equals("PROCEDURE") || !TagsAndDetails.hasTagDetails(gt.sons(), tag)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean hasTagDetails(Iterator<IGeneratedTag> iters, String tag) {
        if (iters != null) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            gt = iters.next();
            if (gt.getName() == null || !tag.equals(gt.getName())) continue;
            tagLen = gt.getName().length();
            details = gt.sons();
            if (details != null && details.hasNext()) ** GOTO lbl13
            return false;
lbl-1000:
            // 1 sources

            {
                so = (IGeneratedTag)details.next();
                name = so.getName();
                if (name == null || name.length() < tagLen || !name.substring(0, tagLen).equals(gt.getName()) || !(is = TagsAndDetails.is3Digits(name, tagLen, true))) continue;
                return true;
lbl13:
                // 2 sources

                ** while (details.hasNext())
            }
lbl14:
            // 1 sources

            if (!TagsAndDetails.hasTagDetails(gt.sons(), tag)) continue;
            return true;
lbl16:
            // 3 sources

            ** while (iters.hasNext())
        }
lbl17:
        // 1 sources

        return false;
    }

    public static boolean isTagDetail(String tag) {
        if (tag == null || tag.length() == 0 || tag.charAt(0) != 'F') {
            return false;
        }
        return TagsAndDetails.is3Digits(tag, 3, true) || TagsAndDetails.is3Digits(tag, 5, true) || TagsAndDetails.is3Tiret3Digits(tag, 5);
    }

    public static boolean isTagBeginOfDetail(ITextProcessor txtProc, String tag) {
        IGeneratedTag rt = txtProc.getGeneratedInfo().getRootTag();
        Iterator iters = rt.sons();
        while (iters.hasNext()) {
            IGeneratedTag gt = (IGeneratedTag)iters.next();
            if (!gt.getName().equals("PROCEDURE") || !TagsAndDetails.isTagBeginOfDetail(gt.sons(), tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTagBeginOfDetail(Iterator<IGeneratedTag> iters, String tag) {
        if (iters == null) {
            return false;
        }
        int len = tag.length();
        while (iters.hasNext()) {
            IGeneratedTag gt = iters.next();
            String name = gt.getName();
            if (name != null && name.length() == len + 3 && name.substring(0, len).equals(tag)) {
                return TagsAndDetails.is3Digits(name, len, true);
            }
            if (name != null && name.length() == 8 && len == 3 && tag.equals(name.substring(0, 3)) && TagsAndDetails.is3Digits(name, 5, true)) {
                return true;
            }
            if (name != null && name.length() == 12 && name.substring(0, len).equals(tag)) {
                return TagsAndDetails.is3Tiret3Digits(name, 5);
            }
            if (!TagsAndDetails.isTagBeginOfDetail(gt.sons(), tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTagWithinMSP(ITextProcessor textProc, String tag) {
        IGeneratedTag rt = textProc.getGeneratedInfo().getRootTag();
        Iterator iters = rt.sons();
        while (iters.hasNext()) {
            IGeneratedTag gt = (IGeneratedTag)iters.next();
            if (!gt.getName().equals("PROCEDURE") || !TagsAndDetails.isTagWithinMSP(gt.sons(), tag)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isTagWithinMSP(Iterator<IGeneratedTag> iters, String tag) {
        if (iters != null) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            gt = iters.next();
            if (gt.getName().equals(tag) && gt.getParent().getProperty("msp") != null && gt.getParent().getProperty("msp").length() > 0) {
                return true;
            }
            if (!TagsAndDetails.isTagWithinMSP(gt.sons(), tag)) continue;
            return true;
lbl8:
            // 2 sources

            ** while (iters.hasNext())
        }
lbl9:
        // 1 sources

        return false;
    }

    public static String getTagFromTagIndexes(ITextProcessor txtProc, int begIndex, int endIndex) {
        IGeneratedTag rt = txtProc.getGeneratedInfo().getRootTag();
        Iterator iters = rt.sons();
        while (iters.hasNext()) {
            String ret;
            IGeneratedTag gt = (IGeneratedTag)iters.next();
            if (!gt.getName().equals("PROCEDURE") || (ret = TagsAndDetails.getTagFromTagIndexes(gt.sons(), begIndex, endIndex)).length() <= 0) continue;
            return ret;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static String getTagFromTagIndexes(Iterator<IGeneratedTag> iters, int begIndex, int endIndex) {
        if (iters != null) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            gt = iters.next();
            if (gt.getBeginIndex() == begIndex && gt.getEndIndex() == endIndex) {
                return gt.getName();
            }
            ret = TagsAndDetails.getTagFromTagIndexes(gt.sons(), begIndex, endIndex);
            if (ret.length() <= 0) continue;
            return ret;
lbl9:
            // 2 sources

            ** while (iters.hasNext())
        }
lbl10:
        // 1 sources

        return "";
    }

    public static String getDetailAfter(ITextProcessor textProc, String tag) {
        if (tag == null || tag.length() != 6 && tag.length() != 8 && tag.length() != 12) {
            return "";
        }
        IGeneratedTag rt = textProc.getGeneratedInfo().getRootTag();
        Iterator iters = rt.sons();
        while (iters.hasNext()) {
            String ret;
            IGeneratedTag gt = (IGeneratedTag)iters.next();
            if (!gt.getName().equals("PROCEDURE") || (ret = TagsAndDetails.getDetailAfter(gt.sons(), tag)).length() <= 0) continue;
            return ret;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static String getDetailAfter(Iterator<IGeneratedTag> iters, String tag) {
        if (iters != null) ** GOTO lbl19
        return "";
lbl-1000:
        // 1 sources

        {
            gt = iters.next();
            name = gt.getName();
            if (name != null && tag.length() == 6 && name.length() == 6 && tag.substring(0, 3).equals(name.substring(0, 3))) {
                if (tag.substring(3, 6).compareTo(name.substring(3, 6)) < 0) {
                    return name;
                }
            } else if (name != null && tag.length() == 8 && name.length() == 8 && tag.substring(0, 5).equals(name.substring(0, 5))) {
                if (tag.substring(5, 8).compareTo(name.substring(5, 8)) < 0) {
                    return name;
                }
            } else {
                if (name != null && tag.length() == 8 && name.length() == 12 && tag.substring(0, 8).equals(name.substring(0, 8))) {
                    return name;
                }
                if (name != null && tag.length() == 12 && name.length() == 12 && tag.substring(0, 5).equals(name.substring(0, 5)) != false ? tag.substring(5, 12).compareTo(name.substring(5, 12)) < 0 : name != null && tag.length() == 12 && name.length() == 8 && tag.substring(0, 5).equals(name.substring(0, 5)) != false && tag.substring(5, 8).compareTo(name.substring(5, 8)) < 0) {
                    return name;
                }
            }
            if ((ret = TagsAndDetails.getDetailAfter(gt.sons(), tag)).length() <= 0) continue;
            return ret;
lbl19:
            // 2 sources

            ** while (iters.hasNext())
        }
lbl20:
        // 1 sources

        return "";
    }

    public static String getTagFromNodeIndexes(ITextProcessor txtProc, int startOffset, int endOffset) {
        IEditTree et = txtProc.getEditTree();
        Iterator nodes = et.rootNodes();
        ITextNode itn = (ITextNode)nodes.next();
        nodes = itn.sons();
        while (nodes.hasNext()) {
            String ret;
            itn = (ITextNode)nodes.next();
            if (!itn.getLabel().toString().equals("PROCEDURE") || (ret = TagsAndDetails.getTagFromNodeIndexes(itn.sons(), startOffset, endOffset)).length() <= 0) continue;
            return ret;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static String getTagFromNodeIndexes(Iterator<ITextNode> nodes, int startOffset, int endOffset) {
        if (nodes != null) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            itn = nodes.next();
            if (!itn.sons().hasNext() && itn.beginIndex() <= startOffset && endOffset <= itn.endIndex()) {
                return itn.enclosingTagName();
            }
            ret = TagsAndDetails.getTagFromNodeIndexes(itn.sons(), startOffset, endOffset);
            if (ret.length() <= 0) continue;
            return ret;
lbl9:
            // 2 sources

            ** while (nodes.hasNext())
        }
lbl10:
        // 1 sources

        return "";
    }

    public static boolean moreThanOneLineInTagFromNodeIndexes(ITextProcessor txtProc, int startOffset, int endOffset) {
        IEditTree et = txtProc.getEditTree();
        Iterator nodes = et.rootNodes();
        ITextNode itn = (ITextNode)nodes.next();
        nodes = itn.sons();
        while (nodes.hasNext()) {
            boolean ret;
            itn = (ITextNode)nodes.next();
            if (!itn.getLabel().toString().equals("PROCEDURE") || !(ret = TagsAndDetails.moreThanOneLineInTagFromNodeIndexes(itn.sons(), startOffset, endOffset))) continue;
            return ret;
        }
        return false;
    }

    private static boolean moreThanOneLineInTagFromNodeIndexes(Iterator<ITextNode> nodes, int startOffset, int endOffset) {
        if (nodes == null) {
            return false;
        }
        boolean ret = false;
        while (nodes.hasNext()) {
            ITextNode itn = nodes.next();
            if (!(itn.sons().hasNext() ? (ret = TagsAndDetails.moreThanOneLineInTagFromNodeIndexes(itn.sons(), startOffset, endOffset)) : itn.beginIndex() <= startOffset && endOffset <= itn.endIndex() && (itn.beginIndex() != startOffset || endOffset != itn.endIndex()))) continue;
            return true;
        }
        return ret;
    }

    public static boolean isLastLineInTagFromNodeIndexes(ITextProcessor txtProc, int startOffset, int endOffset) {
        IEditTree et = txtProc.getEditTree();
        Iterator nodes = et.rootNodes();
        ITextNode itn = (ITextNode)nodes.next();
        nodes = itn.sons();
        while (nodes.hasNext()) {
            boolean ret;
            itn = (ITextNode)nodes.next();
            if (!itn.getLabel().toString().equals("PROCEDURE") || !(ret = TagsAndDetails.isLastLineInTagFromNodeIndexes(itn.sons(), startOffset, endOffset))) continue;
            return ret;
        }
        return false;
    }

    private static boolean isLastLineInTagFromNodeIndexes(Iterator<ITextNode> nodes, int startOffset, int endOffset) {
        if (nodes == null) {
            return false;
        }
        boolean ret = false;
        while (nodes.hasNext()) {
            ITextNode itn = nodes.next();
            if (!(itn.sons().hasNext() ? (ret = TagsAndDetails.isLastLineInTagFromNodeIndexes(itn.sons(), startOffset, endOffset)) : itn.beginIndex() < startOffset && endOffset == itn.endIndex())) continue;
            return true;
        }
        return ret;
    }

    public static boolean containsDetails(ITextProcessor txtProc, IDocument doc, int firstLine, int lastLine) {
        int startOffset = -1;
        int endOffset = -1;
        int l = firstLine;
        while (l <= lastLine) {
            try {
                startOffset = doc.getLineOffset(l);
                endOffset = doc.getLineOffset(l + 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            String tagEnd = TagsAndDetails.getTagFromNodeIndexes(txtProc, startOffset, endOffset);
            boolean isDetailed = TagsAndDetails.isTagDetail(tagEnd);
            if (isDetailed) {
                return true;
            }
            ++l;
        }
        return false;
    }
}

