/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.pacbase.extension.ProcedureLine;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;

public class ServerTags
implements ProcedureLineConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isServerFunctionAndFunction(String tag) {
        if (tag == null) {
            return false;
        }
        if (tag.length() == 5 && ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            return true;
        }
        return "FSQL".equals(tag);
    }

    public static boolean isServerFunction(String tag) {
        if (tag == null || tag.length() < 2 || tag.charAt(0) != 'F') {
            return false;
        }
        int f = 0;
        while (f < serverFunc.length) {
            if (tag.indexOf(serverFunc[f]) == 1 && tag.length() == 1 + serverFunc[f].length()) {
                return true;
            }
            ++f;
        }
        if (tag.length() == 5 && ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            return true;
        }
        if (tag.length() < 7 || !ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            return false;
        }
        int t = 0;
        while (t < serverTiretFunc.length) {
            if (tag.indexOf(serverTiretFunc[t]) == 5 && tag.length() == 5 + serverTiretFunc[t].length()) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public static boolean isServerAndNormalSubFunction(String tag) {
        if (tag == null || tag.length() != 5 || tag.charAt(0) != 'F') {
            return false;
        }
        return ProcedureLine.isZoneAlphaNum(tag, 1, 5);
    }

    public static boolean hasLineFunction(String line) {
        if (line == null || line.length() <= 7 || line.indexOf(".") <= 7) {
            return false;
        }
        return ServerTags.isServerFunction(line.substring(7, line.indexOf(".")));
    }

    public static boolean hasLineEndFunction(String line) {
        if (line == null || line.length() <= 7 || line.indexOf("-FN.") <= 7) {
            return false;
        }
        return ServerTags.isServerFunction(line.substring(7, line.indexOf("-FN.")));
    }

    public static String label(String line) {
        if (line == null || line.length() <= 7 || line.indexOf(".") <= 7) {
            return "";
        }
        return line.substring(8, line.indexOf("."));
    }

    public static String labelFN(String line) {
        if (line == null || line.length() <= 7 || line.indexOf("-FN.") <= 7) {
            return "";
        }
        return line.substring(8, line.indexOf("-FN."));
    }

    public static boolean hasLineSubFunction(String line) {
        if (line == null || line.length() <= 7 || line.indexOf(".") <= 7) {
            return false;
        }
        String tag = line.substring(7, line.indexOf("."));
        return ServerTags.isServerSubFunction(tag) || ServerTags.isServerSub3LevelFunction(tag) || ServerTags.isServerSub4LevelFunction(tag) || ServerTags.isServerSub5LevelFunction(tag);
    }

    public static boolean hasLineEndSubFunction(String line) {
        if (line == null || line.length() <= 7 || line.indexOf("-FN.") <= 7) {
            return false;
        }
        String tag = line.substring(7, line.indexOf("-FN."));
        return ServerTags.isServerSubFunction(tag) || ServerTags.isServerSub3LevelFunction(tag) || ServerTags.isServerSub4LevelFunction(tag) || ServerTags.isServerSub5LevelFunction(tag);
    }

    public static boolean hasLineTiretFunction(String line) {
        if (line == null) {
            return false;
        }
        int pt = line.indexOf(".");
        if (pt < 13) {
            return false;
        }
        String tag = line.substring(7, pt);
        if (tag.length() < 7 || tag.charAt(0) != 'F' || tag.charAt(5) != '-' || !ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            return false;
        }
        int t = 0;
        while (t < serverTiretFunc.length) {
            if (tag.indexOf(serverTiretFunc[t]) == 5 && tag.length() == 5 + serverTiretFunc[t].length()) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public static boolean isServerSubAllLevelFunction(String tag) {
        return ServerTags.isServerSubFunction(tag) || ServerTags.isServerSub3LevelFunction(tag) || ServerTags.isServerSub4LevelFunction(tag) || ServerTags.isServerSub5LevelFunction(tag);
    }

    public static boolean isServerSubFunction(String tag) {
        if (tag == null || tag.length() < 2 || tag.charAt(0) != 'F') {
            return false;
        }
        int s = 0;
        while (s < serverSub.length) {
            if (tag.indexOf(serverSub[s]) == 1 && tag.length() == 1 + serverSub[s].length()) {
                return true;
            }
            ++s;
        }
        if (6 < tag.length() && ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            int t = 0;
            while (t < serverTiretSub.length) {
                if (tag.indexOf(serverTiretSub[t]) == 5 && tag.length() == 5 + serverTiretSub[t].length()) {
                    return true;
                }
                ++t;
            }
            t = 0;
            while (t < serverTiretBisSub.length) {
                if (tag.indexOf(serverTiretBisSub[t]) == 5 && tag.length() == 5 + serverTiretBisSub[t].length()) {
                    return true;
                }
                ++t;
            }
        }
        if (4 < tag.length() && ProcedureLine.isZoneAlphaNum(tag, tag.length() - 4, tag.length())) {
            s = 0;
            while (s < serverSubTiret.length) {
                if (tag.indexOf(serverSubTiret[s]) == 1 && tag.length() == serverSubTiret[s].length() + 5) {
                    return true;
                }
                ++s;
            }
        }
        return false;
    }

    public static boolean isServerSub3LevelFunction(String tag) {
        if (tag == null || tag.length() < 7 || tag.charAt(0) != 'F' || !ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            return false;
        }
        int t = 0;
        while (t < serverTiretSub3Level.length) {
            if (tag.indexOf(serverTiretSub3Level[t]) == 5 && tag.length() == 5 + serverTiretSub3Level[t].length()) {
                return true;
            }
            ++t;
        }
        int s = 0;
        while (s < serverTiretBisSub.length) {
            int tiretSub = tag.indexOf(serverTiretBisSub[s]);
            if (tiretSub == 5) {
                int lastTiret;
                int len = serverTiretBisSub[s].length();
                return tiretSub + len == (lastTiret = tag.lastIndexOf("-")) && ServerTags.isTiretKey(tag, lastTiret);
            }
            ++s;
        }
        return false;
    }

    public static boolean isServerSub4LevelFunction(String tag) {
        if (tag == null || tag.length() < 7 || tag.charAt(0) != 'F' || !ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            return false;
        }
        int s = 0;
        while (s < serverTiretSub3Level.length) {
            if (tag.indexOf(serverTiretSub3Level[s]) == 5) {
                int e = 0;
                while (e < serverTiretEndSub4Level.length) {
                    if (tag.lastIndexOf(serverTiretEndSub4Level[e]) == 5 + serverTiretSub3Level[s].length() && tag.length() == 5 + serverTiretSub3Level[s].length() + serverTiretEndSub4Level[e].length()) {
                        return true;
                    }
                    ++e;
                }
            }
            ++s;
        }
        int b = 0;
        while (b < serverTiretBisSub.length) {
            if (tag.indexOf(serverTiretBisSub[b]) == 5) {
                int len = serverTiretBisSub[b].length();
                int f = 0;
                while (f < serverTiretEndSub4Level.length) {
                    int beg4 = tag.lastIndexOf(serverTiretEndSub4Level[f]);
                    if (beg4 != -1) {
                        String tiretKey = tag.substring(5 + len, beg4);
                        return 5 + len + tiretKey.length() == beg4 && ServerTags.isTiretKey(tiretKey, 0);
                    }
                    ++f;
                }
            }
            ++b;
        }
        return false;
    }

    public static boolean isServerSub5LevelFunction(String tag) {
        if (tag == null || tag.length() < 7 || tag.charAt(0) != 'F' || !ProcedureLine.isZoneAlphaNum(tag, 1, 5)) {
            return false;
        }
        int s = 0;
        while (s < serverTiretSub3Level.length) {
            if (tag.indexOf(serverTiretSub3Level[s]) == 5) {
                int e = 0;
                while (e < serverTiretEndSub4Level.length) {
                    if (tag.indexOf(serverTiretEndSub4Level[e]) == 5 + serverTiretSub3Level[s].length()) {
                        int f = 0;
                        while (f < serverTiretEndSub5Level.length) {
                            if (tag.lastIndexOf(serverTiretEndSub5Level[f]) == 5 + serverTiretSub3Level[s].length() + serverTiretEndSub4Level[e].length() && tag.length() == 5 + serverTiretSub3Level[s].length() + serverTiretEndSub4Level[e].length() + serverTiretEndSub5Level[f].length()) {
                                return true;
                            }
                            ++f;
                        }
                    }
                    ++e;
                }
            }
            ++s;
        }
        return false;
    }

    public static boolean isTiretKey(String str, int pos) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len - 2 < pos) {
            return false;
        }
        if (str.charAt(pos) != '-') {
            return false;
        }
        if (str.substring(pos + 1, len).equals("PROC")) {
            return false;
        }
        return ProcedureLine.isZoneAlphaNum(str, pos + 1, len);
    }
}

