/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import com.ibm.pdp.util.Strings;
import java.util.StringTokenizer;

public class ProcedureLine
implements ProcedureLineConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String next(String code) {
        if (code.length() == 1) {
            return String.valueOf(code) + "A";
        }
        if (code.length() != 2) {
            return "";
        }
        if (code.charAt(1) != '9' && code.charAt(1) != 'Z') {
            return String.valueOf(code.substring(0, 1)) + String.valueOf((char)(code.charAt(1) + '\u0001'));
        }
        if (code.charAt(1) == 'Z') {
            return String.valueOf(code.substring(0, 1)) + "0";
        }
        if (code.charAt(0) != '9' && code.charAt(0) != 'Z') {
            return String.valueOf(String.valueOf((char)(code.charAt(0) + '\u0001'))) + "A";
        }
        if (code.charAt(0) == 'Z') {
            return "0A";
        }
        return "";
    }

    public static String before(String code) {
        if (code.length() == 1) {
            if (code.equals("A")) {
                return "";
            }
            if (code.equals("0")) {
                return "ZA";
            }
            return String.valueOf(String.valueOf((char)(code.charAt(0) - '\u0001'))) + "A";
        }
        if (code.length() != 2) {
            return "";
        }
        if (code.charAt(1) != '0' && code.charAt(1) != 'A') {
            return String.valueOf(code.substring(0, 1)) + String.valueOf((char)(code.charAt(1) - '\u0001'));
        }
        if (code.charAt(1) == '0') {
            return String.valueOf(code.substring(0, 1)) + "Z";
        }
        if (code.charAt(0) != '0' && code.charAt(0) != 'A') {
            return String.valueOf(String.valueOf((char)(code.charAt(0) - '\u0001'))) + "9";
        }
        if (code.charAt(0) == '0') {
            return "Z9";
        }
        return "";
    }

    public static String extractLabel(String lines) {
        if (lines.length() <= 7) {
            return "";
        }
        int end = lines.indexOf(Strings.getLineSeparator());
        int sepLen = Strings.getLineSeparator().length();
        int end0 = 0;
        String line = "";
        while (-1 < end) {
            line = lines.substring(end0, end);
            if (7 < line.length() && line.charAt(6) == ' ' && 7 < line.indexOf(".")) {
                return line.substring(7, line.indexOf(".", 7));
            }
            end0 = end + sepLen;
            end = lines.indexOf(Strings.getLineSeparator(), end0);
        }
        return "";
    }

    public static String extractComment(String line) {
        if (line.length() <= 6) {
            return "";
        }
        int end = line.indexOf(Strings.getLineSeparator());
        return 6 < end ? line.substring(6, end) : "";
    }

    public static boolean isComment(String line) {
        if (line.length() <= 6) {
            return false;
        }
        return line.charAt(6) == '*';
    }

    public static boolean isEndingComment(String line) {
        if (line.length() <= 6) {
            return false;
        }
        if (line.charAt(6) != '*') {
            return false;
        }
        int len = line.length();
        String ww = line.substring(0, Math.min(72, len));
        String end = ww.substring(6).trim();
        return end.charAt((len = end.length()) - 1) == '.';
    }

    public static boolean haveLinesNoFollower(String txt) {
        StringTokenizer lines = new StringTokenizer(txt, Strings.getLineSeparator());
        String last = null;
        String last1 = null;
        String last2 = null;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.length() <= 6 || line.charAt(6) == '*' || ProcedureLine.isLineLabelFN(line)) continue;
            line = line.substring(6, Math.min(72, line.length()));
            StringTokenizer toks = new StringTokenizer(line, " .");
            while (toks.hasMoreTokens()) {
                last2 = last1;
                last1 = last;
                last = toks.nextToken();
            }
        }
        boolean bl1 = "GO".equals(last2) && "TO".equals(last1) && ProcedureLine.isLabel(last);
        boolean bl2 = "STOP".equals(last1) && "RUN".equals(last);
        boolean bl3 = "GOBACK".equals(last);
        return bl1 || bl2 || bl3;
    }

    public static boolean hasGroupOfLinesNoFollower(String txt) {
        StringTokenizer lines = new StringTokenizer(txt, Strings.getLineSeparator());
        StringBuilder total = new StringBuilder();
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.length() <= 6 || line.charAt(6) == '*' || ProcedureLine.isLineLabelFN(line)) continue;
            line = line.substring(6, Math.min(72, line.length()));
            total.append(String.valueOf(line) + " ");
        }
        StringTokenizer phrases = new StringTokenizer(total.toString().trim(), ".");
        boolean noF = false;
        while (phrases.hasMoreTokens()) {
            String phrase = phrases.nextToken();
            noF = ProcedureLine.hasPhraseNoFollower(phrase);
        }
        return noF;
    }

    public static boolean hasPhraseNoFollower(String line) {
        StringTokenizer tok = new StringTokenizer(line, " ");
        String left = null;
        String right = null;
        int nbIf = 0;
        int nbElse = 0;
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if ("IF".equals(str)) {
                if (left == null) {
                    left = "";
                } else if (left != null && right == null) {
                    left = String.valueOf(left) + " " + str;
                } else if (right != null) {
                    right = String.valueOf(right) + " " + str;
                }
                ++nbIf;
                continue;
            }
            if ("ELSE".equals(str)) {
                if (nbIf == nbElse + 1 && right == null) {
                    right = "";
                } else if (left != null && right == null) {
                    left = String.valueOf(left) + " " + str;
                } else if (right != null) {
                    right = String.valueOf(right) + " " + str;
                }
                ++nbElse;
                continue;
            }
            if (left != null && right == null) {
                left = String.valueOf(left) + " " + str;
                continue;
            }
            if (right == null) continue;
            right = String.valueOf(right) + " " + str;
        }
        if (left == null && right == null) {
            return ProcedureLine.hasNoFollower(line);
        }
        if (left != null && right == null) {
            return false;
        }
        if (left == null) {
            return false;
        }
        boolean leftnoF = ProcedureLine.hasPhraseNoFollower(left);
        boolean rightnoF = ProcedureLine.hasPhraseNoFollower(right);
        return leftnoF && rightnoF;
    }

    private static boolean hasNoFollower(String txt) {
        StringTokenizer lines = new StringTokenizer(txt, Strings.getLineSeparator());
        String last = null;
        String last1 = null;
        String last2 = null;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            StringTokenizer toks = new StringTokenizer(line, " .");
            while (toks.hasMoreTokens()) {
                last2 = last1;
                last1 = last;
                last = toks.nextToken();
            }
        }
        boolean bl1 = "GO".equals(last2) && "TO".equals(last1) && ProcedureLine.isLabel(last);
        boolean bl2 = "STOP".equals(last1) && "RUN".equals(last);
        boolean bl3 = "GOBACK".equals(last);
        return bl1 || bl2 || bl3;
    }

    public static String function(String line) {
        return line.substring(8, 10);
    }

    public static String subFunction(String line) {
        return line.substring(8, 12);
    }

    public static String sub1Function(String line) {
        return line.substring(8, 11);
    }

    public static boolean isRelative(String line) {
        return -1 < line.indexOf("*@BEFORE") || -1 < line.indexOf("*@REPLACE") || -1 < line.indexOf("*@AFTER");
    }

    public static boolean isIter(String line) {
        if (line == null) {
            return false;
        }
        if (line.indexOf("F3999-ITER-FI") == 7) {
            return true;
        }
        if (line.indexOf("F3999-ITER-FT") == 7) {
            return true;
        }
        if (line.indexOf("F3999-FN") == 7) {
            return true;
        }
        if (line.indexOf("F6999-ITER-FI") == 7) {
            return true;
        }
        if (line.indexOf("F6999-ITER-FT") == 7) {
            return true;
        }
        if (line.indexOf("F6999-FN") == 7) {
            return true;
        }
        if (line.indexOf("F80-OK") == 7) {
            return true;
        }
        if (line.indexOf("F80-KO") == 7) {
            return true;
        }
        if (line.indexOf("F8099-FN") == 7) {
            return true;
        }
        return line.indexOf("F9099-ITER-FN") == 7;
    }

    public static boolean isEndOf(String line) {
        if (line == null) {
            return false;
        }
        return line.indexOf("END-OF-RECEPTION") == 7 || line.indexOf("END-OF-DISPLAY") == 7 || line.indexOf("FEND-PGM") == 7;
    }

    public static boolean isNoteFunction(String line) {
        if (line.length() < 11) {
            return false;
        }
        if (line.indexOf("*N") != 6) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 10)) {
            return false;
        }
        if (!ProcedureLine.isEndPoint(line, 10)) {
            return false;
        }
        int len = line.length();
        String ww = line.substring(0, Math.min(72, len));
        if (11 < ww.length() - Strings.getLineSeparator().length()) {
            String end = ww.substring(11).trim();
            len = end.length();
            if (len == 0) {
                return true;
            }
            int ind = end.indexOf("NOTE");
            return -1 < ind && end.charAt(len - 1) == '.';
        }
        return true;
    }

    public static boolean isBegFunction(String line) {
        if (line.length() < 11) {
            return false;
        }
        if (line.indexOf(" F") != 6) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 10)) {
            return false;
        }
        return ProcedureLine.isEndPoint(line, 10);
    }

    public static boolean isEndFunction(String line) {
        if (line.length() < 14) {
            return false;
        }
        if (line.indexOf(" F") != 6) {
            return false;
        }
        if (line.indexOf("-FN") != 10) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 10)) {
            return false;
        }
        return ProcedureLine.isEndPoint(line, 13);
    }

    public static boolean isNoteSubFunction(String line) {
        if (line.length() < 13) {
            return false;
        }
        if (line.indexOf("*N") != 6) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 12)) {
            return false;
        }
        if (!ProcedureLine.isEndPoint(line, 12)) {
            return false;
        }
        int len = line.length();
        String ww = line.substring(0, Math.min(72, len));
        if (13 < ww.length() - Strings.getLineSeparator().length()) {
            String end = ww.substring(13).trim();
            len = end.length();
            if (len == 0) {
                return true;
            }
            int ind = end.indexOf("NOTE");
            return -1 < ind && end.charAt(len - 1) == '.';
        }
        return true;
    }

    public static boolean isBegSubFunction(String line) {
        if (line.indexOf("F3999-ITER-FT") == 7) {
            return true;
        }
        if (line.indexOf("F6999-ITER-FI") == 7) {
            return true;
        }
        if (line.indexOf("F9099-ITER-FN") == 7) {
            return true;
        }
        if (line.length() < 13) {
            return false;
        }
        if (line.indexOf(" F") != 6) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 12)) {
            return false;
        }
        return ProcedureLine.isEndPoint(line, 12);
    }

    public static boolean isBegSub1Function(String line) {
        if (line.length() < 12) {
            return false;
        }
        if (line.indexOf(" F") != 6) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 11)) {
            return false;
        }
        return ProcedureLine.isEndPoint(line, 11);
    }

    public static boolean isBeg80ER(String line) {
        if (line.indexOf(" F") != 6) {
            return false;
        }
        if (line.indexOf("F80-ER") != 7) {
            return false;
        }
        return ProcedureLine.isEndPoint(line, 13);
    }

    public static boolean isEndSubFunction(String line) {
        if (line.length() < 17) {
            return false;
        }
        if (line.indexOf(" F") != 6) {
            return false;
        }
        if (line.indexOf("-FN") != 12) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 12)) {
            return false;
        }
        return ProcedureLine.isEndPoint(line, 15);
    }

    public static boolean isEndSub1Function(String line) {
        if (line.length() < 16) {
            return false;
        }
        if (line.indexOf(" F") != 6) {
            return false;
        }
        if (line.indexOf("-FN") != 11) {
            return false;
        }
        if (!ProcedureLine.isZoneAlphaNum(line, 8, 11)) {
            return false;
        }
        return ProcedureLine.isEndPoint(line, 14);
    }

    public static boolean isZoneAlphaNum(String zone, int deb, int end) {
        int i = deb;
        while (i < end) {
            if (!ProcedureLine.isLetterOrDigit(zone.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isLabel(String label) {
        if (label == null) {
            return false;
        }
        int len = label.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!ProcedureLine.isLetterOrDigit(label.charAt(i)) && label.charAt(i) != '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isLetterOrDigit(char cc) {
        if (Character.isDigit(cc)) {
            return true;
        }
        if ('a' <= cc && cc <= 'z') {
            return true;
        }
        return 'A' <= cc && cc <= 'Z';
    }

    private static boolean isEndPoint(String line, int pointPos) {
        int len = line.length();
        int pos = line.indexOf(".");
        if (len <= pointPos) {
            return false;
        }
        if (pos < pointPos) {
            return false;
        }
        String end = line.substring(pointPos, Math.min(len, pos + 1));
        return end.trim().equals(".");
    }

    /*
     * Unable to fully structure code
     */
    public static boolean includedWithWhiteAfter(String strTot, String str) {
        if (strTot == null || str == null) {
            return false;
        }
        index = strTot.indexOf(str);
        if (index != -1) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            ch = strTot.charAt(index + str.length());
            if (ch == ' ' || ch == Strings.getLineSeparator().charAt(0)) {
                return true;
            }
            index = strTot.indexOf(str, index + 1);
lbl10:
            // 2 sources

            ** while (index != -1)
        }
lbl11:
        // 1 sources

        return false;
    }

    public static String getSubFromFunctionName(String subFunctionName) {
        int len = subFunctionName.length();
        if (len < 3) {
            return "";
        }
        int ind = subFunctionName.indexOf("-");
        if (ind == 2) {
            return subFunctionName.substring(ind + 1, Math.min(ind + 3, len));
        }
        if (ind == 3 && 5 < len) {
            return subFunctionName.substring(ind + 1, ind + 3);
        }
        if (ind == 3 && len == 5) {
            return String.valueOf(subFunctionName.substring(2, 3)) + subFunctionName.substring(4, 5);
        }
        return subFunctionName.substring(2, Math.min(len, 4));
    }

    public static boolean isLineLabelFN(String line) {
        if (line == null || line.length() <= 7) {
            return false;
        }
        int pos = line.indexOf("-FN.");
        if (pos <= 7) {
            return false;
        }
        String tot = line.substring(7, pos);
        if (!ProcedureLine.isLabel(tot)) {
            return false;
        }
        String lab = line.substring(pos + 4).trim();
        return lab.length() == 0 || lab.equals("EXIT.");
    }
}

