/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.pacbase.extension.ProcedureLine;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import com.ibm.pdp.pacbase.extension.ServerTags;
import com.ibm.pdp.util.Strings;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

public class ProcedureLabels
implements ProcedureLineConstants {
    private ArrayList<String> unbalancedFunctionList;
    private ArrayList<String> unbalancedEndFunctionList;
    private ArrayList<String> noteListFromSelection;
    private ArrayList<String> listFromSelection;
    private ArrayList<String> endListFromSelection;
    private ArrayList<String> subFunctionsStack;
    private ArrayList<Integer> pointsPositions;
    private ArrayList<Integer> commentsForInsertionPositions;
    private int startLine;
    private int endLine;
    private boolean selectionHasFunction;
    private boolean containsNote;
    private int currentLineNote;
    private boolean withinNote;
    private boolean foundWithinNote;
    private boolean containsRelative;
    private boolean selectionWithUnbalancedLabels;
    private String functionName;
    private String subFunctionName;
    private int lastLine;
    private int level;
    private boolean endLineTiretFN;
    private boolean hasNoFollower;
    private boolean isIter;
    private boolean endOf;
    private boolean isCSServer;
    private int nextOfComment;
    private String nextStrOfComment;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ProcedureLabels() {
        this.initializations();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean hasTiretFN(IDocument doc, String ABXY) {
        if (ABXY == null || ABXY.length() == 0) {
            return false;
        }
        tot = doc.get();
        pos = tot.indexOf(lab = "F" + ABXY + "-FN.");
        if (pos != -1) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if ((pos = tot.indexOf(lab, pos + 1)) != -1) continue;
            return false;
lbl9:
            // 2 sources

            ** while (!ProcedureLabels.isLabel((String)tot, (int)pos))
        }
lbl10:
        // 1 sources

        return true;
    }

    private static boolean isLabel(String tot, int pos) {
        if (tot.charAt(pos - 1) != ' ') {
            return false;
        }
        String del = Strings.getLineSeparator();
        int posdel = pos - 7 - del.length();
        return tot.substring(posdel, posdel + del.length()).equals(del);
    }

    private static String trim(String line) {
        String ret = line.substring(0, Math.min(72, line.length()));
        if (ret.length() <= 6) {
            return " ";
        }
        int del = ret.indexOf(Strings.getLineSeparator());
        if (del != -1) {
            ret = ret.substring(0, del);
        }
        ret = String.valueOf(ret.substring(6).trim()) + " ";
        return ret;
    }

    protected void initializations() {
        this.startLine = -1;
        this.endLine = -1;
        this.functionName = "";
        this.subFunctionName = "";
        this.selectionHasFunction = false;
        this.containsNote = false;
        this.containsRelative = false;
        this.currentLineNote = -1;
        this.withinNote = false;
        this.foundWithinNote = false;
        this.lastLine = -1;
        this.level = 5;
        this.selectionWithUnbalancedLabels = false;
        this.unbalancedFunctionList = new ArrayList();
        this.unbalancedEndFunctionList = new ArrayList();
        this.noteListFromSelection = new ArrayList();
        this.listFromSelection = new ArrayList();
        this.endListFromSelection = new ArrayList();
        this.subFunctionsStack = new ArrayList();
        this.pointsPositions = new ArrayList();
        this.commentsForInsertionPositions = new ArrayList();
        this.endLineTiretFN = false;
        this.hasNoFollower = false;
        this.isIter = false;
        this.endOf = false;
        this.isCSServer = false;
        this.nextOfComment = 0;
        this.nextStrOfComment = "";
    }

    public int getLevel() {
        return this.level;
    }

    public void setWithNotes() {
        this.containsNote = true;
    }

    public void setForCSServer() {
        this.isCSServer = true;
    }

    public boolean isNote() {
        return this.foundWithinNote;
    }

    public int endNote() {
        return this.currentLineNote;
    }

    public void setWithRelatives() {
        this.containsRelative = true;
    }

    public boolean isRelative() {
        return this.containsRelative;
    }

    public boolean hasNoFollower() {
        return this.hasNoFollower;
    }

    public boolean initsUnbalancedTables(IDocument doc, int startLine) {
        int nbLines = doc.getNumberOfLines();
        boolean fndProc = false;
        int l = 0;
        while (l < nbLines) {
            String line;
            try {
                int lo = doc.getLineOffset(l);
                int ll = doc.getLineLength(l);
                line = doc.get(lo, ll);
            }
            catch (Exception exception) {
                line = "";
            }
            boolean bl = fndProc ? true : (fndProc = line.indexOf("PROCEDURE") > -1);
            if (!fndProc && startLine <= l) {
                return false;
            }
            if (fndProc) {
                this.initUnbalancedTable(line, l);
            }
            ++l;
        }
        return true;
    }

    private void initUnbalancedTable(String line, int l) {
        boolean isNote;
        boolean isComm = ProcedureLine.isComment(line) && !ProcedureLine.isRelative(line);
        boolean bl = isNote = ProcedureLine.isNoteFunction(line) || ProcedureLine.isNoteSubFunction(line);
        if (ProcedureLine.isBegFunction(line)) {
            if (this.isPointLastOnLine(line)) {
                this.pointsPositions.add(new Integer(l));
            }
            String fonct = ProcedureLine.function(line);
            this.unbalancedFunctionList.add(fonct);
        } else if (ProcedureLine.isEndFunction(line)) {
            this.pointsPositions.add(new Integer(l));
            String fonct = ProcedureLine.function(line);
            if (this.unbalancedFunctionList.contains(fonct)) {
                this.unbalancedFunctionList.remove(fonct);
            } else {
                this.unbalancedEndFunctionList.add(fonct);
            }
        } else if (ProcedureLine.isBegSubFunction(line)) {
            if (this.isPointLastOnLine(line)) {
                this.pointsPositions.add(new Integer(l));
            }
            String sub = ProcedureLine.subFunction(line);
            this.unbalancedFunctionList.add(sub);
        } else if (ProcedureLine.isEndSubFunction(line)) {
            this.pointsPositions.add(new Integer(l));
            String sub = ProcedureLine.subFunction(line);
            if (this.unbalancedFunctionList.contains(sub)) {
                this.unbalancedFunctionList.remove(sub);
            } else {
                this.unbalancedEndFunctionList.add(sub);
            }
        } else if (this.isPointLastOnLine(line) && !isComm && !isNote) {
            this.pointsPositions.add(new Integer(l));
        } else if (!isNote && isComm && this.hasPointBeforeComment(l)) {
            this.commentsForInsertionPositions.add(new Integer(l));
        }
    }

    private boolean isPointLastOnLine(String line) {
        if (line.indexOf(".") == -1) {
            return false;
        }
        int ind = line.lastIndexOf(".");
        return ind < 72 && line.substring(ind + 1, Math.min(line.length(), 72)).trim().length() == 0;
    }

    public boolean initializeAllNames(IDocument doc, int startL, int endL) {
        this.startLine = startL;
        this.endLine = endL;
        StringBuilder currentPhrase = null;
        boolean fndProc = false;
        boolean insert = true;
        this.withinNote = false;
        this.foundWithinNote = false;
        int nbLines = doc.getNumberOfLines();
        int nextPtLine = -1;
        this.selectionWithUnbalancedLabels = false;
        int l = 0;
        while (l <= nbLines) {
            String line;
            try {
                int lo = doc.getLineOffset(l);
                int ll = doc.getLineLength(l);
                line = doc.get(lo, ll);
            }
            catch (BadLocationException badLocationException) {
                line = "";
            }
            boolean bl = fndProc ? true : (fndProc = line.indexOf("PROCEDURE") > -1);
            if (fndProc) {
                insert = this.initializeNames(line, this.endLine, l, insert);
                if (l - 1 == this.nextPointPosition(l - 1)) {
                    currentPhrase = new StringBuilder();
                    if (!ProcedureLine.isComment(line)) {
                        currentPhrase.append(ProcedureLabels.trim(line));
                    }
                } else if (currentPhrase != null && !ProcedureLine.isComment(line)) {
                    currentPhrase.append(ProcedureLabels.trim(line));
                }
                if (this.startLine <= l && l <= this.endLine) {
                    this.feedUnbalancedSelections(line);
                    if (this.endLine == l) {
                        this.level = this.endLineTiretFN ? (this.subFunctionsStack.size() + 1) * 5 : this.subFunctionsStack.size() * 5;
                        this.hasNoFollower = ProcedureLine.haveLinesNoFollower(line);
                        this.endOf = ProcedureLine.isEndOf(line);
                        nextPtLine = this.nextPointPosition(this.endLine);
                        this.isIter = ProcedureLine.isIter(line);
                    }
                }
                if (nextPtLine != 1 && nextPtLine == l) {
                    this.hasNoFollower = ProcedureLine.hasPhraseNoFollower(currentPhrase != null ? currentPhrase.toString() : "");
                }
            }
            ++l;
        }
        return insert;
    }

    private boolean initializeNames(String line, int endLine, int l, boolean ins) {
        boolean insert = ins;
        if (l <= endLine && ProcedureLine.isNoteFunction(line)) {
            this.currentLineNote = endLine + 1;
            this.withinNote = true;
            String func = ProcedureLine.function(line);
            if (this.isFunctionOK(func)) {
                this.functionName = func;
                this.subFunctionName = "";
                this.subFunctionsStack.add(func);
                insert = true;
            }
        } else if (l <= endLine && ProcedureLine.isNoteSubFunction(line)) {
            this.currentLineNote = endLine + 1;
            this.withinNote = true;
            String sub = ProcedureLine.subFunction(line);
            if (this.isSubFunctionOK(sub)) {
                this.functionName = "";
                this.subFunctionName = sub;
                this.subFunctionsStack.add(sub);
                insert = true;
            }
        } else if (this.withinNote && ProcedureLine.isEndingComment(line)) {
            this.currentLineNote = l + 1;
        } else if (!ProcedureLine.isComment(line) || !this.withinNote) {
            if (this.withinNote && this.currentLineNote == l && (ProcedureLine.isBegFunction(line) || ProcedureLine.isBegSubFunction(line))) {
                this.withinNote = false;
                if (endLine < l) {
                    this.foundWithinNote = true;
                }
            } else if (this.isCSServer && this.withinNote && this.currentLineNote == l && (ServerTags.hasLineFunction(line) || ServerTags.hasLineSubFunction(line))) {
                this.withinNote = false;
                if (endLine < l) {
                    this.foundWithinNote = true;
                }
            } else if (this.withinNote && this.currentLineNote == l && ProcedureLine.isBegSub1Function(line)) {
                this.withinNote = false;
                if (endLine < l) {
                    this.foundWithinNote = true;
                }
            } else if (l <= endLine && ProcedureLine.isBegFunction(line)) {
                this.withinNote = false;
                String func = ProcedureLine.function(line);
                if (this.isFunctionOK(func)) {
                    this.functionName = func;
                    this.subFunctionName = "";
                    if (!this.subFunctionsStack.contains(func)) {
                        this.subFunctionsStack.add(func);
                    }
                    insert = true;
                }
            } else if (l <= endLine && ProcedureLine.isEndFunction(line)) {
                String func;
                this.withinNote = false;
                if (l == endLine) {
                    this.lastLine = endLine;
                }
                if (this.isFunctionOK(func = ProcedureLine.function(line))) {
                    this.functionName = func;
                    this.subFunctionName = "";
                    this.subFunctionsStack.remove(func);
                    if (l == endLine) {
                        this.endLineTiretFN = true;
                    }
                    insert = false;
                }
            } else if (l <= endLine && ProcedureLine.isBegSubFunction(line)) {
                this.withinNote = false;
                String sub = ProcedureLine.subFunction(line);
                if (this.isSubFunctionOK(sub)) {
                    this.functionName = "";
                    this.subFunctionName = sub;
                    if (!this.subFunctionsStack.contains(sub)) {
                        this.subFunctionsStack.add(sub);
                    }
                    insert = true;
                }
            } else if (l <= endLine && ProcedureLine.isEndSubFunction(line)) {
                String sub;
                this.withinNote = false;
                if (l == endLine) {
                    this.lastLine = endLine;
                }
                if (this.isSubFunctionOK(sub = ProcedureLine.subFunction(line))) {
                    this.functionName = "";
                    this.subFunctionName = sub;
                    this.subFunctionsStack.remove(sub);
                    if (l == endLine) {
                        this.endLineTiretFN = true;
                    }
                    insert = false;
                }
            } else if (this.isCSServer && l <= endLine && ServerTags.hasLineFunction(line)) {
                String func;
                this.withinNote = false;
                this.functionName = func = ServerTags.label(line);
                this.subFunctionName = "";
                if (!this.subFunctionsStack.contains(func)) {
                    this.subFunctionsStack.add(func);
                }
                insert = true;
            } else if (this.isCSServer && l <= endLine && ServerTags.hasLineEndFunction(line)) {
                String func;
                this.withinNote = false;
                if (l == endLine) {
                    this.lastLine = endLine;
                    this.endLineTiretFN = true;
                }
                this.functionName = func = ServerTags.labelFN(line);
                this.subFunctionName = "";
                this.subFunctionsStack.remove(func);
                insert = false;
            } else if (l <= endLine && ProcedureLine.isBegSub1Function(line)) {
                this.withinNote = false;
                String sub = ProcedureLine.sub1Function(line);
                this.functionName = "";
                this.subFunctionName = sub;
                if (!this.subFunctionsStack.contains(sub)) {
                    this.subFunctionsStack.add(sub);
                }
                insert = true;
            } else if (l <= endLine && ProcedureLine.isEndSub1Function(line)) {
                this.withinNote = false;
                if (l == endLine) {
                    this.lastLine = endLine;
                }
                String sub = ProcedureLine.sub1Function(line);
                this.functionName = "";
                this.subFunctionName = sub;
                this.subFunctionsStack.remove(sub);
                if (l == endLine) {
                    this.endLineTiretFN = true;
                }
                insert = false;
            } else if (this.isCSServer && l <= endLine && ServerTags.hasLineSubFunction(line)) {
                this.withinNote = false;
                String sub = ServerTags.label(line);
                int fn = sub.indexOf("-FN");
                int len = sub.length();
                if (-1 < fn && fn + 3 == len) {
                    if (!this.subFunctionsStack.contains(sub.substring(0, len - 3))) {
                        this.functionName = "";
                        this.subFunctionName = sub;
                        if (!this.subFunctionsStack.contains(sub)) {
                            this.subFunctionsStack.add(sub);
                        }
                        insert = true;
                    } else {
                        if (l == endLine) {
                            this.lastLine = endLine;
                            this.endLineTiretFN = true;
                        }
                        sub = ServerTags.labelFN(line);
                        this.functionName = "";
                        this.subFunctionName = sub;
                        this.subFunctionsStack.remove(sub);
                        insert = false;
                    }
                } else {
                    this.functionName = "";
                    this.subFunctionName = sub;
                    if (!this.subFunctionsStack.contains(sub)) {
                        this.subFunctionsStack.add(sub);
                    }
                    insert = true;
                }
            } else if (this.isCSServer && l <= endLine && ServerTags.hasLineEndSubFunction(line)) {
                this.withinNote = false;
                if (l == endLine) {
                    this.lastLine = endLine;
                    this.endLineTiretFN = true;
                }
                String sub = ServerTags.labelFN(line);
                this.functionName = "";
                this.subFunctionName = sub;
                this.subFunctionsStack.remove(sub);
                insert = false;
            } else if (this.isCSServer && l <= endLine && line.indexOf("FSERVER-BEG-FN") == 7) {
                this.withinNote = false;
                this.functionName = "SERVER";
                this.subFunctionName = "";
                this.subFunctionsStack.remove("SERVER-STRVIEW");
                this.subFunctionsStack.remove("SERVER");
                if (l == endLine) {
                    this.endLineTiretFN = true;
                }
                insert = false;
            } else if (l <= endLine) {
                this.withinNote = false;
                String str = this.getLastCode();
                if (this.isCSServer && ServerTags.isServerFunction("F" + str) && this.subFunctionsStack.size() == 1) {
                    this.functionName = str;
                    this.subFunctionName = "";
                    insert = true;
                } else if (this.isCSServer && ServerTags.isServerSubAllLevelFunction("F" + str)) {
                    this.functionName = "";
                    this.subFunctionName = str;
                    insert = true;
                } else if (str.length() == 2) {
                    this.functionName = str;
                    this.subFunctionName = "";
                    insert = true;
                } else if (str.length() == 3 || str.length() == 4) {
                    this.functionName = "";
                    this.subFunctionName = str;
                    insert = true;
                } else {
                    insert = false;
                }
            } else if (endLine < l && ProcedureLine.isEndFunction(line)) {
                this.withinNote = false;
                String func = ProcedureLine.function(line);
                if (this.functionName.equals(func)) {
                    this.lastLine = l;
                    return insert;
                }
            } else if (endLine < l && ProcedureLine.isEndSubFunction(line) && 3 <= this.subFunctionName.length()) {
                this.withinNote = false;
                String sub = ProcedureLine.subFunction(line);
                if (this.subFunctionName.equals(sub)) {
                    this.lastLine = l;
                    return insert;
                }
            } else if (this.isCSServer && endLine < l && this.subFunctionName.length() == 4 && ServerTags.hasLineSubFunction(line)) {
                String sub = ServerTags.label(line);
                if (sub.substring(0, 4).equals(this.subFunctionName)) {
                    this.functionName = this.subFunctionName;
                    this.subFunctionName = "";
                }
            } else if (this.isCSServer && endLine < l && ServerTags.hasLineEndFunction(line)) {
                this.withinNote = false;
                String func = ServerTags.labelFN(line);
                if (this.functionName.equals(func)) {
                    this.lastLine = l;
                    return insert;
                }
            } else if (this.isCSServer && endLine < l && ServerTags.hasLineEndSubFunction(line)) {
                this.withinNote = false;
                String sub = ServerTags.labelFN(line);
                if (this.subFunctionName.equals(sub)) {
                    this.lastLine = l;
                    return insert;
                }
            } else if (this.isCSServer && endLine < l && line.indexOf("FSERVER-BEG-FN") == 7) {
                this.withinNote = false;
                if (this.functionName.equals("SERVER") || this.subFunctionName.equals("SERVER-STRVIEW")) {
                    this.lastLine = l;
                    return insert;
                }
            } else if (endLine < l && ProcedureLine.isEndSub1Function(line)) {
                this.withinNote = false;
                String sub = ProcedureLine.sub1Function(line);
                if (this.subFunctionName.equals(sub)) {
                    this.lastLine = l;
                    return insert;
                }
            } else {
                this.withinNote = false;
            }
        }
        return insert;
    }

    private void feedUnbalancedSelections(String line) {
        if (ProcedureLine.isRelative(line) || ProcedureLine.isIter(line)) {
            this.selectionWithUnbalancedLabels = true;
        }
        if (ProcedureLine.isNoteFunction(line)) {
            String func = ProcedureLine.function(line);
            if (this.isFunctionOK(func)) {
                this.noteListFromSelection.add(func);
            } else {
                this.selectionWithUnbalancedLabels = true;
            }
        } else if (ProcedureLine.isBegFunction(line)) {
            String func = ProcedureLine.function(line);
            if (this.isFunctionOK(func)) {
                this.listFromSelection.add(func);
            } else {
                this.selectionWithUnbalancedLabels = true;
            }
        } else if (ProcedureLine.isEndFunction(line)) {
            String sub = ProcedureLine.function(line);
            if (this.isFunctionOK(sub)) {
                this.endListFromSelection.add(sub);
            } else {
                this.selectionWithUnbalancedLabels = true;
            }
        } else if (ProcedureLine.isNoteSubFunction(line)) {
            String sub = ProcedureLine.subFunction(line);
            if (this.isSubFunctionOK(sub)) {
                this.noteListFromSelection.add(sub);
            } else {
                this.selectionWithUnbalancedLabels = true;
            }
        } else if (ProcedureLine.isBegSubFunction(line)) {
            String sub = ProcedureLine.subFunction(line);
            if (this.isSubFunctionOK(sub)) {
                this.listFromSelection.add(sub);
            } else {
                this.selectionWithUnbalancedLabels = true;
            }
        } else if (ProcedureLine.isEndSubFunction(line)) {
            String sub = ProcedureLine.subFunction(line);
            if (this.isSubFunctionOK(sub)) {
                this.endListFromSelection.add(sub);
            } else {
                this.selectionWithUnbalancedLabels = true;
            }
        }
    }

    private boolean isFunctionOK(String func) {
        if (func == null || func.length() == 0) {
            return false;
        }
        return !this.unbalancedFunctionList.contains(func) && !this.unbalancedEndFunctionList.contains(func);
    }

    private boolean isSubFunctionOK(String subFunc) {
        if (subFunc == null || subFunc.length() == 0) {
            return false;
        }
        return !this.unbalancedFunctionList.contains(subFunc) && !this.unbalancedEndFunctionList.contains(subFunc);
    }

    public boolean isUnbalanced() {
        return this.selectionHasFunction || this.listFromSelection.size() != 0 || this.endListFromSelection.size() != 0;
    }

    public boolean isSelectionBalanced() {
        int esf;
        if (this.selectionWithUnbalancedLabels) {
            return false;
        }
        int sf = this.listFromSelection.size();
        if (sf != (esf = this.endListFromSelection.size())) {
            return false;
        }
        boolean ss = this.listFromSelection.containsAll(this.endListFromSelection);
        if (!ss) {
            return false;
        }
        if (this.containsNote) {
            int nsf = this.noteListFromSelection.size();
            if (nsf != sf) {
                return false;
            }
            boolean nn = this.listFromSelection.containsAll(this.noteListFromSelection);
            if (!nn) {
                return false;
            }
        }
        return true;
    }

    public boolean isPointBalanced(int startLine, int endLine) {
        boolean startMatch = false;
        boolean endMatch = false;
        int i = 0;
        while (i < this.pointsPositions.size()) {
            Integer ii = this.pointsPositions.get(i);
            int pos = ii;
            if (pos == startLine - 1) {
                startMatch = true;
            }
            if (pos == endLine) {
                endMatch = true;
            }
            ++i;
        }
        return startMatch && endMatch;
    }

    public int nextPointPosition(int endLine) {
        int i = 0;
        while (i < this.pointsPositions.size()) {
            Integer ii = this.pointsPositions.get(i);
            int pos = ii;
            if (pos >= endLine) {
                return pos;
            }
            ++i;
        }
        return endLine;
    }

    public int lastPointPosition(int endLine) {
        if (this.lastLine == -1) {
            return this.nextPointPosition(endLine);
        }
        int i = 0;
        while (i < this.pointsPositions.size()) {
            Integer ii = this.pointsPositions.get(i);
            int pos = ii;
            if (pos >= this.lastLine) {
                return pos;
            }
            ++i;
        }
        return endLine;
    }

    private boolean hasPoint(int line) {
        int i = 0;
        while (i < this.pointsPositions.size()) {
            Integer ii = this.pointsPositions.get(i);
            if (line == ii) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasCommentForInsertion(int line) {
        int i = 0;
        while (i < this.commentsForInsertionPositions.size()) {
            Integer ii = this.commentsForInsertionPositions.get(i);
            if (line == ii) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasPointBeforeComment(int line) {
        if (this.pointsPositions.size() == 0) {
            return false;
        }
        if (this.hasPoint(line - 1)) {
            return true;
        }
        return this.hasCommentForInsertion(line - 1);
    }

    public boolean isProcedure() {
        return this.functionName.length() == 0 && this.subFunctionName.length() == 0;
    }

    public boolean isFunction() {
        if (this.isCSServer && this.level == 0) {
            return false;
        }
        if (this.isCSServer && this.functionName.length() > 0) {
            return true;
        }
        if (this.functionName.length() != 2 || this.level == 0) {
            return false;
        }
        return this.isFunctionOK(this.functionName);
    }

    public boolean isSubFunction() {
        if (this.isCSServer && this.subFunctionName.length() > 0) {
            return true;
        }
        if (this.subFunctionName.length() != 3 && this.subFunctionName.length() != 4) {
            return false;
        }
        return this.isSubFunctionOK(this.subFunctionName);
    }

    public boolean isHeadSub() {
        return this.level == 5 && this.subFunctionName.length() == 4;
    }

    public boolean isCommentForInsertion(int l) {
        return this.hasCommentForInsertion(l);
    }

    public boolean isCommentOfFunction(IDocument doc, int endLine, int nextPtLine) {
        return this.isCommentFollowed(doc, endLine, nextPtLine);
    }

    public boolean isCommentFollowed(IDocument doc, int endLine, int nextPtLine) {
        this.nextOfComment = 0;
        boolean lookForSub = false;
        String workStr = "";
        int max = this.isCSServer ? doc.getNumberOfLines() : nextPtLine;
        int l = endLine;
        while (l <= max) {
            block22: {
                String line;
                block25: {
                    block24: {
                        block23: {
                            boolean isSub;
                            boolean isServFunc;
                            block21: {
                                block20: {
                                    block18: {
                                        block19: {
                                            block17: {
                                                block16: {
                                                    try {
                                                        if (lookForSub || nextPtLine >= l) break block16;
                                                        return false;
                                                    }
                                                    catch (BadLocationException badLocationException) {
                                                        return false;
                                                    }
                                                }
                                                int off = doc.getLineOffset(l);
                                                int len = doc.getLineLength(l);
                                                line = doc.get(off, len);
                                                if (l != endLine || ProcedureLine.isComment(line)) break block17;
                                                return false;
                                            }
                                            if (!this.isCSServer || !lookForSub) break block18;
                                            if (!ServerTags.hasLineSubFunction(line)) break block19;
                                            this.nextOfComment = 4;
                                            this.nextStrOfComment = workStr;
                                            return true;
                                        }
                                        if (ProcedureLine.isBegSubFunction(line) || ProcedureLine.isBegSub1Function(line) || ProcedureLine.isBegFunction(line) || ProcedureLine.isEndFunction(line)) {
                                            this.nextOfComment = 2;
                                            this.nextStrOfComment = workStr;
                                            return true;
                                        }
                                    }
                                    isServFunc = this.isCSServer && ServerTags.hasLineFunction(line);
                                    isSub = ProcedureLine.isBegSubFunction(line);
                                    if (!isServFunc || isSub) break block20;
                                    this.nextOfComment = 4;
                                    this.nextStrOfComment = ServerTags.label(line);
                                    return true;
                                }
                                if (isServFunc || !isSub) break block21;
                                this.nextOfComment = 2;
                                this.nextStrOfComment = ProcedureLine.subFunction(line);
                                return true;
                            }
                            if (isServFunc && isSub) {
                                workStr = ProcedureLine.subFunction(line);
                                lookForSub = true;
                                break block22;
                            }
                            if (!this.isCSServer || !ServerTags.hasLineSubFunction(line)) break block23;
                            this.nextOfComment = 5;
                            this.nextStrOfComment = ServerTags.label(line);
                            return true;
                        }
                        if (!ProcedureLine.isBegFunction(line)) break block24;
                        this.nextOfComment = 1;
                        this.nextStrOfComment = ProcedureLine.function(line);
                        return true;
                    }
                    if (!ProcedureLine.isBegSub1Function(line)) break block25;
                    this.nextOfComment = 3;
                    this.nextStrOfComment = ProcedureLine.sub1Function(line);
                    return true;
                }
                if (!ProcedureLine.isComment(line)) {
                    return false;
                }
            }
            ++l;
        }
        if (lookForSub) {
            this.nextOfComment = 2;
            this.nextStrOfComment = workStr;
            return true;
        }
        return false;
    }

    public boolean isCommentOfFunction() {
        return this.nextOfComment == 1;
    }

    public boolean isCommentOfSubFunction() {
        return this.nextOfComment == 2 || this.nextOfComment == 3;
    }

    public boolean isCommentOfServerFunction() {
        return this.nextOfComment == 4;
    }

    public boolean isCommentOfServerSubFunction() {
        return this.nextOfComment == 5;
    }

    public String getFunctionOfComment() {
        return this.nextStrOfComment;
    }

    public String getAdditionFunctionCode() {
        if (this.isCSServer && this.nextOfComment == 4) {
            return this.nextStrOfComment;
        }
        if (this.isCSServer && this.nextOfComment == 5) {
            return "";
        }
        if (this.isCSServer && (this.nextOfComment == 1 || this.nextOfComment == 2)) {
            return this.nextStrOfComment.substring(0, 2);
        }
        if (this.isCSServer && this.functionName.length() > 0) {
            return this.functionName;
        }
        if (this.isCSServer && (this.subFunctionName.length() == 3 || this.subFunctionName.length() == 4)) {
            return this.subFunctionName.substring(0, 2);
        }
        if (this.isCSServer) {
            return "";
        }
        return this.isFunction() ? this.functionName : (this.isSubFunction() ? this.subFunctionName.substring(0, 2) : "");
    }

    public String getAdditionSubFunctionCode() {
        if (this.isCSServer && this.nextOfComment == 4) {
            return "";
        }
        if (this.isCSServer && this.nextOfComment == 5) {
            return this.nextStrOfComment;
        }
        if (this.isCSServer && (this.nextOfComment == 1 || this.nextOfComment == 2)) {
            return this.nextStrOfComment.substring(2);
        }
        if (this.isCSServer && this.subFunctionName.length() == 4) {
            return this.subFunctionName.substring(2, 4);
        }
        if (this.isCSServer && this.subFunctionName.length() == 3) {
            return this.subFunctionName.substring(2, 3);
        }
        if (this.isCSServer) {
            return this.subFunctionName;
        }
        if (this.isFunction()) {
            return "";
        }
        if (this.isSubFunction() && this.subFunctionName.length() == 4) {
            return this.subFunctionName.substring(2, 4);
        }
        if (this.isSubFunction() && this.subFunctionName.length() == 3) {
            return this.subFunctionName.substring(2, 3);
        }
        return "";
    }

    public boolean isServerSpecific() {
        if (this.isCSServer && (this.nextOfComment == 4 || this.nextOfComment == 5)) {
            return true;
        }
        if (this.nextOfComment == 1 || this.nextOfComment == 2) {
            return false;
        }
        if (this.isCSServer && 2 < this.functionName.length() && this.subFunctionName.length() == 0) {
            return true;
        }
        return this.isCSServer && this.functionName.length() == 0 && 4 < this.subFunctionName.length();
    }

    public String getServerLabel() {
        if (this.isCSServer && (this.nextOfComment == 4 || this.nextOfComment == 5)) {
            return "F" + this.nextStrOfComment;
        }
        if (this.isCSServer && 2 < this.functionName.length() && this.subFunctionName.length() == 0) {
            return "F" + this.functionName;
        }
        if (this.isCSServer && this.functionName.length() == 0 && 4 < this.subFunctionName.length()) {
            return "F" + this.subFunctionName;
        }
        return "";
    }

    public String getServerFunction() {
        if (this.isCSServer && (this.nextOfComment == 4 || this.nextOfComment == 5)) {
            return this.nextStrOfComment.substring(0, 2);
        }
        if (this.isCSServer && 2 < this.functionName.length() && this.subFunctionName.length() == 0) {
            return this.functionName.substring(0, 2);
        }
        if (this.isCSServer && this.functionName.length() == 0 && 4 < this.subFunctionName.length()) {
            return this.subFunctionName.substring(0, 2);
        }
        return "";
    }

    public String getServerSubFunction() {
        if (this.isCSServer && this.nextOfComment == 4) {
            return "";
        }
        if (this.isCSServer && this.nextOfComment == 5) {
            return ProcedureLine.getSubFromFunctionName(this.nextStrOfComment);
        }
        if (this.isCSServer && 2 < this.functionName.length() && this.subFunctionName.length() == 0) {
            return "";
        }
        if (this.isCSServer && this.functionName.length() == 0 && 4 < this.subFunctionName.length()) {
            return ProcedureLine.getSubFromFunctionName(this.subFunctionName);
        }
        return "";
    }

    public String getInsertionFunctionCode() {
        String ret = this.getLastCode();
        return 2 <= ret.length() ? ret.substring(0, 2) : "";
    }

    public String getInsertionSubFunctionCode() {
        String ret = this.getLastCode();
        return ret.length() == 4 ? ret.substring(2, 4) : (ret.length() == 3 ? ret.substring(2, 3) : "");
    }

    private String getLastCode() {
        int size = this.subFunctionsStack.size();
        if (size == 0) {
            return "";
        }
        return this.subFunctionsStack.get(size - 1);
    }

    public int getCursorOffset(IDocument doc, ITextSelection sel, int nextPtLine) {
        int cursorOffset = -1;
        if (this.startLine == this.endLine) {
            block8: {
                cursorOffset = sel.getOffset();
                String str = doc.get(cursorOffset, sel.getLength());
                if (str.trim().length() <= 0) break block8;
                return -1;
            }
            try {
                int lineLen = doc.getLineLength(this.endLine);
                int beforeEndOffset = doc.getLineOffset(this.endLine);
                int cursorPos = cursorOffset - beforeEndOffset;
                String line = doc.get(beforeEndOffset, lineLen);
                line = line.substring(0, Math.min(line.length(), 72));
                int posSep = line.indexOf(Strings.getLineSeparator());
                if (-1 < posSep) {
                    line = line.substring(0, posSep);
                }
                int posPt = line.indexOf(".");
                while (-1 < posPt) {
                    if (posPt < cursorPos) {
                        String chunck = line.substring(posPt, cursorPos);
                        String end = line.substring(posPt);
                        if (chunck.trim().equals(".") && 1 < end.trim().length()) {
                            return cursorOffset;
                        }
                    }
                    posPt = line.indexOf(".", posPt + 1);
                }
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return -1;
    }

    public boolean isIter() {
        return this.isIter;
    }

    public boolean isEndOf() {
        return this.endOf;
    }
}

