/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.util.geninfo.GeneratedInfoConverter;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.ITransformGeneratedInfo;
import com.ibm.pdp.pacbase.extension.PacGenerationPostProcessor;

public class PacTransformGiFromV0ToV1
extends GeneratedInfoConverter
implements ITransformGeneratedInfo {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String LEVEL_PROPERTY = "level";
    private final String MICROPATTERN_PROPERTY = "mp";
    private final String PATTERN_PROPERTY = "pattern";
    private final String VERSION_PROPERTY = "version";
    private String[] dialogFcts = new String[]{"F25", "F35", "F60"};
    private String[] categFcts = new String[]{"A", "R", "Z"};
    private String pattern = null;
    private boolean isModified = false;
    private boolean isProcedure = false;
    private String dateTag = null;

    public PacTransformGiFromV0ToV1() {
    }

    public PacTransformGiFromV0ToV1(IGeneratedInfoFactory factory) {
        super(factory);
    }

    public IGeneratedInfo transformGeneratedInfo(IGeneratedInfo genInfo) {
        IGenInfoBuilder gib;
        boolean modified;
        String version = genInfo.getProperty("version");
        if (version != null) {
            try {
                int v = Integer.parseInt(version);
                if (v >= 2) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        IEngineFactory ief = PdpTool.getEngineFactory();
        this.factory = ief.newGeneratedInfoFactory();
        this.dateTag = null;
        this.isModified = false;
        this.isProcedure = false;
        IGeneratedInfo gi = this.convert(genInfo);
        if (this.isModified && this.dateTag != null) {
            gi = this.manageLevelForDateTag(gi);
        }
        boolean bl = modified = (modified = PacGenerationPostProcessor.CleanDateWorkingTags(gib = gi.toGeneratedInfoBuilder())) || PacGenerationPostProcessor.CleanDateProcedureTags(gib);
        if (modified) {
            gib.setProperty("version", "002");
            return gib.toGeneratedInfo();
        }
        if (this.isModified) {
            return gi;
        }
        return null;
    }

    protected boolean toConvert(IGeneratedInfo generatedInfo) {
        return true;
    }

    protected void convertTag(IGeneratedTag tag) {
        if (tag.getName().equals("PROCEDURE")) {
            this.isProcedure = true;
        }
        if (this.isProcedure && tag.getProperty("mp") != null && tag.getProperty("level") == null) {
            boolean update = false;
            if (this.pattern != null && this.pattern.equals("com.ibm.pdp.pacbase.dialog") || this.pattern.equals("com.ibm.pdp.pacbase.client")) {
                update = this.managePropertiesForDialog(tag);
            } else if (this.pattern != null && this.pattern.equals("com.ibm.pdp.pacbase.batch")) {
                update = this.managePropertiesForBatch(tag);
            }
            this.isModified = this.isModified ? this.isModified : update;
        }
        super.convertTag(tag);
    }

    protected String convertPropertyValue(String name, String value) {
        if (this.pattern == null && name.equals("pattern")) {
            this.pattern = value;
        } else if (name.equals("version")) {
            return "001";
        }
        return super.convertPropertyValue(name, value);
    }

    private boolean managePropertiesForBatch(IGeneratedTag tag) {
        if (tag.getName().equals("F9520")) {
            tag.setProperty("level", "10");
            return true;
        }
        if (tag.getName().endsWith("-CONVERT") && tag.getParent().getProperty("level") == null && tag.getParent().getProperty("mp") != null) {
            this.dateTag = tag.getParent().getName();
            return true;
        }
        return false;
    }

    private boolean managePropertiesForDialog(IGeneratedTag tag) {
        if (tag.getName().equals("F8120")) {
            tag.setProperty("level", "10");
            return true;
        }
        if (tag.getName().equals("F2599")) {
            tag.setProperty("level", "10");
            return true;
        }
        if (tag.getName().startsWith("F80-")) {
            return this.manageLevelForF80(tag);
        }
        String[] stringArray = this.dialogFcts;
        int n = this.dialogFcts.length;
        int n2 = 0;
        while (n2 < n) {
            String fct = stringArray[n2];
            if (tag.getName().startsWith(fct)) {
                String[] stringArray2 = this.categFcts;
                int n3 = this.categFcts.length;
                int n4 = 0;
                while (n4 < n3) {
                    String categ = stringArray2[n4];
                    if (tag.getName().equals(String.valueOf(fct) + categ)) {
                        tag.setProperty("level", "5.5");
                        return true;
                    }
                    ++n4;
                }
                break;
            }
            ++n2;
        }
        return false;
    }

    private boolean manageLevelForF80(IGeneratedTag tag) {
        if (tag.getName().length() == 8) {
            tag.setProperty("level", "9.5");
            return true;
        }
        if (tag.getName().length() > 8 && tag.getName().substring(4).indexOf("-") > 0) {
            tag.setProperty("level", "10");
            return true;
        }
        return false;
    }

    private IGeneratedInfo manageLevelForDateTag(IGeneratedInfo gi) {
        IGenInfoBuilder gib = gi.toGeneratedInfoBuilder();
        IBuilderTag tag = gib.tagFromName(this.dateTag);
        if (tag != null) {
            tag.setProperty("level", "10");
            gi = gib.toGeneratedInfo();
        }
        return gi;
    }
}

