/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.internal.IOrganizeExtension;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.organize.FunctionsConsistencyAnalyzer;
import java.util.StringTokenizer;

public class PacOrganizeExtension
implements IOrganizeExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected FunctionsConsistencyAnalyzer analyzer = null;
    protected String pattern = null;
    private boolean _isMVinProgress = false;
    private boolean _isMVdone = false;

    public PacOrganizeExtension(String pattern) {
        this.pattern = pattern;
    }

    public IGeneratedInfo refactor(ITextProcessor textProcessor) {
        this.pattern = textProcessor.getGeneratedInfo().getProperty("pattern");
        this.analyzer = new FunctionsConsistencyAnalyzer(textProcessor.getEditTree(), this._isMVdone, this._isMVinProgress);
        return this.analyzer.refactorGeneratedInfo();
    }

    public IGeneratedInfo moveDeletedSubFunctions() {
        return this.analyzer.moveDeletedSubFunctions();
    }

    public IGeneratedInfo mergeSyntacticTagsWithGeneratedInfo(IGeneratedInfo genInfo) {
        return this.analyzer.mergeSyntacticTagsWithGeneratedInfo(genInfo);
    }

    public FunctionsConsistencyAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean isVirtualMacroUsed(IGeneratedInfo genInfo) {
        this._isMVinProgress = PacTool.isGenerationWithVirtualMacroInProgress(genInfo);
        this._isMVdone = PacTool.isGenerationWithVirtualMacroAlreadyDone(genInfo);
        return this._isMVdone || this._isMVinProgress;
    }

    public IGeneratedInfo cleanVirtualMacroTags(IGeneratedInfo newFullGeneneratedInfo) {
        IGenInfoBuilder genInfoBuilder = newFullGeneneratedInfo.toGeneratedInfoBuilder();
        if (this.cleanVirtualMacroInformations(genInfoBuilder)) {
            return genInfoBuilder.toGeneratedInfo();
        }
        return newFullGeneneratedInfo;
    }

    private boolean cleanVirtualMacroInformations(IGenInfoBuilder genInfoBuilder) {
        boolean result = false;
        String prop = genInfoBuilder.getProperty("MSPVIRT_DELETE_TAGS");
        if (prop != null) {
            result = true;
            StringTokenizer st = new StringTokenizer(prop);
            while (st.hasMoreTokens()) {
                String fct = st.nextToken();
                genInfoBuilder.removeTag(fct);
            }
            genInfoBuilder.setProperty("MSPVIRT_DELETE_TAGS", null);
        }
        return result;
    }

    public ITextProcessor instanciateNewTextProcessor(IGeneratedInfo genInfo, IGeneratedInfo newGenInfo) {
        IEngineFactory factory = PdpTool.getEngineFactory();
        com.ibm.pdp.engine.internal.ITextProcessor newTextProcessor = (com.ibm.pdp.engine.internal.ITextProcessor)factory.newTextProcessor();
        newTextProcessor.initialize(genInfo);
        newTextProcessor.setText(newGenInfo.getText());
        return newTextProcessor;
    }
}

