/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.engine.extension.IGenerationPostProcessorExtension;
import com.ibm.pdp.engine.turbo.impl.MicroPatternEngine;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacCommentsInsertionOptionValues;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.AbstractDotModifier;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.CobolLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;

public class PacGenerationPostProcessor
extends AbstractDotModifier
implements IGenerationPostProcessorExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacCommentsInsertionOptionValues pciov;
    private ArrayList<String> macrosCalled;
    private boolean generated_END_EXEC_in_new_line = true;
    private ArrayList<String> sql_declared_cursors;
    private String programName;
    private static final String EXIT_KEYWORD = "EXIT.";
    private static final String EXIT_TO_ADD_STRING = " EXIT.";
    private static final String EXEC = "EXEC";
    private static final String EXEC_SQL = "EXEC SQL";
    private static final String EXEC_CICS = "EXEC CICS";
    private static final String EXEC_PAF = "EXEC PAF";
    private static final String END_EXEC = "END-EXEC.";
    private static final String END_EXEC_WP = "END-EXEC";
    private static final String WHENEVER = "WHENEVER";
    private static final String CONTINUE = "CONTINUE";
    private static final String GOTO = "GOTO";
    private static final String UPDATE = "UPDATE";
    private static final String SET = "SET";
    private static final String GETMAIN = "GETMAIN";
    private static final String GO_TO = "GO TO";
    private static final String SPECIFIG_TAG = "SpecificTag";
    private static final String GENERATED_TEXT = "GeneratedText";
    private int procedureDivisionDeclarationIndex;
    private int procedureDivisionEndDeclarationIndex;
    private final String PROCEDURE_TAG = "PROCEDURE";
    private static final String SERVER_LABEL = "       Fnn.                                                             lv05";

    public void postProcess(IMicroPatternProcessingContext context) {
        String pattern;
        String reconcileProp = context.getGeneratedInfo().getProperty("Reconcile");
        if (reconcileProp != null && reconcileProp.equals("false")) {
            return;
        }
        IGenInfoBuilder genInfoBuilder = context.getGeneratedInfo().toGeneratedInfoBuilder();
        this.init(genInfoBuilder);
        this.cleanTags(genInfoBuilder);
        this.dealWithEND_EXEC(context, genInfoBuilder);
        this.dealWithDOT(context, genInfoBuilder);
        this.dealWithEXIT_v2(genInfoBuilder);
        this.dealWithRightMarks(genInfoBuilder);
        PacGenerationPostProcessor.CleanSQLTags(genInfoBuilder);
        PacGenerationPostProcessor.CleanDateWorkingTags(genInfoBuilder);
        PacGenerationPostProcessor.CleanDateProcedureTags(genInfoBuilder);
        this.cleanVirtualMacroInformations(genInfoBuilder);
        if (context.getGenerationProperties() != null && (pattern = context.getGenerationProperties().getProperty("PATTERN_NAME")) != null && "com.ibm.pdp.pacbase.csserver".equals(pattern)) {
            this.processAttachFunctionInServer(genInfoBuilder);
        }
    }

    private void init(IGenInfoBuilder genInfoBuilder) {
        if (genInfoBuilder.getText().length() != 0) {
            this.NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)genInfoBuilder.getText());
        } else {
            IGeneratedTag tag = genInfoBuilder.getGeneratedInfo().getRootTag();
            String lineDelimiterFromGeneratedCode = this.getLineDelimiterFromTag(tag);
            if (lineDelimiterFromGeneratedCode != null) {
                this.NEW_LINE = lineDelimiterFromGeneratedCode;
            }
        }
        if (this.NEW_LINE == null) {
            this.NEW_LINE = "\r";
        }
        String text = genInfoBuilder.getRootTag().getText().toString();
        this.procedureDivisionDeclarationIndex = this.findProcedureDivisionDeclarationIndex(text);
        if (this.procedureDivisionDeclarationIndex != -1) {
            int endOfLine = text.lastIndexOf(this.NEW_LINE, this.procedureDivisionDeclarationIndex);
            if (endOfLine != -1) {
                this.procedureDivisionDeclarationIndex = endOfLine + this.NEW_LINE.length();
            }
            this.initProcedureDivisionDeclarationEndIndex(text);
        } else {
            IBuilderTag tag = genInfoBuilder.tagFromName("DATA");
            if (tag != null) {
                this.procedureDivisionDeclarationIndex = tag.getEndIndex();
            }
        }
    }

    private String getLineDelimiterFromTag(IGeneratedTag tag) {
        String generatedText = tag.getProperty(GENERATED_TEXT);
        if (generatedText != null && generatedText.length() != 0) {
            return PdpTool.determineDelimiterOfV2((CharSequence)generatedText);
        }
        Iterator sonsIter = tag.sons();
        while (sonsIter.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sonsIter.next();
            String lineDelimiter = this.getLineDelimiterFromTag(son);
            if (lineDelimiter == null) continue;
            return lineDelimiter;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int findProcedureDivisionDeclarationIndex(String text) {
        index = text.indexOf(" PROCEDURE DIVISION");
        if (index == -1 || (ind2 = text.indexOf(" PROCEDURE DIVISION", index + 1)) != -1) ** GOTO lbl8
        return index;
lbl-1000:
        // 1 sources

        {
            line = this.extractLineFromIndex(text, index);
            if (line.length() > 6 && line.charAt(6) != '*' && !line.trim().startsWith("'") && !line.trim().startsWith("\"")) {
                return index;
            }
            index = text.indexOf(" PROCEDURE DIVISION", index + 1);
lbl8:
            // 2 sources

            ** while (index != -1)
        }
lbl9:
        // 1 sources

        return index;
    }

    private String extractLineFromIndex(String text, int index) {
        int startOfLine = text.lastIndexOf(this.NEW_LINE, index);
        startOfLine = startOfLine == -1 ? 0 : (startOfLine += this.NEW_LINE.length());
        int nextNewline = text.indexOf(this.NEW_LINE, index);
        if (nextNewline == -1) {
            nextNewline = text.length();
        }
        String line = text.substring(startOfLine, nextNewline);
        return line;
    }

    private void initProcedureDivisionDeclarationEndIndex(String text) {
        this.procedureDivisionEndDeclarationIndex = -1;
        int startOfLineIndex = this.procedureDivisionDeclarationIndex;
        while (true) {
            int dotIndex;
            int NLIndex;
            String line;
            String string = line = (NLIndex = text.indexOf(this.NEW_LINE, startOfLineIndex)) == -1 ? text.substring(startOfLineIndex) : text.substring(startOfLineIndex, NLIndex);
            if (line.length() > 72) {
                line = line.substring(0, 72);
            }
            if ((dotIndex = line.indexOf(".")) != -1) {
                this.procedureDivisionEndDeclarationIndex = NLIndex;
                return;
            }
            if (NLIndex == -1) {
                return;
            }
            startOfLineIndex = NLIndex + this.NEW_LINE.length();
        }
    }

    private void processAttachFunctionInServer(IGenInfoBuilder genInfoBuilder) {
        if (!PacTool.isGenerationWithVirtualMacroAlreadyDone(genInfoBuilder.getGeneratedInfo())) {
            return;
        }
        boolean isMVinProgress = "true".equals(genInfoBuilder.getProperty("MVPROGRESS"));
        if (!isMVinProgress) {
            return;
        }
        ArrayList<String> fcts = new ArrayList<String>();
        IBuilderTag tag = genInfoBuilder.tagFromName("PROCEDURE");
        IBuilderTag son = tag.firstSon();
        ArrayList<String> toRemove = new ArrayList<String>();
        boolean b = false;
        while (son != null) {
            if (son.getName().startsWith("ATTACH")) {
                if (son.getText().toString().contains("functionNotEmpty")) {
                    fcts.add(son.getProperty("ATTACH_FUNCTION"));
                }
                b = true;
            } else if (b) {
                if (fcts.isEmpty()) break;
                for (String name : fcts) {
                    if (son.getName().equals(name)) continue;
                    if (son.getName().startsWith(name)) {
                        IBuilderTag previousTag = son.previousTag();
                        String text = previousTag.getText().toString();
                        if (text.startsWith("       " + name + ".")) continue;
                        String newText = this.prepareTextToInsert(name, text);
                        MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)previousTag, (int)previousTag.getBeginIndex(), (int)previousTag.getEndIndex(), (String)newText, (boolean)false);
                        toRemove.add(name);
                        break;
                    }
                    if (son.getProperty("sort") != null || !son.getText().toString().contains("       " + name + "-FN.")) continue;
                    String newText = this.prepareTextToInsert(name, son.getText().toString());
                    MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)son, (int)son.getBeginIndex(), (int)son.getEndIndex(), (String)newText, (boolean)false);
                    toRemove.add(name);
                }
            }
            fcts.removeAll(toRemove);
            toRemove.clear();
            son = son.nextTag();
        }
        genInfoBuilder.setProperty("MVPROGRESS", null);
    }

    private String prepareTextToInsert(String functionName, String text) {
        List lines = PdpTool.splitsInLine((CharSequence)text);
        StringBuilder sb = new StringBuilder();
        if (lines.size() == 1) {
            sb.append(SERVER_LABEL.replace("Fnn", functionName));
            sb.append(this.NEW_LINE);
            sb.append(text);
        } else {
            boolean insert = false;
            String labelFn = "       " + functionName + "-FN.";
            String labelLine = String.valueOf(SERVER_LABEL.replace("Fnn", functionName)) + this.NEW_LINE;
            boolean fnExist = text.indexOf(labelFn) > 0;
            int i = lines.size() - 1;
            while (i >= 0) {
                String line = (String)lines.get(i);
                if (!fnExist) {
                    if (!insert && line.startsWith("       F") && line.contains("-FN.") && line.indexOf(functionName) < 0) {
                        sb.insert(0, labelLine);
                        insert = true;
                    }
                } else if (line.startsWith(labelFn)) {
                    fnExist = false;
                }
                sb.insert(0, line);
                --i;
            }
            if (!insert) {
                sb.insert(0, labelLine);
            }
        }
        return sb.toString();
    }

    private void cleanTags(IGenInfoBuilder genInfoBuilder) {
        IBuilderTag tagF80 = genInfoBuilder.tagFromName("F80");
        if (tagF80 != null) {
            this.removeFnTag(genInfoBuilder, tagF80.firstSon());
        }
    }

    private void cleanVirtualMacroInformations(IGenInfoBuilder genInfoBuilder) {
        IBuilderTag currentTag;
        StringTokenizer st;
        String prop = genInfoBuilder.getProperty("MSPVIRT_DASH_900_TO_DELETE");
        if (prop != null) {
            st = new StringTokenizer(prop, "/");
            while (st.hasMoreTokens()) {
                String dash900 = st.nextToken();
                currentTag = null;
                int begIndex = 0;
                while (currentTag == null && begIndex != -1) {
                    begIndex = genInfoBuilder.getText().toString().indexOf(dash900, begIndex + 1);
                    if (begIndex == -1) continue;
                    int endIndex = genInfoBuilder.getText().toString().indexOf(this.NEW_LINE, begIndex) + this.NEW_LINE.length();
                    currentTag = genInfoBuilder.includingTag(begIndex, endIndex);
                    if ("True".equals(currentTag.getProperty(SPECIFIG_TAG))) {
                        MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)currentTag, (int)begIndex, (int)endIndex, (String)"", (boolean)false);
                        if (currentTag.getBeginIndex() != currentTag.getEndIndex()) continue;
                        genInfoBuilder.removeTag(currentTag);
                        currentTag = null;
                        begIndex = -1;
                        continue;
                    }
                    currentTag = null;
                }
            }
            genInfoBuilder.setProperty("MSPVIRT_DASH_900_TO_DELETE", null);
        }
        if ((prop = genInfoBuilder.getProperty("MSPVIRT_DASH_900_TO_INSERT")) != null) {
            st = new StringTokenizer(prop, "/");
            while (st.hasMoreTokens()) {
                String dash900;
                String allText = genInfoBuilder.getText().toString();
                if (allText.indexOf(dash900 = st.nextToken()) != -1) continue;
                int index = dash900.indexOf("-900");
                String etiqu = dash900.substring(0, index).trim();
                Pattern lastLinePattern = Pattern.compile(String.valueOf(this.NEW_LINE) + "......." + etiqu + "-FN.");
                Matcher lastLineMatcher = lastLinePattern.matcher(allText);
                if (!lastLineMatcher.find()) continue;
                int begIndex = lastLineMatcher.start() + this.NEW_LINE.length();
                int endIndex = allText.indexOf(this.NEW_LINE, begIndex);
                IBuilderTag currentTag2 = genInfoBuilder.includingTag(begIndex, endIndex);
                String toInsert = String.valueOf(dash900) + allText.substring(begIndex, endIndex);
                MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)currentTag2, (int)begIndex, (int)endIndex, (String)toInsert, (boolean)false);
            }
            genInfoBuilder.setProperty("MSPVIRT_DASH_900_TO_INSERT", null);
        }
        if ((prop = genInfoBuilder.getProperty("MSPVIRT_TAGS_WITH_NTI_PROP")) != null) {
            st = new StringTokenizer(prop, "/");
            while (st.hasMoreTokens()) {
                String tagName = st.nextToken();
                currentTag = genInfoBuilder.tagFromName(tagName);
                if (currentTag == null) continue;
                Iterator it = currentTag.propertyNames();
                while (it.hasNext()) {
                    String propTag = (String)it.next();
                    if (!propTag.startsWith("NTI_")) continue;
                    String newProp = propTag.substring(4);
                    currentTag.setProperty(newProp, currentTag.getProperty(propTag));
                    currentTag.setProperty(propTag, null);
                }
            }
            genInfoBuilder.setProperty("MSPVIRT_TAGS_WITH_NTI_PROP", null);
        }
    }

    public static boolean CleanDateWorkingTags(IGenInfoBuilder genInfoBuilder) {
        boolean result = false;
        IBuilderTag tag = genInfoBuilder.tagFromName("WSS-CONTINUATION");
        if (tag != null) {
            tag = tag.firstSon();
        }
        while (tag != null) {
            String name = tag.getName();
            tag = tag.nextTag();
            if (!name.startsWith("DATE_WORKING_")) continue;
            genInfoBuilder.removeTag(name);
            result = true;
        }
        return result;
    }

    public static boolean CleanDateProcedureTags(IGenInfoBuilder genInfoBuilder) {
        boolean result = false;
        IBuilderTag tag = genInfoBuilder.tagFromName("FUNCTION_DATE_CONVERT");
        if (tag != null) {
            genInfoBuilder.removeTag("FUNCTION_DATE_CONVERT");
            result = true;
        }
        if ((tag = genInfoBuilder.tagFromName("FUNCTION_DATE_ER")) != null) {
            genInfoBuilder.removeTag("FUNCTION_DATE_ER");
            result = true;
        }
        return result;
    }

    public static void CleanSQLTags(IGenInfoBuilder genInfoBuilder) {
        IBuilderTag tagSQL = genInfoBuilder.tagFromName("FSQL");
        if (tagSQL != null) {
            IBuilderTag tag = tagSQL.firstSon();
            while (tag != null) {
                if (tag.getProperty("SQLDCMP") != null) {
                    IBuilderTag tagChild = tag.firstSon();
                    while (tagChild != null) {
                        if (tagChild.getName().endsWith("-SQLDCMP")) {
                            genInfoBuilder.removeTag(tagChild);
                        }
                        tagChild = tagChild.nextTag();
                    }
                }
                tag = tag.nextTag();
            }
        }
    }

    private void removeFnTag(IGenInfoBuilder genInfoBuilder, IBuilderTag currentTag) {
        while (currentTag != null) {
            if (currentTag.getName().endsWith("-FN") && currentTag.getProperty("mp") != null) {
                genInfoBuilder.removeTag(currentTag.getName());
            }
            this.removeFnTag(genInfoBuilder, currentTag.firstSon());
            currentTag = currentTag.nextTag();
        }
    }

    private void processDotsAddition(IGenInfoBuilder genInfoBuilder, ArrayList<GeneratedTagPart> macroStructureIndexes, ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates, ArrayList<AbstractDotModifier.CandidateAddition> currentCandidates, int i, String previousSortproperty, String currentSortProperty, int procedureDivisionIndex) {
        boolean isProceduralCode;
        int macroStructureIndex = macroStructureIndexes.get(i).beginIndex;
        boolean bl = isProceduralCode = procedureDivisionIndex != -1 && macroStructureIndex >= procedureDivisionIndex;
        if (!isProceduralCode) {
            this.processDotsAddition(genInfoBuilder, macroStructureIndexes, validatedCandidates, currentCandidates, i, true);
        } else {
            this.processDotsAddition(genInfoBuilder, macroStructureIndexes, validatedCandidates, currentCandidates, i, false);
        }
    }

    private void processDotsAddition(IGenInfoBuilder genInfoBuilder, ArrayList<GeneratedTagPart> macroStructureIndexes, ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates, ArrayList<AbstractDotModifier.CandidateAddition> currentCandidates, int i, boolean manageWorking) {
        boolean redefinedOrDeletedPart;
        GeneratedTagPart macroStructureTagPart = macroStructureIndexes.get(i);
        IBuilderTag tag = macroStructureTagPart.getTag();
        String generatedText = tag.getProperty(GENERATED_TEXT);
        String mspPartText = null;
        boolean bl = redefinedOrDeletedPart = generatedText != null && generatedText.length() != 0;
        if (redefinedOrDeletedPart) {
            int beginIdx = macroStructureTagPart.getBeginIndex();
            int endIdx = macroStructureTagPart.getEndIndex();
            mspPartText = genInfoBuilder.getText().subSequence(beginIdx, endIdx).toString();
            this.processDotsAdditions_(genInfoBuilder, macroStructureIndexes, validatedCandidates, currentCandidates, i, manageWorking, macroStructureTagPart, tag, mspPartText, beginIdx, endIdx, true, false);
            mspPartText = generatedText;
            beginIdx = 0;
            endIdx = generatedText.length();
            this.processDotsAdditions_(genInfoBuilder, macroStructureIndexes, validatedCandidates, currentCandidates, i, manageWorking, macroStructureTagPart, tag, mspPartText, beginIdx, endIdx, true, true);
        } else {
            int beginIdx = macroStructureTagPart.getBeginIndex();
            int endIdx = macroStructureTagPart.getEndIndex();
            mspPartText = genInfoBuilder.getText().subSequence(beginIdx, endIdx).toString();
            this.processDotsAdditions_(genInfoBuilder, macroStructureIndexes, validatedCandidates, currentCandidates, i, manageWorking, macroStructureTagPart, tag, mspPartText, beginIdx, endIdx, false, false);
        }
    }

    protected void processDotsAdditions_(IGenInfoBuilder genInfoBuilder, ArrayList<GeneratedTagPart> macroStructureIndexes, ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates, ArrayList<AbstractDotModifier.CandidateAddition> currentCandidates, int i, boolean manageWorking, GeneratedTagPart macroStructureTagPart, IBuilderTag tag, String mspPartText, int beginIdx, int endIdx, boolean isRedefinedOrDeletedPart, boolean isOverridedText) {
        boolean onlyGenerateOnFirstLine = false;
        int macroStructureIndex = macroStructureIndexes.get(i).beginIndex;
        if (!manageWorking && this.procedureDivisionEndDeclarationIndex != -1 && macroStructureIndex <= this.procedureDivisionEndDeclarationIndex) {
            onlyGenerateOnFirstLine = true;
        }
        int startOfLineIndex = 0;
        int NLIndex = mspPartText.indexOf(this.NEW_LINE);
        AbstractDotModifier.CandidateAddition currentCandidateForGeneratedTagPart = null;
        while (NLIndex != -1) {
            boolean isSignificantLine;
            String line = mspPartText.substring(startOfLineIndex, NLIndex);
            if (currentCandidates != null && currentCandidates.size() != 0) {
                int dotOrigin;
                if (isRedefinedOrDeletedPart) {
                    if (isOverridedText) {
                        if (currentCandidateForGeneratedTagPart != null && (dotOrigin = this.isDotGeneratorLine(mspPartText, startOfLineIndex, NLIndex, manageWorking, macroStructureTagPart.getTag(), genInfoBuilder, beginIdx, true)) >= 0) {
                            boolean isDotCandidateValid = this.isDotCandidateValid(currentCandidateForGeneratedTagPart, dotOrigin);
                            if (isDotCandidateValid) {
                                validatedCandidates.add(currentCandidateForGeneratedTagPart);
                            }
                            currentCandidates.remove(currentCandidateForGeneratedTagPart);
                            currentCandidateForGeneratedTagPart = null;
                            continue;
                        }
                    } else {
                        dotOrigin = this.isDotGeneratorLine(mspPartText, startOfLineIndex, NLIndex, manageWorking, macroStructureTagPart.getTag(), genInfoBuilder, beginIdx, true);
                        if (dotOrigin >= 0) {
                            this.deleteUnvalidDotCandidates(currentCandidates, dotOrigin);
                            validatedCandidates.addAll(currentCandidates);
                            currentCandidates.clear();
                            continue;
                        }
                    }
                } else {
                    dotOrigin = this.isDotGeneratorLine(mspPartText, startOfLineIndex, NLIndex, manageWorking, macroStructureTagPart.getTag(), genInfoBuilder, beginIdx, true);
                    if (dotOrigin >= 0) {
                        this.deleteUnvalidDotCandidates(currentCandidates, dotOrigin);
                        validatedCandidates.addAll(currentCandidates);
                        currentCandidates.clear();
                        continue;
                    }
                }
            }
            boolean bl = isSignificantLine = !onlyGenerateOnFirstLine && this.isSignificantLineForDotAddition(mspPartText, startOfLineIndex, NLIndex, manageWorking, macroStructureTagPart.getTag());
            if (!isSignificantLine) {
                startOfLineIndex = NLIndex + this.NEW_LINE.length();
                NLIndex = mspPartText.indexOf(this.NEW_LINE, NLIndex + 1);
                continue;
            }
            int dotToAddPosition = this.getDotToAddPosition(mspPartText, startOfLineIndex, NLIndex, beginIdx, manageWorking);
            if (dotToAddPosition != -1) {
                if (!isRedefinedOrDeletedPart || isRedefinedOrDeletedPart && !isOverridedText) {
                    currentCandidates.clear();
                } else if (currentCandidateForGeneratedTagPart != null && currentCandidates.contains(currentCandidateForGeneratedTagPart)) {
                    currentCandidates.remove(currentCandidateForGeneratedTagPart);
                }
                if (!isRedefinedOrDeletedPart || isRedefinedOrDeletedPart && isOverridedText || isRedefinedOrDeletedPart && !isOverridedText && this.isLineWithMacroCodeAtRightMargin(line)) {
                    AbstractDotModifier.CandidateAddition candidate = new AbstractDotModifier.CandidateAddition(macroStructureTagPart.getTag(), startOfLineIndex + beginIdx, NLIndex + beginIdx, dotToAddPosition, isRedefinedOrDeletedPart ? tag.getBeginIndex() : startOfLineIndex + tag.getBeginIndex(), isRedefinedOrDeletedPart, line, isRedefinedOrDeletedPart && !isOverridedText);
                    currentCandidates.add(candidate);
                    if (isRedefinedOrDeletedPart && isOverridedText) {
                        currentCandidateForGeneratedTagPart = candidate;
                    }
                }
            } else {
                if (isRedefinedOrDeletedPart && isOverridedText) {
                    if (currentCandidateForGeneratedTagPart != null) {
                        currentCandidates.remove(currentCandidateForGeneratedTagPart);
                    }
                } else {
                    currentCandidates.clear();
                }
                currentCandidateForGeneratedTagPart = null;
            }
            startOfLineIndex = NLIndex + this.NEW_LINE.length();
            NLIndex = mspPartText.indexOf(this.NEW_LINE, NLIndex + 1);
        }
        if (genInfoBuilder.getRootTag().getEndIndex() != endIdx && startOfLineIndex + beginIdx != endIdx) {
            String message = "The end of the generated tag is not correct. \n" + macroStructureTagPart.getTag() + "\nLine part : " + mspPartText.substring(startOfLineIndex);
            throw new RuntimeException(message);
        }
        if (currentCandidates != null && currentCandidates.size() != 0) {
            String betweenMSPPartText;
            if (i + 1 == macroStructureIndexes.size()) {
                betweenMSPPartText = genInfoBuilder.getText().subSequence(macroStructureTagPart.getEndIndex(), genInfoBuilder.getText().length()).toString();
                if (betweenMSPPartText.trim().length() == 0 && manageWorking && this.procedureDivisionDeclarationIndex == -1) {
                    this.deleteUnvalidDotCandidates(currentCandidates, 1);
                    validatedCandidates.addAll(currentCandidates);
                    currentCandidates.clear();
                }
            } else if (i + 1 < macroStructureIndexes.size()) {
                GeneratedTagPart nextMacroStructureTagPart = macroStructureIndexes.get(i + 1);
                if (nextMacroStructureTagPart.getBeginIndex() == macroStructureTagPart.getEndIndex()) {
                    return;
                }
                betweenMSPPartText = genInfoBuilder.getText().subSequence(macroStructureTagPart.getEndIndex(), nextMacroStructureTagPart.getBeginIndex()).toString();
            } else {
                return;
            }
            startOfLineIndex = 0;
            NLIndex = betweenMSPPartText.indexOf(this.NEW_LINE);
            while (NLIndex != -1) {
                boolean isSignificantLine;
                int dotOrigin;
                if (currentCandidates != null && currentCandidates.size() != 0 && (dotOrigin = this.isDotGeneratorLine(betweenMSPPartText, startOfLineIndex, NLIndex, manageWorking, null, genInfoBuilder, macroStructureTagPart.getEndIndex(), true)) >= 0) {
                    this.deleteUnvalidDotCandidates(currentCandidates, dotOrigin);
                    validatedCandidates.addAll(currentCandidates);
                    currentCandidates.clear();
                    break;
                }
                boolean bl = isSignificantLine = !onlyGenerateOnFirstLine && this.isSignificantLineForDotAddition(betweenMSPPartText, startOfLineIndex, NLIndex, manageWorking, null);
                if (!isSignificantLine) {
                    startOfLineIndex = NLIndex + this.NEW_LINE.length();
                    if ((NLIndex = betweenMSPPartText.indexOf(this.NEW_LINE, NLIndex + 1)) != -1) continue;
                    break;
                }
                currentCandidates.clear();
                break;
            }
        }
    }

    private void deleteUnvalidDotCandidates(ArrayList<AbstractDotModifier.CandidateAddition> currentCandidates, int dotOrigin) {
        if (currentCandidates == null || currentCandidates.size() == 0) {
            return;
        }
        int i = currentCandidates.size() - 1;
        while (i >= 0) {
            AbstractDotModifier.CandidateAddition candidate = currentCandidates.get(i);
            if (!this.isDotCandidateValid(candidate, dotOrigin)) {
                currentCandidates.remove(i);
            }
            --i;
        }
    }

    private boolean isDotCandidateValid(AbstractDotModifier.CandidateAddition candidate, int dotOrigin) {
        if (dotOrigin == 1) {
            return true;
        }
        if (candidate.getLine() == null) {
            return true;
        }
        String line = candidate.getLine();
        if (line.length() > 72) {
            line = line.substring(11, 72).trim();
        } else {
            if (line.length() < 12) {
                return true;
            }
            line = line.substring(11).trim();
        }
        if (line.equals("IF")) {
            return false;
        }
        if (line.startsWith("IF ") && !line.endsWith("END-IF")) {
            return false;
        }
        if (line.startsWith("OR ") && !line.endsWith("END-IF") || line.startsWith("AND ") && !line.endsWith("END-IF")) {
            String textBefore;
            int maxLine = Math.max(line.length(), 80);
            int startFrom = candidate.getLineBegining() - maxLine * 20;
            if (startFrom < 0) {
                startFrom = 0;
            }
            return !this.isFromIfStatement(textBefore = "" + candidate.getTag().getGenInfoBuilder().getText().subSequence(startFrom, candidate.getLineBegining()));
        }
        return true;
    }

    private boolean isFromIfStatement(String textBefore) {
        int currentEndOfLine = textBefore.length() - 1;
        int previousEndOfLine = textBefore.lastIndexOf("\n", currentEndOfLine - 1);
        while (previousEndOfLine != -1) {
            String previousLine = textBefore.substring(previousEndOfLine + 1, currentEndOfLine);
            if (previousLine.contains(" IF ")) {
                return true;
            }
            if (previousLine.contains(" UNTIL ")) {
                return false;
            }
            if (previousLine.contains(" UNSTRING ")) {
                return false;
            }
            currentEndOfLine = previousEndOfLine;
            previousEndOfLine = textBefore.lastIndexOf("\n", currentEndOfLine - 1);
        }
        return true;
    }

    private void dealWithDOT(IMicroPatternProcessingContext context, IGenInfoBuilder genInfoBuilder) {
        this.pciov = this.getCommentInsertionOption(context);
        this.macrosCalled = this.getMacrosCalled(context);
        this.tagsFor_POS_VPSI_postProcessor = this.getTagsFor_POS_VPSI_postProcessor(context);
        ArrayList<GeneratedTagPart> macroStructureIndexes = this.getComputedAllGeneratedIndexes(genInfoBuilder, false);
        if (macroStructureIndexes.size() == 0) {
            return;
        }
        ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates = new ArrayList<AbstractDotModifier.CandidateAddition>();
        ArrayList<AbstractDotModifier.CandidateAddition> currentCandidates = new ArrayList<AbstractDotModifier.CandidateAddition>();
        String previousSortProperty = null;
        String currentSortProperty = null;
        int i = 0;
        while (i < macroStructureIndexes.size()) {
            GeneratedTagPart macroStructureTagPart = macroStructureIndexes.get(i);
            currentSortProperty = macroStructureTagPart.getTag().getProperty("sort");
            this.processDotsAddition(genInfoBuilder, macroStructureIndexes, validatedCandidates, currentCandidates, i, previousSortProperty, currentSortProperty, this.procedureDivisionDeclarationIndex);
            if (currentSortProperty != null) {
                previousSortProperty = currentSortProperty;
            }
            ++i;
        }
        this.writeDotForValidateCandidates(validatedCandidates, genInfoBuilder);
    }

    private Set<String> getTagsFor_POS_VPSI_postProcessor(IMicroPatternProcessingContext context) {
        Object result = context.getData("TAG_LIST_VPSI_DISPLAY");
        if (result != null && result instanceof Set) {
            return (Set)result;
        }
        return Collections.emptySet();
    }

    private ArrayList<String> getMacrosCalled(IMicroPatternProcessingContext context) {
        ArrayList<String> result = new ArrayList<String>();
        Object obj = context.getData("DESIGN_FILE_IN_CONTEXT");
        EList cpLines = null;
        if (obj instanceof PacProgram) {
            cpLines = ((PacProgram)obj).getCPLines();
        } else if (obj instanceof PacAbstractDialog) {
            cpLines = ((PacAbstractDialog)obj).getCPLines();
        } else if (obj instanceof PacAbstractDialogServer) {
            cpLines = ((PacAbstractDialogServer)obj).getCPLines();
        }
        if (cpLines == null) {
            return result;
        }
        for (Object cpline : cpLines) {
            PacCPLine pacCPLine;
            String macro;
            if (!(cpline instanceof PacCPLine) || result.contains(macro = (pacCPLine = (PacCPLine)cpline).getMacro().getName())) continue;
            result.add(macro);
        }
        return result;
    }

    private IBuilderTag getTagAfterTheEndTag(String tagName, IGenInfoBuilder genInfoBuilder) {
        IBuilderTag tag = genInfoBuilder.getRootTag();
        if (tagName.equals(tag.getName())) {
            return this.nextTagInHiearchy(tag, true);
        }
        tag = this.nextTagInHiearchy(tag, false);
        while (tag != null && !tagName.equals(tag.getName())) {
            tag = this.nextTagInHiearchy(tag, false);
        }
        if (tag != null && tagName.equals(tag.getName())) {
            return this.nextTagInHiearchy(tag, true);
        }
        return null;
    }

    private IBuilderTag nextTagInHiearchy(IBuilderTag tag, boolean jumpChildren) {
        if (!jumpChildren && tag.hasSon()) {
            return tag.firstSon();
        }
        IBuilderTag next = tag.nextTag();
        if (next != null) {
            return next;
        }
        IBuilderTag parent = tag;
        while (next == null) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            next = parent.nextTag();
        }
        return next;
    }

    protected PacCommentsInsertionOptionValues getCommentInsertionOption(IMicroPatternProcessingContext context) {
        PacLibrary lib;
        Object obj = context.getData("DESIGN_FILE_IN_CONTEXT");
        PacProgramWrapper rew = null;
        if (obj instanceof PacProgram) {
            rew = new PacProgramWrapper((PacProgram)obj);
        }
        if (rew != null && (lib = rew.getGenerationParameter()) != null) {
            return lib.getCommentsInsertionOption();
        }
        return null;
    }

    private boolean isReformatted(IBuilderTag builderTag) {
        String reformattedTag = builderTag.getProperty("ChangeNature");
        return "Reformated".equalsIgnoreCase(reformattedTag);
    }

    private boolean index_insideInterval(int i, int j, int k) {
        return i >= j && i < k;
    }

    private void dealWithEXIT_v2(IGenInfoBuilder genInfoBuilder) {
        ArrayList<GeneratedTagPart> macroStructureIndexes = this.getComputedAllGeneratedIndexes(genInfoBuilder, false);
        if (macroStructureIndexes.size() == 0 || this.procedureDivisionDeclarationIndex == -1) {
            return;
        }
        ArrayList<ExitAddition> exitAdditions = new ArrayList<ExitAddition>();
        CobolLabel previousLabel = null;
        int previousLabelLineOffset = -1;
        GeneratedTagPart previousTagPart = null;
        int startIndexAlreadyTreatedForSpecific = -1;
        int endIndexAlreadyTreatedForSpecific = -1;
        int i = 0;
        while (i < macroStructureIndexes.size()) {
            GeneratedTagPart macroStructureTagPart = macroStructureIndexes.get(i);
            if (macroStructureTagPart.getEndIndex() > this.procedureDivisionDeclarationIndex) {
                int beginIdx = macroStructureTagPart.getBeginIndex();
                int endIdx = macroStructureTagPart.getEndIndex();
                String mspPartText = genInfoBuilder.getText().subSequence(beginIdx, endIdx).toString();
                String generatedTextOfSpecificTag = macroStructureTagPart.getTag().getProperty(GENERATED_TEXT);
                String changeNature = macroStructureTagPart.getTag().getProperty("ChangeNature");
                boolean isReformattedTag = this.isReformatted(macroStructureTagPart.getTag());
                if (generatedTextOfSpecificTag != null) {
                    if (isReformattedTag || previousLabel == null) {
                        beginIdx = 0;
                        endIdx = generatedTextOfSpecificTag.length();
                        mspPartText = generatedTextOfSpecificTag;
                    } else if (changeNature.equalsIgnoreCase("Replaced") && !this.index_insideInterval(i, startIndexAlreadyTreatedForSpecific, endIndexAlreadyTreatedForSpecific)) {
                        startIndexAlreadyTreatedForSpecific = i;
                        boolean encore = true;
                        while (i < macroStructureIndexes.size() && encore) {
                            macroStructureTagPart = macroStructureIndexes.get(i);
                            beginIdx = macroStructureTagPart.getBeginIndex();
                            endIdx = macroStructureTagPart.getEndIndex();
                            mspPartText = genInfoBuilder.getText().subSequence(beginIdx, endIdx).toString();
                            int startLineIndex = 0;
                            int nlIndex = mspPartText.indexOf(this.NEW_LINE);
                            while (nlIndex != -1) {
                                String line2 = mspPartText.substring(startLineIndex, nlIndex);
                                boolean isSignificantLine = this.isSignificantLine(mspPartText, startLineIndex, nlIndex);
                                if (!isSignificantLine) {
                                    startLineIndex = nlIndex + this.NEW_LINE.length();
                                    nlIndex = mspPartText.indexOf(this.NEW_LINE, nlIndex + 1);
                                    continue;
                                }
                                CobolLabel l = BasicPacLabelRecognizer.findLabelInLine(line2);
                                if (l != null) {
                                    if (previousLabel != null && !previousLabel.isSpecialKeyword()) {
                                        int x = previousLabelLineOffset + 7 + previousLabel.getPacLabel().length() + 1;
                                        ExitAddition cea = new ExitAddition(previousTagPart.getTag(), x);
                                        exitAdditions.add(cea);
                                        previousLabel = null;
                                        encore = false;
                                        break;
                                    }
                                } else {
                                    previousLabel = null;
                                    encore = false;
                                }
                                startLineIndex = nlIndex + this.NEW_LINE.length();
                                nlIndex = mspPartText.indexOf(this.NEW_LINE, nlIndex + 1);
                            }
                            ++i;
                        }
                        beginIdx = 0;
                        endIdx = generatedTextOfSpecificTag.length();
                        mspPartText = generatedTextOfSpecificTag;
                        endIndexAlreadyTreatedForSpecific = i;
                        i = startIndexAlreadyTreatedForSpecific;
                        macroStructureTagPart = macroStructureIndexes.get(i);
                    }
                }
                int startOfLineIndex = 0;
                int NLIndex = mspPartText.indexOf(this.NEW_LINE);
                while (NLIndex != -1) {
                    String line = mspPartText.substring(startOfLineIndex, NLIndex);
                    boolean isSignificantLine = this.isSignificantLine(mspPartText, startOfLineIndex, NLIndex);
                    if (!isSignificantLine) {
                        startOfLineIndex = NLIndex + this.NEW_LINE.length();
                        NLIndex = mspPartText.indexOf(this.NEW_LINE, NLIndex + 1);
                        continue;
                    }
                    CobolLabel l = BasicPacLabelRecognizer.findLabelInLine(line);
                    if (l != null) {
                        int b;
                        int a;
                        String remainingStr;
                        if (previousLabel != null && !previousLabel.isSpecialKeyword()) {
                            int x = previousLabelLineOffset + 7 + previousLabel.getPacLabel().length() + 1;
                            ExitAddition cea = new ExitAddition(previousTagPart.getTag(), x);
                            exitAdditions.add(cea);
                            previousLabel = null;
                        }
                        if ((remainingStr = line.substring((a = l.getPosInLine()) + (b = l.getPacLabel().length() + 1), Math.min(line.length(), 72))).trim().isEmpty()) {
                            previousLabel = l;
                            previousTagPart = macroStructureTagPart;
                            previousLabelLineOffset = generatedTextOfSpecificTag != null ? startOfLineIndex : macroStructureTagPart.getBeginIndex() + startOfLineIndex;
                        }
                    } else {
                        previousLabel = null;
                    }
                    startOfLineIndex = NLIndex + this.NEW_LINE.length();
                    NLIndex = mspPartText.indexOf(this.NEW_LINE, NLIndex + 1);
                }
                if (i + 1 < macroStructureIndexes.size() && previousLabel != null) {
                    GeneratedTagPart nextMacroStructureTagPart = macroStructureIndexes.get(i + 1);
                    if (nextMacroStructureTagPart.getBeginIndex() == macroStructureTagPart.getEndIndex()) {
                        String overriddenText = nextMacroStructureTagPart.getTag().getProperty(GENERATED_TEXT);
                        if (overriddenText != null) {
                            String betweenMSPPartText = genInfoBuilder.getText().subSequence(macroStructureTagPart.getEndIndex(), genInfoBuilder.getText().length()).toString();
                            startOfLineIndex = 0;
                            NLIndex = betweenMSPPartText.indexOf(this.NEW_LINE);
                            for (int nbOfMaxLinesToSweep = 30; NLIndex != -1 && nbOfMaxLinesToSweep >= 0; --nbOfMaxLinesToSweep) {
                                String line = betweenMSPPartText.substring(startOfLineIndex, NLIndex);
                                boolean isSignificantLine = this.isSignificantLine(betweenMSPPartText, startOfLineIndex, NLIndex);
                                if (!isSignificantLine) {
                                    startOfLineIndex = NLIndex + this.NEW_LINE.length();
                                    NLIndex = betweenMSPPartText.indexOf(this.NEW_LINE, NLIndex + 1);
                                    continue;
                                }
                                CobolLabel l = BasicPacLabelRecognizer.findLabelInLine(line);
                                if (l != null && !previousLabel.isSpecialKeyword()) {
                                    int x = previousLabelLineOffset + 7 + previousLabel.getPacLabel().length() + 1;
                                    ExitAddition cea = new ExitAddition(previousTagPart.getTag(), x);
                                    exitAdditions.add(cea);
                                    previousLabel = null;
                                } else {
                                    previousLabel = null;
                                }
                                break;
                            }
                        }
                    } else {
                        String betweenMSPPartText = genInfoBuilder.getText().subSequence(macroStructureTagPart.getEndIndex(), nextMacroStructureTagPart.getBeginIndex()).toString();
                        startOfLineIndex = 0;
                        NLIndex = betweenMSPPartText.indexOf(this.NEW_LINE);
                        while (NLIndex != -1) {
                            String line = betweenMSPPartText.substring(startOfLineIndex, NLIndex);
                            boolean isSignificantLine = this.isSignificantLine(betweenMSPPartText, startOfLineIndex, NLIndex);
                            if (!isSignificantLine) {
                                startOfLineIndex = NLIndex + this.NEW_LINE.length();
                                NLIndex = betweenMSPPartText.indexOf(this.NEW_LINE, NLIndex + 1);
                                continue;
                            }
                            CobolLabel l = BasicPacLabelRecognizer.findLabelInLine(line);
                            if (l != null && !previousLabel.isSpecialKeyword()) {
                                int x = previousLabelLineOffset + 7 + previousLabel.getPacLabel().length() + 1;
                                ExitAddition cea = new ExitAddition(previousTagPart.getTag(), x);
                                exitAdditions.add(cea);
                                previousLabel = null;
                            } else {
                                previousLabel = null;
                            }
                            break;
                        }
                    }
                }
            }
            ++i;
        }
        this.writeExitFor(genInfoBuilder, exitAdditions);
    }

    private void dealWithRightMarks(IGenInfoBuilder genInfoBuilder) {
        if (PacTool.markAtEndOfLine()) {
            IBuilderTag rootTag = genInfoBuilder.getRootTag();
            String entityName = rootTag.getName();
            if (entityName.startsWith("ENTITY_")) {
                entityName = entityName.substring(7);
            }
            if (rootTag.firstSon() != null) {
                IBuilderTag tag = this.nextTagInHiearchy(rootTag.firstSon(), false);
                while (tag != null) {
                    if (!tag.hasSon()) {
                        if (tag.getProperty("lowMPFrom") != null) {
                            tag.setText((CharSequence)this.appendMark(tag.getText().toString(), tag.getProperty("lowMPFrom")));
                        } else if (tag.getProperty("mp") != null) {
                            String name = entityName;
                            if (tag.getProperty("specificMP") != null) {
                                name = "000000" + tag.getProperty("specificMP");
                                name = name.substring(name.length() - 6);
                            }
                            tag.setText((CharSequence)this.appendMark(tag.getText().toString(), name));
                        }
                    }
                    if (tag.getParent().getProperty("lowMPFrom") != null || tag.getParent().getProperty("mp") != null) {
                        String mark;
                        String string = mark = tag.getParent().getProperty("mp") != null ? entityName : tag.getParent().getProperty("lowMPFrom");
                        if (tag.getProperty("specificMP") != null) {
                            mark = "000000" + tag.getProperty("specificMP");
                            mark = mark.substring(mark.length() - 6);
                        }
                        if (tag.getTextBefore().length() > 0) {
                            tag.setTextBefore((CharSequence)this.appendMark(tag.getTextBefore().toString(), mark));
                        }
                        if (tag.getTextAfter().length() > 0) {
                            tag.setTextAfter((CharSequence)this.appendMark(tag.getTextAfter().toString(), mark));
                        }
                    }
                    tag = this.nextTagInHiearchy(tag, false);
                }
            }
        }
    }

    private String appendMark(String originalText, String markToAppend) {
        if (originalText.trim().length() == 0) {
            return originalText;
        }
        String[] tab = PdpTool.splitTextIntoArrayLines((String)originalText.toString());
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < tab.length) {
            StringBuilder line = new StringBuilder(tab[i]);
            CobolLabel lab = BasicPacLabelRecognizer.findCobolLabelInLine(line.toString());
            boolean isRightMargin = true;
            if (lab == null || lab.getPacLabel().equals("F25-FN") || lab.getPacLabel().equals("F35-FN") || lab.getPacLabel().equals("F60-FN") || lab.getPacLabel().equals("F65-FN")) {
                if (tab[i].length() > 72) {
                    String margin = line.substring(72).trim();
                    if (margin.length() == 0) {
                        line = new StringBuilder(line.substring(0, 72));
                    } else {
                        isRightMargin = false;
                    }
                }
                if (isRightMargin) {
                    while (line.length() < 72) {
                        line.append(" ");
                    }
                    line.append(markToAppend);
                }
            }
            result.append((CharSequence)line);
            result.append(this.NEW_LINE);
            ++i;
        }
        if (!originalText.endsWith(this.NEW_LINE)) {
            int length = result.length();
            result.replace(length - this.NEW_LINE.length(), length, "");
        }
        return result.toString();
    }

    private void writeExitForGenInProperty(IGenInfoBuilder genInfoBuilder, ExitAddition elem, String generatedTextOfSpecificTag) {
        int endOffset;
        int a = elem.getBeginningOffset();
        int end = generatedTextOfSpecificTag.length();
        int begin = PdpTool.getLineStartOffset((CharSequence)generatedTextOfSpecificTag, (int)a);
        CharSequence line = generatedTextOfSpecificTag.subSequence(begin, endOffset = PdpTool.getLineEndOffset((CharSequence)generatedTextOfSpecificTag, (int)a));
        if (line.length() > 66) {
            String value = String.valueOf(generatedTextOfSpecificTag.substring(0, a)) + EXIT_TO_ADD_STRING + generatedTextOfSpecificTag.substring(a + 6, end);
            elem.getTag().setProperty(GENERATED_TEXT, value);
        } else {
            String value = String.valueOf(generatedTextOfSpecificTag.substring(0, a)) + EXIT_TO_ADD_STRING + generatedTextOfSpecificTag.substring(a, end);
            elem.getTag().setProperty(GENERATED_TEXT, value);
        }
    }

    private void writeExitForGen(IGenInfoBuilder genInfoBuilder, ExitAddition elem) {
        int end;
        int begin;
        int beginOffset = elem.getBeginningOffset();
        CharSequence cs = genInfoBuilder.getText();
        CharSequence line = cs.subSequence(begin = PdpTool.getLineStartOffset((CharSequence)cs, (int)beginOffset), end = PdpTool.getLineEndOffset((CharSequence)cs, (int)beginOffset));
        if (line.length() > 66) {
            MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)elem.getTag(), (int)beginOffset, (int)(beginOffset + 6), (String)EXIT_TO_ADD_STRING, (boolean)false);
        } else {
            MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)elem.getTag(), (int)beginOffset, (int)beginOffset, (String)EXIT_TO_ADD_STRING, (boolean)false);
        }
    }

    private void writeExitFor(IGenInfoBuilder genInfoBuilder, List<ExitAddition> exitAdditions) {
        int last;
        int i = last = exitAdditions.size() - 1;
        while (i > -1) {
            ExitAddition elem = exitAdditions.get(i);
            String generatedTextOfSpecificTag = elem.getTag().getProperty(GENERATED_TEXT);
            if (generatedTextOfSpecificTag != null) {
                this.writeExitForGenInProperty(genInfoBuilder, elem, generatedTextOfSpecificTag);
            } else {
                this.writeExitForGen(genInfoBuilder, elem);
            }
            --i;
        }
    }

    private void writeDotForValidateCandidates(ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates, IGenInfoBuilder genInfoBuilder) {
        int i = validatedCandidates.size() - 1;
        while (i >= 0) {
            int dotPosition;
            AbstractDotModifier.CandidateAddition ctda = validatedCandidates.get(i);
            if (ctda.specificModification) {
                dotPosition = ctda.getAdditionPosition();
                MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)ctda.getTag(), (int)dotPosition, (int)(dotPosition + 1), (String)".", (boolean)false);
            } else {
                dotPosition = ctda.getAdditionPosition();
                String generatedText = ctda.getTag().getProperty(GENERATED_TEXT);
                if (generatedText != null && generatedText.length() != 0 && ctda.isInDeletedBlock()) {
                    if (dotPosition >= 0) {
                        String newGeneratedText;
                        if (dotPosition < ctda.getLineEnd()) {
                            newGeneratedText = String.valueOf(generatedText.substring(0, dotPosition)) + "." + generatedText.substring(dotPosition + 1);
                            ctda.getTag().setProperty(GENERATED_TEXT, newGeneratedText);
                        } else {
                            newGeneratedText = String.valueOf(generatedText.substring(0, dotPosition)) + "." + generatedText.substring(dotPosition);
                            ctda.getTag().setProperty(GENERATED_TEXT, newGeneratedText);
                        }
                    }
                } else if (dotPosition >= 0) {
                    if (dotPosition < ctda.getLineEnd()) {
                        MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)ctda.getTag(), (int)dotPosition, (int)(dotPosition + 1), (String)".", (boolean)false);
                    } else {
                        MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)ctda.getTag(), (int)dotPosition, (int)dotPosition, (String)".", (boolean)false);
                    }
                } else if (dotPosition == -3) {
                    StringBuilder sb;
                    String textOriginal = ctda.getTag().getText().toString();
                    String line = new String(ctda.getLine());
                    int caractBlanc = line.indexOf("  ", 12);
                    if (caractBlanc >= 0) {
                        sb = new StringBuilder(line);
                        sb.deleteCharAt(caractBlanc);
                        sb.insert(71, ".");
                        String newLine = textOriginal.replace(line, sb);
                        ctda.getTag().setText((CharSequence)newLine);
                    } else {
                        sb = new StringBuilder();
                        String rightMarginName = ctda.getTag().getProperty("msp");
                        while (sb.length() < 12) {
                            sb.append(" ");
                        }
                        sb.append(".");
                        if (rightMarginName != null) {
                            while (sb.length() < 72) {
                                sb.append(" ");
                            }
                            sb.append(rightMarginName);
                        }
                        sb.append(this.NEW_LINE);
                        String newLine = String.valueOf(textOriginal) + sb;
                        ctda.getTag().setText((CharSequence)newLine);
                    }
                }
            }
            --i;
        }
    }

    private void writeEndExecForValidateCandidates(ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates, IGenInfoBuilder genInfoBuilder) {
        int i = validatedCandidates.size() - 1;
        while (i >= 0) {
            AbstractDotModifier.CandidateAddition ctda = validatedCandidates.get(i);
            boolean insertNewLine = ctda.specificModification;
            String line = ctda.getLine();
            int endExecposition = ctda.getAdditionPosition();
            int delta = 0;
            if (endExecposition >= 0) {
                String endExec = null;
                if (endExecposition > ctda.getLineEnd()) {
                    StringBuilder sb = new StringBuilder();
                    if (line.length() != 0 && line.charAt(line.length() - 1) == '.') {
                        sb.append(" ");
                        delta = 1;
                    }
                    int j = endExecposition - ctda.getLineEnd();
                    while (j > 0) {
                        sb.append(" ");
                        --j;
                    }
                    sb.append(END_EXEC);
                    endExecposition = ctda.getLineEnd();
                    String rightMarginName = this.programName;
                    if (insertNewLine) {
                        String specificProperty;
                        IBuilderTag tag = genInfoBuilder.includingTag(endExecposition - delta, endExecposition);
                        String mspProperty = tag.getProperty("msp");
                        if (mspProperty != null) {
                            if ("artificialCreate".equals(mspProperty)) {
                                IBuilderTag son = this.findFirstRealMacro(tag);
                                if (son != null && (mspProperty = son.getProperty("msp")) != null) {
                                    rightMarginName = mspProperty;
                                }
                            } else {
                                rightMarginName = mspProperty;
                            }
                        }
                        if ((specificProperty = tag.getProperty(SPECIFIG_TAG)) != null) {
                            rightMarginName = "";
                        }
                        while (sb.length() < 72) {
                            sb.append(" ");
                        }
                        sb.append(rightMarginName);
                        sb.append(this.NEW_LINE);
                    }
                    endExec = sb.toString();
                    MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)(insertNewLine ? null : ctda.getTag()), (int)(endExecposition - delta), (int)endExecposition, (String)endExec, (boolean)false);
                } else {
                    String trimRightLine;
                    if (line.length() > 72) {
                        line = line.substring(0, 72);
                    }
                    if ((trimRightLine = PacGenerationPostProcessor.trimRight(line)).charAt(trimRightLine.length() - 1) == '.') {
                        int dotIndexInLine = trimRightLine.length() - 1;
                        int dotIndex = ctda.getLineBegining() + dotIndexInLine;
                        if (endExecposition <= dotIndex) {
                            endExec = END_EXEC;
                            MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)ctda.getTag(), (int)endExecposition, (int)(endExecposition + endExec.length()), (String)endExec, (boolean)false);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            int j = endExecposition - dotIndex;
                            while (j > 0) {
                                sb.append(" ");
                                --endExecposition;
                                --j;
                            }
                            sb.append(END_EXEC);
                            endExec = sb.toString();
                            MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)ctda.getTag(), (int)endExecposition, (int)(endExecposition + endExec.length()), (String)endExec, (boolean)false);
                        }
                    } else {
                        endExec = END_EXEC;
                        int nbCharsAfterDotPosition = ctda.getLineEnd() - endExecposition;
                        int min = Math.min(nbCharsAfterDotPosition, endExec.length());
                        MicroPatternEngine.ReplaceText((IGenInfoBuilder)genInfoBuilder, (IBuilderTag)ctda.getTag(), (int)endExecposition, (int)(endExecposition + min), (String)endExec, (boolean)false);
                    }
                }
            }
            --i;
        }
    }

    private IBuilderTag findFirstRealMacro(IBuilderTag tag) {
        String mspProperty = tag.getProperty("msp");
        if (mspProperty != null && !mspProperty.equals("artificialCreate")) {
            return tag;
        }
        IBuilderTag son = tag.firstSon();
        while (son != null) {
            IBuilderTag sonResult = this.findFirstRealMacro(son);
            if (sonResult != null) {
                return sonResult;
            }
            son = son.nextTag();
        }
        return null;
    }

    private boolean isMacroOrMPTag(IBuilderTag tag, HashSet<IBuilderTag> tagPartiallyTreated) {
        String generatedText;
        boolean isMP;
        boolean isMacro;
        String property = tag.getProperty("msp");
        boolean bl = isMacro = property != null && property.trim().length() != 0;
        if (isMacro) {
            return true;
        }
        String mpProperty = tag.getProperty("mp");
        boolean bl2 = isMP = mpProperty != null && mpProperty.trim().length() != 0;
        if (isMP) {
            return true;
        }
        String specific_property = tag.getProperty(SPECIFIG_TAG);
        if (specific_property != null && specific_property.trim().length() != 0 && (generatedText = tag.getProperty(GENERATED_TEXT)) != null && generatedText.length() != 0) {
            boolean result = this.isMacroOrMPTag(tag.getParent(), tagPartiallyTreated);
            if (tagPartiallyTreated.contains(tag)) {
                return false;
            }
            tagPartiallyTreated.add(tag);
            return result;
        }
        return false;
    }

    private boolean isGeneratedTag(IBuilderTag tag, HashSet<IBuilderTag> tagPartiallyTreated) {
        String generatedText;
        boolean isGenerated;
        String property = tag.getProperty(SPECIFIG_TAG);
        boolean bl = isGenerated = property == null || property.trim().length() == 0;
        if (isGenerated) {
            return true;
        }
        if (property != null && property.trim().length() != 0 && (generatedText = tag.getProperty(GENERATED_TEXT)) != null && generatedText.length() != 0) {
            if (tagPartiallyTreated.contains(tag)) {
                return false;
            }
            tagPartiallyTreated.add(tag);
            return true;
        }
        return false;
    }

    private boolean isSignificantLineForDotAddition(String text, int startOfLine, int endOfLine, boolean manageWorking, IBuilderTag tag) {
        String tmpS;
        boolean significantComment;
        boolean bl = significantComment = this.pciov == PacCommentsInsertionOptionValues._O_LITERAL && !manageWorking && (tag == null || tag != null && !tag.getName().startsWith("N"));
        if (significantComment && this.pciov == PacCommentsInsertionOptionValues._O_LITERAL && (tmpS = text.substring(startOfLine, endOfLine)).length() > 6 && tmpS.substring(6).startsWith("*{") && tmpS.length() > 8 && ((tmpS = tmpS.substring(8)).startsWith("AFTER") || tmpS.startsWith("BEFORE") || tmpS.startsWith("REPLACE"))) {
            significantComment = false;
        }
        if (!significantComment && tag != null && this.tagsFor_POS_VPSI_postProcessor.contains(tag.getName())) {
            significantComment = true;
        }
        return this.isSignificantLine_(text, startOfLine, endOfLine, significantComment);
    }

    private boolean isSignificantLineForExec(String text, int startOfLine, int endOfLine) {
        String line;
        int lineLength = endOfLine - startOfLine;
        if (lineLength > 6 && !(line = text.substring(startOfLine + 6, endOfLine).trim()).startsWith(EXEC)) {
            return false;
        }
        return this.isSignificantLine_(text, startOfLine, endOfLine, false);
    }

    private ArrayList<GeneratedTagPart> getComputedAllGeneratedIndexes(IGenInfoBuilder genInfoBuilder, boolean onlyMacro) {
        IBuilderTag rootTag = genInfoBuilder.getRootTag();
        ArrayList<GeneratedTagPart> macroStructureTags = new ArrayList<GeneratedTagPart>();
        HashSet<IBuilderTag> tagPartiallyTreated = new HashSet<IBuilderTag>();
        this.addGeneratedIndexesForTag(rootTag, macroStructureTags, onlyMacro, tagPartiallyTreated);
        return macroStructureTags;
    }

    private void addGeneratedIndexesForTag(IBuilderTag tag, ArrayList<GeneratedTagPart> macroStructureTagList, boolean onlyMacro, HashSet<IBuilderTag> tagPartiallyTreated) {
        boolean isCandidate = false;
        isCandidate = this.isCandidateForMacroStructureTagList(tag, onlyMacro, tagPartiallyTreated);
        int previousIdx = tag.getBeginIndex();
        if (tag.hasSon()) {
            IBuilderTag sonTag = tag.firstSon();
            do {
                if (isCandidate && sonTag.getBeginIndex() != previousIdx) {
                    macroStructureTagList.add(new GeneratedTagPart(tag, previousIdx, sonTag.getBeginIndex()));
                    isCandidate = this.isCandidateForMacroStructureTagList(tag, onlyMacro, tagPartiallyTreated);
                }
                this.addGeneratedIndexesForTag(sonTag, macroStructureTagList, onlyMacro, tagPartiallyTreated);
                previousIdx = sonTag.getEndIndex();
            } while ((sonTag = sonTag.nextTag()) != null);
            if (isCandidate && tag.getEndIndex() != previousIdx) {
                macroStructureTagList.add(new GeneratedTagPart(tag, previousIdx, tag.getEndIndex()));
            }
        } else if (isCandidate) {
            macroStructureTagList.add(new GeneratedTagPart(tag, tag.getBeginIndex(), tag.getEndIndex()));
        }
    }

    private boolean isCandidateForMacroStructureTagList(IBuilderTag tag, boolean onlyMacro, HashSet<IBuilderTag> tagPartiallyTreated) {
        boolean isCandidate = onlyMacro ? this.isMacroOrMPTag(tag, tagPartiallyTreated) : this.isGeneratedTag(tag, tagPartiallyTreated);
        return isCandidate;
    }

    private void dealWithEND_EXEC(IMicroPatternProcessingContext context, IGenInfoBuilder genInfoBuilder) {
        IBuilderTag tag;
        String text;
        int procedureDivisionIndex;
        Object obj = context.getData("DESIGN_FILE_IN_CONTEXT");
        if (obj instanceof RadicalEntity) {
            this.programName = ((RadicalEntity)obj).getName();
        }
        if ((procedureDivisionIndex = (text = genInfoBuilder.getText().toString()).indexOf(" PROCEDURE DIVISION")) < 0 && (tag = this.getTagAfterTheEndTag("DATA", genInfoBuilder)) != null) {
            procedureDivisionIndex = tag.getBeginIndex();
        }
        if (procedureDivisionIndex < 0) {
            return;
        }
        this.initSQLDeclaredCursor(text);
        ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates = new ArrayList<AbstractDotModifier.CandidateAddition>();
        int exec_index = -1;
        while (true) {
            String line;
            int endExec_index = text.indexOf(END_EXEC_WP, exec_index + 1);
            if ((exec_index = text.indexOf(EXEC, exec_index + 1)) == -1) {
                this.writeEndExecForValidateCandidates(validatedCandidates, genInfoBuilder);
                this.sql_declared_cursors = null;
                return;
            }
            if (exec_index < procedureDivisionIndex || endExec_index == exec_index - 4) continue;
            int startOfLine = text.lastIndexOf(this.NEW_LINE, exec_index);
            startOfLine = startOfLine == -1 ? 0 : (startOfLine += this.NEW_LINE.length());
            int nextNewline = text.indexOf(this.NEW_LINE, exec_index);
            if (nextNewline == -1) {
                nextNewline = text.length();
            }
            if ((line = text.substring(startOfLine, nextNewline)).indexOf(END_EXEC) != -1 || line.indexOf(END_EXEC_WP) != -1) {
                exec_index = nextNewline;
                continue;
            }
            if (!this.isSignificantLineForExec(text, startOfLine, nextNewline) || line.indexOf(EXEC_CICS) < 11 && line.indexOf(EXEC_PAF) < 11 && line.indexOf(EXEC_SQL) < 11) continue;
            exec_index = this.scanExecBloc(validatedCandidates, text, startOfLine, nextNewline, genInfoBuilder);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initSQLDeclaredCursor(String text) {
        exec_index = -1;
        this.sql_declared_cursors = new ArrayList<E>(2);
        block0: while (true) {
            endExec_index = text.indexOf("END-EXEC", exec_index + 1);
            if ((exec_index = text.indexOf("EXEC", exec_index + 1)) == -1) {
                return;
            }
            if (endExec_index == exec_index - 4) continue;
            startOfLine = text.lastIndexOf(this.NEW_LINE, exec_index);
            startOfLine = startOfLine == -1 ? 0 : (startOfLine += this.NEW_LINE.length());
            nextNewline = text.indexOf(this.NEW_LINE, exec_index);
            if (nextNewline == -1) {
                nextNewline = text.length();
            }
            line = text.substring(startOfLine, nextNewline);
            tokensFromLine = this.getTokens(line);
            checkFound = false;
            var12_12 = tokensFromLine;
            var11_11 = tokensFromLine.length;
            var10_10 = 0;
            while (var10_10 < var11_11) {
                token = var12_12[var10_10];
                if (token.equals("EXEC")) {
                    checkFound = true;
                    break;
                }
                ++var10_10;
            }
            if (!checkFound) continue;
            cursorCandidate = null;
            inDeclare = false;
            firstExec = true;
            while (true) {
                endFindCursor = false;
                var16_17 = tokensFromLine;
                var15_16 = tokensFromLine.length;
                var14_15 = 0;
                while (var14_15 < var15_16) {
                    token = var16_17[var14_15];
                    if (!token.equals("EXEC")) ** GOTO lbl43
                    if (firstExec) {
                        firstExec = false;
                    } else {
                        endFindCursor = true;
                        break;
lbl43:
                        // 1 sources

                        if (token.equals("END-EXEC")) {
                            endFindCursor = true;
                            break;
                        }
                        if (token.equals("DECLARE")) {
                            inDeclare = true;
                        } else {
                            if (token.equals("CURSOR") && cursorCandidate != null) {
                                this.sql_declared_cursors.add(cursorCandidate);
                                inDeclare = false;
                                cursorCandidate = null;
                                endFindCursor = true;
                                break;
                            }
                            if (inDeclare) {
                                cursorCandidate = token;
                            }
                        }
                    }
                    ++var14_15;
                }
                if (!endFindCursor && startOfLine != text.length() && (startOfLine = nextNewline + this.NEW_LINE.length()) < text.length()) ** break;
                continue block0;
                nextNewline = text.indexOf(this.NEW_LINE, startOfLine);
                if (nextNewline == -1) {
                    nextNewline = text.length();
                }
                line = text.substring(startOfLine, nextNewline);
                tokensFromLine = this.getTokens(line);
            }
            break;
        }
    }

    private int scanExecBloc(ArrayList<AbstractDotModifier.CandidateAddition> validatedCandidates, String text, int startOfLine, int nextNewline, IGenInfoBuilder genInfoBuilder) {
        int startOfLineIndex;
        int NLIndex;
        String line = text.substring(startOfLine, nextNewline);
        if (line.length() > 72) {
            line = line.substring(0, 72);
        }
        int commentIndex = -1;
        int inCase = 0;
        int inParenthesis = 0;
        String[] tokens = this.getTokens(line);
        boolean isInSQLBlock = line.indexOf(EXEC_SQL) >= 7;
        boolean isInPAFBlock = line.indexOf(EXEC_PAF) >= 7;
        boolean isFirstOrderInitializedInSQLBlock = false;
        if (isInSQLBlock || isInPAFBlock) {
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals("CASE")) {
                    ++inCase;
                } else if (tokens[i].equals("(")) {
                    ++inParenthesis;
                } else if (tokens[i].equals(")")) {
                    --inParenthesis;
                }
                ++i;
            }
            if (line.substring(line.indexOf(EXEC_SQL) + EXEC_SQL.length()).trim().length() != 0) {
                isFirstOrderInitializedInSQLBlock = true;
            }
        }
        String[] mustExistWords = new String[]{WHENEVER};
        String[] mustNotExistWords = new String[]{CONTINUE, GOTO};
        boolean isInWheneverSQLBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords) && line.indexOf(GO_TO) == -1;
        mustExistWords = new String[]{"DO"};
        mustNotExistWords = new String[]{"PERFORM", "BREAK", CONTINUE};
        boolean isInWheneverWithDo = isInWheneverSQLBlock && this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{UPDATE};
        mustNotExistWords = new String[]{SET, "DECLARE"};
        boolean isInUpdateSLQBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{GETMAIN};
        mustNotExistWords = new String[]{SET};
        boolean isInGetMainCICSBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{"LOAD"};
        mustNotExistWords = new String[]{SET};
        boolean isInLoadCICSBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{"ALTER", "SESSION"};
        mustNotExistWords = new String[]{SET};
        boolean isInAlterSessionSQLBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{"POST"};
        mustNotExistWords = new String[]{SET};
        boolean isInPostCICSBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{"READQ"};
        mustNotExistWords = new String[]{SET};
        boolean isInREADQCICSBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{SET, "TDQUEUE"};
        mustNotExistWords = new String[]{"OPEN"};
        boolean isInSET_TDQUEUE_CICSBlock = !isInSQLBlock && this.containsWords(tokens, mustExistWords, mustNotExistWords);
        mustExistWords = new String[]{"INQUIRE", "TASK", "LIST"};
        mustNotExistWords = new String[]{SET};
        boolean isInINQUIRE_TASK_LIST_CICSBlock = !isInSQLBlock && this.containsWords(tokens, mustExistWords, mustNotExistWords);
        AbstractDotModifier.CandidateAddition candidate = null;
        boolean isCandidate = false;
        IBuilderTag tag = genInfoBuilder.includingTag(startOfLine + 1, startOfLine + 1);
        if (tag != null) {
            IBuilderTag parentTag;
            String mp = tag.getProperty("mp");
            boolean bl = isCandidate = mp != null && mp.trim().length() != 0;
            if (isCandidate) {
                String textInMP = tag.getText().toString();
                isCandidate = textInMP.indexOf(END_EXEC) > 0;
            } else {
                String property = tag.getProperty("msp");
                boolean bl2 = isCandidate = property != null && property.trim().length() != 0;
            }
            if (this.generated_END_EXEC_in_new_line && !isCandidate && (parentTag = genInfoBuilder.includingTag(nextNewline + this.NEW_LINE.length(), nextNewline + this.NEW_LINE.length())) != null) {
                String property = parentTag.getProperty("msp");
                boolean bl3 = isCandidate = property != null && property.trim().length() != 0;
            }
        }
        if (isCandidate) {
            int position = 61 + startOfLine;
            candidate = this.generated_END_EXEC_in_new_line ? new AbstractDotModifier.CandidateAddition(tag, nextNewline + this.NEW_LINE.length(), nextNewline + this.NEW_LINE.length(), nextNewline + this.NEW_LINE.length() + 11, 0, false, "", true) : new AbstractDotModifier.CandidateAddition(tag, startOfLine, nextNewline, position, 0, false, line, false);
        }
        if ((NLIndex = text.indexOf(this.NEW_LINE, startOfLineIndex = nextNewline + this.NEW_LINE.length())) == -1) {
            NLIndex = text.length();
        }
        while (NLIndex != -1) {
            String subLine = line = text.substring(startOfLineIndex, NLIndex);
            if (inParenthesis > 0 && this.isLabelInLine(line)) {
                return startOfLineIndex;
            }
            if (line.length() > 72) {
                subLine = line.substring(7, 72).trim();
            } else if (line.length() >= 7) {
                subLine = line.substring(7).trim();
            }
            boolean isLineInCICSBlock = line.indexOf(EXEC_CICS) >= 7;
            commentIndex = this.searchSQLComment(subLine, "--", !isLineInCICSBlock && isInSQLBlock);
            boolean isSignificantLine = true;
            if (commentIndex != -1) {
                int commentIndexInFullLine = this.searchSQLComment(line, "--", true);
                isSignificantLine = this.isSignificantLine(text, startOfLineIndex, NLIndex - (line.length() - commentIndexInFullLine));
                subLine = subLine.substring(0, commentIndex);
            } else {
                isSignificantLine = this.isSignificantLine(text, startOfLineIndex, NLIndex);
            }
            tokens = this.getTokens(subLine);
            if (!isSignificantLine) {
                startOfLineIndex = NLIndex + this.NEW_LINE.length();
                NLIndex = text.indexOf(this.NEW_LINE, startOfLineIndex);
                continue;
            }
            if (isInSQLBlock && !isInUpdateSLQBlock) {
                mustExistWords = new String[]{UPDATE};
                mustNotExistWords = new String[]{SET, "DECLARE"};
                isInUpdateSLQBlock = this.containsWords(tokens, mustExistWords, mustNotExistWords);
            }
            if (line.indexOf(END_EXEC) != -1 || line.indexOf(END_EXEC_WP) != -1) {
                if ((line.indexOf(EXEC_CICS) >= 7 || line.indexOf(EXEC_PAF) >= 7 || line.indexOf(EXEC_SQL) >= 7) && candidate != null) {
                    validatedCandidates.add(candidate);
                }
                return NLIndex + this.NEW_LINE.length();
            }
            boolean inExecBlock = false;
            if ((isInSQLBlock || isInPAFBlock) && (inParenthesis > 0 || inCase > 0)) {
                inExecBlock = true;
            }
            if ((isInSQLBlock || isInPAFBlock) && line.length() >= 14) {
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].equals("(")) {
                        ++inParenthesis;
                    } else if (inParenthesis > 0 && tokens[i].equals(")")) {
                        --inParenthesis;
                    } else if (tokens[i].equals("CASE")) {
                        ++inCase;
                    } else if (inCase > 0 && tokens[i].equals("END")) {
                        --inCase;
                    }
                    ++i;
                }
            }
            if (isInWheneverSQLBlock) {
                if (line.indexOf(CONTINUE) != -1 || line.indexOf(GOTO) != -1 || line.indexOf(GO_TO) != -1) {
                    isInWheneverSQLBlock = false;
                    inExecBlock = true;
                }
                if (isInWheneverWithDo) {
                    if (line.indexOf("PERFORM") != -1 || line.indexOf("BREAK") != -1 || line.indexOf(CONTINUE) != -1) {
                        isInWheneverSQLBlock = false;
                        inExecBlock = true;
                    }
                } else {
                    mustExistWords = new String[]{"DO"};
                    mustNotExistWords = new String[]{"PERFORM", "BREAK", CONTINUE};
                    isInWheneverWithDo = this.containsWords(tokens, mustExistWords, mustNotExistWords);
                }
            } else if (isInUpdateSLQBlock || isInGetMainCICSBlock || isInAlterSessionSQLBlock || isInPostCICSBlock || isInREADQCICSBlock || isInLoadCICSBlock || isInINQUIRE_TASK_LIST_CICSBlock) {
                mustExistWords = new String[]{SET};
                mustNotExistWords = new String[0];
                if (this.containsWords(tokens, mustExistWords, mustNotExistWords)) {
                    isInUpdateSLQBlock = false;
                    isInGetMainCICSBlock = false;
                    isInAlterSessionSQLBlock = false;
                    isInPostCICSBlock = false;
                    isInREADQCICSBlock = false;
                    inExecBlock = true;
                } else if (!inExecBlock) {
                    inExecBlock = this.isLineAlwaysInExecBlock(line, tokens, text, NLIndex);
                }
            } else if (isInSET_TDQUEUE_CICSBlock) {
                mustExistWords = new String[]{"OPEN"};
                mustNotExistWords = new String[0];
                if (this.containsWords(tokens, mustExistWords, mustNotExistWords)) {
                    isInSET_TDQUEUE_CICSBlock = false;
                    inExecBlock = true;
                } else if (!inExecBlock) {
                    inExecBlock = this.isLineAlwaysInExecBlock(line, tokens, text, NLIndex);
                }
            } else if (!inExecBlock) {
                inExecBlock = this.isLineAlwaysInExecBlock(line, tokens, text, NLIndex);
            }
            if (!inExecBlock) {
                if (candidate != null) {
                    validatedCandidates.add(candidate);
                }
                return startOfLineIndex;
            }
            isCandidate = false;
            tag = genInfoBuilder.includingTag(startOfLineIndex + 1, startOfLineIndex + 1);
            boolean isSpecific = false;
            if (tag != null) {
                String mp = tag.getProperty("mp");
                isCandidate = mp != null && mp.trim().length() != 0;
                String property = tag.getProperty("msp");
                isCandidate = isCandidate || property != null && property.trim().length() != 0;
                property = tag.getProperty(SPECIFIG_TAG);
                if (property != null && "True".equals(property)) {
                    isSpecific = true;
                }
            }
            if (isCandidate) {
                int position = 61 + startOfLineIndex;
                candidate = this.generated_END_EXEC_in_new_line ? new AbstractDotModifier.CandidateAddition(tag, NLIndex + this.NEW_LINE.length(), NLIndex + this.NEW_LINE.length(), NLIndex + this.NEW_LINE.length() + 11, 0, false, "", true) : new AbstractDotModifier.CandidateAddition(tag, startOfLineIndex, NLIndex, position, 0, false, line, false);
            } else {
                candidate = isSpecific && this.generated_END_EXEC_in_new_line ? new AbstractDotModifier.CandidateAddition(tag, NLIndex + this.NEW_LINE.length(), NLIndex + this.NEW_LINE.length(), NLIndex + this.NEW_LINE.length() + 11, 0, false, "", true) : null;
            }
            if (isInSQLBlock && !isFirstOrderInitializedInSQLBlock && line.trim().length() != 0) {
                isFirstOrderInitializedInSQLBlock = true;
            }
            startOfLineIndex = NLIndex + this.NEW_LINE.length();
            NLIndex = text.indexOf(this.NEW_LINE, startOfLineIndex);
        }
        return startOfLineIndex;
    }

    private int searchSQLComment(String subLine, String commentDelimiter, boolean isInSQL) {
        if (!isInSQL) {
            return -1;
        }
        int commentDelimiterIndex = subLine.indexOf(commentDelimiter);
        if (commentDelimiterIndex == -1) {
            return -1;
        }
        char quote = '\'';
        int nbQuotes = 0;
        int i = commentDelimiterIndex;
        while (i >= 0) {
            if (subLine.charAt(i) == quote) {
                ++nbQuotes;
            }
            --i;
        }
        if (nbQuotes % 2 == 0) {
            return commentDelimiterIndex;
        }
        return -1;
    }

    private String[] getTokens(String line) {
        if (line.length() > 72) {
            line = line.substring(0, 72);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        String allDelims = " ().,";
        String delimsToExclude = " ";
        StringTokenizer st = new StringTokenizer(line, allDelims, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (delimsToExclude.indexOf(token) != -1) continue;
            tokens.add(token);
        }
        String[] emptyList = new String[]{};
        return tokens.toArray(emptyList);
    }

    private boolean isLineWithMacroCodeAtRightMargin(String line) {
        if (line == null || line.length() <= 72) {
            return false;
        }
        String rightMargin = line.substring(72);
        return this.macrosCalled.contains(rightMargin);
    }

    private boolean isLineAlwaysInExecBlock(String line, String[] tokensFromLine, String text, int endOfLineIndex) {
        if (this.isLabelInLine(line)) {
            return false;
        }
        if (line.length() < 14) {
            return true;
        }
        String subLine = this.extractCobolContent(line);
        if (subLine.length() < 3) {
            return true;
        }
        if (subLine.equals("IF") || subLine.startsWith("IF ") || subLine.equals("MOVE") || subLine.startsWith("MOVE ") || subLine.equals("CALL") || subLine.startsWith("CALL ") || subLine.equals("COMPUTE") || subLine.startsWith("COMPUTE ") || subLine.equals(EXEC) || subLine.startsWith("EXEC ") || subLine.equals("PERFORM") || subLine.startsWith("PERFORM ") || subLine.equals("INSPECT") || subLine.startsWith("INSPECT ") || subLine.startsWith("INSTALLATION") || subLine.startsWith("GO ") || subLine.startsWith("GOBACK") || subLine.startsWith("INITIAL") || subLine.startsWith("INITIATE") || subLine.startsWith("INITIALIZE") || subLine.equals("DISPLAY") || subLine.startsWith("DISPLAY ") || subLine.startsWith("DISPLAY\"") || subLine.startsWith("DISPLAY'") || subLine.equals("EVALUATE") || subLine.startsWith("EVALUATE ") || subLine.equals("SERVICE") || subLine.startsWith("SERVICE ") || subLine.equals("ADD") || subLine.startsWith("ADD ") && !subLine.substring(4).trim().startsWith("(") || subLine.equals("SUBTRACT") || subLine.startsWith("SUBTRACT ") || subLine.startsWith("MULTIPLE") || subLine.equals("MULTIPLY") || subLine.startsWith("MULTIPLY ") || subLine.equals("DIVIDE") || subLine.startsWith("DIVIDE ") || subLine.startsWith("EXIT") || subLine.equals("STRING") || subLine.startsWith("STRING ") || subLine.startsWith("*{") || subLine.startsWith("*}") || subLine.equals("ACCEPT") || subLine.startsWith("ACCEPT ") || subLine.equals("COPY") || subLine.startsWith("COPY ")) {
            return false;
        }
        if (subLine.equals("OPEN") || subLine.startsWith("OPEN ") || subLine.equals("CLOSE") || subLine.startsWith("CLOSE ")) {
            if (this.sql_declared_cursors == null || this.sql_declared_cursors.size() == 0) {
                return false;
            }
            if (tokensFromLine != null && tokensFromLine.length > 1) {
                String declareCursorCandidate = tokensFromLine[1];
                for (String declareCursor : this.sql_declared_cursors) {
                    if (!declareCursorCandidate.equals(declareCursor)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        if (subLine.startsWith("ELSE")) {
            return false;
        }
        if (subLine.equals(SET) || subLine.startsWith("SET ")) {
            if (tokensFromLine != null && tokensFromLine.length > 1) {
                String hostVarCandidate = tokensFromLine[1];
                if (hostVarCandidate.startsWith(":") || hostVarCandidate.startsWith("(:")) {
                    return true;
                }
                if (hostVarCandidate.equals("(") && tokensFromLine.length > 2) {
                    return true;
                }
            } else if (subLine.equals(SET)) {
                int startOfNextLineIndex = endOfLineIndex + this.NEW_LINE.length();
                int endOfNextLineIndex = text.indexOf(this.NEW_LINE, startOfNextLineIndex);
                String nextLine = endOfLineIndex != -1 ? text.substring(startOfNextLineIndex, endOfNextLineIndex) : text.substring(startOfNextLineIndex);
                String nextSubLine = this.extractCobolContent(nextLine);
                if (nextSubLine != null && nextSubLine.trim().startsWith(":")) {
                    return true;
                }
            }
            return false;
        }
        if (subLine.startsWith(CONTINUE)) {
            String nextToken;
            return tokensFromLine != null && tokensFromLine.length > 1 && (nextToken = tokensFromLine[1]).startsWith("ON");
        }
        return true;
    }

    private String extractCobolContent(String line) {
        String subLine = line.length() > 72 ? line.substring(11, 72).trim() : line.substring(11).trim();
        return subLine;
    }

    private boolean containsWords(String[] tokens, String[] mustExistWords, String[] mustNotExistWords) {
        int n;
        int n2;
        String[] stringArray;
        ArrayList<String> _mustExistWords;
        if (tokens == null || tokens.length == 0) {
            return false;
        }
        ArrayList<String> arrayList = _mustExistWords = mustExistWords == null ? new ArrayList<String>() : new ArrayList(mustExistWords.length);
        if (mustExistWords != null) {
            stringArray = mustExistWords;
            n2 = mustExistWords.length;
            n = 0;
            while (n < n2) {
                String word = stringArray[n];
                _mustExistWords.add(word);
                ++n;
            }
        }
        stringArray = tokens;
        n2 = tokens.length;
        n = 0;
        while (n < n2) {
            String token = stringArray[n];
            if (_mustExistWords.size() != 0) {
                for (String meWord : _mustExistWords) {
                    if (!meWord.equals(token)) continue;
                    _mustExistWords.remove(meWord);
                    break;
                }
            }
            if (mustNotExistWords != null && mustNotExistWords.length != 0) {
                String[] stringArray2 = mustNotExistWords;
                int n3 = mustNotExistWords.length;
                int n4 = 0;
                while (n4 < n3) {
                    String mneWord = stringArray2[n4];
                    if (mneWord.equals(token)) {
                        return false;
                    }
                    ++n4;
                }
            }
            ++n;
        }
        return _mustExistWords.size() == 0;
    }

    @Override
    public AbstractDotModifier.PreviousLineIter newPreviousLineIter(String mspPartText, int startOfLineIndex, IBuilderTag tag, IGenInfoBuilder genInfoBuilder, int beginIdx) {
        return new PreviousLineIterator(mspPartText, startOfLineIndex, tag, genInfoBuilder, beginIdx);
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    class ExitAddition {
        private IBuilderTag _tag;
        private int _beginningOffset;

        ExitAddition(IBuilderTag tag, int beginningOffset) {
            this._tag = tag;
            this._beginningOffset = beginningOffset;
        }

        public IBuilderTag getTag() {
            return this._tag;
        }

        public int getBeginningOffset() {
            return this._beginningOffset;
        }
    }

    class GeneratedTagPart {
        private IBuilderTag tag;
        private int beginIndex;
        private int endIndex;

        GeneratedTagPart(IBuilderTag tag, int beginIndex, int endIndex) {
            this.tag = tag;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        public IBuilderTag getTag() {
            return this.tag;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String toString() {
            return "Begin : " + this.beginIndex + "\r\n End : " + this.endIndex + "\r\nTag : " + this.tag;
        }
    }

    class MacroLevelAddition {
        private IBuilderTag _tag;
        private int _beginOffset;
        private int _endOffset;
        private String _text;

        MacroLevelAddition(IBuilderTag tag, int beginOffset, int endOffset, String text) {
            this._tag = tag;
            this._beginOffset = beginOffset;
            this._endOffset = endOffset;
            this._text = text;
        }

        public IBuilderTag getTag() {
            return this._tag;
        }

        public int getBeginOffset() {
            return this._beginOffset;
        }

        public int getEndOffset() {
            return this._endOffset;
        }

        public String getText() {
            return this._text;
        }
    }

    private class PreviousLineIterator
    implements AbstractDotModifier.PreviousLineIter {
        private String mspPartText;
        int startOfLineIndexFromMspPartText;
        IBuilderTag tag;
        IGenInfoBuilder genInfoBuilder;
        int beginIdxOfMspPartText;

        public PreviousLineIterator(String mspPartText, int startOfLineIndex, IBuilderTag tag, IGenInfoBuilder genInfoBuilder, int beginIdx) {
            this.mspPartText = mspPartText;
            this.startOfLineIndexFromMspPartText = startOfLineIndex;
            this.tag = tag;
            this.genInfoBuilder = genInfoBuilder;
            this.beginIdxOfMspPartText = beginIdx;
        }

        @Override
        public String getPreviousLine() {
            if (this.startOfLineIndexFromMspPartText != 0) {
                int previousEndOfLine = this.mspPartText.lastIndexOf("\n", this.startOfLineIndexFromMspPartText - 2);
                String previousLine = this.mspPartText.substring(previousEndOfLine + 1, this.startOfLineIndexFromMspPartText);
                this.startOfLineIndexFromMspPartText = previousEndOfLine + 1;
                return previousLine;
            }
            int startOfLine = this.tag != null ? this.tag.getBeginIndex() : this.beginIdxOfMspPartText;
            String text = "" + this.genInfoBuilder.getText();
            int previousEndOfLine = text.lastIndexOf("\n", startOfLine - 2);
            String previousLine = text.substring(previousEndOfLine + 1, this.beginIdxOfMspPartText);
            this.beginIdxOfMspPartText = previousEndOfLine + 1;
            this.tag = null;
            return previousLine;
        }
    }
}

