/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.pacbase.util.EBCDICCompare;

public class Ebcdic {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static int stringCompare(String arg1, String arg2) {
        String argPrim2;
        String PAC_END_LABEL = "-FN";
        int long1 = arg1.length();
        int long2 = arg2.length();
        if (arg1.toUpperCase().endsWith(PAC_END_LABEL)) {
            if (arg2.toUpperCase().endsWith(PAC_END_LABEL)) {
                String argPrim22;
                int longMini = Math.min(long1, long2);
                String argPrim1 = arg1.substring(0, longMini -= PAC_END_LABEL.length());
                if (argPrim1.equalsIgnoreCase(argPrim22 = arg2.substring(0, longMini))) {
                    return -(long1 - long2);
                }
                arg1 = arg1.substring(0, long1 - PAC_END_LABEL.length());
                arg2 = arg2.substring(0, long2 - PAC_END_LABEL.length());
            } else {
                String argPrim1 = arg1.substring(0, long1 - PAC_END_LABEL.length());
                if (argPrim1.equalsIgnoreCase(argPrim2 = arg2.substring(0, Math.min(arg2.length(), long1 - PAC_END_LABEL.length())))) {
                    return 1;
                }
                arg1 = argPrim1;
                arg2 = argPrim2;
            }
        } else if (arg2.toUpperCase().endsWith(PAC_END_LABEL)) {
            String argPrim1 = arg1.substring(0, Math.min(arg1.length(), long2 - PAC_END_LABEL.length()));
            if (argPrim1.equalsIgnoreCase(argPrim2 = arg2.substring(0, long2 - PAC_END_LABEL.length()))) {
                return -1;
            }
            arg1 = argPrim1;
            arg2 = argPrim2;
        }
        char[] v1 = arg1.toCharArray();
        char[] v2 = arg2.toCharArray();
        int len1 = v1.length;
        int len2 = v2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c1 = EBCDICCompare.EbcdicTable[v1[i]];
            char c2 = EBCDICCompare.EbcdicTable[v2[i]];
            ++i;
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static void main(String[] args) {
        int a = Ebcdic.stringCompare("F05OR", "F05-FN");
        System.out.println(a);
        a = Ebcdic.stringCompare("F05OR-FN", "F05OR-BODY");
        System.out.println(a);
        int i = 0;
        while (i < 255) {
            char c = (char)i;
            a = Ebcdic.stringCompare("" + c, "-");
            if (a < 0) {
                System.out.println("- superieur \u00e0 " + c + "(" + i + ")");
            } else if (a > 0) {
                System.err.println("- inf\u00e9rieur \u00e0 " + c + "(" + i + ")");
            } else {
                System.out.println("- \u00e9gal \u00e0 " + c + "(" + i + ")");
            }
            ++i;
        }
    }
}

