/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import java.util.Set;

public abstract class AbstractDotModifier {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String PROCEDURE_DIVISION = " PROCEDURE DIVISION";
    protected String NEW_LINE;
    public static final int DFH_POSITION = 11;
    public static final String DFH = "DFH";
    public static final String DFHBMS = "DFHBMS";
    public static final String TYPE = "TYPE";
    public static final char DOT = '.';
    public static final String DOT_R = "DOT";
    private static final String END_EXEC_WP = "END-EXEC";
    protected static final int DOT_GENERATED_BY_LABEL = 1;
    private static final int DOT_GENERATED_BY_LEVEL99 = 0;
    private static final int DOT_NOT_GENERATED = -1;
    public static final int DOT_ALREADY_PRESENT = -1;
    public static final int DOT_INSERTION_AFTER_LEFT_MARGIN = -2;
    public static final int DOT_INSERTION_IN_A_NEW_LINE_REQUIERED = -3;
    protected Set<String> tagsFor_POS_VPSI_postProcessor;

    /*
     * Enabled aggressive block sorting
     */
    protected int getDotToAddPosition(String text, int startOfLine, int endOfLine, int beginIndexInFullText, boolean manageWorking) {
        String txt;
        if (endOfLine - startOfLine > 6 && text.charAt(startOfLine + 6) == '*' && this.tagsFor_POS_VPSI_postProcessor.isEmpty()) {
            return -1;
        }
        if (startOfLine == endOfLine) {
            return -2;
        }
        int end = endOfLine;
        int start = startOfLine;
        if (end - start > 72) {
            end = start + 72;
        }
        if (end - start <= 7) {
            return -2;
        }
        start += 7;
        while (end > start && text.charAt(end - 1) <= ' ') {
            --end;
        }
        if (start == end) {
            return startOfLine + 7 + beginIndexInFullText;
        }
        if (text.charAt(end - 1) == '.') {
            return -1;
        }
        if (!manageWorking ? (txt = text.substring(startOfLine, end).trim()).endsWith("ELSE") : (txt = text.substring(startOfLine, end).trim()).startsWith("++INCLUDE") || txt.startsWith("EJECT") || txt.startsWith("SKIP")) {
            return -1;
        }
        if (manageWorking && (txt = text.substring(startOfLine, end).trim()).endsWith(END_EXEC_WP)) {
            return -1;
        }
        if (end == startOfLine + 72) {
            return -3;
        }
        return end + beginIndexInFullText;
    }

    protected int isDotGeneratorLine(String text, int startOfLineIndex, int nLIndex, boolean manageWorking, IBuilderTag tag, IGenInfoBuilder genInfoBuilder, int beginIdx, boolean manageRightMarginDot) {
        String endLine;
        String line = text.substring(startOfLineIndex, nLIndex);
        if (line.length() > 72 && manageRightMarginDot && DOT_R.equalsIgnoreCase((endLine = line.substring(72)).trim())) {
            return 0;
        }
        if (!manageWorking) {
            if (this.isLabelInLine(line)) {
                return 1;
            }
        } else {
            if (line.length() > 7 && line.charAt(6) != '*' && line.charAt(6) != '-') {
                String trimLine;
                if (line.length() > 72) {
                    line = line.substring(0, 72);
                }
                if (this.isWorkingSectionLevelLine(trimLine = line.substring(7).trim(), text, startOfLineIndex, tag, genInfoBuilder, beginIdx)) {
                    return 1;
                }
            }
            if (line.length() > 8 && line.charAt(6) != '*') {
                String subString = line.substring(7);
                if ((subString = subString.trim()).startsWith("EXEC") || subString.startsWith("COPY")) {
                    return 1;
                }
                if (subString.startsWith("PROCEDURE") && !subString.startsWith("PROCEDURES") && !subString.replace(" ", "").startsWith("PROCEDUREON")) {
                    return 1;
                }
                if (!subString.startsWith("'") && !subString.startsWith("\"") && subString.contains(" SECTION.")) {
                    return 1;
                }
            }
        }
        if (line.length() < 11) {
            return -1;
        }
        return -1;
    }

    protected boolean isLabelInLine(String line) {
        if (line == null) {
            return false;
        }
        if (line.length() < 8) {
            return false;
        }
        if (line.charAt(6) == '*' || line.charAt(6) == '-') {
            return false;
        }
        int i = 7;
        int areaAMaxPosition = 11;
        int length = line.length();
        char c = ' ';
        while (i < length && i < areaAMaxPosition) {
            c = line.charAt(i);
            if (!Character.isWhitespace(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSignificantLine(String text, int startOfLine, int endOfLine) {
        return this.isSignificantLine_(text, startOfLine, endOfLine, false);
    }

    protected boolean isSignificantLine_(String text, int startOfLine, int endOfLine, boolean significantComment) {
        String word;
        int endWordPosition;
        String subLine;
        String line;
        int lineLength = endOfLine - startOfLine;
        if (lineLength > 6) {
            if (text.charAt(startOfLine + 6) == '*') {
                if (!significantComment) {
                    return false;
                }
                if (lineLength == 7) {
                    return true;
                }
                if (text.charAt(startOfLine + 7) == '!') {
                    return false;
                }
                if (lineLength >= 11 && "@SCH".equals(text.substring(startOfLine + 7, startOfLine + 11))) {
                    return false;
                }
                if (text.substring(startOfLine, endOfLine).startsWith("      *LINETD.")) {
                    return false;
                }
                if (text.charAt(startOfLine + 7) == 'N') {
                    int dotIndex = text.indexOf(".", startOfLine + 7);
                    if (dotIndex == -1 || dotIndex > endOfLine) {
                        return true;
                    }
                    if (dotIndex != startOfLine + 12 && dotIndex != startOfLine + 10) {
                        return true;
                    }
                    int i = dotIndex - 1;
                    while (i > startOfLine + 7) {
                        if (!Character.isLetterOrDigit(text.charAt(i)) && text.charAt(i) != '-') {
                            return true;
                        }
                        --i;
                    }
                    return false;
                }
                return true;
            }
            if (lineLength > 7 && ((line = text.substring(startOfLine + 7, endOfLine).trim()).startsWith("SKIP1") || line.startsWith("SKIP2") || line.startsWith("SKIP3") || line.startsWith("EJECT"))) {
                return false;
            }
        }
        if (startOfLine == endOfLine) {
            return false;
        }
        line = text.substring(startOfLine, endOfLine);
        if (line.trim().length() == 0) {
            return false;
        }
        if (lineLength > 72 && line.substring(0, 72).trim().length() == 0) {
            return false;
        }
        return line.length() <= 11 || !(subLine = line.substring(11).trim()).startsWith(DFH) || (endWordPosition = subLine.indexOf(32)) <= 0 || !(word = subLine.substring(0, endWordPosition)).equals(DFHBMS) && word.length() != 5 || !(subLine = subLine.substring(endWordPosition).trim()).startsWith(TYPE);
    }

    protected boolean isWorkingSectionLevelLine(String line, String mspPartText, int startOfLineIndex, IBuilderTag tag, IGenInfoBuilder genInfoBuilder, int beginIdx) {
        if (line.length() >= 2) {
            int lineLength = line.length();
            if (!Character.isDigit(line.charAt(0))) {
                return false;
            }
            int levelSize = 2;
            if (!Character.isDigit(line.charAt(1))) {
                if (line.charAt(1) != ' ') {
                    return false;
                }
                levelSize = 1;
            }
            if (lineLength >= 3 && levelSize == 2 && line.charAt(2) != ' ') {
                return false;
            }
            int secondWordIndex = -1;
            int i = levelSize + 1;
            while (i < lineLength) {
                if (line.charAt(i) != ' ') {
                    secondWordIndex = i;
                    break;
                }
                ++i;
            }
            if (secondWordIndex == -1) {
                return false;
            }
            int secondWordEndIndex = line.indexOf(32, secondWordIndex);
            if (secondWordEndIndex == -1) {
                secondWordEndIndex = line.charAt(line.length() - 1) == '.' ? line.length() - 1 : line.length();
            }
            if (secondWordEndIndex == secondWordIndex) {
                return false;
            }
            String secondWord = line.substring(secondWordIndex, secondWordEndIndex);
            if (secondWord.charAt(0) == '-' || secondWord.charAt(secondWord.length() - 1) == '-') {
                return false;
            }
            if (secondWord.charAt(0) == '_' || secondWord.charAt(secondWord.length() - 1) == '_') {
                return false;
            }
            boolean notNumericCharFound = false;
            int i2 = 0;
            while (i2 < secondWord.length()) {
                char ch = secondWord.charAt(i2);
                if (ch == '-' || ch == '_' || Character.isLetter(ch) || ch == '\u00a3') {
                    notNumericCharFound = true;
                } else {
                    if (i2 == secondWord.length() - 1 && (ch == ',' || ch == ';' || ch == '.') || secondWord.endsWith(".VALUE") || secondWord.endsWith(".value")) break;
                    if (!Character.isDigit(ch)) {
                        return false;
                    }
                }
                ++i2;
            }
            if (notNumericCharFound && (secondWord.equals("DESC") || secondWord.equals("DESC,") || secondWord.equals("ASC") || secondWord.equals("ASC,"))) {
                String previousLine = null;
                PreviousLineIter pli = this.newPreviousLineIter(mspPartText, startOfLineIndex, tag, genInfoBuilder, beginIdx);
                while ((previousLine = pli.getPreviousLine()) != null) {
                    if (previousLine.indexOf("ORDER BY") != -1) {
                        return false;
                    }
                    if (previousLine.length() > 72) {
                        previousLine = previousLine.substring(0, 72);
                    }
                    if (previousLine.endsWith(",")) continue;
                    return false;
                }
            }
            return notNumericCharFound;
        }
        return false;
    }

    public abstract PreviousLineIter newPreviousLineIter(String var1, int var2, IBuilderTag var3, IGenInfoBuilder var4, int var5);

    public class CandidateAddition {
        private IBuilderTag tag;
        private int lineBegining;
        private int lineEnd;
        private int additionPosition;
        private int sortIndex;
        private boolean isInDeletedBlock;
        private String line;
        boolean specificModification;

        CandidateAddition(IBuilderTag tag, int lineBegining, int lineEnd, int additionPosition, int sortIndex) {
            this(tag, lineBegining, lineEnd, additionPosition, sortIndex, false);
        }

        CandidateAddition(IBuilderTag tag, int lineBegining, int lineEnd, int additionPosition, int sortIndex, boolean isInDeletedBlock) {
            this(tag, lineBegining, lineEnd, additionPosition, sortIndex, isInDeletedBlock, null, false);
        }

        public CandidateAddition(IBuilderTag tag, int lineBegining, int lineEnd, int additionPosition, int sortIndex, boolean isInDeletedBlock, String line, boolean specificModification) {
            this.tag = tag;
            this.lineBegining = lineBegining;
            this.lineEnd = lineEnd;
            this.additionPosition = additionPosition;
            this.sortIndex = sortIndex;
            this.isInDeletedBlock = isInDeletedBlock;
            this.line = line;
            this.specificModification = specificModification;
        }

        public IBuilderTag getTag() {
            return this.tag;
        }

        String getLine() {
            return this.line;
        }

        public int getLineBegining() {
            return this.lineBegining;
        }

        public int getLineEnd() {
            return this.lineEnd;
        }

        public int getAdditionPosition() {
            return this.additionPosition;
        }

        public int getSortIndex() {
            return this.sortIndex;
        }

        public boolean isInDeletedBlock() {
            return this.isInDeletedBlock;
        }

        public String toString() {
            return String.valueOf(this.getSortIndex()) + " " + this.tag.toString();
        }

        public void setLineEnd(int lineEnd) {
            this.lineEnd = lineEnd;
        }
    }

    public static interface PreviousLineIter {
        public String getPreviousLine();
    }
}

