/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.editors;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.interfaces.IEditorContextualMenuBuilder;
import com.ibm.pdp.pacbase.extension.ProcedureLine;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import java.util.Iterator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class CommonPatternEditorContextualMenuBuilder
implements IEditorContextualMenuBuilder,
ProcedureLineConstants {
    protected Separator SEPARATOR = new Separator("additions");
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void fillContextMenu(IMenuManager menuManager, IEditor editor) {
    }

    protected static boolean isFunctionRelativeInsertion(IDocument doc, int startLine, String func) {
        int ind = startLine;
        int foundBeg = -1;
        while (ind > 0) {
            String line;
            block9: {
                try {
                    int stOff = doc.getLineOffset(ind);
                    int stLen = doc.getLineLength(ind);
                    line = doc.get(stOff, stLen);
                    if (line.indexOf("PROCEDURE") != 7) break block9;
                    return false;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (foundBeg == -1 && ProcedureLine.isBegFunction(line) && func.equals(ProcedureLine.function(line))) {
                foundBeg = ind;
            } else if (foundBeg == -1 && ProcedureLine.isBegSubFunction(line) && func.equals(ProcedureLine.subFunction(line))) {
                foundBeg = ind;
            } else if (foundBeg - 1 == ind) {
                return line.indexOf("*@BEFORE") > -1 || line.indexOf("*@REPLACE") > -1 || line.indexOf("*@AFTER") > -1;
            }
            --ind;
        }
        return false;
    }

    protected static boolean isLinePartOfRelativeInsertion(IDocument doc, int startLine) {
        try {
            int stOff = doc.getLineOffset(startLine);
            int stLen = doc.getLineLength(startLine);
            String line = doc.get(stOff, stLen);
            return line.indexOf("*@BEFORE") > -1 || line.indexOf("*@REPLACE") > -1 || line.indexOf("*@AFTER") > -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected static boolean hasRelativeReplace(IDocument doc, String tag) {
        String totTxt = doc.get();
        return ProcedureLine.includedWithWhiteAfter(totTxt, "*@REPLACE F" + tag);
    }

    protected static boolean hasRelatives(IDocument doc, String tag) {
        if (tag == null || tag.length() < 2) {
            return false;
        }
        String totTxt = doc.get();
        boolean bl1 = ProcedureLine.includedWithWhiteAfter(totTxt, "*@BEFORE F" + tag);
        boolean bl2 = ProcedureLine.includedWithWhiteAfter(totTxt, "*@REPLACE F" + tag);
        boolean bl3 = ProcedureLine.includedWithWhiteAfter(totTxt, "*@AFTER F" + tag);
        return bl1 || bl2 || bl3;
    }

    protected static int getTagNodeIndex(ITextProcessor txtProc, String tag, boolean before) {
        IEditTree et = txtProc.getEditTree();
        Iterator nodes = et.rootNodes();
        ITextNode itn = (ITextNode)nodes.next();
        nodes = itn.sons();
        while (nodes.hasNext()) {
            int ret;
            itn = (ITextNode)nodes.next();
            if (!itn.getLabel().toString().equals("PROCEDURE") || (ret = CommonPatternEditorContextualMenuBuilder.getTagNodeIndex(itn.sons(), tag, before)) <= -1) continue;
            return ret;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int getTagNodeIndex(Iterator<ITextNode> nodes, String tag, boolean before) {
        if (nodes != null) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            itn = nodes.next();
            if (itn.enclosingTagName().equals(tag)) {
                return before != false ? itn.beginIndex() : itn.endIndex();
            }
            ret = CommonPatternEditorContextualMenuBuilder.getTagNodeIndex(itn.sons(), tag, before);
            if (ret <= -1) continue;
            return ret;
lbl9:
            // 2 sources

            ** while (nodes.hasNext())
        }
lbl10:
        // 1 sources

        return -1;
    }

    protected static boolean hasTagNoFollower(IDocument doc, ITextProcessor txtProc, String tag) {
        String lines = CommonPatternEditorContextualMenuBuilder.getTagContent(doc, txtProc, tag);
        if (lines == null || lines.length() == 0) {
            return false;
        }
        return ProcedureLine.hasGroupOfLinesNoFollower(lines);
    }

    private static String getTagContent(IDocument doc, ITextProcessor txtProc, String tag) {
        IEditTree et = txtProc.getEditTree();
        Iterator nodes = et.rootNodes();
        ITextNode itn = (ITextNode)nodes.next();
        nodes = itn.sons();
        while (nodes.hasNext()) {
            itn = (ITextNode)nodes.next();
            if (!itn.getLabel().toString().equals("PROCEDURE")) continue;
            return CommonPatternEditorContextualMenuBuilder.getTagContent(doc, itn.sons(), tag);
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static String getTagContent(IDocument doc, Iterator<ITextNode> nodes, String tag) {
        if (nodes != null) ** GOTO lbl17
        return "";
lbl-1000:
        // 1 sources

        {
            itn = nodes.next();
            beg = itn.beginIndex();
            end = itn.endIndex();
            try {
                lines = doc.get(beg, end - beg);
                lab = ProcedureLine.extractLabel(lines);
                if (lab.equals(tag)) {
                    return lines;
                }
            }
            catch (BadLocationException v0) {
                return "";
            }
            ret = CommonPatternEditorContextualMenuBuilder.getTagContent(doc, itn.sons(), tag);
            if (ret.length() <= 0) continue;
            return ret;
lbl17:
            // 2 sources

            ** while (nodes.hasNext())
        }
lbl18:
        // 1 sources

        return "";
    }
}

