/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.dialogs;

import com.ibm.pdp.pacbase.dialogs.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PacListSelectionDialog
extends SelectionDialog {
    private static String SELECT_ALL = Messages.PacListSelectionDialog_SELECT_ALL;
    private static String DESELECT_ALL = Messages.PacListSelectionDialog_DESELECT_ALL;
    private static String INSTANCES = Messages.PacListSelectionDialog_INSTANCES;
    private static String LABELS = Messages.PacListSelectionDialog_LABELS;
    private static String DEFAULT_MESS = Messages.PacListSelectionDialog_DEFAULT_MESS;
    protected Object _inputElement;
    protected ILabelProvider _labelProvider;
    protected IStructuredContentProvider _contentProvider;
    protected CheckboxTableViewer _listViewer;
    protected TableColumn _col1;
    protected TableColumn _col2;
    protected ViewerComparator _sorter;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String title, String message, ViewerComparator sorter) {
        super(parentShell);
        this.setTitle(title);
        this._inputElement = input;
        this._contentProvider = contentProvider;
        this._labelProvider = labelProvider;
        this._sorter = sorter;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(DEFAULT_MESS);
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, SELECT_ALL, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PacListSelectionDialog.this._listViewer.setAllChecked(true);
                if (PacListSelectionDialog.this._listViewer.getCheckedElements().length > 0) {
                    PacListSelectionDialog.this.getOkButton().setEnabled(true);
                }
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, DESELECT_ALL, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PacListSelectionDialog.this._listViewer.setAllChecked(false);
                PacListSelectionDialog.this.getOkButton().setEnabled(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this._listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control aControl = super.createButtonBar(parent);
        this.getOkButton().setEnabled(false);
        return aControl;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x860 | 0x10);
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this._listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67588);
        GridData data = new GridData(1808);
        this._listViewer.getTable().setLayoutData((Object)data);
        Table table = this._listViewer.getTable();
        table.setHeaderVisible(true);
        this._col1 = new TableColumn(table, 16384);
        this._col1.setText(INSTANCES);
        GridData colData = new GridData(1808);
        this._col1.setData((Object)colData);
        this._col2 = new TableColumn(table, 16388);
        this._col2.setText(LABELS);
        GridData col1Data = new GridData(1808);
        this._col2.setData((Object)col1Data);
        this._col1.pack();
        this._col2.pack();
        this._listViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        this._listViewer.setContentProvider((IContentProvider)this._contentProvider);
        this._listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                int nb = PacListSelectionDialog.this._listViewer.getCheckedElements().length;
                if (nb == 0) {
                    PacListSelectionDialog.this.getOkButton().setEnabled(false);
                } else {
                    PacListSelectionDialog.this.getOkButton().setEnabled(true);
                }
            }
        });
        this.addSelectionButtons(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        this._listViewer.setComparator(this._sorter);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected CheckboxTableViewer getViewer() {
        return this._listViewer;
    }

    private void initializeViewer() {
        this._listViewer.setInput(this._inputElement);
        this._col1.pack();
        this._col2.pack();
    }

    protected void okPressed() {
        Object[] children = this._contentProvider.getElements(this._inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this._listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        super.okPressed();
    }
}

