/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.dialogs;

import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.view.tool.IPTFilterListener;
import com.ibm.pdp.explorer.view.tool.PTFilterGroup;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.mdl.kernel.dialog.KernelDialogLabel;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.dialogs.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class PacListCommonSelectionFilteredDialog
extends SelectionDialog
implements IPTFilterListener {
    protected static final String INSTANCES = Messages.PacListMonoSelectionDialog_INSTANCES;
    protected static final String LABELS = Messages.PacListMonoSelectionDialog_LABELS;
    protected static final String MATCHING_ITEMS = Messages.PacListCommonSelectionFilteredDialog_MATCHING_ITEMS;
    protected static final String ANY_CHARACTER_DEFINITION = Messages.PacListCommonSelectionFilteredDialog_ANY_CHARACTER_DEFINITION;
    protected Object _inputElement;
    protected Object[] _inputList;
    protected ILabelProvider _labelProvider;
    protected IStructuredContentProvider _contentProvider;
    protected Label _filterLabel = null;
    protected Text _filterText = null;
    protected PTFilterGroup _grpFilter;
    private int _numberVisible = 100;
    private PTElementComparateur _comparateur;
    protected ViewerSorter _sorter;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected PacListCommonSelectionFilteredDialog(Shell shell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String title, String message, ViewerSorter sorter) {
        super(shell);
        this.setTitle(title);
        this._inputElement = input;
        if (input instanceof Object[]) {
            this._inputList = (Object[])input;
        }
        this.sortList(this._inputList);
        this._contentProvider = contentProvider;
        this._labelProvider = labelProvider;
        this._sorter = sorter;
        if (message != null) {
            this.setMessage(String.valueOf(message) + "  " + ANY_CHARACTER_DEFINITION);
        }
    }

    private void sortList(Object[] tab) {
        this._comparateur = new PTElementComparateur();
        if (tab.length > 0 && tab[0] instanceof IPTElement) {
            ArrayList<IPTElement> list = new ArrayList<IPTElement>(tab.length);
            int i = 0;
            while (i < tab.length) {
                list.add((IPTElement)tab[i]);
                ++i;
            }
            Collections.sort(list, this._comparateur);
            this._inputList = list.toArray();
        }
    }

    protected String getElementName(Object element) {
        String name = this._labelProvider.getText(element);
        return name;
    }

    protected String getLabel(Object element) {
        String name = "";
        if (this._labelProvider instanceof ITableLabelProvider) {
            name = ((ITableLabelProvider)this._labelProvider).getColumnText(element, 1);
        }
        return name;
    }

    protected Object[] computeNewList(Object[] inputList, String filterPattern, int scope, int maxElem) {
        if (inputList == null || inputList.length == 0 || maxElem == 0) {
            return new Object[0];
        }
        Object[] newList = new Object[maxElem];
        String filterRegExp = PdpTool.transformUserPatternIntoRegex((String)filterPattern);
        Pattern pat = Pattern.compile(filterRegExp, 2);
        int counter = 0;
        int i = 0;
        while (i < inputList.length) {
            Object obj = inputList[i];
            String stringSelection = "";
            stringSelection = scope == 0 ? this.getElementName(obj) : this.getLabel(obj);
            Matcher matcher = pat.matcher(stringSelection);
            if (matcher.matches()) {
                newList[counter++] = obj;
            }
            if (counter >= maxElem) break;
            ++i;
        }
        if (counter == 0) {
            return new Object[0];
        }
        if (counter < maxElem) {
            Object[] shortenedList = new Object[counter];
            System.arraycopy(newList, 0, shortenedList, 0, counter);
            return shortenedList;
        }
        return newList;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x860 | 0x10);
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PdpPacbasePlugin.setHelpMechanism(parent, this.getContextId());
        return composite;
    }

    protected void createFilterGroup(Composite parent) {
        String label1 = KernelDialogLabel.getString((String)KernelDialogLabel._NAME);
        String label2 = KernelDialogLabel.getString((String)KernelDialogLabel._LABEL);
        this._grpFilter = new PTFilterGroup(parent, new String[]{label1, label2}, 0);
        this._grpFilter.setNumberVisible(this._numberVisible);
        this._grpFilter.addListener((IPTFilterListener)this);
    }

    private String getContextId() {
        return "DV_select";
    }

    private static class PTElementComparateur
    implements Comparator<IPTElement> {
        private PTElementComparateur() {
        }

        @Override
        public int compare(IPTElement o1, IPTElement o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

