/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.dialogs;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.dialogs.Messages;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import com.ibm.pdp.pacbase.wizards.ActionType;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MoveTreeDialog
extends Dialog
implements ProcedureLineConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Text _function;
    protected Text _FirstCharSubfunction;
    protected Text _SecondCharSubfunction;
    private String _targetFunction;
    private String _targetFirstCharSubFunction;
    private String _targetSubFunction;
    private IFunctionControls _functionControls;
    private Label _lblImage;
    private Text _lblError;
    private IFunctionNode _node;
    private String _label;
    private ActionType _actionType;

    public MoveTreeDialog(String label, IFunctionControls functionControl, Shell shell, IFunctionNode node, ActionType actionType) {
        super(shell);
        this._label = label;
        this._functionControls = functionControl;
        this._node = node;
        this._actionType = actionType;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compo = (Composite)super.createDialogArea(parent);
        Composite composite = PTWidgetTool.createComposite((Composite)compo, (int)4, (boolean)false);
        GridLayout gl = (GridLayout)composite.getLayout();
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        Label l = this._label.length() != 2 ? PTWidgetTool.createLabel((Composite)composite, (String)Messages.MoveTree_TARGET_CODE) : PTWidgetTool.createLabel((Composite)composite, (String)Messages.MoveTree_TARGET_FUNCTION_CODE);
        GridData gridData = (GridData)l.getLayoutData();
        gridData.widthHint = 350;
        this._function = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        gridData = (GridData)this._function.getLayoutData();
        gridData.widthHint = 22;
        gridData.horizontalAlignment = this._label.length() == 2 ? 4 : 3;
        this._function.setTextLimit(2);
        this._function.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
            }

            public void focusGained(FocusEvent arg0) {
                MoveTreeDialog.this._function.selectAll();
            }
        });
        this._function.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MoveTreeDialog.this._targetFunction = MoveTreeDialog.this._function.getText();
                if (MoveTreeDialog.this._function.getEnabled()) {
                    boolean enabled = MoveTreeDialog.this.isMoveFunctionPossible();
                    MoveTreeDialog.this.updateOKButton(enabled);
                }
            }
        });
        if (this._label.length() != 2) {
            this._FirstCharSubfunction = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
            gridData = (GridData)this._FirstCharSubfunction.getLayoutData();
            gridData.widthHint = 11;
            gridData.horizontalAlignment = 3;
            gridData.horizontalIndent = 1;
            this._FirstCharSubfunction.setTextLimit(1);
            if (this._label.length() == 2 || !this.isSameFirstCharacter(this._node)) {
                this._FirstCharSubfunction.setEditable(false);
            }
            this._FirstCharSubfunction.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent arg0) {
                }

                public void focusGained(FocusEvent arg0) {
                    MoveTreeDialog.this._FirstCharSubfunction.selectAll();
                }
            });
            this._FirstCharSubfunction.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    MoveTreeDialog.this._targetFirstCharSubFunction = MoveTreeDialog.this._FirstCharSubfunction.getText().toUpperCase();
                    MoveTreeDialog.this._targetSubFunction = String.valueOf(MoveTreeDialog.this._targetFirstCharSubFunction) + MoveTreeDialog.this._label.substring(3, 4).toUpperCase();
                    if (MoveTreeDialog.this._FirstCharSubfunction.getEnabled()) {
                        boolean enabled = MoveTreeDialog.this.isMoveSubFunctionPossible();
                        MoveTreeDialog.this.updateOKButton(enabled);
                    }
                }
            });
        }
        if (this._label.length() != 2) {
            this._SecondCharSubfunction = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)true);
            gridData = (GridData)this._SecondCharSubfunction.getLayoutData();
            gridData.widthHint = 11;
            gridData.horizontalAlignment = 1;
            gridData.horizontalIndent = 1;
            this._SecondCharSubfunction.setTextLimit(1);
        }
        Composite messComposite = new Composite(parent, 1024);
        GridLayout gridL = new GridLayout(2, true);
        gridL.makeColumnsEqualWidth = false;
        messComposite.setLayout((Layout)gridL);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        messComposite.setLayoutData((Object)data);
        this.createMessageGroup(messComposite);
        return composite;
    }

    public String get_function() {
        return this._targetFunction;
    }

    public String get_subFunction() {
        return this._targetSubFunction;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMaximized(true);
        newShell.setMinimumSize(400, 100);
        String node = "F" + this._label;
        String title = this._actionType != ActionType.COPYPASTE_TREE_ACTION ? (this._label.length() == 2 ? String.valueOf(Messages.MoveTreeTitleFunction) + " " + node + " " + Messages.MoveTreeEndTitle : String.valueOf(Messages.MoveTreeTitleSubFunction) + " " + node + " " + Messages.MoveTreeEndTitle) : (this._label.length() == 2 ? String.valueOf(Messages.CopyPasteTreeTitleFunction) + " " + node + " " + Messages.MoveTreeEndTitle : String.valueOf(Messages.CopyPasteTreeTitleSubFunction) + " " + node + " " + Messages.MoveTreeEndTitle);
        newShell.setText(title);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this._function.setText(this._label);
        if (this._label.length() != 2) {
            this._FirstCharSubfunction.setText(this._label.substring(2, 3));
            this._SecondCharSubfunction.setText(this._label.substring(3));
            this.setErrorMessage(Messages.MoveTree_TARGET_CODE, Messages.MoveTree_DATA_REQUIRED, true);
        } else {
            this.setErrorMessage(Messages.MoveTree_TARGET_FUNCTION_CODE, Messages.MoveTree_DATA_REQUIRED, true);
        }
        this.updateOKButton(false);
        return control;
    }

    private void createMessageGroup(Composite parent) {
        this._lblImage = PTWidgetTool.createLabel((Composite)parent, (String)"");
        this._lblError = MoveTreeDialog.createTextField(parent);
    }

    public static Text createTextField(Composite parent) {
        int style = 8;
        Text text = new Text(parent, style);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void updateOKButton(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    protected void setErrorMessage(String message1, String message2, boolean isError) {
        if (message1 != null) {
            if (isError) {
                this._lblImage.setImage(PdpPacbasePlugin.getImage("icons/nodesview/error.gif"));
            } else {
                this._lblImage.setImage(PdpPacbasePlugin.getImage("icons/nodesview/warning.gif"));
            }
            this._lblError.setText(message1);
            if (message2 != null) {
                this._lblError.setText(String.valueOf(message1) + " : " + message2);
            }
        } else {
            this._lblImage.setImage(null);
            this._lblError.setText("                                                            ");
        }
        this._lblError.getParent().pack();
        this._lblError.getParent().redraw();
    }

    private boolean isMoveFunctionPossible() {
        if (this._targetFunction.length() == 0) {
            this.setErrorMessage(Messages.MoveTree_TARGET_FUNCTION_CODE, Messages.MoveTree_DATA_REQUIRED, true);
            return false;
        }
        if (this._targetFunction.length() < 2) {
            this.setErrorMessage(Messages.MoveTree_TARGET_FUNCTION_CODE, Messages.MoveTree_INVALID, true);
            return false;
        }
        if (this._targetFunction.equals(this._label.substring(0, 2)) && (this._targetSubFunction == null || this._targetSubFunction.substring(0, 1).equals(this._label.substring(2, 3)))) {
            this.setErrorMessage(Messages.MoveTree_TARGET_CODE, Messages.MoveTree_DATA_REQUIRED, true);
            return false;
        }
        String targetNode = this._label.length() == 2 ? this._targetFunction : String.valueOf(this._targetFunction) + this._targetFirstCharSubFunction + this._label.substring(3, 4);
        if (this._functionControls.isExistingLabel(targetNode) || this.isExistingDependents(this._node)) {
            this.setErrorMessage(Messages.MoveTree_ALREADY_EXIST, null, true);
            return false;
        }
        this.setErrorMessage(Messages.MoveTree_GENERATION_IS_REQUIRED, null, false);
        return true;
    }

    private boolean isMoveSubFunctionPossible() {
        if (this._targetFirstCharSubFunction.length() == 0) {
            this.setErrorMessage(Messages.FunctionDialog_SUB_FUNCTION_CODE, Messages.MoveTree_DATA_REQUIRED, true);
            return false;
        }
        if (this._targetFunction != null && this._targetFunction.equals(this._label.substring(0, 2)) && this._targetSubFunction.substring(0, 1).equals(this._label.substring(2, 3))) {
            this.setErrorMessage(Messages.MoveTree_TARGET_CODE, Messages.MoveTree_DATA_REQUIRED, true);
            return false;
        }
        String targetNode = String.valueOf(this._targetFunction) + this._targetFirstCharSubFunction + this._label.substring(3, 4);
        if (this._functionControls.isExistingLabel(targetNode) || this.isExistingDependents(this._node)) {
            this.setErrorMessage(Messages.MoveTree_ALREADY_EXIST, null, true);
            return false;
        }
        this.setErrorMessage(Messages.MoveTree_GENERATION_IS_REQUIRED, null, false);
        return true;
    }

    private boolean isSameFirstCharacter(IFunctionNode node) {
        boolean b = true;
        List<IFunctionNode> childrenList = node.getChildren();
        if (!childrenList.isEmpty()) {
            int i = 0;
            while (i < childrenList.size()) {
                IFunctionNode c = childrenList.get(i);
                if (!this._label.substring(2, 3).equals(c.getName().substring(3, 4))) {
                    return false;
                }
                if (!c.getChildren().isEmpty()) {
                    b = this.isSameFirstCharacter(c);
                }
                ++i;
            }
        }
        return b;
    }

    private boolean isExistingDependents(IFunctionNode node) {
        boolean b = false;
        List<IFunctionNode> childrenList = node.getChildren();
        if (!childrenList.isEmpty()) {
            int i = 0;
            while (i < childrenList.size()) {
                IFunctionNode c = childrenList.get(i);
                String newSubFunction = this._targetFirstCharSubFunction != null && this.isSameFirstCharacter(this._node) ? String.valueOf(this._targetFunction) + this._targetFirstCharSubFunction + c.getName().substring(4, 5) : String.valueOf(this._targetFunction) + c.getName().substring(3, 5);
                if (this._functionControls.isExistingLabel(newSubFunction)) {
                    b = true;
                    return b;
                }
                if (!c.getChildren().isEmpty()) {
                    b = this.isExistingDependents(c);
                }
                ++i;
            }
        }
        return b;
    }
}

