/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.dialogs;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.views.GeneratedCodeStructureTreeView;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.dialogs.Messages;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.extension.ProcedureLine;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import com.ibm.pdp.pacbase.extension.ServerTags;
import com.ibm.pdp.pacbase.extension.TagsAndDetails;
import com.ibm.pdp.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.WorkbenchPart;

public class FunctionDialog
extends Dialog
implements ProcedureLineConstants {
    private String begLine;
    private String endLine;
    private ITextProcessor textProcessor;
    private IEditor iEditor;
    private boolean atBeginning;
    private boolean forEncap;
    private boolean forInsertion;
    private int relativePosition;
    private boolean isRelative;
    private boolean isForBatchGenerator;
    private boolean isCSServer;
    private boolean subAtFirstLevel;
    private boolean forgetSubFunction;
    private boolean activateIndexes;
    protected Text _function;
    protected Text _subFunction;
    protected Text _level;
    private Label _lblImage;
    private Label _lblError;
    private boolean sizeInit = false;
    private String selectedFunctionCode;
    private String selectedSubFunctionCode;
    private int startOffset;
    private int endOffset;
    private String functionCodeToSuggest;
    private String subFunctionCodeToSuggest;
    private String nextFunctionCode;
    private String nextSubFunctionCode;
    private String precedingFunctionCode;
    private String precedingSubFunctionCode;
    private String functionCode;
    private String subFunctionCode;
    private String level;
    private boolean init = false;
    private boolean lexicographicInsertionPossible;
    private boolean found;
    private boolean isLineCut;
    private boolean isCursorInsert;
    private boolean isStructGeneratedCode;
    private int decale;
    private int geographicalInsertionIndex;
    private int detailBeginIndex;
    private int detailEndIndex;
    private String detailedTitle;
    private boolean useDetailedTitle;
    private ArrayList<String> functionsList;
    private ArrayList<String> subFunctionsList;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public FunctionDialog(GeneratedCodeStructureTreeView view, boolean forInsert) {
        super(view.getViewSite().getShell());
        this.textProcessor = view.getController().getTextProcessor();
        this.iEditor = view.getAssociatedEditor();
        this.isStructGeneratedCode = true;
        this.initialisations();
        this.forInsertion = forInsert;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public FunctionDialog(IEditor editor, boolean forInsert) {
        super(((WorkbenchPart)editor).getSite().getShell());
        this.textProcessor = editor.getController().getTextProcessor();
        this.iEditor = editor;
        this.isStructGeneratedCode = false;
        this.initialisations();
        this.forInsertion = forInsert;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private void initialisations() {
        this.isRelative = false;
        this.isForBatchGenerator = false;
        this.isCSServer = false;
        this.forEncap = false;
        this.atBeginning = false;
        this.subAtFirstLevel = false;
        this.forgetSubFunction = false;
        this.activateIndexes = false;
        this.functionCode = "";
        this.subFunctionCode = "";
        this.begLine = "";
        this.endLine = "";
        this.detailBeginIndex = -1;
        this.detailEndIndex = -1;
        this.detailedTitle = "";
        this.useDetailedTitle = false;
        this.startOffset = -1;
        this.endOffset = -1;
        this.selectedFunctionCode = "";
        this.functionCodeToSuggest = "";
        this.precedingFunctionCode = "";
        this.nextFunctionCode = "";
        this.selectedSubFunctionCode = "";
        this.subFunctionCodeToSuggest = "";
        this.precedingSubFunctionCode = "";
        this.nextSubFunctionCode = "";
        this.lexicographicInsertionPossible = false;
        this.geographicalInsertionIndex = -1;
        this.found = false;
        this.isLineCut = false;
        this.isCursorInsert = false;
        this.decale = 0;
        this.functionsList = new ArrayList();
        this.subFunctionsList = new ArrayList();
    }

    public String getFunctionCode() {
        return this.functionCode;
    }

    public void setLevel(int l) {
        this.level = String.valueOf(l);
    }

    public String getSubFunctionCode() {
        return this.subFunctionCode;
    }

    public void setRelativePosition(int rel) {
        this.relativePosition = rel;
        this.isRelative = true;
    }

    public void setAbsoluteInsertionMode() {
        this.isRelative = false;
    }

    public void setForBatchGenerator() {
        this.isForBatchGenerator = true;
    }

    public void setAtBeginning() {
        this.atBeginning = true;
    }

    public void setForEncapsulation() {
        this.forEncap = true;
    }

    public void setForCSServer() {
        this.isCSServer = true;
    }

    public void setSubAtFirstLevel() {
        this.subAtFirstLevel = true;
    }

    public void forgetSubFunction() {
        this.forgetSubFunction = true;
    }

    public void activateIndexes() {
        this.activateIndexes = true;
    }

    public void useDetailedTitle() {
        this.useDetailedTitle = true;
    }

    public void setCursorInsert(int insert) {
        this.isCursorInsert = true;
        this.decale = insert;
    }

    private boolean isBefore() {
        return this.isRelative && this.relativePosition == 0;
    }

    private boolean isReplace() {
        return this.isRelative && this.relativePosition == 1;
    }

    private boolean isAfter() {
        return this.isRelative && this.relativePosition == 2;
    }

    private boolean isAbsolute() {
        return !this.isRelative;
    }

    private boolean isApres() {
        return !this.isRelative || this.relativePosition == 2;
    }

    protected void configureShell(Shell shell) {
        String title;
        super.configureShell(shell);
        Object[] objs = new Object[1];
        if (this.atBeginning) {
            title = Messages.FunctionDialog_CREATE_FUNCTION_BEGINNING;
        } else if (!(!this.subAtFirstLevel && this.selectedSubFunctionCode.length() != 0 || this.forInsertion || this.forEncap)) {
            objs[0] = this.selectedFunctionCode.length() == 2 && (!this.subAtFirstLevel || this.forgetSubFunction) ? "F" + this.selectedFunctionCode : (this.selectedFunctionCode.length() == 2 && this.subAtFirstLevel ? "F" + this.selectedFunctionCode + this.selectedSubFunctionCode : this.detailedTitle);
            title = this.isBefore() ? NLS.bind((String)Messages.FunctionDialog_CREATE_FUNCTION_BEFORE, (Object[])objs) : (this.isReplace() ? NLS.bind((String)Messages.FunctionDialog_MODIFY_FUNCTION, (Object[])objs) : NLS.bind((String)Messages.FunctionDialog_CREATE_FUNCTION_AFTER, (Object[])objs));
        } else if (FunctionDialog.subOK(this.selectedSubFunctionCode) && !this.forInsertion && !this.forEncap) {
            objs[0] = "F" + this.selectedFunctionCode + (this.forgetSubFunction ? "" : this.selectedSubFunctionCode);
            title = this.isBefore() ? NLS.bind((String)Messages.FunctionDialog_CREATE_SUB_FUNCTION_BEFORE, (Object[])objs) : (this.isReplace() ? NLS.bind((String)Messages.FunctionDialog_MODIFY_SUB_FUNCTION, (Object[])objs) : NLS.bind((String)Messages.FunctionDialog_CREATE_SUB_FUNCTION_AFTER, (Object[])objs));
        } else if (!this.forInsertion && this.forEncap) {
            objs[0] = "F" + this.selectedFunctionCode + this.selectedSubFunctionCode;
            title = NLS.bind((String)Messages.FunctionDialog_ENCAPSULATE_SUB_FUNCTION_INSIDE, (Object[])objs);
        } else if (this.selectedSubFunctionCode.length() == 0 && this.forInsertion) {
            objs[0] = "F" + this.selectedFunctionCode;
            title = NLS.bind((String)Messages.FunctionDialog_INSERT_SUB_FUNCTION_INSIDE, (Object[])objs);
        } else {
            objs[0] = "F" + this.selectedFunctionCode + this.selectedSubFunctionCode;
            title = NLS.bind((String)Messages.FunctionDialog_INSERT_SUB_FUNCTION_INSIDE, (Object[])objs);
        }
        if (this.detailedTitle.length() == 6 && this.detailedTitle.substring(1, 3).equals(this.selectedFunctionCode)) {
            title = String.valueOf(title) + this.detailedTitle.substring(3, 6);
        } else if (this.detailedTitle.length() == 8 && this.detailedTitle.substring(1, 3).equals(this.selectedFunctionCode)) {
            title = String.valueOf(title) + this.detailedTitle.substring(5, 8);
        } else if (this.detailedTitle.length() == 12 && this.detailedTitle.substring(1, 3).equals(this.selectedFunctionCode)) {
            title = String.valueOf(title) + this.detailedTitle.substring(5, 12);
        } else if ((this.useDetailedTitle || this.isCSServer) && this.detailedTitle.length() > 0) {
            title = !this.forInsertion && this.selectedSubFunctionCode.length() == 0 ? (this.isBefore() ? NLS.bind((String)Messages.FunctionDialog_CREATE_FUNCTION_BEFORE, (Object)this.detailedTitle) : (this.isReplace() ? NLS.bind((String)Messages.FunctionDialog_MODIFY_FUNCTION, (Object)this.detailedTitle) : NLS.bind((String)Messages.FunctionDialog_CREATE_FUNCTION_AFTER, (Object)this.detailedTitle))) : (!this.forInsertion ? (this.isBefore() ? NLS.bind((String)Messages.FunctionDialog_CREATE_SUB_FUNCTION_BEFORE, (Object)this.detailedTitle) : (this.isReplace() ? NLS.bind((String)Messages.FunctionDialog_MODIFY_SUB_FUNCTION, (Object)this.detailedTitle) : NLS.bind((String)Messages.FunctionDialog_CREATE_SUB_FUNCTION_AFTER, (Object)this.detailedTitle))) : NLS.bind((String)Messages.FunctionDialog_INSERT_SUB_FUNCTION_INSIDE, (Object)this.detailedTitle));
        }
        shell.setText(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite specComposite = new Composite(parent, 128);
        GridLayout gridL = new GridLayout(2, true);
        gridL.makeColumnsEqualWidth = false;
        specComposite.setLayout((Layout)gridL);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        specComposite.setLayoutData((Object)data);
        this.createSpecificGroup(specComposite);
        Composite messComposite = new Composite(parent, 1024);
        gridL = new GridLayout(2, true);
        gridL.makeColumnsEqualWidth = false;
        messComposite.setLayout((Layout)gridL);
        data = new GridData();
        data.horizontalAlignment = 4;
        messComposite.setLayoutData((Object)data);
        this.createMessageGroup(messComposite);
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        if (this.functionCodeToSuggest.length() == 2) {
            this._function.setText(this.functionCodeToSuggest);
        }
        if (this.subFunctionCodeToSuggest.length() == 2) {
            this._subFunction.setText(this.subFunctionCodeToSuggest);
        }
        this.getButton(0).setEnabled(this.isDialogComplete());
        if (this.found) {
            this.displayWarnings();
        }
        return control;
    }

    private void createMessageGroup(Composite parent) {
        this._lblImage = PTWidgetTool.createLabel((Composite)parent, (String)"");
        this._lblError = PTWidgetTool.createLabel((Composite)parent, (String)"");
    }

    protected void createSpecificGroup(Composite parent) {
        this.createFunctionGroup(parent);
        this.createSubFunctionGroup(parent);
        this.createLevelGroup(parent);
        if (this._function.isEnabled()) {
            this._function.setFocus();
        } else {
            this._level.setFocus();
        }
    }

    private void updateOKButton(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
        if (!this.sizeInit) {
            int he = this._function.getLineHeight();
            this.getShell().setSize(340, he * 15);
            this.sizeInit = true;
        }
    }

    private void createFunctionGroup(Composite composite) {
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.FunctionDialog_FUNCTION_CODE);
        this._function = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        if (!this.subAtFirstLevel && FunctionDialog.subOK(this.selectedSubFunctionCode) || this.forInsertion) {
            this._function.setEnabled(false);
        }
        this._function.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (FunctionDialog.this._function.getEnabled()) {
                    boolean enabled = FunctionDialog.this.isFunctionInsertionPossible();
                    FunctionDialog.this.updateOKButton(enabled);
                }
            }
        });
    }

    private void createSubFunctionGroup(Composite composite) {
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.FunctionDialog_SUB_FUNCTION_CODE);
        this._subFunction = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._subFunction.setEnabled(!this.subAtFirstLevel && FunctionDialog.subOK(this.selectedSubFunctionCode) || this.forInsertion);
        this._subFunction.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                boolean enabled = FunctionDialog.this.isFunctionInsertionPossible();
                FunctionDialog.this.updateOKButton(enabled);
            }
        });
    }

    private void createLevelGroup(Composite composite) {
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.FunctionDialog_LEVEL);
        this._level = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._level.setEnabled(false);
    }

    public void setOffsets(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    public void setTextNodeIndexes(int bi, int ei) {
        this.detailBeginIndex = bi;
        this.detailEndIndex = ei;
    }

    public void setDetailedTitle(String txt) {
        this.detailedTitle = txt;
    }

    public void findBestNextCodes(String code, String subCode) {
        this.findFunctionsAndSubFunctions();
        this.selectedFunctionCode = code;
        this.selectedSubFunctionCode = subCode;
        this.geographicalInsertionIndex = -1;
        this.functionCodeToSuggest = "notInit";
        this.subFunctionCodeToSuggest = "";
        this.precedingFunctionCode = "";
        this.precedingSubFunctionCode = "";
        this.nextFunctionCode = "";
        this.nextSubFunctionCode = "";
        IDocument doc = this.iEditor.getDocument();
        int nbDocLines = doc.getNumberOfLines();
        boolean prcDiv = false;
        boolean containsRel = false;
        int nbChars = 0;
        this.found = false;
        String currFunc = "";
        String currSubFunc = "";
        int currLine = 0;
        while (currLine < nbDocLines) {
            int lineLen;
            String line = "";
            try {
                int offset = doc.getLineOffset(currLine);
                lineLen = doc.getLineLength(currLine);
                line = doc.get(offset, lineLen);
                if (-1 < line.indexOf(Strings.getLineSeparator())) {
                    line = line.substring(0, lineLen - Strings.getLineSeparator().length());
                }
            }
            catch (BadLocationException badLocationException) {
                line = "";
                lineLen = 0;
            }
            ++currLine;
            boolean bl = prcDiv ? true : (prcDiv = line.indexOf("PROCEDURE") == 7);
            if (!this.found && !this.forInsertion && this.atBeginning && line.indexOf("PROCEDURE") == 7) {
                this.found = true;
                int n = this.geographicalInsertionIndex = this.endOffset == -1 ? nbChars + lineLen : this.endOffset;
            }
            if (prcDiv && line.indexOf("PROCEDURE") == -1) {
                if (this.endLine.length() == 0 && 72 < line.length() && line.length() <= 78) {
                    this.endLine = line.substring(72, line.length());
                }
                if (6 <= line.length() && !this.found) {
                    this.begLine = line.substring(0, 6);
                }
                int posType = FunctionDialog.debut(line, code, subCode);
                containsRel = FunctionDialog.containsRelative(line);
                if (!containsRel) {
                    if (posType == 3 || posType == 1 || posType == 4 || posType == 2) {
                        currFunc = ProcedureLine.function(line);
                        if (posType == 4 || posType == 2) {
                            currSubFunc = "";
                        }
                    } else if (posType == 7 || posType == 6 || posType == 8 || posType == 5) {
                        currSubFunc = ProcedureLine.subFunction(line);
                        if (currSubFunc.charAt(3) == '.' || currSubFunc.charAt(3) == '-') {
                            currSubFunc = currSubFunc.substring(0, 3);
                        }
                        currFunc = currSubFunc.substring(0, 2);
                    }
                }
                if (this.found && !this.forInsertion && this.atBeginning && posType == 3) {
                    String sugg = this.intermediate("", currFunc, true);
                    this.lexicographicInsertionPossible = sugg.length() == 2;
                    this.functionCodeToSuggest = this.lexicographicInsertionPossible ? sugg : this.findChoiceAfter(currFunc);
                    this.nextFunctionCode = currFunc;
                    break;
                }
                if (!(this.found || this.forInsertion || !this.isBefore() || posType != 3 && posType != 7 || subCode.length() != 0 && !this.subAtFirstLevel)) {
                    this.precedingFunctionCode = currFunc;
                } else {
                    if (!this.forInsertion && this.isBefore() && !this.activateIndexes && this.isBeforeFunctionFound(posType, line, code, subCode, nbChars)) {
                        this.found = true;
                        String sugg = this.intermediate(this.precedingFunctionCode, code, false);
                        this.lexicographicInsertionPossible = sugg.length() == 2;
                        String string = this.functionCodeToSuggest = this.lexicographicInsertionPossible ? sugg : this.findChoiceAfter(code);
                        if (this.endOffset == -1) {
                            this.geographicalInsertionIndex = nbChars;
                            break;
                        }
                        this.geographicalInsertionIndex = this.endOffset;
                        break;
                    }
                    if (!this.found && !this.forInsertion && this.isBefore() && posType == 7 && FunctionDialog.subOK(subCode) && FunctionDialog.totOK(currSubFunc)) {
                        this.precedingFunctionCode = currSubFunc.substring(0, 2);
                        this.precedingSubFunctionCode = currSubFunc.substring(2);
                    } else {
                        if (!this.forInsertion && this.isBefore() && !this.activateIndexes && this.isBeforeSubFunctionFound(posType, line, code, subCode, nbChars)) {
                            this.found = true;
                            this.functionCodeToSuggest = code;
                            if (code.equals(this.precedingFunctionCode)) {
                                String sugg = this.intermediate(String.valueOf(this.precedingFunctionCode) + this.precedingSubFunctionCode, String.valueOf(code) + subCode, false);
                                this.lexicographicInsertionPossible = sugg.length() == 4;
                                this.subFunctionCodeToSuggest = this.lexicographicInsertionPossible ? sugg.substring(2, 4) : this.findChoiceBefore(code, subCode);
                            } else {
                                this.lexicographicInsertionPossible = true;
                                this.precedingSubFunctionCode = "";
                                this.subFunctionCodeToSuggest = this.findChoiceBefore(code, subCode);
                            }
                            if (this.endOffset == -1) {
                                this.geographicalInsertionIndex = nbChars;
                                break;
                            }
                            this.geographicalInsertionIndex = this.endOffset;
                            break;
                        }
                        if (!this.found && !this.forInsertion && this.isReplace() && !this.activateIndexes && (posType == 2 && subCode.length() == 0 || posType == 5 && FunctionDialog.subOK(subCode) && this.subAtFirstLevel)) {
                            this.found = true;
                        } else if (!this.found && !this.forInsertion && this.isReplace() && !this.activateIndexes && posType == 5 && FunctionDialog.subOK(subCode)) {
                            this.found = true;
                        } else if (!this.found && !this.forInsertion && this.isReplace() && posType == 0 && this.detailBeginIndex == nbChars) {
                            this.found = true;
                            this.geographicalInsertionIndex = this.detailEndIndex;
                        } else if (this.found && !this.forInsertion && this.isReplace() && posType == 0 && this.geographicalInsertionIndex == -1) {
                            this.geographicalInsertionIndex = nbChars;
                        } else {
                            if (this.found && !this.forInsertion && this.isReplace() && this.isFirstLevel(subCode, posType)) {
                                String sugg = this.intermediate(code, currFunc, true);
                                this.lexicographicInsertionPossible = sugg.length() == 2;
                                this.functionCodeToSuggest = this.lexicographicInsertionPossible ? sugg : this.findChoiceAfter(code);
                                this.nextFunctionCode = currFunc;
                                if (this.geographicalInsertionIndex != -1) break;
                                this.geographicalInsertionIndex = nbChars;
                                break;
                            }
                            if (this.found && !this.forInsertion && this.isReplace() && posType == 7) {
                                String sugg = this.intermediate(String.valueOf(code) + subCode, currSubFunc, true);
                                this.lexicographicInsertionPossible = sugg.length() == 4;
                                this.functionCodeToSuggest = code;
                                this.subFunctionCodeToSuggest = this.lexicographicInsertionPossible ? sugg.substring(2, 4) : this.findChoiceAfter(code, subCode);
                                this.nextFunctionCode = currSubFunc.substring(0, 2);
                                this.nextSubFunctionCode = currSubFunc.substring(2);
                                if (this.geographicalInsertionIndex != -1) break;
                                this.geographicalInsertionIndex = nbChars;
                                break;
                            }
                            if (this.found && !this.forInsertion && this.isReplace() && (posType == 2 || posType == 8) && FunctionDialog.subOK(subCode)) {
                                String nxt = this.findChoiceAfter(code, subCode);
                                this.lexicographicInsertionPossible = nxt.length() == 2;
                                this.functionCodeToSuggest = code;
                                this.subFunctionCodeToSuggest = nxt;
                                this.nextFunctionCode = code;
                                this.nextSubFunctionCode = "";
                                if (this.geographicalInsertionIndex != -1) break;
                                this.geographicalInsertionIndex = nbChars;
                                break;
                            }
                            if (!this.found && !this.forInsertion && this.isApres() && !this.activateIndexes && (posType == 2 && subCode.length() == 0 || posType == 5 && FunctionDialog.subOK(subCode))) {
                                this.found = true;
                            } else if (!this.found && !this.forInsertion && this.isApres() && posType == 0 && this.detailBeginIndex == nbChars) {
                                this.found = true;
                                this.geographicalInsertionIndex = this.detailEndIndex;
                                if (code.length() == 0) {
                                    code = currFunc;
                                }
                            } else if (this.found && !this.forInsertion && this.isApres() && posType == 0 && this.geographicalInsertionIndex == -1) {
                                this.geographicalInsertionIndex = nbChars;
                            } else if (this.found && !this.forInsertion && this.isApres() && this.isFirstLevel(subCode, posType)) {
                                if (!containsRel) {
                                    String sugg = this.intermediate(code, currFunc, true);
                                    this.lexicographicInsertionPossible = sugg.length() == 2;
                                    this.functionCodeToSuggest = this.lexicographicInsertionPossible ? sugg : this.findChoiceAfter(code);
                                    this.nextFunctionCode = currFunc;
                                }
                                if (this.endOffset == -1 && this.geographicalInsertionIndex == -1) {
                                    this.geographicalInsertionIndex = nbChars;
                                } else if (this.endOffset != -1) {
                                    this.geographicalInsertionIndex = this.endOffset;
                                }
                                if (!containsRel) {
                                    break;
                                }
                            } else if (this.found && !this.forInsertion && this.isApres() && FunctionDialog.subOK(subCode) && posType == 7) {
                                if (!containsRel) {
                                    String sugg = this.intermediate(String.valueOf(code) + subCode, currSubFunc, true);
                                    this.lexicographicInsertionPossible = sugg.length() == 4;
                                    this.functionCodeToSuggest = code;
                                    this.subFunctionCodeToSuggest = this.lexicographicInsertionPossible ? sugg.substring(2, 4) : this.findChoiceAfter(code, subCode);
                                    this.nextFunctionCode = currSubFunc.substring(0, 2);
                                    this.nextSubFunctionCode = currSubFunc.substring(2);
                                }
                                if (this.endOffset == -1 && this.geographicalInsertionIndex == -1) {
                                    this.geographicalInsertionIndex = nbChars;
                                } else if (this.endOffset != -1) {
                                    this.geographicalInsertionIndex = this.endOffset;
                                }
                                if (!containsRel) {
                                    break;
                                }
                            } else {
                                if (this.found && !this.forInsertion && this.isApres() && FunctionDialog.subOK(subCode) && (posType == 8 || posType == 2 || !this.subAtFirstLevel && posType == 5 && this.detailBeginIndex != -1)) {
                                    String nxt = this.findChoiceAfter(code, subCode);
                                    this.lexicographicInsertionPossible = nxt.length() == 2;
                                    this.functionCodeToSuggest = code;
                                    this.subFunctionCodeToSuggest = nxt;
                                    this.nextFunctionCode = code;
                                    this.nextSubFunctionCode = "";
                                    if (this.endOffset == -1 && this.geographicalInsertionIndex == -1) {
                                        this.geographicalInsertionIndex = nbChars;
                                        break;
                                    }
                                    if (this.endOffset == -1) break;
                                    this.geographicalInsertionIndex = this.endOffset;
                                    break;
                                }
                                if (!this.found && this.forInsertion && !this.activateIndexes && (posType == 1 && subCode.length() == 0 || posType == 6 && FunctionDialog.subOK(subCode))) {
                                    this.found = true;
                                    int dec = FunctionDialog.has2Points(line);
                                    if (this.isStructGeneratedCode && dec != -1) {
                                        this.isLineCut = true;
                                        this.decale = dec;
                                        this.geographicalInsertionIndex = nbChars + dec;
                                    }
                                } else {
                                    if (!this.found && this.forInsertion && this.activateIndexes && this.detailBeginIndex == nbChars) {
                                        this.found = true;
                                        int dec = FunctionDialog.has2Points(line);
                                        if (this.isStructGeneratedCode && dec != -1) {
                                            this.isLineCut = true;
                                            this.decale = dec;
                                            this.geographicalInsertionIndex = nbChars + dec;
                                        } else {
                                            this.geographicalInsertionIndex = this.detailBeginIndex + lineLen;
                                        }
                                        String strSub = FunctionDialog.subOK(subCode) ? subCode : "AA";
                                        String nxt = this.findChoiceAfter(code, strSub);
                                        this.lexicographicInsertionPossible = nxt.length() == 2;
                                        this.functionCodeToSuggest = code;
                                        this.subFunctionCodeToSuggest = nxt;
                                        this.nextFunctionCode = code;
                                        this.nextSubFunctionCode = "";
                                        break;
                                    }
                                    if (this.found && this.forInsertion && posType == 0 && this.geographicalInsertionIndex == -1) {
                                        this.geographicalInsertionIndex = this.isCursorInsert ? this.startOffset : nbChars;
                                    } else {
                                        if (this.found && this.forInsertion && (posType == 2 || posType == 5)) {
                                            this.lexicographicInsertionPossible = true;
                                            this.functionCodeToSuggest = code;
                                            String strSub = FunctionDialog.subOK(subCode) ? subCode : "AA";
                                            this.subFunctionCodeToSuggest = this.findChoiceAfter(code, strSub);
                                            if (this.endOffset == -1 && this.geographicalInsertionIndex == -1) {
                                                this.geographicalInsertionIndex = nbChars;
                                                break;
                                            }
                                            if (this.endOffset == -1) break;
                                            this.geographicalInsertionIndex = this.endOffset;
                                            break;
                                        }
                                        if (this.found && this.forInsertion && posType == 7) {
                                            String strSub = FunctionDialog.subOK(subCode) ? subCode : "AA";
                                            String sugg = this.intermediate(String.valueOf(code) + strSub, currSubFunc, true);
                                            this.lexicographicInsertionPossible = sugg.length() == 4;
                                            this.functionCodeToSuggest = code;
                                            this.subFunctionCodeToSuggest = this.lexicographicInsertionPossible ? sugg.substring(2, 4) : this.findChoiceAfter(code, subCode);
                                            this.nextFunctionCode = currSubFunc.substring(0, 2);
                                            this.nextSubFunctionCode = currSubFunc.substring(2);
                                            if (this.endOffset == -1 && this.geographicalInsertionIndex == -1) {
                                                this.geographicalInsertionIndex = nbChars;
                                                break;
                                            }
                                            if (this.endOffset == -1) break;
                                            this.geographicalInsertionIndex = this.endOffset;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            nbChars += lineLen;
        }
        if (this.found && !this.forInsertion && this.functionCodeToSuggest.equals("notInit")) {
            boolean bl = this.lexicographicInsertionPossible = this.selectedFunctionCode.length() == 2 && this.selectedSubFunctionCode.length() == 0 && !this.selectedFunctionCode.equals("99");
            if (this.geographicalInsertionIndex == -1) {
                this.geographicalInsertionIndex = nbChars;
            }
            String string = this.functionCodeToSuggest = this.lexicographicInsertionPossible ? this.intermediate(code, "", true) : "";
        }
        if (this.isCSServer && !this.found && this.detailEndIndex != -1) {
            this.geographicalInsertionIndex = this.detailEndIndex;
            this.functionCodeToSuggest = code;
            this.subFunctionCodeToSuggest = subCode;
            this.found = true;
        }
    }

    public boolean isInsertionPositionFound() {
        return this.found && this.geographicalInsertionIndex != -1;
    }

    private boolean isFirstLevel(String subCode, int type) {
        if (subCode.length() == 0 && (type == 3 || type == 7)) {
            return true;
        }
        if (type != 3 && type != 7) {
            return false;
        }
        return this.subAtFirstLevel;
    }

    private boolean isFunctionInsertionPossible() {
        boolean ret;
        boolean bl = ret = this.isDialogComplete() && this.init && !this.isFunctionHere();
        if (ret) {
            this.displayWarnings();
        }
        return ret;
    }

    private boolean isDialogComplete() {
        this.init = false;
        if (!this.found || this.geographicalInsertionIndex == -1) {
            this.setErrorMessage(Messages.FunctionDialog_INSERTION_POSITION_NOT_FOUND, null, true);
            return false;
        }
        this.functionCode = this._function.getText().toUpperCase().trim();
        this.subFunctionCode = this._subFunction.getText().toUpperCase().trim();
        this._level.setText(this.level != null ? this.level : "");
        if (this.functionCode.length() == 0) {
            this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_DATA_REQUIRED, true);
            return false;
        }
        if ((this.forInsertion || !this.subAtFirstLevel && FunctionDialog.subOK(this.selectedSubFunctionCode)) && this.subFunctionCode.length() == 0) {
            this.setErrorMessage(Messages.FunctionDialog_SUB_FUNCTION_CODE, Messages.FunctionDialog_DATA_REQUIRED, true);
            return false;
        }
        if (this.functionCode.length() != 2) {
            this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_LENGTH_INVALID, true);
            return false;
        }
        if (!this.forInsertion && FunctionDialog.isFunctionReserved(this.functionCode) && this.subFunctionCode.length() == 0) {
            this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_RESERVED_FUNCTION, true);
            return false;
        }
        if (this.subFunctionCode.length() != 0 && this.subFunctionCode.length() != 2) {
            this.setErrorMessage(Messages.FunctionDialog_SUB_FUNCTION_CODE, Messages.FunctionDialog_LENGTH_INVALID, true);
            return false;
        }
        if (this.functionCode.length() == 2 && !ProcedureLine.isZoneAlphaNum(this.functionCode, 0, 2)) {
            this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_MUST_BE_ALPHANUM, true);
            return false;
        }
        if (!this.forInsertion && this.functionCode.length() == 2 && this.subFunctionCode.length() == 2 && !this.functionCodeToSuggest.equals(this.functionCode)) {
            this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_MUST_BE_FROM_ABOVE, true);
            return false;
        }
        if (this.forInsertion && this.functionCode.length() == 2 && !this.functionCodeToSuggest.equals(this.functionCode)) {
            this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_MUST_BE_FROM_ABOVE, true);
            return false;
        }
        if (this.subFunctionCode.length() == 2 && !ProcedureLine.isZoneAlphaNum(this.subFunctionCode, 0, 2)) {
            this.setErrorMessage(Messages.FunctionDialog_SUB_FUNCTION_CODE, Messages.FunctionDialog_MUST_BE_ALPHANUM, true);
            return false;
        }
        if (this.subFunctionCode.trim().length() == 0) {
            this.subFunctionCode = "";
        }
        this.setErrorMessage(null, null, true);
        this.init = true;
        return true;
    }

    private void displayWarnings() {
        if ((this.isApres() || this.isReplace()) && this.lexicographicInsertionPossible) {
            if (this.selectedSubFunctionCode.length() == 0 && this.nextSubFunctionCode.length() == 0 && this.selectedFunctionCode.length() == 2 && this.nextFunctionCode.length() == 2 && (Ebcdic.stringCompare(this.selectedFunctionCode, this.functionCode) > 0 || Ebcdic.stringCompare(this.functionCode, this.nextFunctionCode) > 0)) {
                Object[] args = new Object[]{this.selectedFunctionCode, this.nextFunctionCode};
                String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_FUNCTION_BETWEEN, (Object[])args);
                this.setErrorMessage(text, null, false);
            } else if (this.selectedSubFunctionCode.length() == 0 && this.nextSubFunctionCode.length() == 0 && this.selectedFunctionCode.length() == 0 && this.nextFunctionCode.length() == 2 && Ebcdic.stringCompare(this.functionCode, this.nextFunctionCode) > 0) {
                Object[] args = new Object[]{this.nextFunctionCode};
                String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_FUNCTION_BELOW, (Object[])args);
                this.setErrorMessage(text, null, false);
            } else if (this.selectedSubFunctionCode.length() == 0 && this.nextSubFunctionCode.length() == 0 && this.selectedFunctionCode.length() == 2 && this.nextFunctionCode.length() == 0 && Ebcdic.stringCompare(this.selectedFunctionCode, this.functionCode) > 0) {
                Object[] args = new Object[]{this.selectedFunctionCode};
                String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_FUNCTION_ABOVE, (Object[])args);
                this.setErrorMessage(text, null, false);
            } else if (!this.subAtFirstLevel && FunctionDialog.subOK(this.selectedSubFunctionCode) && this.nextSubFunctionCode.length() == 2 && (Ebcdic.stringCompare(this.selectedSubFunctionCode, this.subFunctionCode) > 0 || Ebcdic.stringCompare(this.subFunctionCode, this.nextSubFunctionCode) > 0)) {
                Object[] args = new Object[]{this.selectedSubFunctionCode, this.nextSubFunctionCode};
                String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_SUB_FUNCTION_BETWEEN, (Object[])args);
                this.setErrorMessage(text, null, false);
            } else if (!this.subAtFirstLevel && this.selectedSubFunctionCode.length() == 0 && this.nextSubFunctionCode.length() == 2 && Ebcdic.stringCompare(this.subFunctionCode, this.nextSubFunctionCode) > 0) {
                Object[] args = new Object[]{this.nextSubFunctionCode};
                String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_SUB_FUNCTION_BELOW, (Object[])args);
                this.setErrorMessage(text, null, false);
            } else if (!this.subAtFirstLevel && FunctionDialog.subOK(this.selectedSubFunctionCode) && this.nextSubFunctionCode.length() == 0 && Ebcdic.stringCompare(this.selectedSubFunctionCode, this.subFunctionCode) > 0) {
                Object[] args = new Object[]{this.selectedSubFunctionCode};
                String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_SUB_FUNCTION_ABOVE, (Object[])args);
                this.setErrorMessage(text, null, false);
            }
        }
        if (this.lexicographicInsertionPossible && this.isBefore()) {
            this.displayBeforeWarnings();
        }
        if (!this.lexicographicInsertionPossible && this.nextFunctionCode.length() == 2 && (this.subAtFirstLevel || this.selectedSubFunctionCode.length() == 0)) {
            this.setErrorMessage(Messages.FunctionDialog_FUNC_ADD_NOT_LEXICOGRAPHIC, null, false);
        } else if (!this.lexicographicInsertionPossible && this.nextSubFunctionCode.length() == 2 && FunctionDialog.subOK(this.selectedSubFunctionCode)) {
            this.setErrorMessage(Messages.FunctionDialog_SUB_FUNC_ADD_NOT_LEXICOGRAPHIC, null, false);
        } else if (!this.lexicographicInsertionPossible && this.precedingFunctionCode.length() == 2 && (this.subAtFirstLevel || this.precedingSubFunctionCode.length() == 0)) {
            this.setErrorMessage(Messages.FunctionDialog_FUNC_ADD_NOT_LEXICOGRAPHIC, null, false);
        } else if (!this.lexicographicInsertionPossible && this.precedingSubFunctionCode.length() == 2 && FunctionDialog.subOK(this.selectedSubFunctionCode)) {
            this.setErrorMessage(Messages.FunctionDialog_SUB_FUNC_ADD_NOT_LEXICOGRAPHIC, null, false);
        }
    }

    private void displayBeforeWarnings() {
        if (this.selectedSubFunctionCode.length() == 0 && this.precedingSubFunctionCode.length() == 0 && this.selectedFunctionCode.length() == 2 && this.precedingFunctionCode.length() == 2 && (Ebcdic.stringCompare(this.precedingFunctionCode, this.functionCode) > 0 || Ebcdic.stringCompare(this.functionCode, this.selectedFunctionCode) > 0)) {
            Object[] args = new Object[]{this.precedingFunctionCode, this.selectedFunctionCode};
            String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_FUNCTION_BETWEEN, (Object[])args);
            this.setErrorMessage(text, null, false);
        } else if (this.selectedSubFunctionCode.length() == 0 && this.precedingSubFunctionCode.length() == 0 && this.selectedFunctionCode.length() == 2 && this.precedingFunctionCode.length() == 0 && Ebcdic.stringCompare(this.functionCode, this.selectedFunctionCode) > 0) {
            Object[] args = new Object[]{this.selectedFunctionCode};
            String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_FUNCTION_BELOW, (Object[])args);
            this.setErrorMessage(text, null, false);
        } else if (this.selectedSubFunctionCode.length() == 0 && this.precedingSubFunctionCode.length() == 0 && this.precedingFunctionCode.length() == 2 && this.selectedFunctionCode.length() == 0 && Ebcdic.stringCompare(this.precedingFunctionCode, this.functionCode) > 0) {
            Object[] args = new Object[]{this.precedingFunctionCode};
            String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_FUNCTION_ABOVE, (Object[])args);
            this.setErrorMessage(text, null, false);
        } else if (FunctionDialog.subOK(this.selectedSubFunctionCode) && this.precedingSubFunctionCode.length() == 2 && (Ebcdic.stringCompare(this.precedingSubFunctionCode, this.subFunctionCode) > 0 || Ebcdic.stringCompare(this.subFunctionCode, this.selectedSubFunctionCode) > 0)) {
            Object[] args = new Object[]{this.precedingSubFunctionCode, this.selectedSubFunctionCode};
            String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_SUB_FUNCTION_BETWEEN, (Object[])args);
            this.setErrorMessage(text, null, false);
        } else if (FunctionDialog.subOK(this.selectedSubFunctionCode) && this.precedingSubFunctionCode.length() == 0 && Ebcdic.stringCompare(this.subFunctionCode, this.selectedSubFunctionCode) > 0) {
            Object[] args = new Object[]{this.selectedSubFunctionCode};
            String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_SUB_FUNCTION_BELOW, (Object[])args);
            this.setErrorMessage(text, null, false);
        } else if (this.selectedSubFunctionCode.length() == 0 && this.precedingSubFunctionCode.length() == 2 && Ebcdic.stringCompare(this.precedingSubFunctionCode, this.subFunctionCode) > 0) {
            Object[] args = new Object[]{this.precedingSubFunctionCode};
            String text = NLS.bind((String)Messages.FunctionDialog_CHOOSE_SUB_FUNCTION_ABOVE, (Object[])args);
            this.setErrorMessage(text, null, false);
        }
    }

    protected void setErrorMessage(String message1, String message2, boolean isError) {
        if (message1 != null) {
            if (isError) {
                this._lblImage.setImage(PdpPacbasePlugin.getImage("icons/nodesview/error.gif"));
            } else {
                this._lblImage.setImage(PdpPacbasePlugin.getImage("icons/nodesview/warning.gif"));
            }
            this._lblError.setText(message1);
            if (message2 != null) {
                this._lblError.setText(String.valueOf(message1) + " : " + message2);
            }
        } else {
            this._lblImage.setImage(null);
            this._lblError.setText("                                                            ");
        }
        this._lblError.getParent().pack();
        this._lblError.getParent().redraw();
    }

    private boolean isFunctionHere() {
        if (this.functionCode.length() == 2 && this.subFunctionCode.length() == 0) {
            if (this.functionsList.contains(this.functionCode)) {
                this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_ALREADY_THERE, true);
                return true;
            }
            if (TagsAndDetails.isTagBeginOfDetail(this.textProcessor, "F" + this.functionCode)) {
                this.setErrorMessage(Messages.FunctionDialog_FUNCTION_CODE, Messages.FunctionDialog_ALREADY_INSIDE_DETAIL_LINE, true);
                return true;
            }
        } else if (this.functionCode.length() == 2 && this.subFunctionCode.length() == 2) {
            if (this.subFunctionsList.contains(String.valueOf(this.functionCode) + this.subFunctionCode)) {
                this.setErrorMessage(Messages.FunctionDialog_SUB_FUNCTION_CODE, Messages.FunctionDialog_ALREADY_THERE, true);
                return true;
            }
            if (TagsAndDetails.isTagBeginOfDetail(this.textProcessor, "F" + this.functionCode + this.subFunctionCode)) {
                this.setErrorMessage(Messages.FunctionDialog_SUB_FUNCTION_CODE, Messages.FunctionDialog_ALREADY_INSIDE_DETAIL_LINE, true);
                return true;
            }
        }
        return false;
    }

    private void findFunctionsAndSubFunctions() {
        StringTokenizer st = new StringTokenizer(this.textProcessor.getText().toString(), Strings.getLineSeparator());
        boolean prcDiv = false;
        while (st.hasMoreTokens()) {
            String subFunc;
            String func;
            String line = st.nextToken();
            boolean bl = prcDiv ? true : (prcDiv = line.indexOf("PROCEDURE") > -1);
            if (!prcDiv) continue;
            if (ProcedureLine.isBegFunction(line)) {
                func = ProcedureLine.function(line);
                if (func.length() != 2 || this.functionsList.contains(func)) continue;
                this.functionsList.add(func);
                continue;
            }
            if (ProcedureLine.isEndFunction(line)) {
                func = ProcedureLine.function(line);
                if (func.length() != 2 || this.functionsList.contains(func)) continue;
                this.functionsList.add(func);
                continue;
            }
            if (ProcedureLine.isBegSubFunction(line)) {
                subFunc = ProcedureLine.subFunction(line);
                if (subFunc.length() == 4 && !this.subFunctionsList.contains(subFunc)) {
                    this.subFunctionsList.add(subFunc);
                }
                if (subFunc.length() != 4 || this.functionsList.contains(subFunc.substring(0, 2))) continue;
                this.functionsList.add(subFunc.substring(0, 2));
                continue;
            }
            if (ProcedureLine.isEndSubFunction(line)) {
                subFunc = ProcedureLine.subFunction(line);
                if (subFunc.length() != 4 || this.subFunctionsList.contains(subFunc)) continue;
                this.subFunctionsList.add(subFunc);
                continue;
            }
            if (ProcedureLine.isBegSub1Function(line)) {
                subFunc = ProcedureLine.sub1Function(line);
                if (subFunc.length() == 3 && !this.subFunctionsList.contains(subFunc)) {
                    this.subFunctionsList.add(subFunc);
                }
                if (subFunc.length() != 3 || this.functionsList.contains(subFunc.substring(0, 2))) continue;
                this.functionsList.add(subFunc.substring(0, 2));
                continue;
            }
            if (ProcedureLine.isEndSub1Function(line)) {
                subFunc = ProcedureLine.sub1Function(line);
                if (subFunc.length() != 3 || this.subFunctionsList.contains(subFunc)) continue;
                this.subFunctionsList.add(subFunc);
                continue;
            }
            if (!ServerTags.hasLineTiretFunction(line) || this.functionsList.contains(func = line.substring(8, 10))) continue;
            this.functionsList.add(func);
        }
    }

    private static int debut(String line, String strCode, String strSubCode) {
        String str;
        StringTokenizer tok;
        String fu;
        int index;
        if (ProcedureLine.isBegFunction(line)) {
            String deb = ProcedureLine.function(line);
            int index2 = Ebcdic.stringCompare(deb, strCode);
            return index2 == 0 ? 1 : 3;
        }
        if (ProcedureLine.isBegSubFunction(line)) {
            String deb = ProcedureLine.subFunction(line);
            int index3 = Ebcdic.stringCompare(deb, String.valueOf(strCode) + strSubCode);
            return index3 == 0 ? 6 : 7;
        }
        if (ProcedureLine.isBegSub1Function(line)) {
            String deb = ProcedureLine.sub1Function(line);
            int index4 = Ebcdic.stringCompare(deb, String.valueOf(strCode) + strSubCode);
            return index4 == 0 ? 6 : 7;
        }
        if (ProcedureLine.isEndFunction(line)) {
            String deb = ProcedureLine.function(line);
            int index5 = Ebcdic.stringCompare(deb, strCode);
            return index5 == 0 ? 2 : 4;
        }
        if (ProcedureLine.isEndSubFunction(line)) {
            String deb = ProcedureLine.subFunction(line);
            int index6 = Ebcdic.stringCompare(deb, String.valueOf(strCode) + strSubCode);
            return index6 == 0 ? 5 : 8;
        }
        if (ProcedureLine.isEndSub1Function(line)) {
            String deb = ProcedureLine.sub1Function(line);
            int index7 = Ebcdic.stringCompare(deb, String.valueOf(strCode) + strSubCode);
            return index7 == 0 ? 5 : 8;
        }
        if (FunctionDialog.containsRelative(line) && (index = line.indexOf(" F")) > -1 && 3 <= (fu = (tok = new StringTokenizer(str = line.substring(index + 1), " ")).nextToken()).length() && Character.isLetterOrDigit(fu.charAt(1)) && Character.isLetterOrDigit(fu.charAt(2))) {
            if (fu.length() == 3) {
                return 3;
            }
            if (fu.length() == 5 && Character.isLetterOrDigit(fu.charAt(3)) && Character.isLetterOrDigit(fu.charAt(4))) {
                return 7;
            }
        }
        return 0;
    }

    private boolean isBeforeFunctionFound(int type, String line, String code, String subCode, int nbChars) {
        if (this.isForBatchGenerator && type == 0 && ProcedureLine.isNoteFunction(line) && (subCode.length() == 0 || this.subAtFirstLevel)) {
            return ProcedureLine.function(line).equals(code);
        }
        if (!this.isForBatchGenerator && type == 0 && this.startOffset == nbChars && subCode.length() == 0) {
            return true;
        }
        if (type == 1 && subCode.length() == 0) {
            return true;
        }
        return type == 6 && FunctionDialog.subOK(subCode) && this.subAtFirstLevel;
    }

    private boolean isBeforeSubFunctionFound(int type, String line, String code, String subCode, int nbChars) {
        if (this.isForBatchGenerator && type == 0 && ProcedureLine.isNoteSubFunction(line) && FunctionDialog.subOK(subCode)) {
            return ProcedureLine.subFunction(line).equals(String.valueOf(code) + subCode);
        }
        if (!this.isForBatchGenerator && type == 0 && this.startOffset == nbChars && FunctionDialog.subOK(subCode)) {
            return true;
        }
        return type == 6 && FunctionDialog.subOK(subCode);
    }

    private static int has2Points(String line) {
        if (!(ProcedureLine.isBegFunction(line) || ProcedureLine.isBegSubFunction(line) || ProcedureLine.isBegSub1Function(line) || ProcedureLine.isBeg80ER(line))) {
            return -1;
        }
        String trimLine = line.substring(0, Math.min(72, line.length()));
        int ind0 = trimLine.indexOf(".");
        int ind1 = -1;
        int exit = line.indexOf("EXIT", ind0 + 1);
        ind1 = line.indexOf(".", ind0 + 1);
        if (exit != -1 && trimLine.substring(ind1 + 1).trim().length() != 0) {
            return ind1 + 1;
        }
        if (exit == -1 && trimLine.substring(ind0 + 1).trim().length() != 0) {
            return ind0 + 1;
        }
        return -1;
    }

    private static boolean containsRelative(String line) {
        return line.indexOf("*@BEFORE") == 6 || line.indexOf("*@AFTER") == 6 || line.indexOf("*@REPLACE") == 6;
    }

    private String getFLabel(String line) {
        if (line.length() < 9 || line.charAt(6) != ' ' || line.charAt(7) != 'F') {
            return null;
        }
        if (line.indexOf("-FN") > -1) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(line.substring(7), " .");
        if (!tok.hasMoreTokens()) {
            return null;
        }
        String lab = tok.nextToken();
        if (!tok.hasMoreTokens()) {
            return null;
        }
        String ex = tok.nextToken();
        if (!ex.equals("EXIT")) {
            return null;
        }
        return lab;
    }

    private boolean isTag(String lab) {
        return this.getGISons(this.textProcessor.getGeneratedInfo(), lab);
    }

    private boolean getGISons(IGeneratedInfo gi, String tagName) {
        IGeneratedTag rt = gi.getRootTag();
        Iterator iters = rt.sons();
        while (iters.hasNext()) {
            IGeneratedTag gt = (IGeneratedTag)iters.next();
            if (!gt.getName().equals("PROCEDURE") || !this.getSons(gt.sons(), tagName)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean getSons(Iterator<IGeneratedTag> iters, String tagName) {
        if (iters != null) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            gt = iters.next();
            if (gt.getName().equals(tagName)) {
                return true;
            }
            if (!this.getSons(gt.sons(), tagName)) continue;
            return true;
lbl8:
            // 2 sources

            ** while (iters.hasNext())
        }
lbl9:
        // 1 sources

        return false;
    }

    private static boolean isFunctionReserved(String code) {
        if (code == null || code.length() != 2) {
            return false;
        }
        int r = 0;
        while (r < reservedFunctions.length) {
            if (reservedFunctions[r].equals(code)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    private boolean available(String str) {
        if (str.length() == 2) {
            if (this.functionsList.contains(str)) {
                return false;
            }
            if (TagsAndDetails.isTagBeginOfDetail(this.textProcessor, "F" + str)) {
                return false;
            }
        } else if (FunctionDialog.totOK(str)) {
            if (this.subFunctionsList.contains(str)) {
                return false;
            }
            if (TagsAndDetails.isTagBeginOfDetail(this.textProcessor, "F" + str)) {
                return false;
            }
        }
        return true;
    }

    private String intermediate(String code, String next, boolean fromBottom) {
        if (code == null || next == null) {
            return "";
        }
        if (code.length() == next.length() && Ebcdic.stringCompare(code, next) == 0) {
            return "";
        }
        if (code.length() == next.length() && Ebcdic.stringCompare(code, next) > 0) {
            return "";
        }
        if (code.length() == 0 && next.length() == 2 && fromBottom) {
            if (next.equals("AA")) {
                return "";
            }
            String ret = "AA";
            while (!ret.equals("99")) {
                if (this.available(ret)) {
                    return ret;
                }
                ret = ProcedureLine.next(ret);
            }
            return "";
        }
        if (code.length() == 0 && next.length() == 2 && !fromBottom) {
            if (next.equals("AA")) {
                return "";
            }
            String ret = ProcedureLine.before(next);
            while (!ret.equals("AA")) {
                if (this.available(ret)) {
                    return ret;
                }
                ret = ProcedureLine.before(ret);
            }
            return "";
        }
        if (code.length() == 2 && next.length() == 0 && fromBottom) {
            if (code.equals("99")) {
                return "";
            }
            String ret = ProcedureLine.next(code);
            while (!ret.equals("99")) {
                if (this.available(ret)) {
                    return ret;
                }
                ret = ProcedureLine.next(ret);
            }
            return "";
        }
        if (code.length() == 2 && next.length() == 0 && !fromBottom) {
            if (code.equals("99")) {
                return "";
            }
            String ret = "99";
            while (!ret.equals("AA")) {
                if (this.available(ret)) {
                    return ret;
                }
                ret = ProcedureLine.before(ret);
            }
            return "";
        }
        if (code.length() == 2 && next.length() == 2 && fromBottom) {
            String ret = ProcedureLine.next(code);
            while (!ret.equals(next)) {
                if (this.available(ret)) {
                    return ret;
                }
                ret = ProcedureLine.next(ret);
            }
            return "";
        }
        if (code.length() == 2 && next.length() == 2 && !fromBottom) {
            String ret = ProcedureLine.before(next);
            while (!ret.equals(code)) {
                if (this.available(ret)) {
                    return ret;
                }
                ret = ProcedureLine.before(ret);
            }
            return "";
        }
        if (FunctionDialog.totOK(code) && FunctionDialog.totOK(next) && fromBottom) {
            String func = code.substring(0, 2);
            if (func.equals(next.substring(0, 2))) {
                String beg = code.substring(2);
                String end = next.substring(2);
                beg = FunctionDialog.compl(beg);
                end = FunctionDialog.compl(end);
                String ret = beg;
                while (!ret.equals(end)) {
                    if (this.available(String.valueOf(func) + ret)) {
                        return String.valueOf(func) + ret;
                    }
                    ret = ProcedureLine.next(ret);
                }
                return "";
            }
            return "";
        }
        if (FunctionDialog.totOK(code) && FunctionDialog.totOK(next) && !fromBottom) {
            String func = code.substring(0, 2);
            if (func.equals(next.substring(0, 2))) {
                String beg = code.substring(2);
                String end = next.substring(2);
                beg = FunctionDialog.compl(beg);
                String ret = end = FunctionDialog.compl(end);
                while (!ret.equals(beg)) {
                    if (this.available(String.valueOf(func) + ret)) {
                        return String.valueOf(func) + ret;
                    }
                    ret = ProcedureLine.before(ret);
                }
                return "";
            }
            return "";
        }
        return next;
    }

    private String findChoiceAfter(String function, String sub) {
        while (!(sub.length() != 1 && sub.length() != 2 || this.available(String.valueOf(function) + sub))) {
            if ((sub = ProcedureLine.next(sub)).length() != 0) continue;
            sub = "AA";
        }
        return sub;
    }

    private String findChoiceBefore(String function, String sub) {
        while (sub.length() == 2 && !this.available(String.valueOf(function) + sub)) {
            if ((sub = ProcedureLine.before(sub)).length() != 0) continue;
            sub = "99";
        }
        return sub;
    }

    private String findChoiceAfter(String function) {
        if (function.length() == 2) {
            while (!this.available(function)) {
                if ((function = ProcedureLine.next(function)).length() != 0) continue;
                function = "AA";
            }
            return function;
        }
        return "";
    }

    public void insertFunction() {
        boolean inOneShot = this.startOffset == this.endOffset;
        String total = "";
        this.increaseBegLine(this.isRelative || this.isForBatchGenerator ? 3 : 2);
        if (this.isLineCut || this.isCursorInsert) {
            if (inOneShot) {
                total = String.valueOf(FunctionDialog.whites(this.decale)) + total;
            } else {
                this.textProcessor.replaceText(this.geographicalInsertionIndex, this.geographicalInsertionIndex, (CharSequence)FunctionDialog.whites(this.decale));
            }
        }
        if (inOneShot) {
            total = String.valueOf(this.newFunctionLine(false)) + total;
        } else {
            this.textProcessor.replaceText(this.geographicalInsertionIndex, this.geographicalInsertionIndex, (CharSequence)this.newFunctionLine(false));
        }
        this.increaseBegLine(-1);
        if (inOneShot) {
            total = String.valueOf(this.newFunctionLine(true)) + total;
        } else {
            this.textProcessor.replaceText(this.startOffset, this.startOffset, (CharSequence)this.newFunctionLine(true));
        }
        if (this.isRelative && !this.forInsertion) {
            this.increaseBegLine(-1);
            if (inOneShot) {
                total = String.valueOf(this.relativeLine()) + total;
            } else {
                this.textProcessor.replaceText(this.geographicalInsertionIndex, this.geographicalInsertionIndex, (CharSequence)this.relativeLine());
            }
        }
        if (this.isForBatchGenerator && !this.isRelative) {
            this.increaseBegLine(-1);
            if (inOneShot) {
                total = String.valueOf(this.commentLineForBatch()) + total;
            } else {
                this.textProcessor.replaceText(this.startOffset, this.startOffset, (CharSequence)this.commentLineForBatch());
            }
        }
        if (this.isLineCut || this.isCursorInsert) {
            if (inOneShot) {
                total = String.valueOf(Strings.getLineSeparator()) + total;
            } else {
                this.textProcessor.replaceText(this.geographicalInsertionIndex, this.geographicalInsertionIndex, (CharSequence)Strings.getLineSeparator());
            }
        }
        if (inOneShot) {
            this.textProcessor.replaceText(this.geographicalInsertionIndex, this.geographicalInsertionIndex, (CharSequence)total);
        }
        if (this.iEditor != null) {
            TextSelection txtSel = new TextSelection(this.geographicalInsertionIndex, 0);
            this.iEditor.getSelectionProvider().setSelection((ISelection)txtSel);
        }
        if (this.subFunctionCode.length() == 0) {
            this.functionsList.add(this.functionCode);
        } else {
            this.subFunctionsList.add(String.valueOf(this.functionCode) + this.subFunctionCode);
        }
    }

    private String relativeLine() {
        StringBuffer buff = new StringBuffer();
        if (this.begLine.length() == 6) {
            buff.append(this.begLine);
        } else {
            FunctionDialog.addWhites(buff, 6);
        }
        if (this.isBefore()) {
            buff.append("*@BEFORE");
        } else if (this.isReplace()) {
            buff.append("*@REPLACE");
        } else if (this.isAfter()) {
            buff.append("*@AFTER");
        }
        if (this.detailedTitle.length() > 0) {
            buff.append(" " + this.detailedTitle);
        } else {
            buff.append(" F");
            buff.append(this.selectedFunctionCode);
            buff.append(this.selectedSubFunctionCode);
        }
        String lineSep = Strings.getLineSeparator();
        FunctionDialog.addWhites(buff, 72 - buff.length());
        buff.append(lineSep);
        return buff.toString();
    }

    private String commentLineForBatch() {
        StringBuffer buff = new StringBuffer();
        if (this.begLine.length() == 6) {
            buff.append(this.begLine);
        } else {
            FunctionDialog.addWhites(buff, 6);
        }
        buff.append("*N");
        buff.append(this.functionCode);
        if (this.subFunctionCode.length() == 2) {
            buff.append(this.subFunctionCode);
        }
        buff.append(".");
        String lineSep = Strings.getLineSeparator();
        FunctionDialog.addWhites(buff, 72 - buff.length());
        if (this.endLine.length() > 0) {
            buff.append(this.endLine);
        }
        buff.append(lineSep);
        return buff.toString();
    }

    private String newFunctionLine(boolean beg) {
        StringBuffer buff = new StringBuffer();
        if (this.begLine.length() == 6) {
            buff.append(this.begLine);
        } else {
            FunctionDialog.addWhites(buff, 6);
        }
        FunctionDialog.addWhites(buff, 1);
        buff.append("F");
        buff.append(this.functionCode);
        if (!this.subAtFirstLevel && this.subFunctionCode.length() == 2) {
            buff.append(this.subFunctionCode);
        }
        if (beg) {
            buff.append(".");
        } else {
            buff.append("-FN.");
        }
        FunctionDialog.addWhites(buff, 17 - buff.length());
        buff.append("EXIT.");
        String lineSep = Strings.getLineSeparator();
        FunctionDialog.addWhites(buff, 72 - buff.length());
        if (beg && this.endLine.length() > 0) {
            buff.append(this.endLine);
        }
        buff.append(lineSep);
        return buff.toString();
    }

    private void increaseBegLine(int incr) {
        if (this.begLine.length() != 6) {
            return;
        }
        char cc = this.begLine.charAt(4);
        if (this.begLine.length() == 6 && '0' <= cc && cc < '8') {
            this.begLine = String.valueOf(this.begLine.substring(0, 4)) + String.valueOf((char)(cc + incr)) + this.begLine.substring(5, 6);
        }
    }

    private static void addWhites(StringBuffer buff, int len) {
        int i = 0;
        while (i < len) {
            buff.append(" ");
            ++i;
        }
    }

    private static String whites(int nb) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < nb) {
            buff.append(" ");
            ++i;
        }
        return buff.toString();
    }

    private static boolean subOK(String subCode) {
        return subCode.length() == 1 || subCode.length() == 2;
    }

    private static boolean totOK(String subCode) {
        return subCode.length() == 3 || subCode.length() == 4;
    }

    private static String compl(String sub) {
        if (sub.length() == 1) {
            return String.valueOf(sub) + "A";
        }
        return sub;
    }
}

