/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.designview.contentprovider;

import com.ibm.pdp.mdl.pacbase.PacAbstractCDLine;
import com.ibm.pdp.mdl.pacbase.PacAbstractWLine;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.pacbase.designview.contentprovider.PacComparator;
import java.util.Arrays;
import java.util.List;

public class PacDesignViewUtil {
    private static PacComparator pacComparator;
    private static final char[] ALPHANUM;
    private static final int[] ALPHANUM2;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        ALPHANUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        ALPHANUM2 = new int[ALPHANUM.length];
        int i = 0;
        while (i < ALPHANUM.length) {
            PacDesignViewUtil.ALPHANUM2[i] = ALPHANUM[i];
            ++i;
        }
    }

    public static boolean isCDLineNameAlreadyUsed(List<PacAbstractCDLine> cdLines, String name) {
        int cdLinesSize = cdLines.size();
        int i = 0;
        while (i < cdLinesSize) {
            PacAbstractCDLine md = cdLines.get(i);
            if (md.getCommonDescription().getCodeInProgram().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPurePacbaseAlphanumeric(char value) {
        int sup = ALPHANUM.length;
        int i = 0;
        while (i < sup) {
            if (ALPHANUM[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPurePacbaseAlphanumeric2(char value) {
        char val = value;
        int inf = 0;
        int sup = ALPHANUM2.length - 1;
        int pivot = 0;
        while (inf <= sup) {
            pivot = (inf + sup) / 2;
            if (val > ALPHANUM2[pivot]) {
                inf = pivot + 1;
                continue;
            }
            if (val < ALPHANUM2[pivot]) {
                sup = pivot - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static boolean isPurePacbaseAlphanumeric(String str) {
        int sup = str.length();
        int i = 0;
        while (i < sup) {
            char ch = str.charAt(i);
            if (!PacDesignViewUtil.isPurePacbaseAlphanumeric2(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isWLineNameAlreadyUsed(List<PacAbstractWLine> wLines, String name) {
        int wLinesSize = wLines.size();
        int i = 0;
        while (i < wLinesSize) {
            PacWLineF wlinef;
            PacAbstractWLine wLine = wLines.get(i);
            if (wLine instanceof PacWLineF && (wlinef = (PacWLineF)wLine).getCommonDescription().getCodeInProgram().equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String convertA2digitsNumIntoA2CharsString(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    public static void sort(Object[] array) {
        if (pacComparator == null) {
            pacComparator = new PacComparator();
        }
        Arrays.sort(array, pacComparator);
    }
}

