/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.designview.contentprovider;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.framework.editor.design.KernelLightEditor;
import com.ibm.pdp.framework.editor.design.TextLightEditor;
import com.ibm.pdp.framework.interfaces.IDesignLink;
import com.ibm.pdp.framework.interfaces.IDesignModelManager;
import com.ibm.pdp.framework.interfaces.ILightModelEditor;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.MetaDataAggregate;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.MetaEntityType;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.UserEntity;
import com.ibm.pdp.mdl.pacbase.PacDLine;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacSourceInheritanceGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacText;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.design.ModelUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PacDesignModelManager
implements IDesignModelManager {
    protected IDesignLink _designLink;
    protected String _designFileId;
    protected String _realDesignFileName;
    protected Map<Object, String> _radicalEntities;
    protected int _methode = 2;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacDesignModelManager(IDesignLink designLink, String designFileName) {
        this._designLink = designLink;
        this._designFileId = designFileName;
    }

    public Object getRootObject() {
        this._realDesignFileName = PdpTool.addRPPFolderToFileName((String)this._designFileId);
        RadicalEntity radEntity = ModelUtil.getSharedRadicalEntity(this._designFileId);
        return radEntity;
    }

    protected void computeAllReferencedRadicalEntities(Object object, Map<Object, String> allReferencedRadicalEntities) {
        if (!(object instanceof RadicalEntity)) {
            return;
        }
        RadicalEntity radicalEntity = (RadicalEntity)object;
        if (radicalEntity.eIsProxy()) {
            return;
        }
        Map<Object, Object> calledInstances = this.getCalledInstances(radicalEntity);
        Set<Object> ciSet = calledInstances.keySet();
        for (Object key : ciSet) {
            String obj = allReferencedRadicalEntities.get(key);
            if (obj != null) continue;
            if (key instanceof PacProgram || key instanceof PacScreen || key instanceof PacServer || key instanceof PacDialog || key instanceof PacDialogServer) {
                PacGenerationHeader generationHeader = null;
                if (radicalEntity instanceof PacProgram) {
                    generationHeader = ((PacProgram)radicalEntity).getGenerationHeader();
                } else if (radicalEntity instanceof PacScreen) {
                    generationHeader = ((PacScreen)radicalEntity).getGenerationHeader();
                }
                if (generationHeader != null) {
                    RadicalEntity radEntity;
                    String fileName;
                    IFile file;
                    RadicalEntity calledByChapeau = null;
                    if (generationHeader instanceof PacSourceInheritanceGenerationHeader) {
                        calledByChapeau = ((PacSourceInheritanceGenerationHeader)generationHeader).getGeneratedRadicalEntity();
                    } else if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                        calledByChapeau = ((PacLibrarySubstitutionGenerationHeader)generationHeader).getGeneratedRadicalEntity();
                    }
                    if (calledByChapeau == key && (file = PdpTool.getFile((String)(fileName = PacTool.getFullCobolFileNameFromDesignFileName(radEntity = (RadicalEntity)key, null)))).exists()) {
                        allReferencedRadicalEntities.put(fileName, fileName);
                    }
                }
            }
            RadicalEntity aRE = (RadicalEntity)key;
            String entityFileName = aRE.getPath(aRE.getProject()).toString();
            allReferencedRadicalEntities.put(key, entityFileName);
            this.computeAllReferencedRadicalEntities(key, allReferencedRadicalEntities);
        }
    }

    private Map<Object, Object> getCalledInstances(RadicalEntity radicalEntity) {
        HashMap<Object, Object> calledInstances = new HashMap<Object, Object>();
        HashMap<URI, RadicalEntity> calledProxies = new HashMap<URI, RadicalEntity>();
        this.getCalledInstances((Entity)radicalEntity, calledInstances, calledProxies);
        return calledInstances;
    }

    private void getCalledInstances(Entity node, Map<Object, Object> calledInstances, Map<URI, RadicalEntity> calledProxies) {
        EList references = node.eClass().getEAllReferences();
        for (EReference relation : references) {
            int size;
            int i;
            List eObjects;
            Object eObject;
            KernelPackage kernelPackage;
            if (relation.isVolatile() || relation.isTransient() || relation == (kernelPackage = KernelPackage.eINSTANCE).getRadicalEntity_FunctionalDocumentation() || relation == kernelPackage.getRadicalEntity_TechnicalDocumentation() || relation == kernelPackage.getRadicalEntity_UserDocumentation() || relation == kernelPackage.getRadicalEntity_FunctionalDocumentation() || relation == kernelPackage.getRadicalEntity_Keywords() || relation == kernelPackage.getRadicalEntity_ExportInfo() || relation == kernelPackage.getDescriptionType_MetaEntityType() || relation == kernelPackage.getDescriptionType_Field() || (eObject = node.eGet((EStructuralFeature)relation)) == null) continue;
            if (relation.isContainment()) {
                if (eObject instanceof Entity && !(eObject instanceof PacGLine) && !(eObject instanceof PacDLine)) {
                    this.getCalledInstances((Entity)eObject, calledInstances, calledProxies);
                    continue;
                }
                if (!(eObject instanceof List)) continue;
                eObjects = (List)eObject;
                i = 0;
                size = eObjects.size();
                while (i < size) {
                    eObject = eObjects.get(i);
                    if (eObject instanceof Entity && !(eObject instanceof PacGLine) && !(eObject instanceof PacDLine)) {
                        this.getCalledInstances((Entity)eObject, calledInstances, calledProxies);
                    }
                    ++i;
                }
                continue;
            }
            if (eObject instanceof RadicalEntity) {
                this.registerCalledInstance((RadicalEntity)eObject, calledInstances, calledProxies);
                continue;
            }
            if (!(eObject instanceof List)) continue;
            eObjects = (List)eObject;
            i = 0;
            size = eObjects.size();
            while (i < size) {
                eObject = eObjects.get(i);
                if (eObject instanceof RadicalEntity) {
                    this.registerCalledInstance((RadicalEntity)eObject, calledInstances, calledProxies);
                }
                ++i;
            }
        }
    }

    private boolean includedTypes(Object eObject) {
        boolean excluded = eObject instanceof MetaEntity || eObject instanceof MetaEntityType || eObject instanceof UserEntity || eObject instanceof MetaDataAggregate || eObject instanceof PacText;
        return !excluded;
    }

    public Map<Object, String> getAllReferencedEntities(Object rootEntity) {
        if (!(rootEntity instanceof RadicalEntity)) {
            throw new RuntimeException("PacDesignModelManager.getAllReferencedEntities() : type not supported : " + (rootEntity == null ? "null" : rootEntity.getClass().getName()));
        }
        long a = System.currentTimeMillis();
        RadicalEntity radEntity = (RadicalEntity)rootEntity;
        int initialResolvingMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this._radicalEntities = new HashMap<Object, String>();
        this._radicalEntities.put(radEntity, this._realDesignFileName);
        this.computeAllReferencedRadicalEntities(radEntity, this._radicalEntities);
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("PacDesignModeManager. Nb of instances registered for (" + this._designFileId + ") : " + this._radicalEntities.size() + ". Elapsed (ms) = " + (b - a)));
        }
        PTEditorService.setResolvingMode((int)initialResolvingMode);
        return this._radicalEntities;
    }

    public Map<String, ILightModelEditor> listenToAll(Map<Object, String> refEntities) {
        long a = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("Start PacDesignModeManager.listenToAll for (" + this._designFileId + "). Nb to register : " + refEntities.size()));
        }
        HashMap<String, ILightModelEditor> editors = new HashMap<String, ILightModelEditor>();
        for (Object entity : refEntities.keySet()) {
            String fileName = refEntities.get(entity);
            ILightModelEditor editor = this.listenTo(entity, fileName);
            editors.put(fileName, editor);
        }
        if (Trace.traceOn) {
            long b = System.currentTimeMillis();
            Trace.outPrintln((String)("End PacDesignModeManager.listenToAll. Time elapsed (ms): " + (b - a)));
        }
        return editors;
    }

    public ILightModelEditor listenTo(Object object, String uri) {
        KernelLightEditor editor;
        if (object instanceof RadicalEntity) {
            editor = new KernelLightEditor(this._designLink, uri, (RadicalEntity)object);
        } else if (object instanceof String) {
            editor = new TextLightEditor(this._designLink, uri);
        } else {
            throw new RuntimeException("PacDesignModelManager.listenTo : Type not supported = " + (object == null ? "null" : object.getClass().getName()));
        }
        return editor;
    }

    protected void registerCalledInstance(RadicalEntity calledNode, Map<Object, Object> calledInstances, Map<URI, RadicalEntity> calledProxies) {
        if (calledNode.eIsProxy()) {
            return;
        }
        if (!this.includedTypes(calledNode)) {
            return;
        }
        if (calledInstances.containsKey(calledNode)) {
            return;
        }
        IPath path = calledNode.getPath(calledNode.getProject());
        RadicalEntity uniqueInstance = PTEditorService.getSharedResource((IPath)path);
        calledInstances.put(uniqueInstance, path.toString());
    }
}

