/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.designview.contentprovider;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.pacbase.PacDataStructureCall;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.mdl.pacbase.PacbaseFactory;
import com.ibm.pdp.mdl.pacbase.impl.PacSegmentCallImpl;
import com.ibm.pdp.pacbase.designview.contentprovider.VirtualPacSegmentCall;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class PacDataStructureTool {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static List<PacSegmentCall> getSegmentCalls(DataUnit dataUnit) {
        return PacDataStructureTool.getSegmentCalls(dataUnit, (Entity)dataUnit);
    }

    public static List<PacSegmentCall> getSegmentCalls(PacDataStructureCall pDataStructureCall) {
        if (pDataStructureCall.getSegmentCalls().size() == 0) {
            DataUnit dataUnit = pDataStructureCall.getDataStructure();
            List<PacSegmentCall> list = PacDataStructureTool.getSegmentCalls(dataUnit, (Entity)pDataStructureCall);
            return list;
        }
        List<PacSegmentCall> list = PacDataStructureTool.convertEListIntoList(pDataStructureCall.getSegmentCalls());
        return list;
    }

    public static List<PacSegmentCall> getSegmentCalls(PacWLineF wLine) {
        if (wLine.getSegmentCalls().size() == 0) {
            DataUnit dataUnit = wLine.getDataStructure();
            List<PacSegmentCall> list = PacDataStructureTool.getSegmentCalls(dataUnit, (Entity)wLine);
            return list;
        }
        List<PacSegmentCall> list = PacDataStructureTool.convertEListIntoList(wLine.getSegmentCalls());
        return list;
    }

    private static List<PacSegmentCall> getSegmentCalls(DataUnit dataUnit, Entity realParent) {
        ArrayList<PacSegmentCall> list = new ArrayList<PacSegmentCall>();
        EList segmentDataCall = dataUnit.getComponents();
        for (Object object : segmentDataCall) {
            DataAggregate segment = (DataAggregate)((DataCall)object).getDataDefinition();
            if (segment.eIsProxy()) continue;
            PacSegmentCall pSegmentCall = PacbaseFactory.eINSTANCE.createPacSegmentCall();
            pSegmentCall.setSegment(segment);
            pSegmentCall.setCodeInProgram(segment.getName().substring(2));
            VirtualPacSegmentCall vpc = new VirtualPacSegmentCall(realParent, (PacSegmentCallImpl)pSegmentCall);
            list.add((PacSegmentCall)vpc);
        }
        return list;
    }

    private static List<PacSegmentCall> convertEListIntoList(EList<?> segmentCalls) {
        ArrayList<PacSegmentCall> list = new ArrayList<PacSegmentCall>();
        for (Object object : segmentCalls) {
            PacSegmentCall pcs = (PacSegmentCall)object;
            DataAggregate da = pcs.getSegment();
            if (da.eIsProxy()) continue;
            list.add(pcs);
        }
        return list;
    }
}

