/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.designview.contentprovider;

import com.ibm.pdp.mdl.pacbase.PacAbstractCDLine;
import com.ibm.pdp.mdl.pacbase.PacAbstractCSLine;
import com.ibm.pdp.mdl.pacbase.PacAbstractWLine;
import com.ibm.pdp.mdl.pacbase.PacCommonLineDescription;
import com.ibm.pdp.pacbase.designview.contentprovider.PacDesignViewUtil;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import java.util.Comparator;

public class PacComparator
implements Comparator<Object> {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof PacAbstractWLine && o2 instanceof PacAbstractWLine) {
            PacAbstractWLine wLine1 = (PacAbstractWLine)o1;
            PacAbstractWLine wLine2 = (PacAbstractWLine)o2;
            StringBuilder s1 = new StringBuilder(wLine1.getCobolPosition());
            s1.append(wLine1.getLineNumber());
            StringBuilder s2 = new StringBuilder(wLine2.getCobolPosition());
            s2.append(wLine2.getLineNumber());
            return Ebcdic.stringCompare(s1.toString(), s2.toString());
        }
        if (o1 instanceof PacAbstractCDLine && o2 instanceof PacAbstractCDLine) {
            PacAbstractCDLine cdLine1 = (PacAbstractCDLine)o1;
            PacCommonLineDescription commonDesc1 = cdLine1.getCommonDescription();
            PacAbstractCDLine cdLine2 = (PacAbstractCDLine)o2;
            PacCommonLineDescription commonDesc2 = cdLine2.getCommonDescription();
            return Ebcdic.stringCompare(commonDesc1.getCodeInProgram(), commonDesc2.getCodeInProgram());
        }
        if (o1 instanceof PacAbstractCSLine && o2 instanceof PacAbstractCSLine) {
            PacAbstractCSLine csLine1 = (PacAbstractCSLine)o1;
            PacAbstractCSLine csLine2 = (PacAbstractCSLine)o2;
            StringBuilder s1 = new StringBuilder(csLine1.getCategoryNature().getName());
            s1.append(csLine1.getSegmentCode());
            s1.append(PacDesignViewUtil.convertA2digitsNumIntoA2CharsString(csLine1.getLineNumber()));
            StringBuilder s2 = new StringBuilder(csLine2.getCategoryNature().getName());
            s2.append(csLine2.getSegmentCode());
            s2.append(PacDesignViewUtil.convertA2digitsNumIntoA2CharsString(csLine2.getLineNumber()));
            return Ebcdic.stringCompare(s1.toString(), s2.toString());
        }
        throw new RuntimeException("Comparison between this kind of object is not supported");
    }
}

