/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.designview.contentprovider;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.framework.interfaces.IDesignLink;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataDefinition;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnion;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacDCLine;
import com.ibm.pdp.mdl.pacbase.PacDHLine;
import com.ibm.pdp.mdl.pacbase.PacDRLine;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacKLine;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacSourceInheritanceGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacStructuredLanguageEntity;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.design.ModelUtil;
import com.ibm.pdp.pacbase.designview.contentprovider.PacDataStructureTool;
import com.ibm.pdp.pacbase.designview.contentprovider.PacDesignModelManager;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;

public class CommonDesignModelMgr
extends PacDesignModelManager {
    protected static final String DATAUNIT_SUFFIX = "." + DataUnit.class.getSimpleName().toLowerCase();
    protected static final String DATAAGGREGATE_SUFFIX = "." + DataAggregate.class.getSimpleName().toLowerCase();
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CommonDesignModelMgr(IDesignLink designLink, String designFileName) {
        super(designLink, designFileName);
    }

    protected DataAggregate getSegmentCommonPartOfDataUnit(DataUnit du) {
        String duFullName = du.getPath(du.getProject()).toString();
        int idx = duFullName.indexOf(DATAUNIT_SUFFIX);
        String daName = String.valueOf(duFullName.substring(0, idx)) + "00" + DATAAGGREGATE_SUFFIX;
        DataAggregate daPartieCommune = (DataAggregate)PTEditorService.getSharedResource((IPath)new Path(daName));
        return daPartieCommune;
    }

    protected DataAggregate getSegmentCommonPartOfDataAggregate(DataAggregate da) {
        String daFullName = da.getPath(da.getProject()).toString();
        int idx = daFullName.indexOf(DATAAGGREGATE_SUFFIX);
        String daName = String.valueOf(daFullName.substring(0, idx - 2)) + "00" + DATAAGGREGATE_SUFFIX;
        DataAggregate daPartieCommune = (DataAggregate)PTEditorService.getSharedResource((IPath)new Path(daName));
        return daPartieCommune;
    }

    protected boolean register(String fileName) {
        if (this._radicalEntities.containsKey(fileName)) {
            return false;
        }
        IFile file = PdpTool.getFile((String)fileName);
        if (file.exists()) {
            this._radicalEntities.put(fileName, fileName);
        }
        return true;
    }

    protected boolean register(RadicalEntity radicalEntity) {
        if (radicalEntity == null || radicalEntity.eIsProxy()) {
            return false;
        }
        if (this._radicalEntities.containsKey(radicalEntity)) {
            return false;
        }
        String entityFileName = radicalEntity.getPath(radicalEntity.getProject()).toString();
        this._radicalEntities.put(radicalEntity, entityFileName);
        return true;
    }

    protected RadicalEntity visitGenerationHeader(PacGenerationHeader generationHeader) {
        RadicalEntity refEntity = null;
        refEntity = generationHeader instanceof PacLibrarySubstitutionGenerationHeader ? ((PacLibrarySubstitutionGenerationHeader)generationHeader).getGeneratedRadicalEntity() : ((PacSourceInheritanceGenerationHeader)generationHeader).getGeneratedRadicalEntity();
        this.register(refEntity);
        String fileName = PacTool.getFullCobolFileNameFromDesignFileName(refEntity, null);
        this.register(fileName);
        PacGenerationHeader pgh = null;
        if (refEntity instanceof PacProgram) {
            pgh = ((PacProgram)refEntity).getGenerationHeader();
        } else if (refEntity instanceof PacAbstractDialog) {
            pgh = ((PacAbstractDialog)refEntity).getGenerationHeader();
        } else if (refEntity instanceof PacAbstractDialogServer) {
            pgh = ((PacAbstractDialogServer)refEntity).getGenerationHeader();
        }
        if (pgh != null) {
            return this.visitGenerationHeader(pgh);
        }
        return refEntity;
    }

    protected void visitDataElement(DataElement dataElement) {
        this.register((RadicalEntity)dataElement);
        DataElement theParent = ModelUtil.getDataElementMotherIfUsedBy(dataElement);
        if (theParent != null) {
            this.register((RadicalEntity)theParent);
        }
    }

    protected void visitLibrary(PacLibrary library) {
        this.register((RadicalEntity)library);
    }

    private EList<?> getComponents(DataDescription dataDescription) {
        if (dataDescription instanceof DataAggregateDescription) {
            return ((DataAggregateDescription)dataDescription).getComponents();
        }
        if (dataDescription instanceof DataUnionDescription) {
            return ((DataUnionDescription)dataDescription).getRedefines();
        }
        return null;
    }

    protected void visitDataDescription(DataDescription elem) {
        if (!(elem instanceof DataAggregateDescription) && !(elem instanceof DataUnionDescription)) {
            return;
        }
        EList<?> components = this.getComponents(elem);
        int componentsSize = components.size();
        int i = 0;
        while (i < componentsSize) {
            Object iemeComponent = components.get(i);
            if (!(iemeComponent instanceof Filler)) {
                DataCall aDC = (DataCall)iemeComponent;
                DataDefinition dd = aDC.getDataDefinition();
                if (dd != null) {
                    if (dd instanceof DataElement) {
                        this.visitDataElement((DataElement)dd);
                    } else if (dd instanceof DataAggregate) {
                        this.visitDataAggregate((DataAggregate)dd);
                    } else if (dd instanceof DataUnion) {
                        this.visitDataUnion((DataUnion)dd);
                    } else {
                        Trace.errPrintln((String)("BatchModelAdapterAdapter.visitDataAggregateDescription : Unknow entity type" + dd.toString()));
                    }
                } else {
                    DataDescription internalDad = aDC.getDataDescription();
                    this.visitDataDescription(internalDad);
                }
            }
            ++i;
        }
    }

    protected void visitDataAggregate(DataAggregate dataAggregate) {
        if (dataAggregate == null) {
            return;
        }
        DataAggregateDescription elem = (DataAggregateDescription)dataAggregate.getDataDescription();
        boolean registrationOK = this.register((RadicalEntity)dataAggregate);
        if (registrationOK) {
            this.visitDataDescription((DataDescription)elem);
        }
    }

    protected void visitDataUnion(DataUnion dataUnion) {
        if (dataUnion == null) {
            return;
        }
        DataUnionDescription elem = (DataUnionDescription)dataUnion.getDataDescription();
        this.register((RadicalEntity)dataUnion);
        this.visitDataDescription((DataDescription)elem);
    }

    protected void visitDataUnit(DataUnit dataUnit) {
        this.register((RadicalEntity)dataUnit);
        List<PacSegmentCall> segmentCalls = PacDataStructureTool.getSegmentCalls(dataUnit);
        int i = 0;
        while (i < segmentCalls.size()) {
            PacSegmentCall psc = segmentCalls.get(i);
            this.visitDataAggregate(psc.getSegment());
            ++i;
        }
    }

    private void visitBlockBaseDCLine(PacDCLine dcLine) {
        DataAggregate segment = dcLine.getSegment();
        this.visitDataAggregate(segment);
        DataAggregate fromSegment = dcLine.getFromSegment();
        this.visitDataAggregate(fromSegment);
        DataAggregate child = dcLine.getChild();
        this.visitDataAggregate(child);
    }

    private void visitBlockBaseDHLine(PacDHLine dhLine) {
        DataAggregate parentSegment = dhLine.getParent();
        this.visitDataAggregate(parentSegment);
        DataAggregate segment = dhLine.getSegment();
        this.visitDataAggregate(segment);
    }

    private void visitBlockBaseDRLine(PacDRLine drLine) {
        DataAggregate segment = drLine.getSegment();
        this.visitDataAggregate(segment);
        EList kLines = drLine.getKLines();
        int kLinesSize = kLines.size();
        int i = 0;
        while (i < kLinesSize) {
            PacKLine kLine = (PacKLine)kLines.get(i);
            this.visitDataElement(kLine.getDataElement());
            ++i;
        }
    }

    protected void visitBlockBase(PacBlockBase blockBase) {
        if (blockBase == null) {
            return;
        }
        this.register((RadicalEntity)blockBase);
    }

    protected void visitMacro(PacStructuredLanguageEntity macro) {
        this.register((RadicalEntity)macro);
    }

    protected void visitCPLines(EList<?> cpLines) {
        PacStructuredLanguageEntity structLangEntity = null;
        int cpLinesSize = cpLines.size();
        PacStructuredLanguageEntity previous_structLangEntity = null;
        int i = 0;
        while (i < cpLinesSize) {
            PacCPLine cpLine = (PacCPLine)cpLines.get(i);
            structLangEntity = cpLine.getMacro();
            if (structLangEntity != previous_structLangEntity) {
                this.visitMacro(structLangEntity);
            }
            previous_structLangEntity = structLangEntity;
            EList parameters = cpLine.getParameters();
            int parametersSize = parameters.size();
            int j = 0;
            while (j < parametersSize) {
                PacMacroParameter pmp = (PacMacroParameter)parameters.get(j);
                if (pmp == null || "".equals(pmp.getValue())) break;
                ++j;
            }
            ++i;
        }
    }
}

