/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.design;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.IPTFolder;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacBlankWhenZeroValues;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementInternalUsageValues;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ModelUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static List<IPTElement> getByTypeOld(RadicalEntity radicalObject, String type) {
        String startProject = radicalObject.getProject();
        List projectsToSearchIn = PTNature.getPaths((String)startProject);
        IPTLocation location = PTModelService.getLocation((String)radicalObject.getLocation());
        IPTFolder folder = location.getFolder(type);
        Iterator instances = folder.elements();
        ArrayList<IPTElement> result = new ArrayList<IPTElement>();
        while (instances.hasNext()) {
            IPTElement element = (IPTElement)instances.next();
            String name = element.getProject().getName();
            if (!projectsToSearchIn.contains(name)) continue;
            boolean found = false;
            int j = 0;
            while (j < result.size()) {
                IPTElement e2 = (IPTElement)result.get(j);
                if (element.getName().equals(e2.getName())) {
                    int k2;
                    String p2 = e2.getProject().getName();
                    int k1 = projectsToSearchIn.indexOf(name);
                    if (k1 < (k2 = projectsToSearchIn.indexOf(p2))) {
                        result.remove(j);
                        break;
                    }
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) continue;
            result.add(element);
        }
        ModelUtil.trace(result);
        return result;
    }

    private static List<IPTElement> getByType(RadicalEntity radicalObject, String type) {
        String startProject = radicalObject.getProject();
        List projectsToSearchIn = PTNature.getPaths((String)startProject);
        IPTLocation location = PTModelService.getLocation((String)radicalObject.getLocation());
        IPTFolder folder = location.getFolder(type);
        Iterator instances = folder.elements();
        ArrayList<IPTElement> result = new ArrayList<IPTElement>();
        HashMap<String, IPTElement> temp = new HashMap<String, IPTElement>();
        while (instances.hasNext()) {
            IPTElement element = (IPTElement)instances.next();
            String projectName = element.getProject().getName();
            if (!projectsToSearchIn.contains(projectName)) continue;
            boolean found = false;
            IPTElement x = (IPTElement)temp.get(element.getName());
            if (x != null) {
                int k2;
                String p2 = x.getProject().getName();
                int k1 = projectsToSearchIn.indexOf(projectName);
                if (k1 >= (k2 = projectsToSearchIn.indexOf(p2))) {
                    found = true;
                }
            }
            if (found) continue;
            temp.put(element.getName(), element);
        }
        result.addAll(temp.values());
        return result;
    }

    private static void trace(List<IPTElement> result) {
        StringBuilder sb = new StringBuilder(result.size() * 20);
        int i = 0;
        while (i < result.size()) {
            IPTElement elem = result.get(i);
            sb.append(elem.getDocument().getId());
            sb.append("\r\n");
            ++i;
        }
        PdpTool.writeFileContents((String)sb.toString(), (String)"c:/modelUtilTrace_BNP_AUP009.txt");
        String[] g = sb.toString().split("\r\n");
        List<Object> l = new ArrayList();
        l = Arrays.asList(g);
        long a = System.currentTimeMillis();
        Collections.sort(l);
        long b = System.currentTimeMillis();
        System.out.println("elapsed=" + (b - a));
    }

    public static List<IPTElement> getAllDataUnits(RadicalEntity radicalObject, String projectName) {
        List<IPTElement> list = ModelUtil.getByType(radicalObject, DataUnit.class.getSimpleName().toLowerCase());
        return list;
    }

    public static List<IPTElement> getAllMacros(RadicalEntity radicalObject, String projectName) {
        List<IPTElement> list = ModelUtil.getByType(radicalObject, PacMacro.class.getSimpleName().toLowerCase());
        return list;
    }

    public static List<IPTElement> getAllReports(RadicalEntity radicalObject, String projectName) {
        List<IPTElement> list = ModelUtil.getByType(radicalObject, PacReport.class.getSimpleName().toLowerCase());
        return list;
    }

    public static List<IPTElement> getAllDataElement(RadicalEntity radicalObject, String projectName) {
        List<IPTElement> list = ModelUtil.getByType(radicalObject, DataElement.class.getSimpleName().toLowerCase());
        return list;
    }

    public static DataElement getDataElementMother(DataElement aDE) {
        if (aDE == null || aDE.eIsProxy()) {
            return null;
        }
        DataElementDescription ded = (DataElementDescription)aDE.getDataDescription();
        for (Object obj : ded.getExtensions()) {
            if (!(obj instanceof PacDataElementDescription)) continue;
            return ((PacDataElementDescription)obj).getParent();
        }
        return null;
    }

    public static DataElement getDataElementMotherIfUsedBy(DataElement aDE) {
        if (aDE == null || aDE.eIsProxy()) {
            return null;
        }
        DataElementDescription ded = (DataElementDescription)aDE.getDataDescription();
        for (Object obj : ded.getExtensions()) {
            if (!(obj instanceof PacDataElementDescription)) continue;
            PacDataElementDescription pded = (PacDataElementDescription)obj;
            if (pded.getInputFormat().length() > 0) {
                return ((PacDataElementDescription)obj).getParent();
            }
            if (pded.getInternalFormat().length() > 0) {
                return ((PacDataElementDescription)obj).getParent();
            }
            if (pded.getOutputFormat().length() > 0) {
                return ((PacDataElementDescription)obj).getParent();
            }
            if (pded.getInternalUsage().equals(PacDataElementInternalUsageValues._INHERITED_LITERAL)) {
                return ((PacDataElementDescription)obj).getParent();
            }
            if (pded.getBlkWhenZero().equals(PacBlankWhenZeroValues._INHERITED_LITERAL)) {
                return ((PacDataElementDescription)obj).getParent();
            }
            if (pded.getType() != PacDataElementTypeValues._INHERITED_LITERAL) continue;
            return ((PacDataElementDescription)obj).getParent();
        }
        return null;
    }

    public static List<IPTElement> getAllScreen(RadicalEntity radicalObject, String projectName) {
        List<IPTElement> list = ModelUtil.getByType(radicalObject, PacScreen.class.getSimpleName().toLowerCase());
        return list;
    }

    public static List<IPTElement> getAllServers(RadicalEntity radicalObject, String projectName) {
        List<IPTElement> list = ModelUtil.getByType(radicalObject, PacServer.class.getSimpleName().toLowerCase());
        return list;
    }

    public static List<IPTElement> getAllDataAggregates(RadicalEntity radicalObject, String projectName) {
        List<IPTElement> list = ModelUtil.getByType(radicalObject, DataAggregate.class.getSimpleName().toLowerCase());
        return list;
    }

    public static RadicalEntity getSharedRadicalEntity(IPath realDesignEntityPath) {
        int originalResolvingMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        RadicalEntity radEntity = PTEditorService.getSharedResource((IPath)realDesignEntityPath);
        PTEditorService.setResolvingMode((int)originalResolvingMode);
        return radEntity;
    }

    public static RadicalEntity getSharedRadicalEntity(String logicalDesignEntityPath) {
        String s = PdpTool.addRPPFolderToFileName((String)logicalDesignEntityPath);
        Path realDesignEntityPath = new Path(s);
        return ModelUtil.getSharedRadicalEntity((IPath)realDesignEntityPath);
    }

    public static RadicalEntity getSharedRadicalEntity(IFile file) {
        IPath realDesignEntityPath = file.getFullPath();
        return ModelUtil.getSharedRadicalEntity(realDesignEntityPath);
    }

    public static String getProjectFromRadicalObject(String fullFileName) {
        if (fullFileName == null || fullFileName.length() < 4) {
            return null;
        }
        int index = fullFileName.indexOf(47, 1);
        String destination = fullFileName.substring(1, index);
        return destination;
    }
}

