/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.analyzeCobols;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.tool.PTProjectCriterion;
import com.ibm.pdp.explorer.view.provider.PTProjectContentProvider;
import com.ibm.pdp.explorer.view.provider.PTProjectLabelProvider;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.view.tool.PTContainerCheckedTreeViewer;
import com.ibm.pdp.explorer.view.tool.PTProjectSorter;
import com.ibm.pdp.pacbase.analyzeCobols.PTAnalyzeCblLabel;
import com.ibm.pdp.pdppath.service.PdpPathService;
import com.ibm.pdp.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PTAnalyzeCblWizardPage
extends WizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected IEclipsePreferences _prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.explorer");
    public PTContainerCheckedTreeViewer _cbtrvProjects;
    private Button _pbInAll;
    private Button _pbInNone;
    protected Button _rdbAllLocations;
    protected Button _rdbLocation;
    protected Combo _cbbLocation;
    public int _locationScope = 0;
    public String _locationName = "";
    private PTLocation _location;
    public static final int _ALL_LOCATIONS = 0;
    public static final int _LOCATION = 1;
    public Set<IResource> _lsSelectedProject;

    public PTAnalyzeCblWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_PAGE_TITLE));
        this.setDescription(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_PAGE_DESC));
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.COBOL_analysis";
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        this.setHelp(composite);
        this.createLocationGroup(composite);
        this.createProjectsGroup(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setupData();
        this.refresh();
        this.setControl((Control)composite);
    }

    protected void createLocationGroup(Composite parent) {
        String groupLabel = PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._LOCATION_SCOPE);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (int)1, (String)groupLabel);
        String rdbLabel = PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ALL_LOCATIONS);
        this._rdbAllLocations = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false, (int)2);
        this._rdbAllLocations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTAnalyzeCblWizardPage.this.handleButtonSelected(e);
            }
        });
        this.addAccessibleListener((Control)this._rdbAllLocations, group.getText());
        rdbLabel = PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._OPENED_LOCATION);
        this._rdbLocation = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false);
        this._rdbLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTAnalyzeCblWizardPage.this._cbbLocation.setEnabled(PTAnalyzeCblWizardPage.this._rdbLocation.getSelection());
                PTAnalyzeCblWizardPage.this.handleButtonSelected(e);
            }
        });
        this.addAccessibleListener((Control)this._rdbLocation, group.getText());
        this._cbbLocation = PTWidgetTool.createCombo((Composite)group);
        this._cbbLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTAnalyzeCblWizardPage.this.handleComboSelected(e);
            }
        });
        this.addAccessibleListener((Control)this._cbbLocation, group.getText());
    }

    private void createProjectsGroup(Composite parent) {
        String groupLabel = PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._SEARCH_IN);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)groupLabel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
        Composite tablePane = PTWidgetTool.createComposite((Composite)group, (int)5, (int)1, (boolean)false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tablePane);
        this._cbtrvProjects = new PTContainerCheckedTreeViewer(tablePane, 2176);
        GridDataFactory.fillDefaults().grab(true, true).span(5, 1).applyTo((Control)this._cbtrvProjects.getTree());
        this._cbtrvProjects.setContentProvider((IContentProvider)new PTProjectContentProvider());
        this._cbtrvProjects.setLabelProvider((IBaseLabelProvider)new PTProjectLabelProvider());
        this._cbtrvProjects.setComparator((ViewerComparator)new PTProjectSorter());
        this._cbtrvProjects.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PTAnalyzeCblWizardPage.this.setPageComplete(PTAnalyzeCblWizardPage.this.isPageComplete());
            }
        });
        this.addAccessibleListener(this._cbtrvProjects.getControl(), group.getText());
        Composite buttonPane = PTWidgetTool.createComposite((Composite)group, (int)1, (boolean)false);
        buttonPane.setLayoutData((Object)new GridData(4));
        String pbLabel = PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ALL_SELECTED);
        this._pbInAll = PTWidgetTool.createPushButton((Composite)buttonPane, (String)pbLabel, (boolean)true);
        this._pbInAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTAnalyzeCblWizardPage.this.setProjectsCheckState(true);
                PTAnalyzeCblWizardPage.this.setPageComplete(PTAnalyzeCblWizardPage.this.isPageComplete());
            }
        });
        this.addAccessibleListener((Control)this._pbInAll, group.getText());
        pbLabel = PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._NONE_SELECTED);
        this._pbInNone = PTWidgetTool.createPushButton((Composite)buttonPane, (String)pbLabel, (boolean)true);
        this._pbInNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTAnalyzeCblWizardPage.this.setProjectsCheckState(false);
                PTAnalyzeCblWizardPage.this.setPageComplete(PTAnalyzeCblWizardPage.this.isPageComplete());
            }
        });
        this.addAccessibleListener((Control)this._pbInNone, group.getText());
    }

    protected void setProjectsCheckState(boolean state) {
        Collection inputList = (Collection)this._cbtrvProjects.getInput();
        for (Object element : inputList) {
            this._cbtrvProjects.setSubtreeChecked(element, state);
        }
    }

    protected void addAccessibleListener(Control control, final String text) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = e.result != null && e.result.length() > 0 ? String.valueOf(text) + e.result : text;
            }
        });
    }

    public boolean isPageComplete() {
        if (this._cbtrvProjects.getCheckedElements().length == 0) {
            return false;
        }
        return !this._rdbLocation.getSelection() || this._cbbLocation.getText() != null && this._cbbLocation.getText().length() != 0;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    PTAnalyzeCblWizardPage.this.analyzeProjects(projects, monitor);
                }
            };
            try {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                progressDialog.run(true, true, operation);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    PTMessageManager.handleStackTrace((Throwable)e.getCause());
                } else {
                    PTMessageManager.handleStackTrace((Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (e.getCause() != null) {
                    PTMessageManager.handleStackTrace((Throwable)e.getCause());
                }
                PTMessageManager.handleStackTrace((Throwable)e);
            }
        }
        super.setVisible(visible);
    }

    private void analyzeProjects(IProject[] projects, IProgressMonitor monitor) {
        monitor.beginTask("", projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                String projectName = project.getName();
                Object[] array = new String[]{projectName};
                monitor.setTaskName(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_PROJECTS, array));
                IProject rootMember = project;
                String rppFolder = PdpPathService.getRppRootFolder((String)projectName);
                if (rppFolder != null && rppFolder.length() > 0) {
                    rootMember = project.getFolder(rppFolder);
                }
                HashSet<String> projectDesignIds = new HashSet<String>();
                ArrayList<IFile> designFiles = new ArrayList<IFile>();
                this.collectCobolFiles(designFiles, (IResource)rootMember);
                for (IFile file : designFiles) {
                    String designId = PTElement.getDesignId((IPath)file.getFullPath());
                    projectDesignIds.add(designId);
                }
            }
            if (monitor.isCanceled()) break;
            monitor.worked(1);
            ++n2;
        }
    }

    private void collectCobolFiles(List<IFile> files, IResource resource) {
        IResource[] members = new IResource[]{};
        try {
            if (resource.isAccessible() && resource instanceof IProject) {
                members = ((IProject)resource).members();
            }
        }
        catch (CoreException e) {
            throw Util.rethrow((Throwable)e);
        }
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member instanceof IFile) {
                IFile file = (IFile)member;
                if (file.getFullPath().getFileExtension() != null && file.getFullPath().getFileExtension().equals("cbl")) {
                    files.add(file);
                }
            } else if (member instanceof IFolder) {
                IFolder folder = (IFolder)member;
                folder.getFullPath();
                this.collectCobolFiles(files, member);
            }
            ++i;
        }
    }

    protected void refreshLocation(String location, Set<String> locations) {
        this._cbbLocation.removeAll();
        for (String text : locations) {
            this._cbbLocation.add(text);
        }
        if (location != null && locations.contains(location)) {
            this._cbbLocation.setText(location);
        } else if (locations.size() > 0) {
            this._cbbLocation.setText(locations.iterator().next());
        } else {
            this._cbbLocation.setText("");
        }
    }

    private Set<String> getCheckedProjects() {
        Object[] checkedObjects;
        HashSet<String> checkedProjects = new HashSet<String>();
        Object[] objectArray = checkedObjects = this._cbtrvProjects.getCheckedElements();
        int n = checkedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedObject = objectArray[n2];
            if (checkedObject instanceof PTProjectCriterion) {
                checkedProjects.add(((PTProjectCriterion)checkedObject).getName());
            }
            ++n2;
        }
        return checkedProjects;
    }

    protected void refresh() {
        boolean all = true;
        this._rdbAllLocations.setSelection(all);
        this._rdbLocation.setSelection(!all);
        this._cbbLocation.setEnabled(!all);
        this._cbtrvProjects.setInput(this.refreshProjects());
        this._cbtrvProjects.expandAll();
        this.setProjectsCheckState(true);
        this.refreshProjectsCheckState((Set)this._cbtrvProjects.getInput());
    }

    protected Set<PTProjectCriterion> organizeProjects(Map<String, PTProjectCriterion> allProjects) {
        TreeSet<PTProjectCriterion> projectRoots = new TreeSet<PTProjectCriterion>(new Comparator<PTProjectCriterion>(){

            @Override
            public int compare(PTProjectCriterion project1, PTProjectCriterion project2) {
                return project1.getName().compareTo(project2.getName());
            }
        });
        for (PTProjectCriterion project : allProjects.values()) {
            projectRoots.add(project);
        }
        return projectRoots;
    }

    protected void organizeSelectedProjects(Map<String, IResource> allProjects) {
        TreeSet<IResource> projectRoots = new TreeSet<IResource>(new Comparator<IResource>(){

            @Override
            public int compare(IResource project1, IResource project2) {
                return project1.getName().compareTo(project2.getName());
            }
        });
        for (IResource project : allProjects.values()) {
            projectRoots.add(project);
        }
        this._lsSelectedProject = projectRoots;
    }

    protected void refreshProjectsCheckState(Set<PTProjectCriterion> projects) {
        for (PTProjectCriterion project : projects) {
            boolean state = this.getCheckedProjects().size() == 0 || this.getCheckedProjects().contains(project.getName());
            this._cbtrvProjects.setChecked((Object)project, state);
            this.refreshProjectsCheckState(project.getChildren());
        }
    }

    protected void setupData() {
        TreeSet<String> locations = new TreeSet<String>();
        for (PTLocation location : PTModelManager.getLocations()) {
            if (!location.isOpened()) continue;
            locations.add(location.getName());
        }
        this.refreshLocation(this._locationName, locations);
    }

    public void handleButtonSelected(SelectionEvent e) {
        if (e.widget == this._rdbLocation) {
            this._locationName = this._cbbLocation.getText();
            this._location = PTModelManager.getLocation((String)this._locationName);
        }
        if (e.widget == this._rdbAllLocations) {
            this._locationName = "";
        }
        this._cbtrvProjects.setInput(this.refreshProjects());
        this._cbtrvProjects.expandAll();
        this.setProjectsCheckState(true);
        this.refreshProjectsCheckState((Set)this._cbtrvProjects.getInput());
    }

    public void handleComboSelected(SelectionEvent e) {
        if (e.widget == this._cbbLocation) {
            this._locationName = this._cbbLocation.getText();
            this._location = PTModelManager.getLocation((String)this._locationName);
            this._cbtrvProjects.setInput(this.refreshProjects());
            this._cbtrvProjects.expandAll();
            this.setProjectsCheckState(true);
            this.refreshProjectsCheckState((Set)this._cbtrvProjects.getInput());
        }
    }

    private Set<PTProjectCriterion> refreshProjects() {
        IProject project;
        HashMap<String, PTProjectCriterion> allProjects = new HashMap<String, PTProjectCriterion>();
        HashMap<String, IResource> selectedProjects = new HashMap<String, IResource>();
        if (this._locationName.equals("")) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                project = iProjectArray[n2];
                for (PTLocation location : PTModelManager.getLocations()) {
                    if (location == null || !location.isOpened() || !project.getName().startsWith(location.getName())) continue;
                    allProjects.put(project.getName(), new PTProjectCriterion(project.getName(), location.getName(), "layer"));
                    selectedProjects.put(project.getName(), (IResource)project);
                }
                ++n2;
            }
        } else {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                project = iProjectArray[n3];
                if (this._location != null && this._location.isOpened() && project.getName().startsWith(this._location.getName())) {
                    allProjects.put(project.getName(), new PTProjectCriterion(project.getName(), this._location.getName(), "layer"));
                    selectedProjects.put(project.getName(), (IResource)project);
                }
                ++n3;
            }
        }
        Set<PTProjectCriterion> projectRoots = this.organizeProjects(allProjects);
        this.refreshProjectsCheckState(projectRoots);
        this.organizeSelectedProjects(selectedProjects);
        return projectRoots;
    }

    public void setHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getContextId());
    }

    protected void addFocusListener(Text txtControl) {
        txtControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                PTAnalyzeCblWizardPage.this.handleFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
                PTAnalyzeCblWizardPage.this.handleFocusLost(e);
            }
        });
    }

    protected void handleFocusGained(FocusEvent e) {
    }

    protected void handleFocusLost(FocusEvent e) {
    }

    protected void addModifyListener(Text txtControl) {
        txtControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PTAnalyzeCblWizardPage.this.handleModifyText(e);
            }
        });
    }

    protected void handleModifyText(ModifyEvent e) {
    }

    protected void addSelectionListener(Button pbControl) {
        pbControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PTAnalyzeCblWizardPage.this.handleButtonSelected(e);
            }
        });
    }

    public Object[] getSelectedProjects() {
        ArrayList<IResource> list = new ArrayList<IResource>();
        for (IResource prj : this._lsSelectedProject) {
            Object[] objectArray = this._cbtrvProjects.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                PTProjectCriterion projet;
                Object checkedObject = objectArray[n2];
                if (checkedObject instanceof PTProjectCriterion && (projet = (PTProjectCriterion)checkedObject).getName().equals(prj.getName())) {
                    list.add(prj);
                }
                ++n2;
            }
        }
        return list.toArray();
    }
}

