/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.analyzeCobols;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IControllerFactory;
import com.ibm.pdp.pacbase.analyzeCobols.PTAnalyzeCblLabel;
import com.ibm.pdp.pacbase.analyzeCobols.PTAnalyzeCblWizardPage;
import com.ibm.pdp.pacbase.analyzeCobols.PTAsyncJob;
import com.ibm.pdp.pacbase.extension.organize.PacRightMarginMarkerUpdateExtension;
import com.ibm.pdp.pdppath.service.PdpPathService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class PTAnalyzeCblWizard
extends Wizard {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public PTAnalyzeCblWizardPage _locationPage;

    public PTAnalyzeCblWizard() {
        this.setWindowTitle(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_PAGE_TITLE));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this._locationPage = new PTAnalyzeCblWizardPage("rebuildCblPage_ID");
        this.addPage((IWizardPage)this._locationPage);
    }

    public boolean canFinish() {
        return this._locationPage.isPageComplete();
    }

    public void analyzeCobols(IProgressMonitor progress, Object[] selectedProjects) {
        progress.beginTask(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._SEARCH_CBL), 100);
        float step = 0.0f;
        int cumul2 = 0;
        int done = 0;
        progress.setTaskName(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._SEARCH_CBL));
        ArrayList<String> _workspaceCblFilesNames = new ArrayList<String>();
        try {
            if (selectedProjects.length > 0) {
                step = 0.5f;
                List<IResource> list = this.transformToListofResources(selectedProjects);
                for (IResource aMember : list) {
                    this.addAllCblFilesOf(aMember, progress, _workspaceCblFilesNames);
                    if (!progress.isCanceled()) continue;
                    return;
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        int nbFiles = _workspaceCblFilesNames.size();
        if (nbFiles > 0) {
            progress.setTaskName(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_IN_PROGRESS));
            int currentFile = 0;
            step = 1.0f;
            StringBuilder subTaskName = null;
            for (String afilename : _workspaceCblFilesNames) {
                if (progress.isCanceled()) {
                    return;
                }
                subTaskName = new StringBuilder("(");
                subTaskName.append(currentFile).append("/").append(nbFiles).append(") : ").append(afilename);
                progress.subTask(subTaskName.toString());
                cumul2 = ++currentFile * 100 / nbFiles;
                if (cumul2 != done) {
                    progress.worked(cumul2 - done);
                    done = cumul2;
                }
                IController controller = ControllerFactory.getInstance().getController(afilename);
                IFile sourceCodeFile = PdpTool.getFile((String)afilename);
                System.setProperty("globalAnalyzisCobols", "true");
                PacRightMarginMarkerUpdateExtension ext = new PacRightMarginMarkerUpdateExtension();
                ext.updateMarkersOnly(controller, null, sourceCodeFile);
            }
            progress.subTask("");
            progress.worked(100);
            progress.done();
        }
    }

    private List<IResource> transformToListofResources(Object[] selectedProjects) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        Object[] objectArray = selectedProjects;
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object prj = objectArray[n2];
            list.add((IResource)prj);
            ++n2;
        }
        return list;
    }

    private void addAllCblFilesOf(IResource aMember, IProgressMonitor progress, List<String> _workspaceCblFilesNames) throws CoreException {
        if (progress.isCanceled()) {
            return;
        }
        if (aMember instanceof IContainer) {
            IResource[] members;
            if (aMember instanceof IProject && !((IProject)aMember).isOpen()) {
                return;
            }
            IResource[] iResourceArray = members = ((IContainer)aMember).members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aRes = iResourceArray[n2];
                if (aRes instanceof IFile) {
                    IPath path = aRes.getFullPath();
                    if (path.getFileExtension() != null && path.getFileExtension().endsWith("cbl")) {
                        String filename = path.toString();
                        _workspaceCblFilesNames.add(filename);
                    }
                } else {
                    this.addAllCblFilesOf(aRes, progress, _workspaceCblFilesNames);
                }
                ++n2;
            }
        } else {
            IPath path = aMember.getFullPath();
            if (path.getFileExtension() != null && path.getFileExtension().endsWith("cbl")) {
                String filename = aMember.getLocation().toOSString();
                _workspaceCblFilesNames.add(filename);
            }
        }
    }

    public static IPath getPdpFilePath(IPath generatedFilePath) {
        String projectName = generatedFilePath.segment(0);
        String genRoot = PdpPathService.getGenRootFolder((String)projectName);
        String pdpRoot = PdpPathService.getMetaPdpRootFolder((String)projectName);
        if (genRoot == null) {
            genRoot = "";
        }
        if (pdpRoot == null || pdpRoot.trim().length() == 0) {
            pdpRoot = genRoot;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('/').append(projectName);
        if (!genRoot.equals(pdpRoot)) {
            buffer.append('/').append(pdpRoot);
        }
        int i = 1;
        while (i < generatedFilePath.segmentCount()) {
            if (i == generatedFilePath.segmentCount() - 1) {
                buffer.append('/').append(generatedFilePath.segment(i)).append("pdp");
            } else {
                buffer.append('/').append(generatedFilePath.segment(i));
            }
            ++i;
        }
        Path pdpFilePath = new Path(buffer.toString());
        return pdpFilePath;
    }

    public boolean performFinish() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IEditorReference[] allEditors = PdpTool.findAllOpenedEditors();
        if (allEditors.length != 0) {
            MessageDialog.openError((Shell)shell, (String)PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_PAGE_TITLE), (String)PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_OPENED_EDITORS));
            return false;
        }
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        final Object[] selectedProjects = this._locationPage.getSelectedProjects();
        ArrayList statusList = new ArrayList();
        Job[] jobs = Job.getJobManager().find((Object)"RPP_FAMILY");
        if (jobs.length > 0) {
            PTMessageManager.handleWarning((String)PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ASYNC_TASK_IN_PROGRESS));
            return true;
        }
        PTAsyncJob searchJob = new PTAsyncJob(PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_PAGE_TITLE)){

            protected IStatus run(IProgressMonitor monitor) {
                IControllerFactory factory = ControllerFactory.getInstance();
                if (factory instanceof ControllerFactory) {
                    ((ControllerFactory)factory).disposeAllControlers();
                }
                PTAnalyzeCblWizard.this.analyzeCobols(monitor, selectedProjects);
                monitor.done();
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        if (statusList.size() > 0) {
            String reportTitle = PTAnalyzeCblLabel.getString(PTAnalyzeCblLabel._ANALYZE_PAGE_TITLE);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, reportTitle, null);
            for (IStatus status : statusList) {
                multiStatus.add(status);
            }
            PTMessageManager.handleErrors((String)reportTitle, (MultiStatus)multiStatus);
        }
        shell.setCursor(null);
        searchJob.setPriority(10);
        searchJob.setUser(true);
        searchJob.schedule();
        return true;
    }
}

