/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.actionpolicy;

import com.ibm.pdp.engine.internal.ITextSegment;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.IPTFolder;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.IPTProject;
import com.ibm.pdp.explorer.model.service.IPTSearchPattern;
import com.ibm.pdp.explorer.model.service.PTActionResult;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.model.service.PTSearchPattern;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.explorer.plugin.IPTActionPolicy;
import com.ibm.pdp.explorer.plugin.PTActionPolicy;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.util.CharsetUtil;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataDefinition;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.kernel.impl.RadicalEntityImpl;
import com.ibm.pdp.mdl.link.design.MacrosMicroPatternsAndDEUsagesParser;
import com.ibm.pdp.mdl.link.design.MicroPatternsAndDEUsagesResults;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogFolderView;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataAggregateTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataUnit;
import com.ibm.pdp.mdl.pacbase.PacDataUnitTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogFolderView;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacErrorLabel;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacStructuredLanguageEntity;
import com.ibm.pdp.mdl.pacbase.PacbaseFactory;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.pacbase.actionpolicy.Messages;
import com.ibm.pdp.pacbase.xrefs.CobolMicroPatternsAndDEUsagesParser;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;

public class PacActionPolicy
extends PTActionPolicy
implements IPTActionPolicy {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final String CR = "\r";
    private static final String LFCR = "\n\r";
    private static final String REF = "REF=";
    private static final String BEGIN_OFFSET = "begin";
    private static final String END_OFFSET = "end";
    private static final String LINE_OFFSET = "lineOff";
    private static final String CONTEXTUAL_LINE = "ctx";
    private static final String OFFSET = "offset";
    public static final String _MSP_USER = "\u00a3\u00a3USER";
    public static final String _MSP_80EX = "\u00a3\u00a380EX";
    private static final int COBOL_RIGHT_MARGIN = 72;
    private HashMap<String, String> designToRegenerate;
    private ArrayList<String> cobolsToModify;
    private ArrayList<String> macrosToModify;
    private ArrayList<String> screensToModify;
    private ArrayList<String> serversToModify;
    private ArrayList<String> programsToModify;
    private ArrayList<String> noValidatedGeneratedFiles;
    private String currentDesignID;

    public String getFacetName() {
        return "pacbase";
    }

    public boolean acceptAction(IPTActionPolicy.PTActionKind actionKind, String designId) {
        String[] tokens;
        if ((actionKind == IPTActionPolicy.PTActionKind.Create || actionKind == IPTActionPolicy.PTActionKind.Copy || actionKind == IPTActionPolicy.PTActionKind.Paste || actionKind == IPTActionPolicy.PTActionKind.Rename || actionKind == IPTActionPolicy.PTActionKind.Move || actionKind == IPTActionPolicy.PTActionKind.Delete) && (tokens = MetadataService.getTokens((String)designId))[4].equalsIgnoreCase(PacbasePackage.eINSTANCE.getPacMacro().getName()) && (tokens[2].equalsIgnoreCase(_MSP_USER) || tokens[2].equalsIgnoreCase(_MSP_80EX))) {
            return false;
        }
        return super.acceptAction(actionKind, designId);
    }

    public void cancelAction(IPTActionPolicy.PTActionKind actionKind, String designId) {
        if (actionKind == IPTActionPolicy.PTActionKind.Rename) {
            this.cobolsToModify = null;
            this.macrosToModify = null;
            this.noValidatedGeneratedFiles = null;
            this.currentDesignID = null;
        }
    }

    public void postProcessAdd(String designId, Set<String> addedIds, IProgressMonitor monitor) {
        if (addedIds == null) {
            addedIds = Collections.emptySet();
        }
        String type = MetadataService.getType((String)designId);
        if (KernelPackage.eINSTANCE.getDataAggregate().getName().equalsIgnoreCase(type)) {
            if (addedIds.isEmpty()) {
                String[] tokens = MetadataService.getTokens((String)designId);
                if (tokens[2].length() < 2) {
                    return;
                }
                String dsName = tokens[2].substring(0, 2);
                DataUnit dataStructure = this.retrieveDataStructure(tokens[0], dsName);
                if (dataStructure != null) {
                    DataAggregate segment = this.addSegmentCall(dataStructure, tokens[2]);
                    try {
                        dataStructure.save();
                    }
                    catch (IOException iOException) {}
                    PTModelService.deleteMarkers((RadicalEntity)segment);
                    PTModelService.checkMarkers((RadicalEntity)dataStructure, (boolean)true);
                    this.checkLowerHierarchy(dataStructure, tokens[2]);
                }
            }
        } else if (KernelPackage.eINSTANCE.getDataUnit().getName().equalsIgnoreCase(type) && !addedIds.isEmpty()) {
            String[] tokens = MetadataService.getTokens((String)designId);
            this.checkOrphanSegments(tokens[0], tokens[2], addedIds);
        }
    }

    public void postProcessUpdate(String designId, Set<String> updatedIds, IProgressMonitor monitor) {
        String[] tokens = MetadataService.getTokens((String)designId);
        if (KernelPackage.eINSTANCE.getDataUnit().getName().equalsIgnoreCase(tokens[4])) {
            this.checkOrphanSegments(tokens[0], tokens[2], updatedIds);
        }
    }

    private void checkOrphanSegments(String dsProject, String dsName, Set<String> excludedIds) {
        PTNature nature;
        if (excludedIds == null) {
            excludedIds = Collections.emptySet();
        }
        if ((nature = PTNature.getNature((String)dsProject)) == null) {
            return;
        }
        IPTLocation location = PTModelService.getLocation((String)nature.getLocation());
        HashSet upperProjects = new HashSet();
        upperProjects.addAll(PTNature.getPaths((String)dsProject));
        HashSet<IPTElement> toCheckSegments = new HashSet<IPTElement>();
        IPTFolder segmentFolder = location.getFolder(KernelPackage.eINSTANCE.getDataAggregate().getName().toLowerCase());
        Iterator allSegments = segmentFolder.elements();
        while (allSegments.hasNext()) {
            IPTElement segment = (IPTElement)allSegments.next();
            if (!upperProjects.contains(segment.getProject().getName()) || !segment.getName().startsWith(dsName) || excludedIds.contains(segment.getDocument().getId())) continue;
            toCheckSegments.add(segment);
        }
        for (IPTElement segment : toCheckSegments) {
            RadicalEntity radicalObject = PTModelService.getResource((String)segment.getDocument().getProject(), (String)segment.getDocument().getPackage(), (String)segment.getName(), (String)KernelPackage.eINSTANCE.getDataAggregate().getName().toLowerCase());
            if (radicalObject == null) continue;
            PTModelService.checkMarkers((RadicalEntity)radicalObject, (boolean)true);
        }
    }

    private DataUnit retrieveDataStructure(String projectName, String dsName) {
        PTNature nature = PTNature.getNature((String)projectName);
        if (nature == null) {
            return null;
        }
        IPath relativePath = PTModelService.getPath((String)projectName, (String)"", (String)dsName, (String)KernelPackage.eINSTANCE.getDataUnit().getName().toLowerCase());
        DataUnit dsObject = (DataUnit)PTModelService.getResource((IPath)relativePath);
        DataUnit upperObject = null;
        List upperProjects = nature.getRequiredPaths();
        for (String upperProject : upperProjects) {
            relativePath = PTModelService.getPath((String)upperProject, (String)"", (String)dsName, (String)KernelPackage.eINSTANCE.getDataUnit().getName().toLowerCase());
            upperObject = (DataUnit)PTModelService.getResource((IPath)relativePath);
            if (upperObject != null) break;
        }
        if (dsObject == null) {
            if (upperObject == null) {
                dsObject = KernelFactory.eINSTANCE.createDataUnit();
                dsObject.setProject(projectName);
                dsObject.setName(dsName);
                dsObject.setLabel("...");
                dsObject.setLocation(nature.getLocation());
                PacDataUnit pacDefinition = PacbaseFactory.eINSTANCE.createPacDataUnit();
                pacDefinition.setAlias(dsName);
                dsObject.getExtensions().add((Object)pacDefinition);
            } else {
                String masterStateId = upperObject.getStateId();
                upperObject.setProject(projectName);
                dsObject = upperObject;
                dsObject.setMasterStateId(masterStateId);
            }
            PacLibrary pacLibrary = this.searchPacLibrary(projectName);
            if (pacLibrary != null) {
                for (RadicalEntityExtension extension : dsObject.getExtensions()) {
                    if (!(extension instanceof PacDataUnit)) continue;
                    PacDataUnit pacDefinition = (PacDataUnit)extension;
                    pacDefinition.setGenerationParameter(pacLibrary);
                    pacDefinition.setSkeletonLanguage(pacLibrary.getSkeletonLanguage());
                    break;
                }
            }
        }
        return dsObject;
    }

    private DataAggregate addSegmentCall(DataUnit dataStructure, String segmentName) {
        DataAggregate segment;
        block11: {
            DataCall dataCall;
            block12: {
                segment = (DataAggregate)PTModelService.getResource((String)dataStructure.getProject(), (String)"", (String)segmentName, (String)KernelPackage.eINSTANCE.getDataAggregate().getName().toLowerCase());
                if (segment == null) {
                    return null;
                }
                dataCall = KernelFactory.eINSTANCE.createDataCall();
                dataCall.setDataDefinition((DataDefinition)segment);
                if (dataStructure.getComponents().size() <= 0) break block12;
                int index = 0;
                while (index <= dataStructure.getComponents().size()) {
                    if (index < dataStructure.getComponents().size()) {
                        DataComponent component = (DataComponent)dataStructure.getComponents().get(index);
                        if (component instanceof DataCall) {
                            DataDescription description = ((DataCall)component).getDataDescription();
                            DataDefinition definition = ((DataCall)component).getDataDefinition();
                            String callName = "";
                            if (description != null) {
                                callName = description.getName();
                            } else if (definition != null && segmentName.equals(callName = definition.getProxyName())) break block11;
                            if (segmentName.compareTo(callName) < 0) {
                                dataStructure.getComponents().add(index, (Object)dataCall);
                                break block11;
                            }
                        }
                    } else {
                        dataStructure.getComponents().add((Object)dataCall);
                    }
                    ++index;
                }
                break block11;
            }
            dataStructure.getComponents().add((Object)dataCall);
            PacDataAggregateTypeValues segTypeValue = PacDataAggregateTypeValues._NONE_LITERAL;
            for (RadicalEntityExtension extension : segment.getExtensions()) {
                if (!(extension instanceof PacDataAggregate)) continue;
                PacDataAggregate segExtension = (PacDataAggregate)extension;
                segTypeValue = segExtension.getDataAggregateType();
                break;
            }
            if (segTypeValue == PacDataAggregateTypeValues._NONE_LITERAL) break block11;
            for (RadicalEntityExtension extension : dataStructure.getExtensions()) {
                if (!(extension instanceof PacDataUnit)) continue;
                PacDataUnit dsExtension = (PacDataUnit)extension;
                if (segTypeValue == PacDataAggregateTypeValues._G_LITERAL) {
                    dsExtension.setDataStructureType(PacDataUnitTypeValues._G_LITERAL);
                    break;
                }
                if (segTypeValue != PacDataAggregateTypeValues._V_LITERAL) break;
                dsExtension.setDataStructureType(PacDataUnitTypeValues._V_LITERAL);
                break;
            }
        }
        return segment;
    }

    private void checkLowerHierarchy(DataUnit dataStructure, String segmentName) {
        IPTLocation location = PTModelService.getLocation((String)dataStructure.getLocation());
        Iterator projects = location.projects();
        while (projects.hasNext()) {
            IPath relativePath;
            DataUnit lowerObject;
            IPTProject project = (IPTProject)projects.next();
            if (!PTNature.getRequiredPaths((String)project.getName()).contains(dataStructure.getProject()) || (lowerObject = (DataUnit)PTModelService.getResource((IPath)(relativePath = PTModelService.getPath((String)project.getName(), (String)"", (String)dataStructure.getName(), (String)KernelPackage.eINSTANCE.getDataUnit().getName().toLowerCase())))) == null) continue;
            PTModelService.checkMarkers((RadicalEntity)lowerObject, (boolean)true);
        }
    }

    public PTActionResult acceptRename(String designId, String newName) {
        String[] tokens = MetadataService.getTokens((String)designId);
        if (tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName()) || tokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName()) || tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            String name = tokens[2];
            String type = tokens[4];
            if (KernelPackage.eINSTANCE.getDataAggregate().getName().equalsIgnoreCase(type) && !newName.substring(0, 2).equals(name.substring(0, 2))) {
                StringBuilder sb = new StringBuilder();
                sb.append(Messages.getString(Messages._RENAME_FIRST_2_CHARACTERS_SEGMENT_FORBIDDEN));
                return new PTActionResult(4, sb.toString());
            }
            if (this.cobolsToModify == null && this.macrosToModify == null || this.currentDesignID == null || !this.currentDesignID.equals(designId)) {
                this.noValidatedGeneratedFiles = null;
                this.cobolsToModify = new ArrayList();
                this.macrosToModify = new ArrayList();
                this.screensToModify = new ArrayList();
                this.serversToModify = new ArrayList();
                this.programsToModify = new ArrayList();
                this.findSuperRefs(designId, this.cobolsToModify, this.macrosToModify, this.screensToModify, this.serversToModify, this.programsToModify);
                if (this.cobolsToModify != null && this.cobolsToModify.size() != 0) {
                    for (String cobolId : this.cobolsToModify) {
                        String fullCobolId = GenerationManager.getFullPathFromLogicalGeneratedPath((String)cobolId);
                        String pdpPath = PdpTool.computePdpFileLocationFromSourceFileLocation((String)fullCobolId);
                        try {
                            boolean activated = MigrationHelpTool.isMigrationHelpActivated((String)pdpPath);
                            if (!activated) continue;
                            if (this.noValidatedGeneratedFiles == null) {
                                this.noValidatedGeneratedFiles = new ArrayList();
                            }
                            this.noValidatedGeneratedFiles.add(cobolId);
                        }
                        catch (RuntimeException e) {
                            return new PTActionResult(4, e.getMessage());
                        }
                    }
                }
                this.currentDesignID = designId;
            }
            if (this.noValidatedGeneratedFiles != null && this.noValidatedGeneratedFiles.size() != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(Messages.PacActionPolicy_Migration_Control_not_validated);
                Iterator<String> noValidatedFilesIter = this.noValidatedGeneratedFiles.iterator();
                int i = 0;
                int MAX_PRINTABLE_UNVALIDATED_FILE = 10;
                while (noValidatedFilesIter.hasNext()) {
                    if (++i > MAX_PRINTABLE_UNVALIDATED_FILE) continue;
                    sb.append(LF);
                    sb.append(noValidatedFilesIter.next());
                }
                if (i > MAX_PRINTABLE_UNVALIDATED_FILE) {
                    sb.append(LF);
                    String more = "" + (MAX_PRINTABLE_UNVALIDATED_FILE - i);
                    Object[] array = new String[]{more};
                    sb.append(Messages.getString(Messages.PacActionPolicy_and_more, array));
                }
                return new PTActionResult(4, sb.toString());
            }
        }
        return null;
    }

    public Set<String> getRenamedArtifactIds(String designId) {
        HashSet<String> renamedArtifactIds = new HashSet<String>();
        renamedArtifactIds.add(designId);
        String[] tokens = MetadataService.getTokens((String)designId);
        if (tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            PTSearchPattern searchPattern = new PTSearchPattern();
            searchPattern.setExpression(String.valueOf(tokens[2]) + "*");
            searchPattern.setCaseSensitive(false);
            searchPattern.setLimitTo(0);
            searchPattern.setSearchFor(1);
            searchPattern.getSearchForTypes().add(DataAggregate.class.getSimpleName().toLowerCase());
            List elements = PTModelService.search((IPTSearchPattern)searchPattern);
            HashSet accessiblePaths = new HashSet();
            accessiblePaths.addAll(PTNature.getPaths((String)tokens[0]));
            for (IPTElement element : elements) {
                if (!tokens[0].equals(element.getDocument().getProject())) continue;
                renamedArtifactIds.add(element.getDocument().getId());
            }
        }
        return renamedArtifactIds;
    }

    public Set<String> getChangedArtifactIds(String designId, String newName) {
        Set set = super.getChangedArtifactIds(designId, newName);
        HashSet<String> setToRemove = new HashSet<String>();
        String projectName = MetadataService.getProject((String)designId);
        Set selectedDA = super.getIdsToKeep();
        for (String sourceId : set) {
            String[] sourceTokens = MetadataService.getTokens((String)sourceId);
            if (!sourceTokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName()) || !selectedDA.contains(sourceId) || !PTNature.getPaths((String)sourceTokens[0]).contains(projectName)) continue;
            setToRemove.add(sourceId);
        }
        set.removeAll(setToRemove);
        if (this.screensToModify != null || this.serversToModify != null) {
            this.addMacroRelativeReferences(designId, set);
        }
        return set;
    }

    private void addMacroRelativeReferences(String designId, Set<String> set) {
        String[] tokens = MetadataService.getTokens((String)designId);
        if (!(tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName()) || tokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName()) || tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName()))) {
            return;
        }
        ArrayList<String> screensOrServersToModify = new ArrayList<String>();
        if (this.screensToModify != null && this.screensToModify.size() != 0) {
            for (String cobolId : this.screensToModify) {
                screensOrServersToModify.add(cobolId);
            }
        }
        if (this.serversToModify != null && this.serversToModify.size() != 0) {
            for (String cobolId : this.serversToModify) {
                screensOrServersToModify.add(cobolId);
            }
        }
        Iterator iter = null;
        for (String screenDesignId : screensOrServersToModify) {
            String oldName = tokens[2];
            int resolMode = PTEditorService.getResolvingMode();
            PTEditorService.setResolvingMode((int)3);
            try {
                IPath path = PTModelService.getPath((String)screenDesignId);
                RadicalEntity radicalObject = PTEditorService.getSharedResource((IPath)path);
                if (!(radicalObject instanceof PacScreen) && !(radicalObject instanceof PacServer)) continue;
                if (radicalObject instanceof PacScreen) {
                    PacScreen screen = (PacScreen)radicalObject;
                    iter = screen.getCPLines().iterator();
                }
                if (radicalObject instanceof PacServer) {
                    PacServer server = (PacServer)radicalObject;
                    iter = server.getCPLines().iterator();
                }
                while (iter.hasNext()) {
                    PacCPLine cpLine;
                    PacStructuredLanguageEntity psle;
                    Object obj = iter.next();
                    if (!(obj instanceof PacCPLine) || !((psle = (cpLine = (PacCPLine)obj).getMacro()) instanceof PacMacro)) continue;
                    PacMacro pacMacro = (PacMacro)psle;
                    String source = pacMacro.getSource();
                    boolean modifiedSource = false;
                    int refIndex = source.indexOf(REF);
                    while (refIndex != -1) {
                        int endOfLineIndex = source.indexOf(10, refIndex);
                        String line = endOfLineIndex == -1 ? source.substring(refIndex) : source.substring(refIndex, endOfLineIndex);
                        int oldNameIndex = line.indexOf(oldName);
                        if (oldNameIndex == -1) {
                            refIndex = source.indexOf(REF, endOfLineIndex);
                            continue;
                        }
                        modifiedSource = true;
                        break;
                    }
                    if (!modifiedSource) continue;
                    set.add(pacMacro.getDesignId(pacMacro.getProject()));
                }
            }
            finally {
                PTEditorService.setResolvingMode((int)resolMode);
            }
        }
    }

    public Map<String, List<PTActionResult>> processRename(String designId, String newName, boolean updateReferences, IProgressMonitor monitor) {
        Map<String, List<PTActionResult>> actionResults = null;
        System.getProperties().put("PTActionPolicyRenameContext", new String[]{designId, newName});
        newName = this.normalizeName(designId, newName);
        this.designToRegenerate = new HashMap();
        String projectName = MetadataService.getProject((String)designId);
        String[] tokens = MetadataService.getTokens((String)designId);
        String name = tokens[2];
        String type = tokens[4];
        if (KernelPackage.eINSTANCE.getDataAggregate().getName().equalsIgnoreCase(type)) {
            if (!newName.substring(0, 2).equals(name.substring(0, 2))) {
                updateReferences = false;
            }
            actionResults = super.processRename(designId, newName, updateReferences, monitor);
        } else if (type.equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            actionResults = new HashMap();
            Set<String> renamedArtifactIds = this.getRenamedArtifactIds(designId);
            Map results = super.processRename(designId, newName, updateReferences, monitor);
            if (results != null) {
                actionResults.putAll(results);
            }
            for (String renamedId : renamedArtifactIds) {
                if (renamedId.equals(designId)) continue;
                String[] segmentTokens = MetadataService.getTokens((String)renamedId);
                String newSegmentName = newName;
                if (segmentTokens[2].length() <= 2 || !segmentTokens[0].equals(projectName)) continue;
                newSegmentName = String.valueOf(newSegmentName) + segmentTokens[2].substring(2);
                System.getProperties().put("PTActionPolicyRenameContext", new String[]{renamedId, newSegmentName});
                results = super.processRename(renamedId, newSegmentName, updateReferences, monitor);
                if (results == null) continue;
                actionResults.putAll(results);
            }
        } else {
            if (this.canHaveFreeReferences(type)) {
                this.renameFreeReferences(designId, type, name, newName);
            }
            actionResults = super.processRename(designId, newName, updateReferences, monitor);
            this.modifyAllEntryPoints(null, null, newName, designId);
        }
        if (type.equalsIgnoreCase(DataElement.class.getSimpleName())) {
            this.renameData(designId, newName, tokens);
        }
        if (type.equalsIgnoreCase(DataAggregate.class.getSimpleName())) {
            this.renameData(designId, newName, tokens);
        }
        if (type.equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            this.renameData(designId, newName, tokens);
        }
        System.getProperties().remove("PTActionPolicyRenameContext");
        return actionResults;
    }

    private boolean canHaveFreeReferences(String type) {
        return type.equalsIgnoreCase(PacCommunicationMonitor.class.getSimpleName()) || type.equalsIgnoreCase(PacServer.class.getSimpleName()) || type.equalsIgnoreCase(DataElement.class.getSimpleName());
    }

    private void renameData(String designId, String newName, String[] tokens) {
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        String deProject = MetadataService.getProject((String)designId);
        try {
            String oldName = tokens[2];
            for (String macroDesignId : this.macrosToModify) {
                String macroProject = MetadataService.getProject((String)macroDesignId);
                List macroRequires = PTNature.getPaths((String)macroProject);
                if (!macroRequires.contains(deProject)) continue;
                this.renameDataIntoPacMacro(newName, tokens, oldName, macroDesignId);
            }
            for (String screenDesignId : this.screensToModify) {
                this.renameDataIntoPacScreen(newName, tokens, oldName, screenDesignId);
            }
            for (String serverDesignId : this.serversToModify) {
                this.renameDataIntoPacServer(newName, tokens, oldName, serverDesignId);
            }
            for (String programDesignId : this.programsToModify) {
                this.renameDataIntoPacProgram(newName, tokens, oldName, programDesignId);
            }
            for (String cobolSourceId : this.cobolsToModify) {
                if (tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName())) {
                    this.renameDataElementIntoCobolSource(newName, tokens, oldName, cobolSourceId);
                }
                if (tokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName())) {
                    this.renameDataAggregateIntoCobolSource(newName, tokens, oldName, cobolSourceId);
                }
                if (!tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName())) continue;
                this.renameDataUnitIntoCobolSource(newName, tokens, oldName, cobolSourceId);
            }
        }
        finally {
            PTEditorService.setResolvingMode((int)resolMode);
        }
    }

    private void renameFreeReferences(String designId, String type, String oldName, String newName) {
        Iterator iter = PdpResourcesMgr.getInstance().getAllSuperReferencesExceptGenerationRelations(designId);
        String projectName = MetadataService.getProject((String)designId);
        while (iter.hasNext()) {
            String referenceSourceId;
            String[] referenceSourceTokens;
            Reference reference = (Reference)iter.next();
            if (reference.getType() != 4 || PTModelManager.accept((String)(referenceSourceTokens = MetadataService.getTokens((String)(referenceSourceId = reference.getSourceId())))[4]) && !PTNature.getPaths((String)referenceSourceTokens[0]).contains(projectName)) continue;
            int resolvingMode = PTEditorService.getResolvingMode();
            PTEditorService.setResolvingMode((int)3);
            try {
                boolean renamed;
                IPath path = PTModelService.getPath((String)referenceSourceId);
                RadicalEntity radicalObject = PTEditorService.getSharedResource((IPath)path);
                if (!(radicalObject instanceof RadicalEntityImpl) || !(renamed = ((RadicalEntityImpl)radicalObject).renameFreeReferences(type, oldName, newName))) continue;
                try {
                    try {
                        PTModelManager.enableResourceChangeListeners((boolean)false);
                        radicalObject.save();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    PTModelManager.enableResourceChangeListeners((boolean)true);
                }
            }
            finally {
                PTEditorService.setResolvingMode((int)resolvingMode);
            }
        }
    }

    private void findSuperRefs(String designId, ArrayList<String> cobolsToModify, ArrayList<String> macrosToModify, ArrayList<String> screensToModify, ArrayList<String> serversToModify, ArrayList<String> programsToModify) {
        Iterator iter = PdpResourcesMgr.getInstance().getAllSuperReferencesExceptGenerationRelations(designId);
        while (iter.hasNext()) {
            Reference reference = (Reference)iter.next();
            String referenceSourceId = reference.getSourceId();
            if (referenceSourceId.endsWith("cbl")) {
                if (cobolsToModify.contains(referenceSourceId)) continue;
                cobolsToModify.add(referenceSourceId);
                continue;
            }
            if (referenceSourceId.endsWith("pacmacro")) {
                if (macrosToModify.contains(referenceSourceId)) continue;
                macrosToModify.add(referenceSourceId);
                continue;
            }
            if (referenceSourceId.endsWith("pacscreen")) {
                if (screensToModify.contains(referenceSourceId)) continue;
                screensToModify.add(referenceSourceId);
                continue;
            }
            if (referenceSourceId.endsWith("pacserver")) {
                if (serversToModify.contains(referenceSourceId)) continue;
                serversToModify.add(referenceSourceId);
                continue;
            }
            if (!referenceSourceId.endsWith("pacprogram") || programsToModify.contains(referenceSourceId)) continue;
            programsToModify.add(referenceSourceId);
        }
    }

    private void renameDataElementIntoCobolSource(String newName, String[] tokens, String oldName, String cobolSourceId) {
        CobolMicroPatternsAndDEUsagesParser cobolParser = new CobolMicroPatternsAndDEUsagesParser();
        String cobolSourcePath = GenerationManager.getFullPathFromLogicalGeneratedPath((String)cobolSourceId);
        IController controler = ControllerFactory.getInstance().getController(cobolSourcePath);
        MicroPatternsAndDEUsagesResults results = cobolParser.parse(cobolSourcePath, controler);
        List<Reference> usageRef = results.getDetailedUsages();
        usageRef = this.filterReferences(tokens, usageRef);
        List<Reference> usageRefWithoutMacro = this.filterSourceFromMacro(oldName, controler, usageRef, BEGIN_OFFSET);
        Object[] usages = this.sortReferences(usageRefWithoutMacro, BEGIN_OFFSET);
        String source = controler.getTextProcessor().getText().toString();
        String newLineDelimiter = PacActionPolicy.determineDelimiterOfV2(source);
        source = this.renameDataElementInSource(newName, oldName, source, newLineDelimiter, usages);
        int offsetForProc = cobolParser.getProcDivOffset();
        String sourceBeforeProc = source.substring(0, offsetForProc);
        String sourceProc = source.substring(offsetForProc);
        sourceProc = this.renameEntityAfter(sourceProc, oldName, newName, controler);
        source = sourceBeforeProc.concat(sourceProc);
        List<Reference> mpRefs = results.getMicroPatternRefs();
        List<Reference> mpRefsWithoutMacro = this.filterSourceFromMacro(oldName, controler, mpRefs = this.filterReferences(tokens, mpRefs), OFFSET);
        Object[] mpRef = this.sortReferences(mpRefsWithoutMacro, OFFSET);
        if (mpRef.length != 0 || usageRefWithoutMacro.size() != 0) {
            source = this.renameDataElementInSource(newName, oldName, source, newLineDelimiter, mpRef);
            controler.getTextProcessor().setText((CharSequence)source);
            GenerationManager.saveSrcResource((IController)controler);
        }
        String designFileId = controler.getDesignLink().getFileId();
        String patternName = controler.getPattern().getName();
        this.designToRegenerate.put(designFileId, patternName);
        ControllerFactory.getInstance().dispose(controler);
    }

    private String renameEntityAfter(String source, String oldName, String newName, IController controler) {
        String EOL = System.getProperty("line.separator");
        String[] lines = PdpTool.splitTextIntoArrayLines((String)source);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String aLine = stringArray[n2];
            int i = aLine.indexOf("      *@BEFORE ");
            if (i == -1 && (i = aLine.indexOf("      *@AFTER ")) == -1) {
                i = aLine.indexOf("      *@REPLACE ");
            }
            if (i != -1) {
                int s = 0;
                int e = 0;
                StringBuffer newText = new StringBuffer();
                while ((e = aLine.indexOf(oldName, s)) >= 0) {
                    newText.append(aLine.substring(s, e));
                    newText.append(newName);
                    s = e + oldName.length();
                }
                newText.append(aLine.substring(s));
                aLine = newText.toString();
            }
            sb.append(aLine);
            sb.append(EOL);
            ++n2;
        }
        source = sb.toString();
        controler.getTextProcessor().setText((CharSequence)source);
        GenerationManager.saveSrcResource((IController)controler);
        return source;
    }

    private void renameDataAggregateIntoCobolSource(String newName, String[] tokens, String oldName, String cobolSourceId) {
        CobolMicroPatternsAndDEUsagesParser cobolParser = new CobolMicroPatternsAndDEUsagesParser();
        String cobolSourcePath = GenerationManager.getFullPathFromLogicalGeneratedPath((String)cobolSourceId);
        IController controler = ControllerFactory.getInstance().getController(cobolSourcePath);
        MicroPatternsAndDEUsagesResults results = cobolParser.parse(cobolSourcePath, controler);
        String source = controler.getTextProcessor().getText().toString();
        String newLineDelimiter = PacActionPolicy.determineDelimiterOfV2(source);
        List<Reference> mpRefs = results.getMicroPatternRefs();
        List<Reference> mpRefsWithoutMacro = this.filterSourceFromMacro(oldName, controler, mpRefs = this.filterReferences(tokens, mpRefs), OFFSET);
        Object[] mpRef = this.sortReferences(mpRefsWithoutMacro, OFFSET);
        if (mpRef.length != 0) {
            source = this.renameDataAggregateInSource(newName, oldName, source, newLineDelimiter, mpRef);
            controler.getTextProcessor().setText((CharSequence)source);
            GenerationManager.saveSrcResource((IController)controler);
        }
        String designFileId = controler.getDesignLink().getFileId();
        String patternName = controler.getPattern().getName();
        this.designToRegenerate.put(designFileId, patternName);
        ControllerFactory.getInstance().dispose(controler);
    }

    private void renameDataUnitIntoCobolSource(String newName, String[] tokens, String oldName, String cobolSourceId) {
        CobolMicroPatternsAndDEUsagesParser cobolParser = new CobolMicroPatternsAndDEUsagesParser();
        String cobolSourcePath = GenerationManager.getFullPathFromLogicalGeneratedPath((String)cobolSourceId);
        IController controler = ControllerFactory.getInstance().getController(cobolSourcePath);
        MicroPatternsAndDEUsagesResults results = cobolParser.parse(cobolSourcePath, controler);
        String source = controler.getTextProcessor().getText().toString();
        String newLineDelimiter = PacActionPolicy.determineDelimiterOfV2(source);
        List<Reference> mpRefs = results.getMicroPatternRefs();
        List<Reference> mpRefsWithoutMacro = this.filterSourceFromMacro(oldName, controler, mpRefs = this.filterReferences(tokens, mpRefs), OFFSET);
        Object[] mpRef = this.sortReferences(mpRefsWithoutMacro, OFFSET);
        if (mpRef.length != 0) {
            source = this.renameDataUnitInSource(newName, oldName, source, newLineDelimiter, mpRef);
            controler.getTextProcessor().setText((CharSequence)source);
            GenerationManager.saveSrcResource((IController)controler);
        }
        String designFileId = controler.getDesignLink().getFileId();
        String patternName = controler.getPattern().getName();
        this.designToRegenerate.put(designFileId, patternName);
        ControllerFactory.getInstance().dispose(controler);
    }

    private List<Reference> filterSourceFromMacro(String oldName, IController controler, List<Reference> refs, String propertyName) {
        Iterator<Reference> mpRefIter = refs.iterator();
        ArrayList<Reference> mpRefsWithoutMacro = new ArrayList<Reference>();
        while (mpRefIter.hasNext()) {
            Reference reference = mpRefIter.next();
            String offsetStr = reference.getProperty(propertyName).getValue();
            int offset = Integer.parseInt(offsetStr);
            Iterator segmentsIter = controler.getTextProcessor().segments(offset, offset);
            while (segmentsIter.hasNext()) {
                ITextSegment iTextSegment = (ITextSegment)segmentsIter.next();
                if (iTextSegment.isFromMacro()) continue;
                mpRefsWithoutMacro.add(reference);
            }
        }
        return mpRefsWithoutMacro;
    }

    private void renameDataIntoPacMacro(String newName, String[] tokens, String oldName, String macroDesignId) {
        Object[] usagesMP;
        List<Reference> detailedMP;
        List allMicroPatternRefs;
        MicroPatternsAndDEUsagesResults parserResult;
        MacrosMicroPatternsAndDEUsagesParser parser;
        IPath path = PTModelService.getPath((String)macroDesignId);
        RadicalEntity radicalObject = PTEditorService.getSharedResource((IPath)path);
        PacMacro macro = (PacMacro)radicalObject;
        String source = macro.getSource();
        String newLine = PacActionPolicy.determineDelimiterOfV2(source);
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(source.getBytes());
        if (tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName())) {
            parser = new MacrosMicroPatternsAndDEUsagesParser();
            parserResult = parser.parse(macroDesignId, (InputStream)sourceStream);
            List allDetailedUsages = parserResult.getDetailedUsages();
            List<Reference> detailedUsages = this.filterReferences(tokens, allDetailedUsages);
            Object[] usages = this.sortReferences(detailedUsages, BEGIN_OFFSET);
            source = this.renameDataElementInSource(newName, oldName, source, newLine, usages);
            List allMicroPatternRefs2 = parserResult.getMicroPatternRefs();
            List<Reference> detailedMP2 = this.filterReferences(tokens, allMicroPatternRefs2);
            Object[] usagesMP2 = this.sortReferences(detailedMP2, OFFSET);
            source = this.renameDataElementInSource(newName, oldName, source, newLine, usagesMP2);
            ((PacMacro)radicalObject).setSource(source);
        }
        if (tokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName())) {
            parser = new MacrosMicroPatternsAndDEUsagesParser();
            parserResult = parser.parse(macroDesignId, (InputStream)sourceStream);
            allMicroPatternRefs = parserResult.getMicroPatternRefs();
            detailedMP = this.filterReferences(tokens, allMicroPatternRefs);
            usagesMP = this.sortReferences(detailedMP, OFFSET);
            source = this.renameDataAggregateInSource(newName, oldName, source, newLine, usagesMP);
            ((PacMacro)radicalObject).setSource(source);
        }
        if (tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            parser = new MacrosMicroPatternsAndDEUsagesParser();
            parserResult = parser.parse(macroDesignId, (InputStream)sourceStream);
            allMicroPatternRefs = parserResult.getMicroPatternRefs();
            detailedMP = this.filterReferences(tokens, allMicroPatternRefs);
            usagesMP = this.sortReferences(detailedMP, OFFSET);
            source = this.renameDataUnitInSource(newName, oldName, source, newLine, usagesMP);
            ((PacMacro)radicalObject).setSource(source);
        }
        try {
            radicalObject.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void renameDataIntoPacScreen(String newName, String[] tokens, String oldName, String screenDesignId) {
        IPath path = PTModelService.getPath((String)screenDesignId);
        RadicalEntity radicalObject = PTEditorService.getSharedResource((IPath)path);
        if (!(radicalObject instanceof PacScreen)) {
            return;
        }
        PacScreen screen = (PacScreen)radicalObject;
        Iterator iter2 = screen.getCPLines().iterator();
        if (tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName())) {
            this.renameDataElementIntoCPlines(newName, oldName, (RadicalEntity)screen, iter2);
        }
        if (tokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName())) {
            this.renameDataAggregateIntoCPlines(newName, oldName, (RadicalEntity)screen, iter2);
        }
        if (tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            this.renameDataUnitIntoCPlines(newName, oldName, (RadicalEntity)screen, iter2);
        }
        for (Object obj : screen.getCPLines()) {
            PacCPLine cpLine;
            PacStructuredLanguageEntity psle;
            if (!(obj instanceof PacCPLine) || !((psle = (cpLine = (PacCPLine)obj).getMacro()) instanceof PacMacro)) continue;
            PacMacro pacMacro = (PacMacro)psle;
            String source = pacMacro.getSource();
            boolean modifiedSource = false;
            int refIndex = source.indexOf(REF);
            while (refIndex != -1) {
                int endOfLineIndex = source.indexOf(10, refIndex);
                String line = endOfLineIndex == -1 ? source.substring(refIndex) : source.substring(refIndex, endOfLineIndex);
                int oldNameIndex = line.indexOf(oldName);
                if (oldNameIndex == -1) {
                    refIndex = source.indexOf(REF, endOfLineIndex);
                    continue;
                }
                source = String.valueOf(source.substring(0, refIndex + REF.length())) + newName + source.substring(refIndex + REF.length() + oldName.length());
                modifiedSource = true;
                if (endOfLineIndex == -1) break;
                refIndex = source.indexOf(REF, endOfLineIndex);
            }
            if (!modifiedSource) continue;
            pacMacro.setSource(source);
            try {
                pacMacro.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void renameDataIntoPacServer(String newName, String[] tokens, String oldName, String serverDesignId) {
        IPath path = PTModelService.getPath((String)serverDesignId);
        RadicalEntity radicalObject = PTEditorService.getSharedResource((IPath)path);
        if (!(radicalObject instanceof PacServer)) {
            return;
        }
        PacServer server = (PacServer)radicalObject;
        Iterator iter2 = server.getCPLines().iterator();
        if (tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName())) {
            this.renameDataElementIntoCPlines(newName, oldName, (RadicalEntity)server, iter2);
        }
        if (tokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName())) {
            this.renameDataAggregateIntoCPlines(newName, oldName, (RadicalEntity)server, iter2);
        }
        if (tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            this.renameDataUnitIntoCPlines(newName, oldName, (RadicalEntity)server, iter2);
        }
        for (Object obj : server.getCPLines()) {
            PacCPLine cpLine;
            PacStructuredLanguageEntity psle;
            if (!(obj instanceof PacCPLine) || !((psle = (cpLine = (PacCPLine)obj).getMacro()) instanceof PacMacro)) continue;
            PacMacro pacMacro = (PacMacro)psle;
            String source = pacMacro.getSource();
            boolean modifiedSource = false;
            int refIndex = source.indexOf(REF);
            while (refIndex != -1) {
                int endOfLineIndex = source.indexOf(10, refIndex);
                String line = endOfLineIndex == -1 ? source.substring(refIndex) : source.substring(refIndex, endOfLineIndex);
                int oldNameIndex = line.indexOf(oldName);
                if (oldNameIndex == -1) {
                    refIndex = source.indexOf(REF, endOfLineIndex);
                    continue;
                }
                source = String.valueOf(source.substring(0, refIndex + REF.length())) + newName + source.substring(refIndex + REF.length() + oldName.length());
                modifiedSource = true;
                if (endOfLineIndex == -1) break;
                refIndex = source.indexOf(REF, endOfLineIndex);
            }
            if (!modifiedSource) continue;
            pacMacro.setSource(source);
            try {
                pacMacro.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void renameDataIntoPacProgram(String newName, String[] tokens, String oldName, String screenDesignId) {
        IPath path = PTModelService.getPath((String)screenDesignId);
        RadicalEntity radicalObject = PTEditorService.getSharedResource((IPath)path);
        if (!(radicalObject instanceof PacProgram)) {
            return;
        }
        PacProgram program = (PacProgram)radicalObject;
        Iterator iter2 = program.getCPLines().iterator();
        if (tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName())) {
            this.renameDataElementIntoCPlines(newName, oldName, (RadicalEntity)program, iter2);
        }
        if (tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName())) {
            this.renameDataUnitIntoCPlines(newName, oldName, (RadicalEntity)program, iter2);
        }
        if (tokens[4].equalsIgnoreCase(DataAggregate.class.getSimpleName())) {
            this.renameDataAggregateIntoCPlines(newName, oldName, (RadicalEntity)program, iter2);
        }
        for (Object obj : program.getCPLines()) {
            PacCPLine cpLine;
            PacStructuredLanguageEntity psle;
            if (!(obj instanceof PacCPLine) || !((psle = (cpLine = (PacCPLine)obj).getMacro()) instanceof PacMacro)) continue;
            PacMacro pacMacro = (PacMacro)psle;
            String source = pacMacro.getSource();
            boolean modifiedSource = false;
            int refIndex = source.indexOf(REF);
            while (refIndex != -1) {
                int endOfLineIndex = source.indexOf(10, refIndex);
                String line = endOfLineIndex == -1 ? source.substring(refIndex) : source.substring(refIndex, endOfLineIndex);
                int oldNameIndex = line.indexOf(oldName);
                if (oldNameIndex == -1) {
                    refIndex = source.indexOf(REF, endOfLineIndex);
                    continue;
                }
                source = String.valueOf(source.substring(0, refIndex + REF.length())) + newName + source.substring(refIndex + REF.length() + oldName.length());
                modifiedSource = true;
                if (endOfLineIndex == -1) break;
                refIndex = source.indexOf(REF, endOfLineIndex);
            }
            if (!modifiedSource) continue;
            pacMacro.setSource(source);
            try {
                pacMacro.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void renameDataElementIntoCPlines(String newName, String oldName, RadicalEntity re, Iterator<?> iter2) {
        boolean cpLineModified = false;
        while (iter2.hasNext()) {
            Object obj = iter2.next();
            if (!(obj instanceof PacCPLine)) continue;
            PacCPLine cpLine = (PacCPLine)obj;
            for (Object param : cpLine.getParameters()) {
                PacMacroParameter pmp;
                if (!(param instanceof PacMacroParameter) || !(pmp = (PacMacroParameter)param).getValue().startsWith("E=") || !pmp.getValue().contains(oldName) || !pmp.getDataElement().getName().equals(newName)) continue;
                String oldValue = pmp.getValue();
                int oldNameIndex = oldValue.indexOf(oldName);
                String newValue = String.valueOf(oldValue.substring(0, oldNameIndex)) + newName + oldValue.substring(oldNameIndex + oldName.length());
                pmp.setValue(newValue);
                cpLineModified = true;
            }
        }
        if (cpLineModified) {
            try {
                re.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void renameDataAggregateIntoCPlines(String newName, String oldName, RadicalEntity re, Iterator<?> iter2) {
        boolean cpLineModified = false;
        while (iter2.hasNext()) {
            Object obj = iter2.next();
            if (!(obj instanceof PacCPLine)) continue;
            PacCPLine cpLine = (PacCPLine)obj;
            for (Object param : cpLine.getParameters()) {
                PacMacroParameter pmp;
                if (!(param instanceof PacMacroParameter) || !(pmp = (PacMacroParameter)param).getValue().startsWith("S=") || !pmp.getValue().contains(oldName) || !pmp.getDataAggregate().getName().equals(newName)) continue;
                String oldValue = pmp.getValue();
                int oldNameIndex = oldValue.indexOf(oldName);
                String newValue = String.valueOf(oldValue.substring(0, oldNameIndex)) + newName + oldValue.substring(oldNameIndex + oldName.length());
                pmp.setValue(newValue);
                cpLineModified = true;
            }
        }
        if (cpLineModified) {
            try {
                re.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void renameDataUnitIntoCPlines(String newName, String oldName, RadicalEntity re, Iterator<?> iter2) {
        boolean cpLineModified = false;
        while (iter2.hasNext()) {
            Object obj = iter2.next();
            if (!(obj instanceof PacCPLine)) continue;
            PacCPLine cpLine = (PacCPLine)obj;
            for (Object param : cpLine.getParameters()) {
                String newValue;
                int oldNameIndex;
                String oldValue;
                if (!(param instanceof PacMacroParameter)) continue;
                PacMacroParameter pmp = (PacMacroParameter)param;
                if (pmp.getValue().startsWith("D=") && pmp.getValue().contains(oldName) && pmp.getDataUnit().getName().equals(newName)) {
                    oldValue = pmp.getValue();
                    oldNameIndex = oldValue.indexOf(oldName);
                    newValue = String.valueOf(oldValue.substring(0, oldNameIndex)) + newName + oldValue.substring(oldNameIndex + oldName.length());
                    pmp.setValue(newValue);
                    cpLineModified = true;
                }
                if (!pmp.getValue().startsWith("S=") || !pmp.getValue().contains(oldName.substring(0, 2)) || !pmp.getDataAggregate().getName().substring(0, 2).equals(newName)) continue;
                oldValue = pmp.getValue();
                oldNameIndex = oldValue.indexOf(oldName);
                newValue = String.valueOf(oldValue.substring(0, oldNameIndex)) + newName + oldValue.substring(oldNameIndex + oldName.length());
                pmp.setValue(newValue);
                cpLineModified = true;
            }
        }
        if (cpLineModified) {
            try {
                re.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String renameDataElementInSource(String newName, String oldName, String source, String newLineDelimiter, Object[] references) {
        int deltaChars = newName.length() - oldName.length();
        int i = references.length - 1;
        while (i >= 0) {
            int end;
            String line;
            int lineOff;
            Reference ref = (Reference)references[i];
            Property prop = ref.getProperty(BEGIN_OFFSET);
            boolean isMPReference = prop == null;
            String beginS = isMPReference ? ref.getProperty(OFFSET).getValue() : prop.getValue();
            int start = Integer.parseInt(beginS);
            if (isMPReference) {
                lineOff = PdpTool.getLineStartOffset((CharSequence)source, (int)start);
            } else {
                String lineOffS = ref.getProperty(LINE_OFFSET).getValue();
                lineOff = Integer.parseInt(lineOffS);
            }
            if (isMPReference) {
                int endOfLine = PdpTool.getLineEndOffset((CharSequence)source, (int)start);
                line = source.substring(lineOff, endOfLine - newLineDelimiter.length());
            } else {
                line = ref.getProperty(CONTEXTUAL_LINE).getValue();
            }
            String lineCtx = line;
            if (isMPReference) {
                int startInLine;
                int nextBlankInLine;
                String shortLine = line;
                if (shortLine.length() > 72) {
                    shortLine = shortLine.substring(0, 72);
                }
                end = (nextBlankInLine = shortLine.indexOf(" ", startInLine = start - lineOff)) != -1 ? lineOff + nextBlankInLine : lineOff + shortLine.length();
            } else {
                String endS = ref.getProperty(END_OFFSET).getValue();
                end = Integer.parseInt(endS);
            }
            String parsedString = source.substring(start, end);
            int position = parsedString.indexOf(oldName);
            if (position != -1) {
                if (deltaChars != 0) {
                    line = PacActionPolicy.trimRight(line);
                    int blankNumberBeforeRightmargin = 0;
                    String rightMargin = "";
                    if (line.length() > 73) {
                        rightMargin = line.substring(72);
                        line = PacActionPolicy.trimRight(line.substring(0, 72));
                        blankNumberBeforeRightmargin = 72 - line.length();
                    }
                    if (line.length() + deltaChars > 72) {
                        String lineWithReplacment = String.valueOf(line.substring(0, start + position - lineOff)) + newName + line.substring(start + position + oldName.length() - lineOff);
                        int extraChar = lineWithReplacment.length() - 72;
                        int lastWordIndex = this.getLastWordIndex(lineWithReplacment, extraChar);
                        StringBuilder blankBeforeRightMargin = new StringBuilder();
                        if (rightMargin.length() != 0) {
                            int j = 0;
                            while (j < 72 - lastWordIndex) {
                                blankBeforeRightMargin.append(' ');
                                ++j;
                            }
                        }
                        StringBuilder newSource = new StringBuilder();
                        newSource.append(source.substring(0, lineOff));
                        newSource.append(lineWithReplacment.substring(0, lastWordIndex));
                        newSource.append((CharSequence)blankBeforeRightMargin);
                        newSource.append(rightMargin);
                        newSource.append(newLineDelimiter);
                        newSource.append("           ");
                        newSource.append(lineWithReplacment.substring(lastWordIndex));
                        newSource.append(source.substring(lineOff + lineCtx.length()));
                        source = newSource.toString();
                    } else {
                        StringBuilder newSource = new StringBuilder();
                        newSource.append(source.substring(0, start + position));
                        newSource.append(newName);
                        if (rightMargin.length() != 0) {
                            StringBuilder blankBeforeRightMargin = new StringBuilder();
                            int j = 0;
                            while (j < blankNumberBeforeRightmargin - deltaChars) {
                                blankBeforeRightMargin.append(' ');
                                ++j;
                            }
                            newSource.append(source.substring(start + position + oldName.length(), lineOff + line.length()));
                            newSource.append((CharSequence)blankBeforeRightMargin);
                            newSource.append(source.substring(lineOff + 72));
                            source = newSource.toString();
                        } else {
                            newSource.append(source.substring(start + position + oldName.length()));
                            source = newSource.toString();
                        }
                    }
                } else {
                    source = String.valueOf(source.substring(0, start + position)) + newName + source.substring(start + position + oldName.length());
                }
            }
            --i;
        }
        return source;
    }

    private String renameDataUnitInSource(String newName, String oldName, String source, String newLineDelimiter, Object[] references) {
        int i = references.length - 1;
        while (i >= 0) {
            int end;
            String line;
            int lineOff;
            Reference ref = (Reference)references[i];
            Property prop = ref.getProperty(BEGIN_OFFSET);
            boolean isMPReference = prop == null;
            String beginS = isMPReference ? ref.getProperty(OFFSET).getValue() : prop.getValue();
            int start = Integer.parseInt(beginS);
            if (isMPReference) {
                lineOff = PdpTool.getLineStartOffset((CharSequence)source, (int)start);
            } else {
                String lineOffS = ref.getProperty(LINE_OFFSET).getValue();
                lineOff = Integer.parseInt(lineOffS);
            }
            if (isMPReference) {
                int endOfLine = PdpTool.getLineEndOffset((CharSequence)source, (int)start);
                line = source.substring(lineOff, endOfLine - newLineDelimiter.length());
            } else {
                line = ref.getProperty(CONTEXTUAL_LINE).getValue();
            }
            if (isMPReference) {
                int startInLine;
                int nextBlankInLine;
                String shortLine = line;
                if (shortLine.length() > 72) {
                    shortLine = shortLine.substring(0, 72);
                }
                end = (nextBlankInLine = shortLine.indexOf(" ", startInLine = start - lineOff)) != -1 ? lineOff + nextBlankInLine : lineOff + shortLine.length();
            } else {
                String endS = ref.getProperty(END_OFFSET).getValue();
                end = Integer.parseInt(endS);
            }
            int indexForSegToModify = 0;
            String oldSDSequence = source.substring(start, end);
            String newSDName = newName;
            if (oldSDSequence.trim().length() >= 1 && indexForSegToModify != -1) {
                source = String.valueOf(source.substring(0, start + indexForSegToModify)) + newSDName + source.substring(start + indexForSegToModify + 2);
            }
            --i;
        }
        return source;
    }

    private String renameDataAggregateInSource(String newName, String oldName, String source, String newLineDelimiter, Object[] references) {
        int i = references.length - 1;
        while (i >= 0) {
            int end;
            String line;
            int lineOff;
            Reference ref = (Reference)references[i];
            Property prop = ref.getProperty(BEGIN_OFFSET);
            boolean isMPReference = prop == null;
            String beginS = isMPReference ? ref.getProperty(OFFSET).getValue() : prop.getValue();
            int start = Integer.parseInt(beginS);
            if (isMPReference) {
                lineOff = PdpTool.getLineStartOffset((CharSequence)source, (int)start);
            } else {
                String lineOffS = ref.getProperty(LINE_OFFSET).getValue();
                lineOff = Integer.parseInt(lineOffS);
            }
            if (isMPReference) {
                int endOfLine = PdpTool.getLineEndOffset((CharSequence)source, (int)start);
                line = source.substring(lineOff, endOfLine - newLineDelimiter.length());
            } else {
                line = ref.getProperty(CONTEXTUAL_LINE).getValue();
            }
            if (isMPReference) {
                int startInLine;
                int nextBlankInLine;
                String shortLine = line;
                if (shortLine.length() > 72) {
                    shortLine = shortLine.substring(0, 72);
                }
                end = (nextBlankInLine = shortLine.indexOf(" ", startInLine = start - lineOff)) != -1 ? lineOff + nextBlankInLine : lineOff + shortLine.length();
            } else {
                String endS = ref.getProperty(END_OFFSET).getValue();
                end = Integer.parseInt(endS);
            }
            int indexForSegToModify = 0;
            String oldSegmentSequence = source.substring(start, end);
            String newSegmentNumber = newName.substring(2);
            if (oldSegmentSequence.trim().length() >= 1) {
                if (oldSegmentSequence.trim().length() > 2) {
                    String segmentNumberToRename = oldName.substring(2);
                    indexForSegToModify = oldSegmentSequence.indexOf(segmentNumberToRename);
                }
                if (indexForSegToModify != -1) {
                    source = String.valueOf(source.substring(0, start + indexForSegToModify)) + newSegmentNumber + source.substring(start + indexForSegToModify + 2);
                }
            }
            --i;
        }
        return source;
    }

    private Object[] sortReferences(List<Reference> referencesToSort, String sortProperty) {
        Object[] usages = referencesToSort.toArray();
        class ReferenceComparator
        implements Comparator<Object> {
            String sortProp;

            ReferenceComparator(String sortProperty) {
                this.sortProp = sortProperty;
            }

            @Override
            public int compare(Object first, Object second) {
                String begin1 = ((Reference)first).getProperty(this.sortProp).getValue();
                String begin2 = ((Reference)second).getProperty(this.sortProp).getValue();
                int ind1 = Integer.parseInt(begin1);
                int ind2 = Integer.parseInt(begin2);
                return ind1 - ind2;
            }
        }
        Arrays.sort(usages, new ReferenceComparator(sortProperty));
        return usages;
    }

    private List<Reference> filterReferences(String[] tokens, List<Reference> allReferences) {
        ArrayList<Reference> detailedUsages = new ArrayList<Reference>();
        for (Reference detailedReference : allReferences) {
            String[] detailstokens = MetadataService.getTokens((String)detailedReference.getTargetId());
            if (!tokens[2].equals(detailstokens[2]) || !tokens[3].equals(detailstokens[3]) || !tokens[4].equals(detailstokens[4])) continue;
            detailedUsages.add(detailedReference);
        }
        return detailedUsages;
    }

    /*
     * Unable to fully structure code
     */
    private int getLastWordIndex(String line, int minimumLength) {
        lastWordIndex = line.length() - 1;
        value = line.toCharArray();
        ** GOTO lbl7
        {
            --lastWordIndex;
            do {
                if (lastWordIndex >= 0 && value[lastWordIndex] > ' ') continue block0;
lbl7:
                // 2 sources

            } while (line.length() - (lastWordIndex + 1) < minimumLength);
        }
        return ++lastWordIndex;
    }

    public void postProcessRename(String designId, String newName, IProgressMonitor monitor) {
        super.postProcessRename(designId, newName, monitor);
        String[] tokens = MetadataService.getTokens((String)designId);
        if (KernelPackage.eINSTANCE.getDataAggregate().getName().equalsIgnoreCase(tokens[4]) && !newName.substring(0, 2).equals(tokens[2].substring(0, 2))) {
            String refactoredId = MetadataService.getId((String)tokens[0], (String)tokens[1], (String)newName, (String)tokens[3], (String)tokens[4]);
            this.postProcessAdd(refactoredId, null, monitor);
        }
    }

    public void processDelete(Set<String> artifactIds, IPTActionPolicy.PTArtifactKind artifactKind, IProgressMonitor monitor) {
        ((ControllerFactory)ControllerFactory.getInstance()).retain();
        if (artifactKind == IPTActionPolicy.PTArtifactKind.Location) {
            super.processDelete(artifactIds, artifactKind, monitor);
        } else if (artifactKind == IPTActionPolicy.PTArtifactKind.Design) {
            final HashSet<String> ignoredItemIds = new HashSet<String>();
            for (String designId : artifactIds) {
                String[] tokens = MetadataService.getTokens((String)designId);
                if (!tokens[4].equalsIgnoreCase(PacbasePackage.eINSTANCE.getPacMacro().getName()) || !tokens[2].equalsIgnoreCase(_MSP_USER) && !tokens[2].equalsIgnoreCase(_MSP_80EX)) continue;
                ignoredItemIds.add(designId);
            }
            if (ignoredItemIds.size() > 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String dialogLabel = Messages.getString(Messages._DELETION_ERROR_LABEL);
                        MultiStatus statusList = new MultiStatus("org.eclipse.ui", 0, dialogLabel, null);
                        for (String ignoredId : ignoredItemIds) {
                            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, ignoredId, null));
                        }
                        String dialogTitle = Messages.getString(Messages._DELETION_ERROR_TITLE);
                        PTMessageManager.handleErrors((String)dialogTitle, (MultiStatus)statusList);
                    }
                });
                artifactIds.removeAll(ignoredItemIds);
            }
            if (artifactIds.size() > 0) {
                super.processDelete(artifactIds, artifactKind, monitor);
            }
        }
        ((ControllerFactory)ControllerFactory.getInstance()).release();
    }

    public void postProcessDelete(Set<String> artifactIds, IPTActionPolicy.PTArtifactKind artifactKind, IProgressMonitor monitor) {
        if (artifactKind == IPTActionPolicy.PTArtifactKind.Location) {
            return;
        }
        for (String designId : artifactIds) {
            String type = MetadataService.getType((String)designId);
            if (!KernelPackage.eINSTANCE.getDataUnit().getName().equalsIgnoreCase(type)) continue;
            String[] tokens = MetadataService.getTokens((String)designId);
            this.checkOrphanSegments(tokens[0], tokens[2], null);
        }
    }

    public Set<String> processMove(Set<String> designIds, String newProject, String newPackage, IProgressMonitor monitor) {
        Set designMoved = super.processMove(designIds, newProject, newPackage, monitor);
        for (String designId : designMoved) {
            String[] tokens = MetadataService.getTokens((String)designId);
            if (!tokens[4].equalsIgnoreCase(PacProgram.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacMacro.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacScreen.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacDialog.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(DataElement.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(DataUnit.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacBlockBase.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacReport.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacServer.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacDialogServer.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacErrorLabel.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacCommunicationMonitor.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacDialogCommunicationMonitor.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacFolder.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacDialogFolder.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacFolderView.class.getSimpleName()) && !tokens[4].equalsIgnoreCase(PacDialogFolderView.class.getSimpleName())) continue;
            String newDesignId = MetadataService.getId((String)newProject, (String)tokens[1], (String)tokens[2], (String)tokens[3], (String)tokens[4]);
            IPath path = PTModelService.getPath((String)newDesignId);
            RadicalEntity radicalObject = PTEditorService.getSharedResource((IPath)path);
            PacLibrary lib = this.searchPacLibrary(newProject);
            if (radicalObject instanceof PacStructuredLanguageEntity) {
                PacStructuredLanguageEntity psle = (PacStructuredLanguageEntity)radicalObject;
                psle.setGenerationParameter(lib);
            } else if (radicalObject instanceof PacAbstractDialog) {
                PacAbstractDialog pad = (PacAbstractDialog)radicalObject;
                pad.setGenerationParameter(lib);
            } else if (radicalObject instanceof PacAbstractDialogServer) {
                ((PacAbstractDialogServer)radicalObject).setGenerationParameter(lib);
            } else if (radicalObject instanceof PacAbstractDialogCommunicationMonitor) {
                ((PacAbstractDialogCommunicationMonitor)radicalObject).setGenerationParameter(lib);
            } else if (radicalObject instanceof PacAbstractDialogFolder) {
                ((PacAbstractDialogFolder)radicalObject).setGenerationParameter(lib);
            } else if (radicalObject instanceof PacAbstractDialogFolderView) {
                ((PacAbstractDialogFolderView)radicalObject).setGenerationParameter(lib);
            } else if (radicalObject instanceof DataElement) {
                DataElement de = (DataElement)radicalObject;
                for (RadicalEntityExtension ree : de.getExtensions()) {
                    if (!(ree instanceof PacDataElement)) continue;
                    ((PacDataElement)ree).setGenerationParameter(lib);
                    break;
                }
            } else if (radicalObject instanceof DataUnit) {
                DataUnit du = (DataUnit)radicalObject;
                for (RadicalEntityExtension ree : du.getExtensions()) {
                    if (!(ree instanceof PacDataUnit)) continue;
                    ((PacDataUnit)ree).setGenerationParameter(lib);
                }
            } else if (radicalObject instanceof PacBlockBase) {
                ((PacBlockBase)radicalObject).setGenerationParameter(lib);
            } else if (radicalObject instanceof PacReport) {
                ((PacReport)radicalObject).setGenerationParameter(lib);
            } else if (radicalObject instanceof PacErrorLabel) {
                ((PacErrorLabel)radicalObject).setGenerationParameter(lib);
            }
            this.modifyAllEntryPoints(newProject, newPackage, null, designId);
            try {
                radicalObject.save();
            }
            catch (IOException e) {
                Util.rethrow((Throwable)e);
            }
        }
        return designMoved;
    }

    private void modifyAllEntryPoints(String newProject, String newPackage, String newName, String designId) {
        List super_refs = GenerationManager.getGenerationOutputsFromSuperRef((String)designId, null);
        if (super_refs != null) {
            for (GenerationManager.SuperRef superRef : super_refs) {
                String deletedId = superRef.getDocumentId();
                String uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)deletedId);
                String pdpFileURI = PdpTool.computePdpFileLocationFromSourceFileLocation((String)uri);
                this.modifyEntryPointIntoPdpFile(newProject, newPackage, newName, pdpFileURI);
            }
        }
    }

    private void modifyEntryPointIntoPdpFile(String newProject, String newPackage, String newName, String pdpFileURI) {
        String oldCblPdpContents = null;
        String wksRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        try {
            oldCblPdpContents = PdpTool.readFileContents((String)(String.valueOf(wksRoot) + pdpFileURI), (String)CharsetUtil.getWorkspaceCharset());
        }
        catch (CoreException coreException) {
            oldCblPdpContents = PdpTool.readFileContents((String)pdpFileURI);
        }
        String newCblPdpContents = this.modifyEntryPoint(oldCblPdpContents, newProject, newPackage, newName);
        PdpTool.writeEclipseFileContents((String)newCblPdpContents, (String)pdpFileURI);
    }

    private String modifyEntryPoint(String oldString, String newProject, String newPackage, String newName) {
        if (newName == null) {
            return this.modifyEntryPoint(oldString, newProject, newPackage);
        }
        return this.modifyEntryPoint(oldString, newName);
    }

    private String modifyEntryPoint(String oldString, String newProject, String newPackage) {
        String ENTRY_POINT1 = "_entrypoint\"></subRef>";
        String SUBREF_STARTING = "<subRef project=\"";
        int SUBREF_STARTING_LEN = SUBREF_STARTING.length();
        String PACKAGE = " package=\"";
        int PACKAGE_LEN = PACKAGE.length();
        int idx1 = oldString.indexOf(ENTRY_POINT1);
        int idx2 = oldString.lastIndexOf(SUBREF_STARTING, idx1);
        int idx2_prime = oldString.indexOf(34, idx2 + SUBREF_STARTING_LEN);
        int idx3 = oldString.indexOf(PACKAGE, idx2);
        int idx4 = oldString.indexOf(34, idx3 + PACKAGE_LEN);
        String result = String.valueOf(oldString.substring(0, idx2 + SUBREF_STARTING_LEN)) + newProject + oldString.substring(idx2_prime, idx3 + PACKAGE_LEN) + newPackage + oldString.substring(idx4);
        return result;
    }

    private String modifyEntryPoint(String oldString, String newName) {
        String ENTRY_POINT1 = "_entrypoint\"></subRef>";
        String STARTING_NAME = "name=\"";
        int STARTING_NAME_LEN = STARTING_NAME.length();
        int idx1 = oldString.indexOf(ENTRY_POINT1);
        int idx2 = oldString.lastIndexOf(STARTING_NAME, idx1);
        int idx2_prime = oldString.indexOf(34, idx2 + STARTING_NAME_LEN);
        String result = String.valueOf(oldString.substring(0, idx2 + STARTING_NAME_LEN)) + newName + oldString.substring(idx2_prime);
        return result;
    }

    private PacLibrary searchPacLibrary(String newProject) {
        PacLibrary libraryFromDisk;
        if (newProject == null) {
            return null;
        }
        String pacLibraryName = null;
        int dotIndex = newProject.lastIndexOf(46);
        if (dotIndex != -1) {
            pacLibraryName = newProject.substring(dotIndex + 1);
        }
        if ((libraryFromDisk = (PacLibrary)PTModelService.getResource((String)newProject, (String)"", pacLibraryName, (String)"paclibrary")) != null) {
            return libraryFromDisk;
        }
        List paths = PTNature.getPaths((String)newProject);
        for (String project : paths) {
            pacLibraryName = null;
            dotIndex = project.lastIndexOf(46);
            if (dotIndex != -1) {
                pacLibraryName = project.substring(dotIndex + 1);
            }
            if (pacLibraryName == null || (libraryFromDisk = (PacLibrary)PTModelService.getResource((String)project, (String)"", (String)pacLibraryName, (String)"paclibrary")) == null) continue;
            return libraryFromDisk;
        }
        return libraryFromDisk;
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    public static String determineDelimiterOfV2(CharSequence txt) {
        int i = 0;
        boolean foundCR = false;
        boolean foundLF = false;
        int lngth = txt.length();
        while (i < lngth) {
            char chr = txt.charAt(i);
            if (chr == '\r') {
                foundCR = true;
                break;
            }
            if (chr == '\n') {
                foundLF = true;
                break;
            }
            ++i;
        }
        if (foundCR) {
            if (i + 1 < lngth && txt.charAt(i + 1) == '\n') {
                return CRLF;
            }
            return CR;
        }
        if (foundLF) {
            if (i + 1 < lngth && txt.charAt(i + 1) == '\r') {
                return LFCR;
            }
            return LF;
        }
        return CR;
    }

    public String controlDagNameForRename(DataAggregate dag, String name) {
        String segmentCode = name.substring(2);
        PacDataAggregate pacDag = this.getPacDataAggregate(dag);
        if (name.trim().length() == 4 && (!this.isNumeric(segmentCode.substring(0, 1)) || this.isNumeric(segmentCode.substring(0, 1)) && segmentCode.substring(0, 1).equals("0") && !this.isNumeric(segmentCode.substring(1))) && pacDag.getDataAggregateType().equals(PacDataAggregateTypeValues._G_LITERAL)) {
            return Messages.getString(Messages._INVALID_SEGMENT_FOR_PACTABLE);
        }
        if (name.trim().length() == 4 && (!this.isNumeric(segmentCode.substring(0, 1)) || this.isNumeric(segmentCode.substring(0, 1)) && segmentCode.substring(0, 1).equals("0") && !this.isNumeric(segmentCode.substring(1))) && pacDag.getDataAggregateType().equals(PacDataAggregateTypeValues._V_LITERAL)) {
            return Messages.getString(Messages._INVALID_SEGMENT_FOR_LOGICALVIEW);
        }
        if (name.trim().length() == 4 && (!this.isNumeric(segmentCode.substring(0, 1)) || this.isNumeric(segmentCode.substring(0, 1)) && segmentCode.substring(0, 1).equals("0") && !this.isNumeric(segmentCode.substring(1))) && pacDag.getDataAggregateType().equals(PacDataAggregateTypeValues._NONE_LITERAL)) {
            return Messages.getString(Messages._INVALID_SEGMENT_FOR_SEGMENT);
        }
        return "";
    }

    private boolean isNumeric(String value) {
        try {
            new StringBuilder(value);
            if (value.indexOf(42) > -1) {
                value = value.substring(value.indexOf(42));
            }
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private PacDataAggregate getPacDataAggregate(DataAggregate re) {
        PacDataAggregate pacDefinition = null;
        EList extensions = re.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataAggregate) {
                pacDefinition = (PacDataAggregate)object;
                break;
            }
            ++i;
        }
        return pacDefinition;
    }

    protected void modifyEntity(String projectName, String packageName, String name, String locationName, RadicalEntity clone) {
        DataAggregate da;
        PacDataAggregate pda;
        super.modifyEntity(projectName, packageName, name, locationName, clone);
        if (clone instanceof DataAggregate && (pda = this.getPacDataAggregate(da = (DataAggregate)clone)) != null) {
            pda.setGenerationParameter(null);
        }
    }
}

