/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RationalPlatformDetector {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static boolean isAPowerBundle(String name) {
        return name.startsWith("com.ibm.etools.aix.") || name.startsWith("com.ibm.etools.unix.") || name.startsWith("com.ibm.debug.power.");
    }

    private static boolean isAzOSBundle(String name) {
        return name.startsWith("com.ibm.cics.zos.") || name.startsWith("com.ibm.etools.mvs.") || name.startsWith("com.ibm.etools.zoside.") || name.startsWith("com.ibm.etools.zseries.");
    }

    public static Platform_Type getPlatformType(Plugin plugin) {
        Bundle bundle = plugin.getBundle();
        BundleContext context = bundle.getBundleContext();
        Bundle[] bundles = context.getBundles();
        int bundlesLen = bundles.length;
        boolean zBundlesPresent = false;
        boolean powerBundlesPresent = false;
        int i = 0;
        while (i < bundlesLen) {
            Bundle aBundle = bundles[i];
            String name = aBundle.getSymbolicName();
            if (RationalPlatformDetector.isAPowerBundle(name)) {
                powerBundlesPresent = true;
            }
            if (RationalPlatformDetector.isAzOSBundle(name)) {
                zBundlesPresent = true;
            }
            if (zBundlesPresent && powerBundlesPresent) break;
            ++i;
        }
        if (zBundlesPresent && powerBundlesPresent) {
            return Platform_Type.RDZ_Entreprise;
        }
        if (zBundlesPresent) {
            return Platform_Type.RDZ;
        }
        if (powerBundlesPresent) {
            return Platform_Type.RDP;
        }
        return Platform_Type.UNKNOWN_PLATFORM;
    }

    public static enum Platform_Type {
        RDZ,
        RDP,
        RDZ_Entreprise,
        UNKNOWN_PLATFORM;

    }
}

