/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.pdp.framework.graphictools.PdpColorTool;
import com.ibm.pdp.pacbase.preferences.PdpPacPreferencePage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PdpPacbasePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.pdp.pacbase";
    private static PdpPacbasePlugin plugin;
    private static Map<String, Image> images;
    private static Map<String, ImageDescriptor> descriptors;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        images = new HashMap<String, Image>();
        descriptors = new HashMap<String, ImageDescriptor>();
    }

    public PdpPacbasePlugin() {
        plugin = this;
    }

    public static void setHelpMechanism(Composite parent, String contextId) {
        String aCtx = "com.ibm.pdp.doc.cshelp." + contextId;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, aCtx);
    }

    private void initPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        String exists = null;
        if (PlatformUI.isWorkbenchRunning()) {
            PdpPacPreferencePage.default_PDP_foregound_RGB = PdpColorTool.getDefaultGeneratedForegroundRGB();
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpbackgroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_BACKGROUND_COLOR_RGB);
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmacrobackgroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MACRO_BACKGROUND_COLOR_RGB);
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmacroforegroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MACRO_FOREGROUND_COLOR_RGB);
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmpbackgroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MP_BACKGROUND_COLOR_RGB);
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmpforegroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MP_FOREGROUND_COLOR_RGB);
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmpcallbackgroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MP_CALL_BACKGROUND_COLOR_RGB);
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmpcallforegroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MP_CALL_FOREGROUND_COLOR_RGB);
            exists = store.getString("com.ibm.pdp.pacbase.preferences.pdpbackgroundcolor");
            if (exists.equals("")) {
                PreferenceConverter.setValue((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpbackgroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_BACKGROUND_COLOR_RGB);
            }
            exists = store.getString("com.ibm.pdp.pacbase.preferences.pdpforegroundcolor");
            exists = store.getString("com.ibm.pdp.pacbase.preferences.pdpmacrobackgroundcolor");
            if (exists.equals("")) {
                PreferenceConverter.setValue((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmacrobackgroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MACRO_BACKGROUND_COLOR_RGB);
            }
            if ((exists = store.getString("com.ibm.pdp.pacbase.preferences.pdpmacroforegroundcolor")).equals("")) {
                PreferenceConverter.setValue((IPreferenceStore)store, (String)"com.ibm.pdp.pacbase.preferences.pdpmacroforegroundcolor", (RGB)PdpPacPreferencePage.DEFAULT_PDP_MACRO_FOREGROUND_COLOR_RGB);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static PdpPacbasePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = descriptors.get(path);
        if (descriptor == null) {
            descriptor = PdpPacbasePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            descriptors.put(path, descriptor);
        }
        return descriptor;
    }

    public static Image getImage(String path) {
        ImageDescriptor descriptor;
        Image image = images.get(path);
        if (image == null && (descriptor = PdpPacbasePlugin.getImageDescriptor(path)) != null) {
            image = descriptor.createImage();
            images.put(path, image);
        }
        return image;
    }
}

