/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.icu.lang.UCharacter;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.util.geninfo.GeneratedInfoConverter;
import com.ibm.pdp.engine.util.geninfo.TagConversionMode;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.util.Strings;
import java.util.Arrays;
import java.util.Iterator;

public class PacbaseGenInfoConverter
extends GeneratedInfoConverter {
    protected boolean cutAtColumn72;
    protected SequenceNumberConvert convertNumbers;
    protected char[] sequence;
    protected int column;
    protected boolean skipEndOfLine;
    protected StringBuilder convertedText;
    protected int toCopyBeginIdx;
    protected int toCopyEndIdx;
    protected int variableDigitRank;
    protected boolean batch;
    protected boolean moveTagEndAfterEol;
    protected int tagToClose;
    protected int closeIndex;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacbaseGenInfoConverter(IGeneratedInfoFactory factory) {
        super(factory);
    }

    public SequenceNumberConvert getSequenceNumberConvert() {
        return this.convertNumbers;
    }

    public void setSequenceNumberConvert(SequenceNumberConvert numbersConvert) {
        this.convertNumbers = numbersConvert;
    }

    public boolean getCutAtColumn72() {
        return this.cutAtColumn72;
    }

    public void setCutAtColumn72(boolean newCutAtColumn72) {
        this.cutAtColumn72 = newCutAtColumn72;
    }

    public boolean getMoveTagEndAfterEol() {
        return this.moveTagEndAfterEol;
    }

    public void setMoveTagEndAfterEol(boolean newMoveTagEnd) {
        this.moveTagEndAfterEol = newMoveTagEnd;
    }

    protected boolean toConvert(IGeneratedInfo generatedInfo) {
        return generatedInfo != null && generatedInfo.getProperty("PacbaseConverted") == null;
    }

    protected void initializeConversion(IGeneratedInfo generatedInfoToConvert) {
        int maxNbOfLines;
        if (this.convertNumbers == null) {
            this.initSequenceNumbersConvert(generatedInfoToConvert);
        }
        this.column = 0;
        this.toCopyEndIdx = 0;
        this.toCopyBeginIdx = 0;
        this.skipEndOfLine = false;
        if (this.convertNumbers == SequenceNumberConvert.Renumber) {
            if (this.sequence == null) {
                this.sequence = new char[]{'0', '0', '0', '0', '0', '0'};
            } else {
                Arrays.fill(this.sequence, '0');
            }
        }
        if (this.convertedText == null) {
            this.convertedText = new StringBuilder();
        }
        this.variableDigitRank = (maxNbOfLines = generatedInfoToConvert.getText().length() / 72) < 10000 ? 3 : (maxNbOfLines < 100000 ? 4 : 5);
        super.initializeConversion(generatedInfoToConvert);
    }

    protected IGeneratedInfo createNewGeneratedInfo(IGeneratedInfo generatedInfoToConvert) {
        IGeneratedInfo newGeneratedInfo = super.createNewGeneratedInfo(generatedInfoToConvert);
        newGeneratedInfo.setProperty("PacbaseConverted", "True");
        return newGeneratedInfo;
    }

    protected void initSequenceNumbersConvert(IGeneratedInfo generatedInfo) {
        CharSequence generatedText = generatedInfo.getText();
        int length = generatedText.length();
        this.convertNumbers = length == 0 ? SequenceNumberConvert.Ignore : (generatedText.charAt(0) == ' ' ? SequenceNumberConvert.Clear : SequenceNumberConvert.Renumber);
    }

    protected String convertPropertyName(String name) {
        return (name = name.trim()).length() > 0 ? name : null;
    }

    protected String convertTagName(IGeneratedTag tag) {
        return tag.getName().trim();
    }

    protected TagConversionMode tagConversionMode(IGeneratedTag tag) {
        String tagName = tag.getName().trim();
        if (PdpTool.isFilteredTagName((String)tagName, null) && this.isRemoveableTag(tag)) {
            return TagConversionMode.SkipTag;
        }
        if (tagName.endsWith("-FN") || tagName.endsWith("-BODY")) {
            tag.setProperty("hidden", "true");
        }
        return TagConversionMode.Convert;
    }

    protected boolean isRemoveableTag(IGeneratedTag tag) {
        if (tag.getParent() != null) {
            return true;
        }
        Iterator sons = tag.sons();
        if (!sons.hasNext()) {
            return false;
        }
        tag = (IGeneratedTag)sons.next();
        if (sons.hasNext()) {
            return false;
        }
        return tag.getBeginIndex() == 0 && tag.getEndIndex() == tag.getGeneratedInfo().getText().length();
    }

    protected void beginTag(String tagName) {
        this.flushText();
        this.endAllTagToClose();
        super.beginTag(tagName);
    }

    protected void endTag(String tagName) {
        if (this.tagToClose > 0) {
            ++this.tagToClose;
            return;
        }
        if (this.moveTagEndAfterEol) {
            this.closeIndex = this.endTagIndex(this.toCopyEndIdx);
            if (this.closeIndex > this.toCopyEndIdx) {
                ++this.tagToClose;
                return;
            }
        }
        this.flushText();
        super.endTag(tagName);
    }

    protected int endTagIndex(int index) {
        if (this.cutAtColumn72) {
            return this.endTagIndexCutAtColumn72(index, this.column);
        }
        boolean foundCr = false;
        boolean foundLf = false;
        int length = this.text.length();
        int i = index;
        while (i < length) {
            char c = this.text.charAt(i);
            if (!UCharacter.isWhitespace((int)c)) {
                return foundCr || foundLf ? i : index;
            }
            if (foundCr) {
                return c == '\n' ? i + 1 : i;
            }
            if (foundLf) {
                return c == '\r' ? i + 1 : i;
            }
            if (c == '\r') {
                foundCr = true;
            } else if (c == '\n') {
                foundLf = true;
            }
            ++i;
        }
        return length;
    }

    protected int endTagIndexCutAtColumn72(int index, int currentColumn) {
        char c;
        boolean foundCr = false;
        boolean foundLf = false;
        int length = this.text.length();
        int column72Idx = currentColumn < 72 ? Math.min(index + 72 - currentColumn, length) : index;
        int i = index;
        while (i < column72Idx) {
            c = this.text.charAt(i);
            if (!UCharacter.isWhitespace((int)c)) {
                return foundCr || foundLf ? i : index;
            }
            if (foundCr) {
                return c == '\n' ? i + 1 : i;
            }
            if (foundLf) {
                return c == '\r' ? i + 1 : i;
            }
            if (c == '\r') {
                foundCr = true;
            } else if (c == '\n') {
                foundLf = true;
            }
            ++i;
        }
        i = column72Idx;
        while (i < length) {
            c = this.text.charAt(i);
            if (foundCr) {
                return c == '\n' ? i + 1 : i;
            }
            if (foundLf) {
                return c == '\r' ? i + 1 : i;
            }
            if (c == '\r') {
                foundCr = true;
            } else if (c == '\n') {
                foundLf = true;
            }
            ++i;
        }
        return length;
    }

    protected void endAllTagToClose() {
        while (this.tagToClose > 0) {
            super.endTag(null);
            --this.tagToClose;
        }
    }

    protected void convertText(int beginIdx, int endIdx) {
        if (beginIdx == endIdx) {
            return;
        }
        if (this.tagToClose == 0 || endIdx < this.closeIndex) {
            this.textConvertion(beginIdx, endIdx);
            return;
        }
        if (beginIdx < this.closeIndex) {
            this.textConvertion(beginIdx, this.closeIndex);
        }
        this.flushText();
        this.endAllTagToClose();
        if (this.closeIndex < endIdx) {
            this.textConvertion(this.closeIndex, endIdx);
        }
    }

    protected void textConvertion(int beginIdx, int endIdx) {
        char lastChar;
        switch (this.convertNumbers) {
            case Ignore: {
                this.convertTextIgnoreSequenceNumbers(beginIdx, endIdx);
                break;
            }
            case Clear: {
                this.convertTextClearSequenceNumbers(beginIdx, endIdx);
                break;
            }
            case Renumber: {
                this.convertTextRenumber(beginIdx, endIdx);
            }
        }
        int length = this.text.length();
        if (endIdx == length && length > 0 && (lastChar = this.text.charAt(length - 1)) != '\n' && lastChar != '\r') {
            String lineDelimiter = Strings.getLineSeparator();
            int i = 0;
            while (i < lineDelimiter.length()) {
                this.addConvertedChar(lineDelimiter.charAt(i));
                ++i;
            }
        }
    }

    protected void convertTextIgnoreSequenceNumbers(int beginIdx, int endIdx) {
        if (this.cutAtColumn72) {
            this.convertTextIgnoreSequenceNumbersClearEndOfLine(beginIdx, endIdx);
            return;
        }
        int toCopyBegin = this.toCopyBeginIdx;
        int idx = beginIdx;
        while (idx < endIdx) {
            char c = this.text.charAt(idx);
            if (c == '\n' || c == '\r') {
                this.column = -1;
                this.skipEndOfLine = false;
            } else if (this.skipEndOfLine) {
                toCopyBegin = idx + 1;
            } else if (UCharacter.isWhitespace((int)c) && this.blankToEndOfLine(idx + 1)) {
                this.flushText(toCopyBegin, idx);
                toCopyBegin = idx + 1;
                this.skipEndOfLine = true;
            }
            ++idx;
            ++this.column;
        }
        this.toCopyBeginIdx = toCopyBegin;
        this.toCopyEndIdx = endIdx;
    }

    protected void convertTextIgnoreSequenceNumbersClearEndOfLine(int beginIdx, int endIdx) {
        int toCopyBegin = this.toCopyBeginIdx;
        int idx = beginIdx;
        while (idx < endIdx) {
            char c = this.text.charAt(idx);
            if (c == '\n' || c == '\r') {
                this.column = -1;
                this.skipEndOfLine = false;
            } else if (this.skipEndOfLine) {
                toCopyBegin = idx + 1;
            } else if (this.column >= 72 || UCharacter.isWhitespace((int)c) && this.blankToEndOfLine(idx + 1)) {
                this.flushText(toCopyBegin, idx);
                toCopyBegin = idx + 1;
                this.skipEndOfLine = true;
            }
            ++idx;
            ++this.column;
        }
        this.toCopyBeginIdx = toCopyBegin;
        this.toCopyEndIdx = endIdx;
    }

    protected void convertTextClearSequenceNumbers(int beginIdx, int endIdx) {
        if (this.cutAtColumn72) {
            this.convertTextClearSequenceNumbersClearEndOfLine(beginIdx, endIdx);
            return;
        }
        int toCopyBegin = this.toCopyBeginIdx;
        int idx = beginIdx;
        while (idx < endIdx) {
            char c = this.text.charAt(idx);
            if (c == '\n' || c == '\r') {
                this.column = -1;
                this.skipEndOfLine = false;
            } else if (this.skipEndOfLine) {
                toCopyBegin = idx + 1;
            } else if (this.column < 6) {
                if (c != ' ') {
                    this.addConvertedChar(toCopyBegin, idx, ' ');
                    toCopyBegin = idx + 1;
                }
            } else if (UCharacter.isWhitespace((int)c) && this.blankToEndOfLine(idx + 1)) {
                this.flushText(toCopyBegin, idx);
                toCopyBegin = idx + 1;
                this.skipEndOfLine = true;
            }
            ++idx;
            ++this.column;
        }
        this.toCopyBeginIdx = toCopyBegin;
        this.toCopyEndIdx = endIdx;
    }

    protected void convertTextClearSequenceNumbersClearEndOfLine(int beginIdx, int endIdx) {
        int toCopyBegin = this.toCopyBeginIdx;
        int idx = beginIdx;
        while (idx < endIdx) {
            char c = this.text.charAt(idx);
            if (c == '\n' || c == '\r') {
                this.column = -1;
                this.skipEndOfLine = false;
            } else if (this.skipEndOfLine) {
                toCopyBegin = idx + 1;
            } else if (this.column < 6) {
                if (c != ' ') {
                    this.addConvertedChar(toCopyBegin, idx, ' ');
                    toCopyBegin = idx + 1;
                }
            } else if (this.column >= 72 || UCharacter.isWhitespace((int)c) && this.blankToColumn72(idx + 1, this.column + 1)) {
                this.flushText(toCopyBegin, idx);
                toCopyBegin = idx + 1;
                this.skipEndOfLine = true;
            }
            ++idx;
            ++this.column;
        }
        this.toCopyBeginIdx = toCopyBegin;
        this.toCopyEndIdx = endIdx;
    }

    protected void convertTextRenumber(int beginIdx, int endIdx) {
        if (this.cutAtColumn72) {
            this.convertTextRenumberClearEndOfLine(beginIdx, endIdx);
            return;
        }
        int toCopyBegin = this.toCopyBeginIdx;
        int idx = beginIdx;
        while (idx < endIdx) {
            char c = this.text.charAt(idx);
            if (c == '\n' || c == '\r') {
                this.column = -1;
                this.skipEndOfLine = false;
            } else if (this.skipEndOfLine) {
                toCopyBegin = idx + 1;
            } else if (this.column < 6) {
                char digit;
                if (this.column == 0) {
                    this.nextSequenceNumber();
                }
                if ((digit = this.sequence[this.column]) != c) {
                    this.addConvertedChar(toCopyBegin, idx, digit);
                    toCopyBegin = idx + 1;
                }
            } else if (UCharacter.isWhitespace((int)c) && this.blankToEndOfLine(idx + 1)) {
                this.flushText(toCopyBegin, idx);
                toCopyBegin = idx + 1;
                this.skipEndOfLine = true;
            }
            ++idx;
            ++this.column;
        }
        this.toCopyBeginIdx = toCopyBegin;
        this.toCopyEndIdx = endIdx;
    }

    protected void convertTextRenumberClearEndOfLine(int beginIdx, int endIdx) {
        int toCopyBegin = this.toCopyBeginIdx;
        int idx = beginIdx;
        while (idx < endIdx) {
            char c = this.text.charAt(idx);
            if (c == '\n' || c == '\r') {
                this.column = -1;
                this.skipEndOfLine = false;
            } else if (this.skipEndOfLine) {
                toCopyBegin = idx + 1;
            } else if (this.column < 6) {
                char digit;
                if (this.column == 0) {
                    this.nextSequenceNumber();
                }
                if ((digit = this.sequence[this.column]) != c) {
                    this.addConvertedChar(toCopyBegin, idx, digit);
                    toCopyBegin = idx + 1;
                }
            } else if (this.column >= 72 || UCharacter.isWhitespace((int)c) && this.blankToColumn72(idx + 1, this.column + 1)) {
                this.flushText(toCopyBegin, idx);
                toCopyBegin = idx + 1;
                this.skipEndOfLine = true;
            }
            ++idx;
            ++this.column;
        }
        this.toCopyBeginIdx = toCopyBegin;
        this.toCopyEndIdx = endIdx;
    }

    protected void addConvertedChar(int beginIdx, int endIdx, char c) {
        if (endIdx > beginIdx) {
            this.flushText(beginIdx, endIdx);
        }
        this.convertedText.append(c);
    }

    protected void addConvertedChar(char c) {
        this.flushText();
        this.convertedText.append(c);
    }

    protected void flushText(int beginIdx, int endIdx) {
        if (this.convertedText.length() > 0) {
            this.factory.appendText((CharSequence)this.convertedText);
            this.convertedText.setLength(0);
        }
        if (endIdx > beginIdx) {
            this.factory.appendText(this.text.subSequence(beginIdx, endIdx));
        }
    }

    protected void flushText() {
        this.flushText(this.toCopyBeginIdx, this.toCopyEndIdx);
        this.toCopyBeginIdx = this.toCopyEndIdx;
    }

    protected boolean blankToEndOfLine(int beginIdx) {
        int endIdx = this.text.length();
        while (beginIdx < endIdx) {
            char c;
            if ((c = this.text.charAt(beginIdx++)) == '\r' || c == '\n') {
                return true;
            }
            if (UCharacter.isWhitespace((int)c)) continue;
            return false;
        }
        return true;
    }

    protected boolean blankToColumn72(int beginIdx, int currentColumn) {
        int endIdx = Math.min(beginIdx + 72 - currentColumn, this.text.length());
        while (beginIdx < endIdx) {
            char c;
            if ((c = this.text.charAt(beginIdx++)) == '\r' || c == '\n') {
                return true;
            }
            if (UCharacter.isWhitespace((int)c)) continue;
            return false;
        }
        return true;
    }

    protected void nextSequenceNumber() {
        int digitRank = this.variableDigitRank;
        while (digitRank >= 0) {
            char digit = this.sequence[digitRank];
            if (digit != '9') {
                this.sequence[digitRank] = (char)(digit + '\u0001');
                return;
            }
            this.sequence[digitRank] = 48;
            --digitRank;
        }
    }

    public static enum SequenceNumberConvert {
        Ignore,
        Clear,
        Renumber;

    }
}

