/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.PdpConstants;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.pattern.PdpPatternManager;
import com.ibm.pdp.generation.menu.SynchronizationTool;
import com.ibm.pdp.mdl.cobol.Copy;
import com.ibm.pdp.mdl.cobol.Program;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.UserEntity;
import com.ibm.pdp.mdl.kernel.impl.DataUnitImpl;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacBlockBaseTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacCobolTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataUnit;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacErrorLabel;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacSourceInheritanceGenerationHeader;
import com.ibm.pdp.mdl.pacbase.impl.PacAbstractDialogCommunicationMonitorImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacAbstractDialogFolderImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacAbstractDialogImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacAbstractDialogServerImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacProgramImpl;
import com.ibm.pdp.mdl.pacbase.util.PacGenerationTargetUtil;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationBlockBaseType;
import com.ibm.pdp.pacbase.FunctionInformations;
import com.ibm.pdp.pacbase.PacbaseGenInfoConverter;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.design.ModelUtil;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.generator.AbstractPacbasePattern;
import com.ibm.pdp.pacbase.generator.CobolPacbasePattern;
import com.ibm.pdp.pacbase.model.extension.IGeneratedTargetItem;
import com.ibm.pdp.pacbase.model.extension.internal.GeneratedTargetManager;
import com.ibm.pdp.pdppath.service.PdpPathService;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;

public class PacTool {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String[] _CATEGORIES = new String[]{"A", "R", "Z"};
    private static final String IDENTIFICATION_DIVISION = "IDENTIFICATION DIVISION";
    private static final String ENVIRONMENT_DIVISION = "ENVIRONMENT DIVISION";
    private static final String DATA_DIVISION = "DATA DIVISION";
    private static final String PROCEDURE_DIVISION = "PROCEDURE DIVISION";
    private static final String SLASH = "/";
    private static String DEFAULT = "";
    private static final String LABEL_900 = "-900.";
    private static final String LABEL_FN = "-FN.";
    private static final String LABEL_A = "-A.";
    private static final String LABEL_B = "-B.";
    private static final String LABEL_IF = "IF";
    public static final String CONDITION_CO = "CO";
    public static final String CONDITION_DC = "DC";
    public static final String CONDITION_DI = "DI";
    public static final String CONDITION_DO = "DO";
    public static final String CONDITION_DU = "DU";
    public static final String CONDITION_DV = "DV";
    public static final String CONDITION_DW = "DW";
    public static final String CONDITION_EL = "EL";
    public static final String CONDITION_IT = "IT";
    private static final String[] MP_TYPES = new String[]{"*!DCF", "*!DIF", "*!DVF", "*!CO"};
    private static final String[] MP_CONDITIONS = new String[]{"DC", "DI", "DV", "CO"};
    public static final String EOL = System.getProperty("line.separator");
    private static final String COPIBM = "COPYRIGHT=IBM";
    private static final Pattern patternUserService = Pattern.compile("(F[A-Z0-9]{4}).*\r\n.*\r\n.*(LV=[0-9]{2}).*(REF=USER[\\s]*[\\w]*)");
    private static final Pattern pattern80EX = Pattern.compile("(F80[0-9A-Z]{2}).*\r\n.*\\!SQL.*[\\s]*\"(.*)[\\s]+(EX|[DPRC][0-9])[\\s]+(.*)\"");

    public static String getMapFileNameFromDesign(RadicalEntity radicalEntity) {
        String cblFileName = PacTool.getLogicalMapFileNameFromDesign(radicalEntity);
        if (!(radicalEntity instanceof PacScreen)) {
            return null;
        }
        PacScreen screen = (PacScreen)radicalEntity;
        int index = cblFileName.lastIndexOf(47);
        String newBmsFileName = cblFileName;
        if (index != -1) {
            String externalName = screen.getScreenExternalName();
            if ((externalName == null || externalName.length() == 0) && (externalName = screen.getName().substring(2).equals("HELP") ? "PACHELM" : screen.getName()).length() > 8) {
                externalName = externalName.substring(0, 8);
            }
            newBmsFileName = String.valueOf(cblFileName.substring(0, index + 1)) + externalName + '.' + PacTool.getExtensionForScreen(screen);
        } else {
            newBmsFileName = PdpTool.replaceSuffixInFileName((String)cblFileName, (String)PacTool.getExtensionForScreen(screen));
        }
        return newBmsFileName;
    }

    private static String removeMarksInCol73AndArobaseLineFrom(String commentText) {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines = PdpTool.splitTextIntoArrayLines((String)commentText);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String aLine = stringArray[n2];
            if (!aLine.trim().startsWith("*@")) {
                int len = Math.min(aLine.length(), 72);
                sb.append(aLine.substring(0, len));
                sb.append(EOL);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String formatForGSVNodeTitle(CharSequence w_originalComments, String functionName, boolean truncToDefaultSize) {
        int x2;
        String tagName2;
        int x1;
        if (w_originalComments == null || w_originalComments.length() == 0) {
            return "";
        }
        w_originalComments = "      " + w_originalComments.subSequence(6, w_originalComments.length());
        String NOTE_LABEL = "NOTE ";
        int defaultMaxSize = 50;
        String originalComments = PacTool.removeMarksInCol73AndArobaseLineFrom(w_originalComments.toString());
        StringBuilder sb = new StringBuilder();
        int len = originalComments.length();
        int indice = originalComments.indexOf("*.");
        String[] sText = PdpTool.splitTextIntoArrayLines((String)originalComments);
        int i = 0;
        while (i < len) {
            char c = originalComments.charAt(i);
            if (!(c == '*' || c == '\r' || c == '\n' || c == '.' || c == '+' || c == '=' || c == '#' || c == ' ' && i + 1 < len && originalComments.charAt(i + 1) == ' ' || indice != -1 && sText.length <= 1 && i >= indice)) {
                sb.append(c);
            }
            ++i;
        }
        if (functionName != null && functionName.length() >= 3 && (x1 = sb.indexOf(tagName2 = "N" + functionName.substring(1) + " ")) != -1 && x1 < 5) {
            sb.delete(x1, x1 + tagName2.length());
        }
        if ((x2 = sb.indexOf(NOTE_LABEL)) != -1 && x2 < 5) {
            sb.delete(x2, x2 + NOTE_LABEL.length());
        }
        String s = sb.toString().trim();
        if (truncToDefaultSize && s.length() > defaultMaxSize) {
            s = s.substring(0, defaultMaxSize);
        }
        return s;
    }

    public static String getServerManagerCobolFileNameFromDesign(RadicalEntity radicalEntity) {
        boolean useAbsoluteFolder = false;
        IGeneratedTargetItem targetItem = GeneratedTargetManager.getGeneratedTargetItem((RadicalEntity)radicalEntity);
        if (targetItem == null) {
            return null;
        }
        String cobolProject = targetItem.getServiceManagerProject();
        String cobolFolder = targetItem.getServiceManagerFolder();
        String programName = targetItem.getServiceManagerName();
        String radicalEntityCobolFolder = cobolFolder;
        cobolProject = PacTool.getComputedProjectName(radicalEntity, cobolProject, false, true);
        cobolFolder = PacTool.getComputedFolderName(radicalEntity, radicalEntityCobolFolder, false, true);
        if (cobolFolder != null) {
            useAbsoluteFolder = true;
        } else {
            cobolFolder = PacTool.getFullComputedFolderName(radicalEntity, radicalEntityCobolFolder, cobolProject, false, false, true);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SLASH);
        if (useAbsoluteFolder) {
            sb.append('%');
        }
        sb.append(cobolProject);
        if (cobolFolder != null && cobolFolder.trim().length() != 0) {
            sb.append(SLASH);
            sb.append(cobolFolder);
        }
        sb.append(SLASH);
        sb.append(programName);
        sb.append(".");
        sb.append("cbl");
        return sb.toString();
    }

    public static String getLogicalCobolFileNameFromDesign(RadicalEntity radicalEntity) {
        boolean useAbsoluteFolder = false;
        IGeneratedTargetItem targetItem = GeneratedTargetManager.getGeneratedTargetItem((RadicalEntity)radicalEntity);
        if (targetItem == null) {
            return null;
        }
        String cobolProject = targetItem.getCobolProject();
        String cobolFolder = targetItem.getCobolFolder();
        String programName = targetItem.getCobolName();
        String radicalEntityCobolFolder = cobolFolder;
        cobolProject = PacTool.getComputedProjectName(radicalEntity, cobolProject, false, false);
        cobolFolder = PacTool.getComputedFolderName(radicalEntity, radicalEntityCobolFolder, false, false);
        if (cobolFolder != null) {
            useAbsoluteFolder = true;
        } else {
            cobolFolder = PacTool.getFullComputedFolderName(radicalEntity, radicalEntityCobolFolder, cobolProject, false, false, false);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SLASH);
        if (useAbsoluteFolder) {
            sb.append('%');
        }
        sb.append(cobolProject);
        if (cobolFolder != null && cobolFolder.trim().length() != 0) {
            sb.append(SLASH);
            sb.append(cobolFolder);
        }
        sb.append(SLASH);
        sb.append(programName);
        if (radicalEntity instanceof PacBlockBase) {
            PacBlockBase bb = (PacBlockBase)radicalEntity;
            if (PacTransformationBlockBaseType.isRelationalBlockBaseType((PacBlockBaseTypeValues)bb.getBlockType())) {
                sb.append(".");
                sb.append("ddl");
            } else {
                sb.append(".");
                sb.append("txt");
            }
        } else if (radicalEntity instanceof PacErrorLabel) {
            sb.append(".");
            sb.append("txt");
        } else if (radicalEntity instanceof PacCopybook) {
            sb.append(".");
            sb.append("cpy");
        } else if (radicalEntity instanceof DataAggregate) {
            sb.append(".");
            sb.append("txt");
        } else if (radicalEntity instanceof PacFolderView) {
            sb.append(".");
            sb.append("txt");
        } else {
            sb.append(".");
            sb.append("cbl");
        }
        return sb.toString();
    }

    private static String getLogicalMapFileNameFromDesign(RadicalEntity radicalEntity) {
        boolean useAbsoluteFolder = false;
        IGeneratedTargetItem targetItem = GeneratedTargetManager.getGeneratedTargetItem((RadicalEntity)radicalEntity);
        if (targetItem == null) {
            return null;
        }
        String cobolFolder = targetItem.getCobolFolder();
        String programName = targetItem.getMapName();
        String mapFolder = targetItem.getMapFolder();
        String mapProject = targetItem.getMapProject();
        String radicalEntityCobolFolder = cobolFolder;
        String radicalEntityMapFolder = mapFolder;
        cobolFolder = PacTool.getComputedFolderName(radicalEntity, radicalEntityCobolFolder, false, false);
        mapProject = PacTool.getComputedProjectName(radicalEntity, mapProject, true, false);
        mapFolder = PacTool.getComputedFolderName(radicalEntity, radicalEntityMapFolder, true, false);
        if (cobolFolder != null || mapFolder != null) {
            useAbsoluteFolder = true;
        }
        if (cobolFolder == null && mapFolder == null) {
            cobolFolder = PacTool.getFullComputedFolderName(radicalEntity, radicalEntityCobolFolder, mapFolder, false, false, false);
        }
        if (cobolFolder != null && mapFolder == null) {
            mapFolder = PacTool.getFullComputedFolderName(radicalEntity, radicalEntityMapFolder, mapFolder, false, false, false);
        }
        if (cobolFolder == null && mapFolder != null) {
            mapFolder = PacTool.getFullComputedFolderName(radicalEntity, radicalEntityMapFolder, mapFolder, false, true, false);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SLASH);
        if (useAbsoluteFolder) {
            sb.append('%');
        }
        sb.append(mapProject);
        if (mapFolder != null && mapFolder.trim().length() != 0) {
            sb.append(SLASH);
            sb.append(mapFolder);
        } else if (cobolFolder != null && cobolFolder.trim().length() != 0) {
            sb.append(SLASH);
            sb.append(cobolFolder);
        }
        sb.append(SLASH);
        sb.append(programName);
        sb.append(".");
        sb.append("cbl");
        return sb.toString();
    }

    public static String getLogicalFileNameFromDesign(RadicalEntity re, String targetProject, String targetFolder, String sourceName) {
        boolean useAbsoluteFolder = false;
        if (targetFolder != null && targetFolder.trim().length() > 0) {
            useAbsoluteFolder = true;
        } else {
            targetFolder = PacTool.getFullComputedFolderName(re, targetProject, false);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SLASH);
        if (useAbsoluteFolder) {
            sb.append('%');
        }
        sb.append(targetProject);
        if (targetFolder != null && targetFolder.trim().length() != 0) {
            sb.append(SLASH);
            sb.append(targetFolder);
        }
        sb.append(SLASH);
        sb.append(sourceName);
        sb.append(".");
        sb.append("txt");
        return sb.toString();
    }

    private static String getFullComputedFolderName(RadicalEntity re, String projectName, boolean withRootPath) {
        String genRootPath;
        URI uri = re.getDesignURI();
        String path = uri.devicePath();
        int lastIndex = path.lastIndexOf(47);
        path = lastIndex > 1 ? path.substring(1, lastIndex) : "";
        if (withRootPath && (genRootPath = PdpPathService.getGenRootFolder((String)projectName)) != null && genRootPath.trim().length() != 0) {
            path = String.valueOf(genRootPath) + SLASH + path;
        }
        return path;
    }

    public static String getFullCobolFileNameFromDesignFileName(RadicalEntity radicalEntity, String designfileName) {
        StringBuilder cblFileName = new StringBuilder();
        String cobolProject = "";
        String cobolFolder = "";
        IGeneratedTargetItem targetItem = GeneratedTargetManager.getGeneratedTargetItem((RadicalEntity)radicalEntity);
        String _programName = targetItem.getCobolName();
        if (radicalEntity instanceof PacProgram) {
            PacProgram pgm = (PacProgram)radicalEntity;
            cobolProject = PacTool.getComputedProjectName((RadicalEntity)pgm, pgm.getCobolProject(), false, false);
            cobolFolder = PacTool.getFullComputedFolderName((RadicalEntity)pgm, pgm.getCobolFolder(), cobolProject, true, false, false);
            cblFileName.append(SLASH);
            cblFileName.append(cobolProject);
            cblFileName.append(SLASH);
            if (cobolFolder != null && cobolFolder.length() != 0) {
                cblFileName.append(cobolFolder);
                if (!cobolFolder.endsWith(SLASH)) {
                    cblFileName.append(SLASH);
                }
            }
            cblFileName.append(_programName);
            cblFileName.append(".");
            cblFileName.append("cbl");
            return cblFileName.toString();
        }
        if (radicalEntity instanceof PacBlockBase) {
            PacBlockBase dbd = (PacBlockBase)radicalEntity;
            cobolProject = PacTool.getComputedProjectName((RadicalEntity)dbd, dbd.getGenerateProject(), false, false);
            cobolFolder = PacTool.getFullComputedFolderName((RadicalEntity)dbd, dbd.getGenerateFolder(), cobolProject, true, false, false);
            _programName = GeneratedTargetManager.getGeneratedName((PacBlockBase)dbd);
            cblFileName.append(SLASH);
            cblFileName.append(cobolProject);
            cblFileName.append(SLASH);
            if (cobolFolder != null && cobolFolder.length() != 0) {
                cblFileName.append(cobolFolder);
                if (!cobolFolder.endsWith(SLASH)) {
                    cblFileName.append(SLASH);
                }
            }
            cblFileName.append(_programName.trim());
            cblFileName.append(".");
            if (PacTransformationBlockBaseType.isRelationalBlockBaseType((PacBlockBaseTypeValues)dbd.getBlockType())) {
                cblFileName.append("ddl");
            } else {
                cblFileName.append("txt");
            }
            return cblFileName.toString();
        }
        if (radicalEntity instanceof PacAbstractDialog) {
            PacAbstractDialog dialog = (PacAbstractDialog)radicalEntity;
            cobolProject = PacTool.getComputedProjectName((RadicalEntity)dialog, dialog.getCobolProject(), false, false);
            cobolFolder = PacTool.getFullComputedFolderName((RadicalEntity)dialog, dialog.getCobolFolder(), cobolProject, true, false, false);
            cblFileName.append(SLASH);
            cblFileName.append(cobolProject);
            cblFileName.append(SLASH);
            if (cobolFolder != null && cobolFolder.length() != 0) {
                cblFileName.append(cobolFolder);
                if (!cobolFolder.endsWith(SLASH)) {
                    cblFileName.append(SLASH);
                }
            }
            cblFileName.append(_programName);
            cblFileName.append(".");
            cblFileName.append("cbl");
            return cblFileName.toString();
        }
        if (radicalEntity instanceof PacAbstractDialogServer) {
            PacAbstractDialogServer server = (PacAbstractDialogServer)radicalEntity;
            cobolProject = PacTool.getComputedProjectName((RadicalEntity)server, server.getCobolProject(), false, false);
            cobolFolder = PacTool.getFullComputedFolderName((RadicalEntity)server, server.getCobolFolder(), cobolProject, true, false, false);
            cblFileName.append(SLASH);
            cblFileName.append(cobolProject);
            cblFileName.append(SLASH);
            if (cobolFolder != null && cobolFolder.length() != 0) {
                cblFileName.append(cobolFolder);
                if (!cobolFolder.endsWith(SLASH)) {
                    cblFileName.append(SLASH);
                }
            }
            cblFileName.append(_programName);
            cblFileName.append(".");
            cblFileName.append("cbl");
            return cblFileName.toString();
        }
        if (radicalEntity instanceof PacCommunicationMonitor) {
            PacCommunicationMonitor pgm = (PacCommunicationMonitor)radicalEntity;
            cobolProject = PacTool.getComputedProjectName((RadicalEntity)pgm, pgm.getCobolProject(), false, false);
            cobolFolder = PacTool.getFullComputedFolderName((RadicalEntity)pgm, pgm.getCobolFolder(), cobolProject, true, false, false);
            cblFileName.append(SLASH);
            cblFileName.append(cobolProject);
            cblFileName.append(SLASH);
            if (cobolFolder != null && cobolFolder.length() != 0) {
                cblFileName.append(cobolFolder);
                if (!cobolFolder.endsWith(SLASH)) {
                    cblFileName.append(SLASH);
                }
            }
            cblFileName.append(_programName);
            cblFileName.append(".");
            cblFileName.append("cbl");
            return cblFileName.toString();
        }
        if (radicalEntity instanceof PacFolder) {
            PacFolder pgm = (PacFolder)radicalEntity;
            cobolProject = PacTool.getComputedProjectName((RadicalEntity)pgm, pgm.getCobolProject(), false, false);
            cobolFolder = PacTool.getFullComputedFolderName((RadicalEntity)pgm, pgm.getCobolFolder(), cobolProject, true, false, false);
            cblFileName.append(SLASH);
            cblFileName.append(cobolProject);
            cblFileName.append(SLASH);
            if (cobolFolder != null && cobolFolder.length() != 0) {
                cblFileName.append(cobolFolder);
                if (!cobolFolder.endsWith(SLASH)) {
                    cblFileName.append(SLASH);
                }
            }
            cblFileName.append(_programName);
            cblFileName.append(".");
            cblFileName.append("cbl");
            return cblFileName.toString();
        }
        int i = designfileName.lastIndexOf(".");
        if (i == -1) {
            return null;
        }
        String cblFileOld = String.valueOf(designfileName.substring(0, i)) + "." + "cbl";
        if (radicalEntity instanceof DataUnitImpl) {
            cblFileOld = String.valueOf(designfileName.substring(0, i)) + "." + "cpy";
        }
        return cblFileOld;
    }

    public static String getFullMapFileNameFromDesignFileName(RadicalEntity radicalEntity) {
        StringBuilder cblFileName = new StringBuilder();
        String cobolProject = "";
        String mapFolder = "";
        IGeneratedTargetItem targetItem = GeneratedTargetManager.getGeneratedTargetItem((RadicalEntity)radicalEntity);
        String _mapName = targetItem.getMapName();
        if (radicalEntity instanceof PacScreen) {
            PacScreen screen = (PacScreen)radicalEntity;
            cobolProject = PacTool.getComputedProjectName((RadicalEntity)screen, screen.getCobolProject(), true, false);
            mapFolder = PacTool.getFullComputedFolderName((RadicalEntity)screen, screen.getMapFolder(), cobolProject, true, true, false);
            cblFileName.append(SLASH);
            cblFileName.append(cobolProject);
            cblFileName.append(SLASH);
            if (mapFolder != null && mapFolder.length() != 0) {
                cblFileName.append(mapFolder);
                if (!mapFolder.endsWith(SLASH)) {
                    cblFileName.append(SLASH);
                }
            }
            cblFileName.append(_mapName);
            cblFileName.append(".");
            cblFileName.append("cbl");
            return PdpTool.replaceSuffixInFileName((String)cblFileName.toString(), (String)PacTool.getExtensionForScreen(screen));
        }
        return null;
    }

    private static String getComputedFolderName(RadicalEntity re, String folderName, boolean map, boolean isServiceManager) {
        if (folderName != null && !folderName.equals(DEFAULT)) {
            return folderName;
        }
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        String dlgFolder = PacGenerationTargetUtil.getComputedDialogFolderName((RadicalEntity)re, (boolean)map);
        PTEditorService.setResolvingMode((int)resolMode);
        if (dlgFolder != null) {
            return dlgFolder;
        }
        String libFolder = PacTool.getComputedLibFolderName(re, map, isServiceManager);
        if (libFolder != null) {
            return libFolder;
        }
        return null;
    }

    private static String getFullComputedFolderName(RadicalEntity re, String folderName, String projectName, boolean withRootPath, boolean map, boolean isServiceManager) {
        String genRootPath;
        String computedFolderName = PacTool.getComputedFolderName(re, folderName, map, isServiceManager);
        if (computedFolderName != null) {
            return computedFolderName;
        }
        URI uri = re.getDesignURI();
        String path = uri.devicePath();
        int lastIndex = path.lastIndexOf(47);
        path = lastIndex > 1 ? path.substring(1, lastIndex) : "";
        if (withRootPath && (genRootPath = PdpPathService.getGenRootFolder((String)projectName)) != null && genRootPath.trim().length() != 0) {
            path = String.valueOf(genRootPath) + SLASH + path;
        }
        return path;
    }

    private static String getComputedProjectName(RadicalEntity re, String projectName, boolean map, boolean isServiceManager) {
        if (projectName != null && !projectName.equals(DEFAULT)) {
            return projectName;
        }
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        String dlgProject = PacGenerationTargetUtil.getComputedDialogProjectName((RadicalEntity)re);
        PTEditorService.setResolvingMode((int)resolMode);
        if (dlgProject != null) {
            return dlgProject;
        }
        String libProject = PacTool.getComputedLibProjectName(re, map, isServiceManager);
        if (libProject != null) {
            return libProject;
        }
        return re.getProject();
    }

    private static PatternAndRank getPatternFor(RadicalEntity re, boolean map, boolean isServiceManager) {
        String designId = re.getDesignId(re.getProject());
        String fullDesignName = PdpTool.addRPPFolderToFileName((String)designId);
        String[] generators = GenerationManager.generatorsFor((String)fullDesignName);
        if (generators != null && generators.length > 0) {
            IPattern pattern;
            String patternName;
            if (generators.length == 1) {
                PatternAndRank patternAndRank = new PatternAndRank();
                patternAndRank.patternName = generators[0];
                patternAndRank.rank = map || isServiceManager ? 2 : 1;
                return patternAndRank;
            }
            String[] stringArray = generators;
            int n = generators.length;
            int n2 = 0;
            while (n2 < n) {
                patternName = stringArray[n2];
                pattern = PdpPatternManager.getPdpPattern((String)patternName);
                if (pattern instanceof CobolPacbasePattern) {
                    PatternAndRank patternAndRank = new PatternAndRank();
                    patternAndRank.patternName = patternName;
                    patternAndRank.rank = map || isServiceManager ? 2 : 1;
                    return patternAndRank;
                }
                ++n2;
            }
            stringArray = generators;
            n = generators.length;
            n2 = 0;
            while (n2 < n) {
                patternName = stringArray[n2];
                pattern = PdpPatternManager.getPdpPattern((String)patternName);
                if (pattern instanceof AbstractPacbasePattern) {
                    PatternAndRank patternAndRank = new PatternAndRank();
                    patternAndRank.patternName = patternName;
                    patternAndRank.rank = map || isServiceManager ? 2 : 1;
                    return patternAndRank;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String getComputedLibFolderName(RadicalEntity re, boolean map, boolean isServiceManager) {
        String folder;
        if (re == null) {
            return null;
        }
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        PacLibrary lib = PacTool.getComputedPacLib(re);
        PTEditorService.setResolvingMode((int)resolMode);
        PatternAndRank patternAndRank = PacTool.getPatternFor(re, map, isServiceManager);
        if (patternAndRank != null && (folder = PacGenerationTargetUtil.getLibraryFolderName((RadicalEntity)re, (PacLibrary)lib, (String)patternAndRank.patternName, (int)patternAndRank.rank)) != null) {
            return folder.equals(DEFAULT) ? null : folder;
        }
        if (lib != null) {
            String folderTmp = "";
            folderTmp = !map ? lib.getCobolFolder() : lib.getMapFolder();
            if (folderTmp != null && !folderTmp.equals(DEFAULT)) {
                return folderTmp;
            }
        }
        return null;
    }

    private static String getComputedLibProjectName(RadicalEntity re, boolean map, boolean isServiceManager) {
        String projectTmp;
        String project;
        if (re == null) {
            return null;
        }
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        PacLibrary lib = PacTool.getComputedPacLib(re);
        PTEditorService.setResolvingMode((int)resolMode);
        PatternAndRank patternAndRank = PacTool.getPatternFor(re, map, isServiceManager);
        if (patternAndRank != null && (project = PacGenerationTargetUtil.getLibraryProjectName((RadicalEntity)re, (PacLibrary)lib, (String)patternAndRank.patternName, (int)patternAndRank.rank)) != null) {
            return project.equals(DEFAULT) ? null : project;
        }
        if (lib != null && (projectTmp = lib.getCobolProject()) != null && !projectTmp.equals(DEFAULT)) {
            return projectTmp;
        }
        return null;
    }

    private static PacLibrary getComputedPacLib(RadicalEntity re) {
        if (re == null) {
            return null;
        }
        PacGenerationHeader header = null;
        PacLibrary result = null;
        if (re instanceof PacScreen) {
            PacScreen screen = (PacScreen)re;
            header = screen.getGenerationHeader();
            result = screen.getGenerationParameter();
        } else if (re instanceof PacProgram) {
            PacProgram program = (PacProgram)re;
            header = program.getGenerationHeader();
            result = program.getGenerationParameter();
        } else if (re instanceof PacAbstractDialogServer) {
            PacAbstractDialogServer program = (PacAbstractDialogServer)re;
            header = program.getGenerationHeader();
            result = program.getGenerationParameter();
        } else if (re instanceof PacAbstractDialog) {
            PacAbstractDialog dialog = (PacAbstractDialog)re;
            header = dialog.getGenerationHeader();
            result = dialog.getGenerationParameter();
        } else if (re instanceof PacCommunicationMonitor) {
            PacCommunicationMonitor communicationMonitor = (PacCommunicationMonitor)re;
            header = communicationMonitor.getGenerationHeader();
            result = communicationMonitor.getGenerationParameter();
        } else if (re instanceof PacFolder) {
            PacFolder pacFolder = (PacFolder)re;
            header = pacFolder.getGenerationHeader();
            result = pacFolder.getGenerationParameter();
        } else if (re instanceof PacCopybook) {
            PacCopybook pacCopybook = (PacCopybook)re;
            header = pacCopybook.getGenerationHeader();
            result = pacCopybook.getGenerationParameter();
        } else if (re instanceof PacFolderView) {
            PacFolderView pacFolderView = (PacFolderView)re;
            header = pacFolderView.getGenerationHeader();
            result = pacFolderView.getGenerationParameter();
        } else if (re instanceof PacErrorLabel) {
            PacErrorLabel pacErrorLabel = (PacErrorLabel)re;
            header = pacErrorLabel.getGenerationHeader();
            result = pacErrorLabel.getGenerationParameter();
        } else if (re instanceof PacBlockBase) {
            PacBlockBase pacBlockBase = (PacBlockBase)re;
            result = pacBlockBase.getGenerationParameter();
        } else if (re instanceof DataAggregate) {
            DataUnit du;
            DataAggregate dataAggregate = (DataAggregate)re;
            Iterator ext = re.getExtensions().iterator();
            while (ext.hasNext()) {
                try {
                    PacDataAggregate pdag = (PacDataAggregate)ext.next();
                    result = pdag.getGenerationParameter();
                }
                catch (Exception exception) {}
            }
            if (result == null && (du = (DataUnit)PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)re, (String)dataAggregate.getName().substring(0, 2), (String)"dataunit")) != null) {
                ext = du.getExtensions().iterator();
                while (ext.hasNext()) {
                    try {
                        PacDataUnit pdu = (PacDataUnit)ext.next();
                        header = pdu.getGenerationHeader();
                        result = pdu.getGenerationParameter();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (header instanceof PacLibrarySubstitutionGenerationHeader) {
            result = ((PacLibrarySubstitutionGenerationHeader)header).getGenerationParameter();
        } else if (header instanceof PacSourceInheritanceGenerationHeader) {
            result = PacTool.getComputedPacLib(((PacSourceInheritanceGenerationHeader)header).getGeneratedRadicalEntity());
        }
        return result;
    }

    private static String getExtensionForScreen(PacScreen screen) {
        return GeneratedTargetManager.getExtensionForScreen((PacScreen)screen);
    }

    private static int get_COBOL_Flavor(PacCobolTypeValues pctv, boolean isForSyntaxCheck) {
        if (PacCobolTypeValues._1_LITERAL.equals(pctv) || PacCobolTypeValues._X_LITERAL.equals(pctv) || PacCobolTypeValues._O_LITERAL.equals(pctv)) {
            return 1;
        }
        if (PacCobolTypeValues._Z_LITERAL.equals(pctv)) {
            return 2;
        }
        if (PacCobolTypeValues._3_LITERAL.equals(pctv) && isForSyntaxCheck) {
            IPreferenceStore store = PdpPacbasePlugin.getDefault().getPreferenceStore();
            boolean cobolType3Compatible = false;
            if (store.contains("com.ibm.pdp.pacbase.preferences.coboltype3compatible")) {
                cobolType3Compatible = store.getBoolean("com.ibm.pdp.pacbase.preferences.coboltype3compatible");
            }
            return cobolType3Compatible ? 2 : 3;
        }
        return 3;
    }

    private static int get_COBOL_Flavor(PacProgramVariantValues ppvv, boolean isForSyntaxCheck) {
        if (PacProgramVariantValues._0_LITERAL.equals(ppvv) || PacProgramVariantValues._1_LITERAL.equals(ppvv) || PacProgramVariantValues._O_LITERAL.equals(ppvv) || PacProgramVariantValues._X_LITERAL.equals(ppvv) || PacProgramVariantValues._C_LITERAL.equals(ppvv)) {
            return 1;
        }
        if (PacProgramVariantValues._Z_LITERAL.equals(ppvv)) {
            return 2;
        }
        if (PacProgramVariantValues._3_LITERAL.equals(ppvv) && isForSyntaxCheck) {
            IPreferenceStore store = PdpPacbasePlugin.getDefault().getPreferenceStore();
            boolean cobolType3Compatible = false;
            if (store.contains("com.ibm.pdp.pacbase.preferences.coboltype3compatible")) {
                cobolType3Compatible = store.getBoolean("com.ibm.pdp.pacbase.preferences.coboltype3compatible");
            }
            return cobolType3Compatible ? 2 : 3;
        }
        return 3;
    }

    public static int getCobolFlavor(IPath designEntityPath) {
        int originalResolvingMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        RadicalEntity radEntity = PTEditorService.getSharedResource((IPath)designEntityPath);
        PTEditorService.setResolvingMode((int)originalResolvingMode);
        int a = PacTool.getCOBOLFlavor(radEntity);
        return a;
    }

    public static int getCOBOLFlavor(Object modelRoot) {
        return PacTool.getCOBOLFlavor(modelRoot, false);
    }

    public static int getCOBOLFlavor(Object modelRoot, boolean isForSyntaxCheck) {
        if (modelRoot instanceof Program || modelRoot instanceof Copy) {
            return 1;
        }
        if (modelRoot instanceof PacProgram) {
            PacProgramWrapper wrapper = new PacProgramWrapper((PacProgram)modelRoot);
            PacProgramVariantValues ppvv = wrapper.getVariante();
            return PacTool.get_COBOL_Flavor(ppvv, isForSyntaxCheck);
        }
        if (modelRoot instanceof PacAbstractDialog) {
            if (modelRoot instanceof PacDialog) {
                PacCobolTypeValues pctv = ((PacDialog)modelRoot).getCobolType();
                return PacTool.get_COBOL_Flavor(pctv, isForSyntaxCheck);
            }
            if (modelRoot instanceof PacScreen) {
                PacScreenWrapper wrapper = new PacScreenWrapper((PacScreen)modelRoot);
                PacCobolTypeValues pctv = wrapper.getCobolType();
                return PacTool.get_COBOL_Flavor(pctv, isForSyntaxCheck);
            }
        } else if (modelRoot instanceof PacAbstractDialogServer) {
            if (modelRoot instanceof PacDialogServer) {
                PacCobolTypeValues pctv = ((PacDialogServer)modelRoot).getCobolType();
                return PacTool.get_COBOL_Flavor(pctv, isForSyntaxCheck);
            }
            if (modelRoot instanceof PacServer) {
                PacServerWrapper wrapper = new PacServerWrapper((PacServer)modelRoot);
                PacCobolTypeValues pctv = wrapper.getCobolType();
                return PacTool.get_COBOL_Flavor(pctv, isForSyntaxCheck);
            }
        } else if (modelRoot instanceof UserEntity) {
            return 4;
        }
        return 3;
    }

    public static IGeneratedInfo createGeneratedInfoFrom(String cblGenFilename, String patternName) {
        IEngineFactory ief = PdpTool.getEngineFactory();
        FileInputStream is = null;
        try {
            is = new FileInputStream(cblGenFilename);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        IGeneratedInfo genInfo = ief.readGeneratedInfo((InputStream)is);
        PacbaseGenInfoConverter pacConverter = new PacbaseGenInfoConverter(ief.newGeneratedInfoFactory());
        pacConverter.setMoveTagEndAfterEol(true);
        pacConverter.setSequenceNumberConvert(PacbaseGenInfoConverter.SequenceNumberConvert.Clear);
        pacConverter.setCutAtColumn72(true);
        genInfo = pacConverter.convert(genInfo);
        genInfo.setProperty("pattern", patternName);
        genInfo.setProperty("DoNotAnalyze", "true");
        return genInfo;
    }

    public static String buildTagName(String functionName, String referencedEntity, IEditTree editTree) {
        String refEntity = referencedEntity.trim();
        String category = "A";
        String[] values = referencedEntity.split(" ");
        if (values.length == 2) {
            refEntity = values[0];
            category = values[1];
        }
        ITextNode node = null;
        StringBuilder sb = new StringBuilder(11);
        if (functionName.equals("F30") || functionName.equals("F65")) {
            sb.append(functionName);
            sb.append(refEntity);
            node = editTree.nodeFromTagName(sb.toString());
        } else if (functionName.equals("F20")) {
            int i = 0;
            while (i < _CATEGORIES.length && node == null) {
                sb.setLength(0);
                sb.append(functionName);
                sb.append(_CATEGORIES[i]);
                sb.append("-");
                sb.append(refEntity);
                node = editTree.nodeFromTagName(sb.toString());
                ++i;
            }
        } else if (functionName.equals("F80")) {
            sb.append(functionName);
            sb.append("-");
            sb.append(values[0]);
            if (values.length == 2) {
                sb.append("-");
                sb.append(values[1]);
            }
            node = editTree.nodeFromTagName(sb.toString());
        } else {
            sb.append(functionName);
            sb.append(category);
            sb.append("-");
            sb.append(refEntity);
            node = editTree.nodeFromTagName(sb.toString());
        }
        return sb.toString();
    }

    public static List<Integer> findCOBOLDivisionsIndexes(CharSequence cs) {
        boolean identificationDiv_Present = false;
        boolean environmentDiv_Present = false;
        boolean dataDiv_Present = false;
        ArrayList<Integer> hiddenBlocksOffsets = new ArrayList<Integer>();
        int index = 0;
        List lines = PdpTool.splitsInLine((CharSequence)cs);
        int linesSize = lines.size();
        int i = 0;
        while (i < linesSize) {
            String aLine = (String)lines.get(i);
            int lgth = aLine.length();
            if ((aLine = aLine.trim()).startsWith(IDENTIFICATION_DIVISION)) {
                identificationDiv_Present = true;
                hiddenBlocksOffsets.add(new Integer(index));
            } else if (aLine.startsWith(ENVIRONMENT_DIVISION)) {
                environmentDiv_Present = true;
                if (identificationDiv_Present) {
                    hiddenBlocksOffsets.add(new Integer(index));
                }
                hiddenBlocksOffsets.add(new Integer(index));
            } else if (aLine.startsWith(DATA_DIVISION)) {
                dataDiv_Present = true;
                if (environmentDiv_Present || identificationDiv_Present) {
                    hiddenBlocksOffsets.add(new Integer(index));
                }
                hiddenBlocksOffsets.add(new Integer(index));
            } else if (aLine.startsWith(PROCEDURE_DIVISION)) {
                if (dataDiv_Present || environmentDiv_Present || identificationDiv_Present) {
                    hiddenBlocksOffsets.add(new Integer(index));
                }
                hiddenBlocksOffsets.add(new Integer(index));
                hiddenBlocksOffsets.add(new Integer(cs.length()));
                break;
            }
            index += lgth;
            ++i;
        }
        if (hiddenBlocksOffsets.size() % 2 != 0) {
            hiddenBlocksOffsets.add(new Integer(cs.length()));
        }
        return hiddenBlocksOffsets;
    }

    public static boolean isMapGenerableForScreen(RadicalEntity re) {
        return GeneratedTargetManager.isMapGenerableForScreen((RadicalEntity)re);
    }

    public static boolean IsLinkageSectionStarting(String cobolContent) {
        String next;
        StringTokenizer st;
        return cobolContent.trim().length() > 0 && (st = new StringTokenizer(cobolContent)).hasMoreTokens() && "LINKAGE".equalsIgnoreCase(st.nextToken()) && st.hasMoreTokens() && ("SECTION".equalsIgnoreCase(next = st.nextToken()) || "SECTION.".equalsIgnoreCase(next));
    }

    public static boolean isStruturedCobol(IController controller) {
        String designFileId = controller.getDesignLink().getFileId();
        RadicalEntity _designRoot = ModelUtil.getSharedRadicalEntity(designFileId);
        if (_designRoot instanceof PacProgram) {
            PacProgram pgm = (PacProgram)_designRoot;
            if (pgm.getVariante() == PacProgramVariantValues._C_LITERAL) {
                return false;
            }
            if (pgm.getProgramStructure() == PacProgramStructureValues._D_LITERAL) {
                return false;
            }
            if (pgm.getProgramStructure() == PacProgramStructureValues._F_LITERAL) {
                return false;
            }
            if (pgm.getProgramStructure() == PacProgramStructureValues._S_LITERAL) {
                return false;
            }
        }
        return true;
    }

    public static String getDash900ForFunction(String name, String text) {
        int index;
        String newLine = System.getProperty("line.separator");
        Pattern lastLinePattern = Pattern.compile(String.valueOf(newLine) + "......." + name + "-900");
        Matcher lastLineMatcher = lastLinePattern.matcher(text);
        if (lastLineMatcher.find() && (index = lastLineMatcher.start()) != -1) {
            int endIndexWithoutSep;
            String tmpEnd;
            if ((tmpEnd = text.substring(index += newLine.length(), endIndexWithoutSep = text.indexOf(newLine, index))).endsWith("COA") || tmpEnd.endsWith("coa")) {
                return null;
            }
            int endIndex = text.indexOf(newLine, index) + newLine.length();
            return text.substring(index, endIndex);
        }
        return null;
    }

    public static List<String> splitTextIntoLines(String text) {
        return PdpTool.splitTextIntoLines((String)text);
    }

    public static String getFunctionLevel(String name, String text) {
        List<String> lines = PacTool.splitTextIntoLines(text);
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            PacLabel pacLabel = BasicPacLabelRecognizer.findPacbaseLabelInLine(line);
            if (pacLabel != null && pacLabel.isBeginningLabel() && pacLabel.getPacLabel().equals(name) && line.length() > 72 && line.charAt(72) == 'l' && line.charAt(73) == 'v') {
                return line.substring(74);
            }
            ++i;
        }
        return null;
    }

    public static String getRealLevel(ITextNode current) {
        TextStatus status = current.getTextStatus();
        String level = null;
        level = status == TextStatus.Unchanged && "artificialCreate".equals(current.getProperties().getProperty("msp")) || status == TextStatus.Reformated ? PacTool.getFunctionLevel(current.getLabel().toString(), current.text().toString()) : current.getProperties().getProperty("level");
        return level;
    }

    public static int searchTextInText(String text, String textToSearch, boolean beginLine, boolean searchWithDelimiter) {
        String toSearch = textToSearch;
        String delim = PdpTool.determineDelimiterOfV2((CharSequence)text);
        if (beginLine && !searchWithDelimiter) {
            toSearch = "(^[\\s\\S]{6})" + textToSearch;
        }
        if (beginLine && searchWithDelimiter) {
            toSearch = String.valueOf(delim) + "([\\s\\S]{6})" + textToSearch;
        }
        try {
            Pattern p = Pattern.compile(toSearch);
            Matcher m = p.matcher(text);
            if (m.find()) {
                int i = m.start();
                if (beginLine && searchWithDelimiter) {
                    i += delim.length();
                }
                return i;
            }
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
        }
        return -1;
    }

    public static EList getCPLines(RadicalEntity re) {
        if (re instanceof PacProgram) {
            return ((PacProgramImpl)re).getCPLines();
        }
        if (re instanceof PacAbstractDialog) {
            return ((PacAbstractDialogImpl)re).getCPLines();
        }
        if (re instanceof PacAbstractDialogServer) {
            return ((PacAbstractDialogServerImpl)re).getCPLines();
        }
        if (re instanceof PacAbstractDialogFolder) {
            return ((PacAbstractDialogFolderImpl)re).getCPLines();
        }
        if (re instanceof PacAbstractDialogCommunicationMonitor) {
            return ((PacAbstractDialogCommunicationMonitorImpl)re).getCPLines();
        }
        return null;
    }

    public static FunctionInformations getFunctionInformations(String name, ITextNode textNode, boolean isSearchingInText) {
        FunctionInformations fi = PacTool.getFunctionInformations(isSearchingInText ? textNode.text() : textNode.generatedText());
        if (fi == null) {
            return null;
        }
        String condition = fi.getConditionType();
        String level = PacTool.getFunctionLevel(name, textNode.text().toString());
        fi.setLevel(level);
        if (condition.length() == 0) {
            String line900;
            FunctionInformations f;
            String currentFct;
            String previousFct;
            boolean isFunction = name.charAt(0) == 'F' && name.length() == 3;
            ITextNode previous = null;
            Iterator it = textNode.parentNode().sons();
            String lev = "";
            while (it.hasNext()) {
                ITextNode tn = (ITextNode)it.next();
                lev = PacTool.getFunctionLevel(tn.getLabel().toString(), tn.text().toString());
                if (tn.equals(textNode)) break;
                if (lev == null || !lev.equals(level)) continue;
                previous = tn;
            }
            if (previous != null && ((previousFct = previous.getLabel().subSequence(0, previous.getLabel().length() > 2 ? 3 : previous.getLabel().length()).toString()).equals(currentFct = name.substring(0, name.length() > 2 ? 3 : name.length())) || isFunction) && (f = PacTool.getFunctionInformations(previous.text())) != null && (CONDITION_IT.equals(f.getConditionType()) || CONDITION_DC.equals(f.getConditionType()) || CONDITION_DI.equals(f.getConditionType()) || CONDITION_DV.equals(f.getConditionType())) && (line900 = f.getLine900()) != null) {
                String string = line900 = line900.length() > 72 ? line900.substring(0, 72) : line900;
                if (line900.trim().endsWith(String.valueOf(name) + LABEL_FN)) {
                    condition = CONDITION_EL;
                }
            }
        }
        if (condition.length() == 0) {
            Iterator it = textNode.sons();
            while (it.hasNext()) {
                String line900;
                FunctionInformations f;
                ITextNode tn = (ITextNode)it.next();
                if (!PacTool.isFunctionNode(tn) || (f = PacTool.getFunctionInformations(tn.text())) == null || !CONDITION_IT.equals(f.getConditionType()) || (line900 = f.getLine900()) == null) continue;
                String string = line900 = line900.length() > 72 ? line900.substring(0, 72) : line900;
                if (!line900.trim().endsWith(textNode.getLabel() + LABEL_FN)) continue;
                condition = CONDITION_CO;
                break;
            }
        }
        fi.setConditionType(condition);
        return fi;
    }

    public static String getFunctionCondition(String name, ITextNode textNode, boolean isSearchingInText) {
        FunctionInformations fi = PacTool.getFunctionInformations(name, textNode, isSearchingInText);
        return fi != null ? fi.getConditionType() : "";
    }

    private static boolean isFunctionNode(ITextNode textNode) {
        ITagProperties properties;
        return textNode != null && textNode.isTagged() && (properties = textNode.getProperties()) != null && ("pac_function".equals(properties.getProperty("category")) || properties.getProperty("msp") != null && properties.getProperty("level") != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FunctionInformations getFunctionInformations(CharSequence text) {
        String newLine = "\r\n";
        StringTokenizer st = new StringTokenizer(text.toString(), newLine);
        ArrayList<Word> words = new ArrayList<Word>();
        int index = 0;
        String line = null;
        while (st.hasMoreTokens()) {
            line = st.nextToken();
            int l = line.length() > 72 ? line.length() - 72 : 0;
            String string = line = line.length() > 72 ? line.substring(0, 72) : line;
            if (line.length() < 6) {
                index += line.length();
            } else {
                String leftMargin = line.substring(0, 6);
                if (leftMargin.trim().length() > 0) {
                    line = line.replace(leftMargin, "      ");
                }
                if (line.trim().startsWith("*") && !line.trim().startsWith("*!")) {
                    index += line.length();
                } else {
                    StringTokenizer st1 = new StringTokenizer(line, " ", true);
                    while (st1.hasMoreTokens()) {
                        String t = st1.nextToken();
                        if (t.trim().length() == 0) {
                            index += t.length();
                            continue;
                        }
                        if ("EXIT.".equals(t)) {
                            index += 5;
                            continue;
                        }
                        Word word = new Word();
                        word.text = t;
                        word.start = text.toString().indexOf(t, index);
                        words.add(word);
                        index += t.length();
                    }
                }
            }
            index += l;
            index += newLine.length();
        }
        if (words.size() == 0) {
            return null;
        }
        FunctionInformations f = new FunctionInformations(text);
        boolean startIT = false;
        boolean startDO = false;
        boolean startDU = false;
        boolean startDW = false;
        String startMP = "";
        String label = "";
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < words.size()) {
            Word word = (Word)words.get(i);
            if (i == 0) {
                if (!word.text.startsWith("F") || !word.text.endsWith(".") || word.text.endsWith(LABEL_FN)) return null;
                label = word.text.substring(0, word.text.length() - 1);
                f.setName(label);
            } else {
                if (i == 1) {
                    if (LABEL_IF.equals(word.text)) {
                        startIT = true;
                    } else if ("MOVE".equals(word.text)) {
                        startDO = true;
                    } else if ("GO".equals(word.text)) {
                        startDU = true;
                    } else {
                        int j = 0;
                        while (j < MP_TYPES.length) {
                            if (word.text.equals(MP_TYPES[j])) {
                                startMP = MP_CONDITIONS[j];
                                break;
                            }
                            ++j;
                        }
                    }
                    f.setCondBeginIdx(word.start + word.text.length());
                }
                sb.append(word.text);
            }
            ++i;
        }
        if (!(String.valueOf(f.getName()) + LABEL_FN).equals(((Word)words.get((int)(words.size() - 1))).text)) {
            return null;
        }
        if (PacTool.searchTextInText(line, " " + f.getName() + LABEL_FN, true, false) == -1) {
            return null;
        }
        if (startMP.length() == 0) {
            StringBuilder search = new StringBuilder();
            if (startIT) {
                search.append("NEXTSENTENCEELSEGOTO");
                search.append(label).append(LABEL_FN);
            } else if (startDO) {
                search.append("GOTO");
                search.append(label).append(LABEL_B);
                search.append(label).append(LABEL_A);
            } else if (startDU) {
                search.append("GOTO");
                search.append(label).append(LABEL_B);
                search.append(label).append(LABEL_A);
                search.append(LABEL_IF);
            }
            int indexIT = sb.indexOf(search.toString());
            if (indexIT > -1) {
                if (startIT) {
                    search.replace(0, search.length(), "GOTO");
                    search.append(label).append(LABEL_FN);
                    if (sb.indexOf(search.toString()) < indexIT) {
                        startIT = false;
                        startDW = false;
                    } else {
                        search.replace(0, search.length(), label);
                        search.append(LABEL_900);
                        search.append("GOTO").append(label).append(".");
                        if (sb.indexOf(search.toString()) > -1) {
                            startIT = false;
                            startDW = true;
                        }
                    }
                }
            } else {
                startIT = false;
                startDO = false;
                startDU = false;
                startDW = false;
            }
        }
        String startBody = String.valueOf(label) + ".";
        if (startDU) {
            startBody = String.valueOf(label) + LABEL_B;
        } else if (startDO || startDW || startIT || startMP.length() > 0) {
            startBody = String.valueOf(label) + LABEL_FN;
        }
        String endBody = String.valueOf(label) + LABEL_FN;
        if (startDO || startDU || startDW) {
            endBody = String.valueOf(label) + LABEL_900;
        }
        String label900 = String.valueOf(label) + LABEL_900;
        String nextLabel = "NEXT";
        int index900 = 0;
        int i2 = 0;
        while (i2 < words.size()) {
            Word word = (Word)words.get(i2);
            if (nextLabel.equals(word.text)) {
                f.setCondEndIdx(((Word)words.get((int)(i2 - 1))).start + ((Word)words.get((int)(i2 - 1))).text.length());
                nextLabel = "nullnullnull";
            }
            if (startBody.equals(word.text)) {
                f.setBodyBeginIdx(((Word)words.get((int)i2)).start + text.toString().substring(((Word)words.get((int)i2)).start).indexOf(newLine) + newLine.length());
                startBody = "nullnullnull";
            } else {
                if (label900.equals(word.text)) {
                    index900 = text.toString().substring(0, ((Word)words.get((int)(i2 + 1))).start).lastIndexOf(newLine) + newLine.length();
                }
                if (endBody.equals(word.text)) {
                    f.setBodyEndIdx(text.toString().substring(0, word.start).lastIndexOf(newLine) + newLine.length());
                    break;
                }
            }
            ++i2;
        }
        f.setConditionType("");
        if (index900 > 0) {
            if (startDO) {
                f.setConditionType(CONDITION_DO);
            }
            if (startDU) {
                f.setConditionType(CONDITION_DU);
            }
            if (startDW) {
                f.setConditionType(CONDITION_DW);
            }
        }
        if (startIT) {
            f.setConditionType(CONDITION_IT);
        }
        if (startMP.length() > 0) {
            f.setConditionType(startMP);
        }
        if (!startIT && startMP.length() <= 0 || index900 <= 0) return f;
        f.setBodyEndIdx(index900);
        return f;
    }

    public static boolean markAtEndOfLine() {
        String result = System.getProperty("markAtEndOfLine");
        return result == null || "true".equals(result);
    }

    public static boolean isGenerationPossibleWithVirtualMacro(IController controller) {
        if (PacTool.isMacroVirtualEnabled()) {
            boolean continu;
            if (PacTool.isGenerationWithVirtualMacroAlreadyDone(controller)) {
                return true;
            }
            boolean bl = continu = !PacTool.isEntityWithMigrationWarnings(controller) && PacTool.isPacbasePattern(controller);
            if (continu) {
                if (!PacTool.isDephasedEntity(controller)) {
                    return true;
                }
                return "true".equals(System.getProperty("inRppWksRegenTest"));
            }
        }
        return false;
    }

    public static boolean isPacbasePattern(IController controller) {
        String pattern = controller.getTextProcessor().getGeneratedInfo().getProperty("pattern");
        return "com.ibm.pdp.pacbase.batch".equals(pattern) || "com.ibm.pdp.pacbase.dialog".equals(pattern) || "com.ibm.pdp.pacbase.csclient".equals(pattern) || "com.ibm.pdp.pacbase.csserver".equals(pattern) || "com.ibm.pdp.pacbase.communicationmonitor".equals(pattern) || "com.ibm.pdp.pacbase.folder".equals(pattern) || "com.ibm.pdp.pacbase.server.it".equals(pattern);
    }

    public static boolean isGenerationWithVirtualMacroAlreadyDone(IController controller) {
        if (PacTool.isMacroVirtualEnabled()) {
            if (controller == null) {
                return true;
            }
            ITextProcessor tp = controller.getTextProcessor();
            return PacTool.isGenerationWithVirtualMacroAlreadyDone(tp.getGeneratedInfo());
        }
        return false;
    }

    public static boolean isGenerationWithVirtualMacroAlreadyDone(IGeneratedInfo genInfo) {
        return PacTool.isMacroVirtualEnabled() && "true".equals(genInfo.getProperty("MV"));
    }

    public static boolean isGenerationWithVirtualMacroInProgress(IGeneratedInfo genInfo) {
        return PacTool.isMacroVirtualEnabled() && "true".equals(genInfo.getProperty("MVPROGRESS"));
    }

    public static boolean isCobolValidated(IGeneratedInfo genInfo) {
        return "true".equals(genInfo.getProperty("DoNotAnalyze"));
    }

    public static IPattern GetPatternFor(RadicalEntity re) {
        String designId = re.getDesignId(re.getProject());
        String fullDesignName = PdpTool.addRPPFolderToFileName((String)designId);
        String[] generators = GenerationManager.generatorsFor((String)fullDesignName);
        if (generators != null && generators.length != 0) {
            int i = 0;
            while (i < generators.length) {
                String patternName = generators[i];
                IPattern pattern = PdpPatternManager.getPdpPattern((String)patternName);
                List super_refs = GenerationManager.getGenerationOutputsFromSuperRef((String)designId, (IPattern)pattern);
                if (super_refs != null) {
                    for (GenerationManager.SuperRef superRef : super_refs) {
                        if (!superRef.getDocumentId().endsWith(".cbl")) continue;
                        return pattern;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isDephasedEntity(IController controller) {
        String sourceFileName;
        String logicalFileName = controller.getGenerationLink().getGenerationOutput().getLogicalFileName();
        return SynchronizationTool.checkIfTheGeneratedResourceNeedsRegeneration((String)logicalFileName, (String)(sourceFileName = GenerationManager.getFullPathFromGenerationOutput((IController)controller)));
    }

    public static boolean isEntityWithMigrationWarnings(IController controller) {
        return controller instanceof Controller && ((Controller)controller).getMigrationWarnings() != null && !((Controller)controller).getMigrationWarnings().getWarningsList().isEmpty();
    }

    public static String getFullGeneratedFileName(RadicalEntity re, IPattern pattern, String designFileName) {
        String designId = re.getDesignId(re.getProject());
        List super_refs = GenerationManager.getGenerationOutputsFromSuperRef((String)designId, (IPattern)pattern);
        if (super_refs != null) {
            for (GenerationManager.SuperRef superRef : super_refs) {
                String uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)superRef.getDocumentId());
                if (!uri.endsWith(".cbl")) continue;
                return uri;
            }
        }
        return PacTool.getFullCobolFileNameFromDesignFileName(re, designFileName);
    }

    public static boolean isMacroVirtualEnabled() {
        if (Util.isInRPPTestMode() || Util.isRPPBuildEnv()) {
            String isMacroVirtualForThisVersion = System.getProperty("virtualMacro");
            return isMacroVirtualForThisVersion == null || "true".equals(isMacroVirtualForThisVersion);
        }
        return true;
    }

    public static List<UserService> searchUserServicesInMacroForCpLines(PacCPLine cpLine) {
        ArrayList<UserService> _userServices = new ArrayList<UserService>();
        PacMacro _pacMacro = (PacMacro)cpLine.getMacro();
        String _macroDesignId = _pacMacro.getDesignId(_pacMacro.getProject()).intern();
        String _designId = cpLine.getOwner().getDesignId(cpLine.getOwner().getProject()).intern();
        String _source = _pacMacro.getSource();
        for (Object param : cpLine.getParameters()) {
            PacMacroParameter macroParameter = (PacMacroParameter)param;
            _source = _source.replace(macroParameter.getId(), macroParameter.getValue());
        }
        Matcher matcher = patternUserService.matcher(_source);
        while (matcher.find()) {
            UserService service = new UserService();
            service.function_code = matcher.group(1).substring(1, 3);
            service.function_ss_code = matcher.group(1).substring(3, 5);
            service.level = matcher.group(2).substring(3, 5);
            service.name = matcher.group(3);
            int idx = service.name.lastIndexOf(32);
            if (idx <= 0) continue;
            service.name = service.name.substring(idx + 1).trim();
            service.designId = _designId;
            service.macroDesignId = _macroDesignId;
            if (service.name.length() <= 0) continue;
            _userServices.add(service);
        }
        return _userServices;
    }

    public static List<SQL80EX> search80EXInMacroForCpLines(PacCPLine cpLine) {
        ArrayList<SQL80EX> _sql80EXs = new ArrayList<SQL80EX>();
        PacMacro _pacMacro = (PacMacro)cpLine.getMacro();
        String _macroDesignId = _pacMacro.getDesignId(_pacMacro.getProject()).intern();
        String _designId = cpLine.getOwner().getDesignId(cpLine.getOwner().getProject()).intern();
        String _source = _pacMacro.getSource();
        for (Object param : cpLine.getParameters()) {
            PacMacroParameter macroParameter = (PacMacroParameter)param;
            _source = _source.replace(macroParameter.getId(), macroParameter.getValue());
        }
        Matcher matcher = pattern80EX.matcher(_source);
        while (matcher.find()) {
            String name = matcher.group(4).trim();
            if (name.length() == 0) continue;
            SQL80EX sql80EX = new SQL80EX();
            sql80EX.designId = _designId;
            sql80EX.macroDesignId = _macroDesignId;
            sql80EX.function_code = matcher.group(1).substring(1, 3);
            sql80EX.function_ss_code = matcher.group(1).substring(3, 5);
            sql80EX.segmentCode = matcher.group(2).trim();
            sql80EX.extracCode = matcher.group(3).trim();
            sql80EX.name = name;
            _sql80EXs.add(sql80EX);
        }
        return _sql80EXs;
    }

    public static int[] getFunctionIndexes(String text) {
        int[] result = new int[]{-1, -1};
        FunctionInformations fi = PacTool.getFunctionInformations(text);
        if (fi != null) {
            result[0] = fi.getBodyBeginIdx();
            result[1] = fi.getBodyEndIdx();
        }
        return result;
    }

    public static boolean isOsSupported() {
        return PdpConstants.IS_SUPPORTED_OS;
    }

    public static int searchFirstSCHorSCBforCOA(String newLine, String text, int beginningIndex) {
        String sch = String.valueOf(newLine) + "      *@SCH ";
        String scb = String.valueOf(newLine) + "      *@SCB ";
        int indexsch = text.indexOf(sch, beginningIndex);
        int indexscb = text.indexOf(scb, beginningIndex);
        if (indexsch != -1) {
            if (indexscb != -1) {
                if (indexscb < indexsch) {
                    return indexscb;
                }
                return indexsch;
            }
            return indexsch;
        }
        if (indexscb != -1) {
            return indexscb;
        }
        return -1;
    }

    private static int searchFirstYMpforCOA(String newLine, String text, int beginningIndex) {
        String ymp = String.valueOf(newLine) + "      *!Y ";
        int indexymp = text.indexOf(ymp, beginningIndex);
        if (indexymp != -1) {
            return indexymp;
        }
        return -1;
    }

    public static void CorrectC9FileIfNeeded(IController _controller) {
        String pattern = _controller.getTextProcessor().getGeneratedInfo().getProperty("pattern");
        if ("com.ibm.pdp.pacbase.csserver".equals(pattern) || "com.ibm.pdp.pacbase.server.it".equals(pattern)) {
            PacTool.CorrectCOAInYMicroPattern(_controller);
        }
        PacTool.CorrectCOAInSCHorSCB(_controller);
    }

    public static void CorrectCOAInSCHorSCB(IController _controller) {
        String text = _controller.getTextProcessor().getText().toString();
        IEditTree tree = _controller.getTextProcessor().getEditTree();
        StringBuilder result = new StringBuilder();
        int previousIndex = 0;
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
        int nlLength = newLine.length();
        int indexBeg = PacTool.searchFirstSCHorSCBforCOA(newLine, text, 0);
        while (indexBeg != -1) {
            int indexEnd = text.indexOf(newLine, indexBeg + nlLength);
            ITextNode node = tree.includingNode(indexEnd, indexEnd);
            if (node != null && node.isGeneratedTag()) {
                indexBeg = PacTool.searchFirstSCHorSCBforCOA(newLine, text, indexEnd);
                continue;
            }
            boolean found = false;
            String tmpLine = null;
            do {
                indexBeg = text.indexOf(newLine, indexEnd);
                if (!(tmpLine = text.subSequence(indexBeg += nlLength, indexEnd = text.indexOf(newLine, indexBeg + nlLength)).toString()).startsWith("       ")) continue;
                boolean bl = found = tmpLine.charAt(7) == 'F' && tmpLine.charAt(12) == '-';
            } while (!found && tmpLine.charAt(7) != 'F');
            if (indexEnd - indexBeg < 72) {
                result.append(text.subSequence(previousIndex, indexBeg));
                StringBuilder line = new StringBuilder(text.subSequence(indexBeg, indexEnd));
                if (line.charAt(16) == '.') {
                    String etiquette = line.subSequence(7, 16).toString();
                    PacTool.removeWarningForThisMissingCOA(etiquette, _controller.getResourceName());
                    while (line.length() < 72) {
                        line.append(" ");
                    }
                    line.append("coa");
                }
                line.append(newLine);
                result.append((CharSequence)line);
                previousIndex = indexEnd += nlLength;
            }
            indexBeg = PacTool.searchFirstSCHorSCBforCOA(newLine, text, indexEnd);
        }
        if (result.length() > 0) {
            result.append(text.substring(previousIndex));
            _controller.getTextProcessor().setText((CharSequence)result);
        }
    }

    public static void CorrectCOAInYMicroPattern(IController _controller) {
        String text = _controller.getTextProcessor().getText().toString();
        _controller.getPattern();
        IEditTree tree = _controller.getTextProcessor().getEditTree();
        StringBuilder result = new StringBuilder();
        int previousIndex = 0;
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
        int nlLength = newLine.length();
        int indexBeg = PacTool.searchFirstYMpforCOA(newLine, text, 0);
        while (indexBeg != -1) {
            int indexEnd = text.indexOf(newLine, indexBeg + nlLength);
            ITextNode node = tree.includingNode(indexEnd, indexEnd);
            indexBeg = text.indexOf(newLine, indexEnd);
            indexEnd = text.indexOf(newLine, indexBeg + nlLength);
            if (indexEnd - (indexBeg += nlLength) < 72) {
                result.append(text.subSequence(previousIndex, indexBeg));
                StringBuilder line = new StringBuilder(text.subSequence(indexBeg, indexEnd));
                int indexDot = line.indexOf(".");
                String etiquette = line.subSequence(7, indexDot).toString();
                PacTool.removeWarningForThisMissingCOA(etiquette, _controller.getResourceName());
                while (line.length() < 72) {
                    line.append(" ");
                }
                if (node.isGeneratedTag()) {
                    line.append("COA");
                } else {
                    line.append("coa");
                }
                line.append(newLine);
                result.append((CharSequence)line);
                previousIndex = indexEnd += nlLength;
            }
            indexBeg = PacTool.searchFirstYMpforCOA(newLine, text, indexEnd);
        }
        if (result.length() > 0) {
            result.append(text.substring(previousIndex));
            _controller.getTextProcessor().setText((CharSequence)result);
        }
    }

    private static void removeWarningForThisMissingCOA(String etiquette, String fileName) {
        IFile file = PdpTool.getFile((String)fileName);
        try {
            IMarker[] existingMarkers = file.findMarkers("com.ibm.pdp.pacbase.extension.organize.right_margin_problem_marker", false, 2);
            if (existingMarkers.length > 0) {
                int i = 0;
                while (i < existingMarkers.length) {
                    IMarker marker = existingMarkers[i];
                    Object o = marker.getAttribute("COA");
                    if (etiquette.equals(o)) {
                        marker.delete();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            Util.rethrow((Throwable)ce);
        }
    }

    public static boolean isCOPIBMoption(PacLibrary lib) {
        if (lib.getGOLines() != null && lib.getGOLines().size() > 0) {
            for (PacGLine gLine : lib.getGOLines()) {
                String gLineDesc = gLine.getDescription();
                if (!"O".equals(gLine.getLineType()) || gLineDesc == null || !gLineDesc.contains(COPIBM)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isSubFunctionOrFunctionComment(String line) {
        return line.length() >= 23 && line.substring(6, 8).equals("*N") && (line.substring(12, 23).equals(".    NOTE *") || line.substring(10, 23).equals(".      NOTE *"));
    }

    public static boolean isSpecialPositioningComment(String line, String pattern, String function) {
        return !(!"com.ibm.pdp.pacbase.dialog".equals(pattern) && !"com.ibm.pdp.pacbase.csclient".equals(pattern) || !function.equals("20") && !function.equals("25") && !function.equals("30") && !function.equals("35") && !function.equals("60") && !function.equals("65") && !function.equals("80") || !line.substring(6).startsWith("*@BEFORE") && !line.substring(6).startsWith("*@AFTER") && !line.substring(6).startsWith("*@REPLACE"));
    }

    private static class PatternAndRank {
        String patternName;
        int rank = 1;

        private PatternAndRank() {
        }
    }

    public static class SQL80EX {
        public String designId;
        public String macroDesignId;
        public String function_code;
        public String function_ss_code;
        public String name;
        public String segmentCode;
        public String extracCode;
    }

    public static class UserService {
        public String designId;
        public String macroDesignId;
        public String function_code;
        public String function_ss_code;
        public String level;
        public String name;
    }

    private static class Word {
        public String text;
        public int start;
    }
}

