/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.pdp.pacbase.INodeLoader;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class NodeLoaderManager {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _nodeLoader_EXTENSION_POINT = "nodeLoader";
    private static final String PREFIX = "com.ibm.pdp.pacbase";
    private HashMap<INodeLoader, IConfigurationElement> _nodeLoaderImplementors = new HashMap();
    private static NodeLoaderManager _instance = null;

    public static synchronized NodeLoaderManager getInstance() {
        if (_instance == null) {
            _instance = new NodeLoaderManager();
            _instance.loadExtensionPoints(_nodeLoader_EXTENSION_POINT);
        }
        return _instance;
    }

    public static HashMap<INodeLoader, IConfigurationElement> getNodeLoaderImplementors() {
        return NodeLoaderManager.getInstance()._nodeLoaderImplementors;
    }

    private void loadExtensionPoints(String extensionPoint) {
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extRegistry.getExtensionPoint(PREFIX, extensionPoint);
        if (extPoint != null) {
            IExtension[] extensions = extPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    if (configElement.getName().equals(extensionPoint)) {
                        this.processConfigElement(configElement);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void processConfigElement(IConfigurationElement element) {
        try {
            if (element.getName().equals(_nodeLoader_EXTENSION_POINT)) {
                INodeLoader nodeLoaderImplementor = (INodeLoader)element.createExecutableExtension("class");
                this._nodeLoaderImplementors.put(nodeLoaderImplementor, element);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

