/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.pacbase.FunctionNode;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.Messages;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.CobolLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NodeLoader2
implements INodeLoader {
    private static String LEVEL_INCOMPATIBLE = Messages.NodeLoader2_LEVEL_INCOMPATIBLE;
    protected Map<String, IFunctionNode> _nodesMap;
    protected IFunctionNode _rootNode;
    protected StringBuilder _errorMessage;
    protected List<IFunctionNode> _nodesList;
    protected IEditTree _editTree;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public NodeLoader2() {
    }

    public NodeLoader2(IEditTree editTree) {
        this.initialize(editTree);
    }

    @Override
    public void initialize(IEditTree editTree) {
        this._errorMessage = new StringBuilder();
        this._editTree = editTree;
        this.buildFunctionsTree(editTree);
    }

    protected boolean exclude(CobolLabel pacLabel) {
        String label = pacLabel.getPacLabel();
        if (label.length() > 5) {
            String s = label.substring(5);
            if (PdpTool.isStringNumeric((String)s)) {
                return true;
            }
            int underscoreIdx = s.indexOf(95);
            if (underscoreIdx != -1) {
                return true;
            }
        }
        return false;
    }

    protected CobolLabel getCobolLabel(String name) {
        return BasicPacLabelRecognizer.findPacbaseLabelInTag(name);
    }

    protected void hookForExtraProperties(IFunctionNode fn, ITextNode child) {
    }

    protected IFunctionNode createNewIFunctionNode(String name, float level, int offset, IFunctionNode parent) {
        return new FunctionNode(name, level, offset, parent);
    }

    protected void sweepNodes(ITextNode node, IFunctionNode parent, float level) {
        Iterator children = node.sons();
        while (children.hasNext()) {
            CobolLabel pl;
            ITextNode child = (ITextNode)children.next();
            String name = child.getLabel().toString();
            if (name.equals("PROCEDURE-DIVISION") || (pl = this.getCobolLabel(name)) == null || this.exclude(pl)) continue;
            String alevel = child.getProperties().getProperty("level");
            float lv = 0.0f;
            if (alevel != null) {
                lv = Float.parseFloat(alevel);
                if (lv <= parent.getLevel()) {
                    this._errorMessage.append(String.valueOf(LEVEL_INCOMPATIBLE) + name + "\r\n");
                }
            } else {
                lv = level + 5.0f;
            }
            IFunctionNode fn = this.createNewIFunctionNode(name, lv, child.beginIndex(), parent);
            this.hookForExtraProperties(fn, child);
            parent.getChildren().add(fn);
            this._nodesList.add(fn);
            this._nodesMap.put(fn.getName(), fn);
            fn.setEndOffset(child.endIndex());
            this.sweepNodes(child, fn, lv);
        }
    }

    protected void buildFunctionsTree(IEditTree editTree) {
        long a = System.currentTimeMillis();
        this._nodesMap = new HashMap<String, IFunctionNode>();
        this._rootNode = this.createNewIFunctionNode("", 0.0f, 0, null);
        this._nodesList = new ArrayList<IFunctionNode>();
        Iterator nodes = editTree.rootNodes();
        if (nodes.hasNext()) {
            Iterator sons = ((ITextNode)nodes.next()).sons();
            while (sons.hasNext()) {
                ITextNode node = (ITextNode)sons.next();
                if (!node.getLabel().equals("PROCEDURE")) continue;
                this.sweepNodes(node, this._rootNode, 0.0f);
            }
        }
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("NodeLoader.buildTree() elapsed = " + (b - a)));
        }
    }

    private void sweepNodes(IFunctionNode node) {
        float level = node.getLevel();
        int i = 0;
        while ((float)i < level) {
            Trace.outPrint((String)" ");
            ++i;
        }
        Trace.outPrintln((String)(String.valueOf(node.getName()) + " (" + node.getOffset() + "," + node.getEndOffset() + ") " + level));
        List<IFunctionNode> children = node.getChildren();
        int i2 = 0;
        while (i2 < children.size()) {
            this.sweepNodes(children.get(i2));
            ++i2;
        }
    }

    protected void displayTraceOfFunctionsTree(IFunctionNode root) {
        this.sweepNodes(root);
    }

    @Override
    public IFunctionNode getTreeRoot() {
        return this._rootNode;
    }

    @Override
    public String getErrorMessage() {
        return this._errorMessage.toString();
    }

    @Override
    public Map<String, IFunctionNode> getNodesMap() {
        return this._nodesMap;
    }

    @Override
    public String getPattern() {
        return "DEFAULT";
    }

    @Override
    public List<IFunctionNode> getNodesList() {
        return this._nodesList;
    }

    @Override
    public Map<String, List<String>> getLogViews_Func_Mapping() {
        return null;
    }

    @Override
    public Map<String, List<String>> getSql_Func_Mapping() {
        return null;
    }
}

