/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.FunctionText;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.PacOrganizeExtension;
import com.ibm.pdp.pacbase.extension.organize.DefaultTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.DialogTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.FunctionsConsistencyAnalyzer;
import com.ibm.pdp.pacbase.extension.organize.IFunction;
import com.ibm.pdp.pacbase.extension.organize.ITreeHandler;
import com.ibm.pdp.pacbase.extension.organize.InfoFunctionChanges;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.pacbase.extension.organize.ServerTreeHandler;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FunctionUpdatesManager {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<IFunction> initialTree;
    private List<IFunction> originalTree;
    ITextProcessor textProcessorforFct;
    FunctionsConsistencyAnalyzer analyzer;
    IEditTree editTree;
    private static String NEW_LINE = System.getProperty("line.separator");
    private static String label_FN = "-FN.";
    private static String label_900 = "-900.";

    public FunctionUpdatesManager() {
    }

    public FunctionUpdatesManager(IEditTree editTree) {
        this.editTree = editTree;
        this.initializeFunctionUpdateManager();
    }

    public FunctionUpdatesManager(IEditTree editTree, List<IFunction> originalTree) {
        this.editTree = editTree;
        this.originalTree = originalTree;
        this.initializeFunctionUpdateManager();
    }

    private void initializeFunctionUpdateManager() {
        this.instanciateNewTextProcessor(this.editTree);
        FunctionsConsistencyAnalyzer.functionsTraceLevel = 2;
        this.buildTree(this.editTree);
        FunctionsConsistencyAnalyzer.functionsTraceLevel = 1;
    }

    private void instanciateNewTextProcessor(IEditTree editTree) {
        IEngineFactory factory = PdpTool.getEngineFactory();
        this.textProcessorforFct = (ITextProcessor)factory.newTextProcessor();
        this.textProcessorforFct.initialize(editTree.getTextProcessor().getGeneratedInfo());
        CharSequence oldCompleteText = editTree.getTextProcessor().getText();
        this.textProcessorforFct.setText(oldCompleteText);
    }

    private void buildTree(IEditTree editTree) {
        this.textProcessorforFct.takeIntoAccountSpecific(this.textProcessorforFct.getGeneratedInfo(), false);
        PacOrganizeExtension ext = (PacOrganizeExtension)this.textProcessorforFct.getOrganizeExtension();
        if (ext != null) {
            this.analyzer = ext.getAnalyzer();
            this.updatesInFormationsInTree(this.analyzer.getModifiedTree());
        }
    }

    private void updatesInFormationsInTree(List<IFunction> tree) {
        this.initialTree = new ArrayList<IFunction>();
        IEditTree editTreeforFct = this.textProcessorforFct.getEditTree();
        editTreeforFct.rootNodes();
        int i = 0;
        while (i < tree.size()) {
            IFunction f = tree.get(i);
            PdpFunction pdpFct = new PdpFunction(f.getTagName(), f.getCobolName(), f.getLevel(), f.getNbOfDependents(), f.getLocation(), f.getReference());
            ITextNode tn = editTreeforFct.nodeFromTagName(f.getTagName());
            if (tn != null) {
                pdpFct.setBodyStatementBeginIdx(tn.beginIndex());
                pdpFct.setLastStatementEndIdx(tn.endIndex());
                if (tn.beginIndex() > -1 && tn.endIndex() > -1) {
                    Iterator it = tn.sons();
                    if (it.hasNext()) {
                        boolean first = true;
                        while (it.hasNext()) {
                            ITextNode tnChild = (ITextNode)it.next();
                            if (!first || tnChild.getProperties().getProperty("level") == null) continue;
                            pdpFct.setBodyStatementEndIdx(tnChild.beginIndex());
                            first = false;
                        }
                    }
                    if (this.originalTree == null) {
                        pdpFct.setCondition(PacTool.getFunctionCondition(pdpFct.getCobolName(), tn, true));
                    } else {
                        for (IFunction iFunction : this.originalTree) {
                            if (!iFunction.getCobolName().equals(pdpFct.getCobolName())) continue;
                            pdpFct.setCondition(((PdpFunction)iFunction).getCondition());
                        }
                    }
                    pdpFct.setLastStatementBeginIdx(this.getLastStatementBeginIndex(tn, pdpFct.getCobolName()));
                    String text = tn.text().toString().substring(pdpFct.getLastStatementBeginIdx() - tn.beginIndex());
                    if ("IT".equals(pdpFct.getCondition()) && text.trim().startsWith(String.valueOf(pdpFct.getCobolName()) + label_900)) {
                        pdpFct.setLabel900(text.substring(0, text.indexOf(NEW_LINE)));
                    }
                    if (pdpFct.getBodyStatementEndIdx() == 0) {
                        pdpFct.setBodyStatementEndIdx(pdpFct.getLastStatementBeginIdx());
                    }
                    if (pdpFct.getLevel() > 5.0f) {
                        pdpFct.setLevelIndex(this.getIndexForLevel(tn));
                    }
                    this.initialTree.add(pdpFct);
                }
            }
            ++i;
        }
    }

    private int getLastStatementBeginIndex(ITextNode tn, String name) {
        String text = tn.text().toString();
        String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
        int lastStatementBeginIdx = 0;
        int indFN = 0;
        int ind900 = 0;
        int i = lines.length - 1;
        while (i >= 0) {
            indFN = lines[i].indexOf(String.valueOf(name) + label_FN);
            ind900 = lines[i].indexOf(String.valueOf(name) + label_900);
            if (indFN != 7 && ind900 != 7) break;
            lastStatementBeginIdx = lastStatementBeginIdx + lines[i].length() + NEW_LINE.length();
            --i;
        }
        return tn.endIndex() - lastStatementBeginIdx;
    }

    private int getIndexForLevel(ITextNode tn) {
        String body = tn.text().toString();
        String[] lines = PdpTool.splitTextIntoArrayLines((String)body);
        int index = tn.beginIndex();
        boolean found = false;
        int i = 0;
        while (i < lines.length) {
            String rightMargin;
            if (lines[i].length() > 72 && (rightMargin = lines[i].substring(72).trim()).startsWith("lv")) {
                index += 74;
                found = true;
                break;
            }
            index = index + lines[i].length() + NEW_LINE.length();
            ++i;
        }
        return found ? index : 0;
    }

    public String insertFunction(FunctionModel model, String text) {
        String name = "F" + model.getFunction() + model.getSubFunction();
        float level = Integer.parseInt(model.getLevel());
        ITreeHandler handler = this.instanciateNewTreeHandler();
        PdpFunction insertedFunction = new PdpFunction(name, name, level, 0, this.getLocation(model.getAction()), this.getTagName(model));
        insertedFunction.setCondition(model.getCondition());
        if (model.isBodyToDelete()) {
            int i = 0;
            while (i < this.initialTree.size()) {
                IFunction ssfct = this.initialTree.get(i);
                if (ssfct.getCobolName().equals(name)) {
                    this.initialTree.remove(i);
                    break;
                }
                ++i;
            }
        }
        ArrayList<IFunction> modifiedTree = this.getModifiedTree();
        handler.addFunction(insertedFunction, modifiedTree);
        List<InfoFunctionChanges> changes = this.analyzer.buildChangesFromTreeInsertions(this.initialTree, modifiedTree, name);
        return this.transformTextFromChanges(changes, model, text);
    }

    public String changeLevelFunction(FunctionModel model) {
        String name = "F" + model.getFunction() + model.getSubFunction();
        List<InfoFunctionChanges> changes = new ArrayList<InfoFunctionChanges>();
        int i = 0;
        while (i < this.initialTree.size()) {
            if (this.initialTree.get(i).getCobolName().equals(name)) {
                int level = Integer.parseInt(model.getLevel());
                if (this.initialTree.get(i).getLevel() == (float)level) break;
                ArrayList<IFunction> modifiedTree = this.getModifiedTree();
                ITreeHandler handler = this.instanciateNewTreeHandler();
                handler.changeLevel(name, level, modifiedTree);
                changes = this.analyzer.buildChangesFromTreeChanges(this.initialTree, modifiedTree, name);
                break;
            }
            ++i;
        }
        return this.transformTextFromChanges(changes, model, null);
    }

    public String getTextForNode(FunctionModel model, boolean completeText) {
        String name = "F" + model.getFunction() + model.getSubFunction();
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < this.initialTree.size()) {
            if (this.initialTree.get(i).getCobolName().equals(name)) {
                String textFooter;
                PdpFunction fct = (PdpFunction)this.initialTree.get(i);
                text.append(this.textProcessorforFct.getText().toString().substring(fct.getBodyStatementBeginIdx(), completeText ? fct.getLastStatementEndIdx() : fct.getBodyStatementEndIdx()));
                if (!"IT".equals(model.getCondition()) && !"DO".equals(model.getCondition()) && !"DU".equals(model.getCondition()) && !"DW".equals(model.getCondition()) || !(textFooter = this.textProcessorforFct.getText().toString().substring(fct.getLastStatementBeginIdx(), fct.getLastStatementEndIdx())).trim().startsWith(String.valueOf(name) + label_900)) break;
                String line900 = textFooter.substring(0, textFooter.indexOf(NEW_LINE));
                if (line900.trim().endsWith("COA") || line900.trim().endsWith("coa")) {
                    text.append(line900).append(NEW_LINE);
                    break;
                }
                if ("IT".equals(model.getCondition())) break;
                text.append(line900).append(NEW_LINE);
                break;
            }
            ++i;
        }
        return text.toString();
    }

    protected Comparator<InfoFunctionChanges> getDefaultComparator() {
        Comparator<InfoFunctionChanges> defaultComparator = new Comparator<InfoFunctionChanges>(){

            @Override
            public int compare(InfoFunctionChanges firstF, InfoFunctionChanges secondF) {
                if (firstF.getBeginIndex().compareTo(secondF.getBeginIndex()) == 0) {
                    if (firstF.getType().name().startsWith("INSERT") && secondF.getType().name().startsWith("REMOVE")) {
                        return -1;
                    }
                    if (firstF.getType().name().startsWith("REMOVE") && secondF.getType().name().startsWith("INSERT")) {
                        return 1;
                    }
                    if (InfoFunctionChanges.ActionType.INSERT_FCT.equals((Object)firstF.getType()) && InfoFunctionChanges.ActionType.INSERT_FCT.equals((Object)secondF.getType())) {
                        return EBCDICCompare.stringCompare((String)firstF.getFunction().getCobolName(), (String)secondF.getFunction().getCobolName());
                    }
                    if (InfoFunctionChanges.ActionType.INSERT_FN.equals((Object)firstF.getType()) && InfoFunctionChanges.ActionType.INSERT_FN.equals((Object)secondF.getType())) {
                        return EBCDICCompare.stringCompare((String)firstF.getFunction().getCobolName(), (String)secondF.getFunction().getCobolName()) * -1;
                    }
                    if (firstF.getFunction().getCobolName().equals(secondF.getFunction().getCobolName())) {
                        if (InfoFunctionChanges.ActionType.INSERT_FCT.equals((Object)firstF.getType()) || InfoFunctionChanges.ActionType.REMOVE_FCT.equals((Object)secondF.getType())) {
                            return -1;
                        }
                        return 1;
                    }
                    return EBCDICCompare.stringCompare((String)firstF.getFunction().getCobolName(), (String)secondF.getFunction().getCobolName());
                }
                return firstF.getBeginIndex().compareTo(secondF.getBeginIndex());
            }
        };
        return defaultComparator;
    }

    public String transformTextFromChanges(List<InfoFunctionChanges> changes, FunctionModel model, String textToInsert) {
        String text = this.textProcessorforFct.getText().toString();
        StringBuilder sb = new StringBuilder(text.length() + 200);
        String name = "F" + model.getFunction() + model.getSubFunction();
        FunctionText functionText = this.instanciateNewFunctionText(model);
        int index = text.length();
        Collections.sort(changes, this.getDefaultComparator());
        int i = changes.size() - 1;
        while (i >= 0) {
            InfoFunctionChanges change = changes.get(i);
            switch (change.getType()) {
                case CHANGE_LEVEL: {
                    StringBuilder newText = new StringBuilder(change.getEndIndex() - change.getBeginIndex());
                    newText.append(text.substring(change.getBeginIndex(), change.getLevelIndex()));
                    newText.append(model.getLevel());
                    newText.append(text.substring(change.getLevelIndex() + 2, change.getEndIndex()));
                    sb.insert(0, text.substring(change.getEndIndex(), index));
                    sb.insert(0, newText);
                    index = change.getBeginIndex();
                    break;
                }
                case INSERT_FCT: {
                    sb.insert(0, text.substring(change.getBeginIndex(), index));
                    if (textToInsert != null && textToInsert.length() > 0) {
                        sb.insert(0, textToInsert);
                    } else {
                        sb.insert(0, functionText.getHeader());
                    }
                    index = change.getBeginIndex();
                    break;
                }
                case INSERT_FN: {
                    sb.insert(0, text.substring(change.getBeginIndex(), index));
                    if (change.getFunction().getTagName().equals(name)) {
                        if (!(change.getLabel900() == null || change.getLabel900().trim().length() <= 0 || textToInsert != null && textToInsert.contains(change.getLabel900()))) {
                            sb.insert(0, functionText.createFooterWithlabel900(name, change.getLabel900()));
                        } else {
                            sb.insert(0, functionText.getFooter());
                        }
                    } else {
                        String condition = "";
                        if (change.getFunction() instanceof PdpFunction) {
                            condition = ((PdpFunction)change.getFunction()).getCondition();
                        }
                        FunctionText ft = new FunctionText(change.getFunction().getTagName(), "", 0.0f, condition);
                        if (change.getLabel900() != null && change.getLabel900().trim().length() > 0) {
                            sb.insert(0, ft.createFooterWithlabel900(change.getFunction().getCobolName(), change.getLabel900()));
                        } else {
                            sb.insert(0, ft.getFooter());
                        }
                    }
                    index = change.getBeginIndex();
                    break;
                }
                case REMOVE_FCT: {
                    sb.insert(0, text.substring(change.getEndIndex(), index));
                    index = change.getBeginIndex();
                    break;
                }
                case REMOVE_FN: {
                    sb.insert(0, text.substring(change.getEndIndex(), index));
                    index = change.getBeginIndex();
                }
            }
            --i;
        }
        if (index > 0) {
            if (!text.substring(0, index).endsWith(NEW_LINE)) {
                sb.insert(0, String.valueOf(text.substring(0, index)) + NEW_LINE);
            } else {
                sb.insert(0, text.substring(0, index));
            }
        }
        return sb.toString();
    }

    public List<IFunction> getInitialTree() {
        return this.initialTree;
    }

    private ArrayList<IFunction> getModifiedTree() {
        ArrayList<IFunction> modifiedTree = new ArrayList<IFunction>(this.initialTree.size());
        for (IFunction function : this.initialTree) {
            PdpFunction f = new PdpFunction(function.getTagName(), function.getCobolName(), function.getLevel(), function.getNbOfDependents(), function.getLocation(), function.getReference());
            if (function instanceof PdpFunction) {
                f.setCondition(((PdpFunction)function).getCondition());
            }
            modifiedTree.add(f);
        }
        return modifiedTree;
    }

    private Location getLocation(String action) {
        Location[] locationArray = Location.values();
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location value = locationArray[n2];
            if (action.equals(value.getInsertMspName())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    protected ITreeHandler instanciateNewTreeHandler() {
        String patternName = this.textProcessorforFct.getGeneratedInfo().getProperty("pattern");
        if (patternName == null) {
            return new DefaultTreeHandler();
        }
        if ("com.ibm.pdp.pacbase.dialog".equals(patternName) || "com.ibm.pdp.pacbase.csclient".equals(patternName)) {
            return new DialogTreeHandler();
        }
        if ("com.ibm.pdp.pacbase.csserver".equals(patternName)) {
            return new ServerTreeHandler(this.textProcessorforFct.getGeneratedInfo());
        }
        return new DefaultTreeHandler();
    }

    protected FunctionText instanciateNewFunctionText(FunctionModel model) {
        String name = "F" + model.getFunction() + model.getSubFunction();
        float level = Integer.parseInt(model.getLevel());
        return new FunctionText(name, model.getFormattedTitle(), level, model.getCondition());
    }

    protected String getTagName(FunctionModel model) {
        String ref = "";
        if (model.getReference() != null && model.getReference().trim().length() > 0) {
            ref = model.getReference();
        }
        return PacTool.buildTagName("F" + model.getFunction(), ref, this.editTree);
    }
}

