/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.IFunctionText;
import com.ibm.pdp.pacbase.Messages;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.CobolLabel;

public class FunctionText
implements IFunctionText {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean _GENERATE_LEVEL = true;
    protected static final String CR = System.getProperty("line.separator");
    protected static final String[] CONDITIONS = new String[]{"", "IT", "DW", "DU", "DO", "EL", "DC", "DI", "DV", "CO"};
    private static final String EXIT_WITH_SPACE_AND_DOT = " EXIT.";
    private static final String NEXT_SENTENCE_ELSE_GOTO = "          NEXT SENTENCE ELSE GO TO     ";
    private static final String DASH_900_DOT = "-900.";
    protected static final String DOT = ".";
    protected static final String cobolLineStarting6 = "      ";
    protected static final String cobolLineStarting7 = "       ";
    private static final String END_FUNCTION_STR = "-FN.";
    private static final String GO_TO = " GO TO ";
    private static final String SPACES_BETWEEN_FUNCTION_AND_LEVEL05 = "                                                             ";
    private static final String SPACES_BETWEEN_FUNCTION_AND_LEVEL = "                                                           ";
    private static final String SPACES_BETWEEN_CONDITION_AND_LEVEL = "                                        ";
    private static final String CONTINUE = "           CONTINUE.";
    protected static final String COMMENT_LINE_BEGINNING = "      *";
    protected String _header;
    protected String _footer;
    protected String _attachLine;
    protected String _functionName;
    protected boolean _isNewFunction;
    private boolean _generateInsertComment = true;
    protected int _functionType;
    protected String _spacesBetweenFunctionAndLevel;

    public FunctionText() {
    }

    public FunctionText(String text, String functionName) {
        this._isNewFunction = false;
        this._functionName = functionName;
        this.splitFunctionTextIntoHeaderAndFooter(text, functionName);
    }

    public FunctionText(String functionName, String title, float level, String condition) {
        this.initialize(functionName, title, level, condition, null, null);
    }

    @Override
    public void initialize(String functionName, String title, float level, String condition, String ref, String attachType) {
        this._isNewFunction = true;
        this._functionName = functionName;
        this._functionType = this.getIntValueOf(condition);
        this._spacesBetweenFunctionAndLevel = functionName.length() == 3 ? SPACES_BETWEEN_FUNCTION_AND_LEVEL05 : SPACES_BETWEEN_FUNCTION_AND_LEVEL;
        this.buildHeaderAndFooter(functionName, title, level, condition);
        this._attachLine = "";
    }

    private int getIntValueOf(String condition) {
        int i = 0;
        while (i < CONDITIONS.length) {
            if (CONDITIONS[i].equalsIgnoreCase(condition)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("FunctionText.getValueIntOf(). Condition not supported : " + condition);
    }

    protected void createHeader(String funcName, String title, float level, String condition) {
        if (funcName == null || funcName.length() < 3 || funcName.charAt(0) != 'F') {
            throw new RuntimeException("FunctionCreator2.getNewFunctionString(). The function name passed in parameter is invalid : " + funcName);
        }
        StringBuilder sb = new StringBuilder();
        if (title != null && title.length() > 0) {
            sb.append(cobolLineStarting6);
            sb.append(title);
            if (funcName.length() > 3 && condition != null && condition.length() > 0) {
                this.addCondition(sb, condition);
            }
            sb.append(CR);
        }
        sb.append(cobolLineStarting7);
        sb.append(funcName);
        sb.append(DOT);
        if ("DU".equals(condition)) {
            sb.append(cobolLineStarting7);
            sb.append(cobolLineStarting7);
            sb.append(cobolLineStarting7);
            sb.append(" ");
            sb.append(GO_TO);
            sb.append("    ");
            sb.append(funcName);
            sb.append("-B.");
        }
        if (_GENERATE_LEVEL) {
            if ("DU".equals(condition)) {
                sb.append("                  ");
            } else if ("IT".equals(condition) || "DW".equals(condition)) {
                if (funcName.length() == 3) {
                    sb.append("  ");
                }
                sb.append("    ");
                sb.append("IF    condition");
                sb.append(SPACES_BETWEEN_CONDITION_AND_LEVEL);
            } else {
                sb.append(this._spacesBetweenFunctionAndLevel);
            }
            sb.append("lv");
            sb.append(level < 10.0f ? "0" + (int)level : "" + (int)level);
        }
        sb.append(CR);
        if ("IT".equals(condition) || "DW".equals(condition)) {
            sb.append(cobolLineStarting7);
            sb.append(NEXT_SENTENCE_ELSE_GOTO);
            sb.append(funcName);
            sb.append(END_FUNCTION_STR);
            sb.append(CR);
        }
        if ("DU".equals(condition)) {
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append("-A.");
            sb.append(CR);
            sb.append(cobolLineStarting7);
            sb.append(cobolLineStarting7);
            sb.append("   IF    condition");
            sb.append(CR);
            sb.append(cobolLineStarting7);
            sb.append(cobolLineStarting7);
            sb.append(cobolLineStarting7);
            sb.append(cobolLineStarting7);
            sb.append(cobolLineStarting7);
            sb.append(GO_TO);
            sb.append("    ");
            sb.append(funcName);
            sb.append(END_FUNCTION_STR);
            sb.append(CR);
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append("-B.");
            sb.append(CR);
        }
        if (this._generateInsertComment) {
            sb.append(cobolLineStarting6);
            sb.append(Messages.INSERT_COMMENT);
            sb.append(CR);
            sb.append(CONTINUE);
            sb.append(CR);
        }
        this._header = sb.toString();
    }

    protected void createFooter(String funcName, String title, float level, String condition) {
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        if ("DW".equals(condition)) {
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append(DASH_900_DOT);
            sb.append(" GO TO     ");
            sb.append(funcName);
            sb.append(DOT);
            sb.append(CR);
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append(END_FUNCTION_STR);
            sb.append(EXIT_WITH_SPACE_AND_DOT);
        } else if ("DU".equals(condition) || "DO".equals(condition)) {
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append(DASH_900_DOT);
            sb.append(GO_TO);
            sb.append(funcName);
            sb.append("-A.");
            sb.append(CR);
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append(END_FUNCTION_STR);
            sb.append(EXIT_WITH_SPACE_AND_DOT);
        } else {
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append(END_FUNCTION_STR);
            sb.append(EXIT_WITH_SPACE_AND_DOT);
        }
        sb.append(CR);
        this._footer = sb.toString();
    }

    protected StringBuilder createFooterWithlabel900(String funcName, String label900) {
        StringBuilder sb = new StringBuilder();
        if (label900.trim().endsWith("COA") || label900.trim().endsWith("coa")) {
            sb.append(label900);
        } else {
            sb = new StringBuilder();
            sb.append(cobolLineStarting7);
            sb.append(funcName);
            sb.append(DASH_900_DOT);
            sb.append(GO_TO);
            sb.append(label900);
            sb.append(END_FUNCTION_STR);
        }
        sb.append(CR);
        sb.append(cobolLineStarting7);
        sb.append(funcName);
        sb.append(END_FUNCTION_STR);
        sb.append(EXIT_WITH_SPACE_AND_DOT);
        sb.append(CR);
        return sb;
    }

    protected void buildHeaderAndFooter(String funcName, String title, float level, String condition) {
        this._isNewFunction = true;
        this.createHeader(funcName, title, level, condition);
        this.createFooter(funcName, title, level, condition);
    }

    private String guessFunctionName(String functionText) {
        String name = null;
        String[] lines = functionText.split(CR);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            CobolLabel pl = BasicPacLabelRecognizer.findCobolLabelInLine(line);
            if (pl != null) {
                name = pl.getPacLabel();
                break;
            }
            ++i;
        }
        return name;
    }

    private void splitFunctionTextIntoHeaderAndFooter(String completeTextOfFunctionToInsert, String funcName) {
        StringBuilder name = new StringBuilder(12);
        name.append(cobolLineStarting7);
        name.append(funcName);
        StringBuilder sb = new StringBuilder(16);
        sb.append((CharSequence)name);
        sb.append(DASH_900_DOT);
        int idx900 = completeTextOfFunctionToInsert.lastIndexOf(sb.toString());
        if (idx900 == -1) {
            int idx = completeTextOfFunctionToInsert.indexOf(name + END_FUNCTION_STR);
            if (idx == -1) {
                String guessedName = this.guessFunctionName(completeTextOfFunctionToInsert);
                if (guessedName != null && !guessedName.equals(funcName)) {
                    this.splitFunctionTextIntoHeaderAndFooter(completeTextOfFunctionToInsert, guessedName);
                } else {
                    int y = PdpTool.getLineStartOffset((CharSequence)completeTextOfFunctionToInsert, (int)(completeTextOfFunctionToInsert.length() - 2));
                    this._header = completeTextOfFunctionToInsert.substring(0, y);
                    this._footer = completeTextOfFunctionToInsert.substring(y);
                }
            } else {
                int idx3;
                this._header = completeTextOfFunctionToInsert.substring(0, idx);
                this._footer = completeTextOfFunctionToInsert.substring(idx);
                int idx2 = this._header.indexOf(name + DOT);
                this._functionType = idx2 == -1 ? 0 : ((idx3 = this._header.indexOf("IF ", idx2)) == -1 ? 0 : 1);
            }
        } else {
            this._header = completeTextOfFunctionToInsert.substring(0, idx900);
            this._footer = completeTextOfFunctionToInsert.substring(idx900);
            int idx = this._footer.indexOf(String.valueOf(funcName) + END_FUNCTION_STR);
            this._functionType = idx != -1 ? 2 : 3;
        }
    }

    @Override
    public String getCompleteFunctionText() {
        return String.valueOf(this._header) + this._footer;
    }

    @Override
    public String getHeader() {
        return this._header;
    }

    @Override
    public String getFooter() {
        return this._footer;
    }

    public String getFunctionName() {
        return this._functionName;
    }

    private void addCondition(StringBuilder title, String condition) {
        if (condition != null && condition.length() > 0) {
            int i = title.length();
            while (i < 60) {
                title.append(" ");
                ++i;
            }
            title.append(condition);
        }
    }

    public boolean isNewFunction() {
        return this._isNewFunction;
    }

    @Override
    public String getAttachLine() {
        return this._attachLine;
    }

    @Override
    public String getComments() {
        int counter = 0;
        int endLineOffset = 0;
        StringBuilder sb = new StringBuilder();
        int len = this._header.length();
        while (counter < len) {
            endLineOffset = PdpTool.getLineEndOffset((CharSequence)this._header, (int)counter);
            String line = this._header.substring(counter, endLineOffset);
            if (!line.startsWith(COMMENT_LINE_BEGINNING)) break;
            sb.append(line);
            counter = endLineOffset;
        }
        return sb.toString();
    }

    public static void setGENERATE_LEVEL(boolean b) {
        _GENERATE_LEVEL = b;
    }

    @Override
    public void setGenerateInsertComment(boolean insertComment) {
        this._generateInsertComment = insertComment;
    }

    @Override
    public String getPattern() {
        return "DEFAULT";
    }
}

