/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import java.util.ArrayList;
import java.util.List;

public class FunctionNode
implements Comparable<IFunctionNode>,
IFunctionNode {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String name;
    protected float level;
    protected int offset;
    protected int endOffset;
    protected List<IFunctionNode> children;
    protected IFunctionNode parent;
    protected String refEntity;
    protected String category;
    protected String attachType;

    public FunctionNode(String name, float level, int offset, IFunctionNode parent) {
        this.name = name;
        this.level = level;
        this.offset = offset;
        this.children = new ArrayList<IFunctionNode>();
        this.parent = parent;
    }

    @Override
    public IFunctionNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IFunctionNode parent) {
        this.parent = parent;
    }

    @Override
    public List<IFunctionNode> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public float getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(float level) {
        this.level = level;
    }

    public String toString() {
        String extraInfo = this.attachType == null ? "" : ", attachType=" + this.attachType;
        extraInfo = String.valueOf(extraInfo) + (this.refEntity == null ? "" : ", refEntity=" + this.refEntity);
        extraInfo = String.valueOf(extraInfo) + (this.category == null ? "" : ", categ=" + this.category);
        return String.valueOf(this.name) + " (level=" + Float.toString(this.level) + ", offset=" + this.offset + ", endOffset=" + this.endOffset + extraInfo + ")";
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setEndOffset(int offset) {
        this.endOffset = offset;
    }

    @Override
    public String getRefEntity() {
        return this.refEntity;
    }

    @Override
    public void setRefEntity(String refEntity) {
        this.refEntity = refEntity;
    }

    @Override
    public String getAttachType() {
        return this.attachType;
    }

    @Override
    public void setAttachType(String attachType) {
        this.attachType = attachType;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public boolean isOverrindingFunction() {
        return this.attachType != null && this.attachType.equals("*R");
    }

    @Override
    public boolean isAttachedFunction() {
        return this.attachType != null && (this.attachType.equals("*A") || this.attachType.equals("*P"));
    }

    @Override
    public boolean isAutomaticFunction() {
        return this.category != null && !"".equals(this.refEntity) && (this.category.equals("A") || this.category.equals("R") || this.category.equals("Z"));
    }

    @Override
    public boolean isFixedLocationFunction() {
        return this.refEntity == null || "".equals(this.refEntity);
    }

    @Override
    public int compareTo(IFunctionNode o) {
        String str1 = this.getName();
        String str2 = o.getName();
        return Ebcdic.stringCompare(str1, str2);
    }
}

