/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase;

import com.ibm.icu.util.StringTokenizer;

public class FunctionInformations {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String name;
    private String conditionType;
    private String level;
    private int condBeginIdx;
    private int condEndIdx;
    private int bodyBeginIdx;
    private int bodyEndIdx;
    private CharSequence text;

    public FunctionInformations(CharSequence text) {
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(String conditionType) {
        this.conditionType = conditionType;
    }

    public int getBodyBeginIdx() {
        return this.bodyBeginIdx;
    }

    public int getBodyEndIdx() {
        return this.bodyEndIdx;
    }

    public void setBodyEndIdx(int bodyEndIdx) {
        this.bodyEndIdx = bodyEndIdx;
    }

    public void setBodyBeginIdx(int bodyBeginIdx) {
        this.bodyBeginIdx = bodyBeginIdx;
    }

    public void setCondBeginIdx(int condBeginIdx) {
        this.condBeginIdx = condBeginIdx;
    }

    public void setCondEndIdx(int condEndIdx) {
        this.condEndIdx = condEndIdx;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLine900() {
        String newLine = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(this.text.toString().substring(this.bodyEndIdx, this.text.length()), newLine);
        while (st.hasMoreTokens()) {
            String line = st.nextToken().substring(7);
            if (!line.startsWith(String.valueOf(this.name) + "-900.")) continue;
            return line;
        }
        return null;
    }

    public String getConditionText(boolean withComment) {
        if (!"IT".equals(this.conditionType) && !"DW".equals(this.conditionType)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String t = this.text.toString().substring(this.condBeginIdx, this.condEndIdx);
        int ind = t.indexOf("lv");
        if (ind > -1) {
            sb.append(t.substring(0, ind));
            sb.append(t.substring(ind + 4));
        } else {
            sb.append(t);
        }
        String newLine = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(sb.toString(), newLine);
        sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!withComment && line.startsWith("      *")) continue;
            sb.append(line.trim());
            sb.append(newLine);
        }
        return sb.toString();
    }
}

