/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.ui.screen.emulator.actions;

import com.ibm.pdp.explorer.editor.PTFlatEditor;
import com.ibm.pdp.mdl.pacbase.PacColorAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacIntensityAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacPresentationAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacScreenFieldNatureValues;
import com.ibm.pdp.mdl.pacbase.PacScreenLabelNatureValues;
import com.ibm.pdp.mdl.pacbase.editor.ScreenFlatEditor;
import com.ibm.pdp.pacbase.generate.util.ScreenPositions;
import com.ibm.pdp.screen.emulator.ScreenEmulatorField;
import com.ibm.pdp.screen.emulator.ScreenEmulatorManager;
import com.ibm.pdp.screen.emulator.api.IScreenEmulatorClientLinkListener;
import com.ibm.pdp.screen.emulator.api.IScreenEmulatorField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ScreenEmulatorLauncher {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static ScreenEmulatorLauncher currentEmulatorLauncher = null;
    private static ScreenEmulatorManager screenEmulatorManager = ScreenEmulatorManager.getInstance();
    Adapter adapter = null;
    ScreenFlatEditor flatEditor = null;
    IScreenEmulatorClientLinkListener linkListener = null;
    PacScreen screen = null;
    static String nbLig2 = "24";
    static String nbCol3 = "080";
    private static boolean isWhithColor;

    public static ScreenEmulatorLauncher getCurrentEmulatorLauncher() {
        return currentEmulatorLauncher;
    }

    public static void setCurrentScreenEditor(IEditorPart editorPart) {
        if (currentEmulatorLauncher != null && editorPart == ScreenEmulatorLauncher.currentEmulatorLauncher.flatEditor) {
            return;
        }
        if (currentEmulatorLauncher != null) {
            currentEmulatorLauncher.unregister();
        }
        IEditorPart currentEditorPart = editorPart;
        if (editorPart == null) {
            currentEmulatorLauncher = null;
            if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                currentEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
            if (!(currentEditorPart instanceof ScreenFlatEditor)) {
                currentEditorPart = null;
            }
        }
        if (currentEditorPart != null) {
            currentEmulatorLauncher = new ScreenEmulatorLauncher();
            ScreenEmulatorLauncher.currentEmulatorLauncher.flatEditor = (ScreenFlatEditor)currentEditorPart;
            ScreenEmulatorLauncher.currentEmulatorLauncher.screen = (PacScreen)((PTFlatEditor)currentEditorPart).getEditorData().getRadicalObject();
            if (screenEmulatorManager != null && screenEmulatorManager.getScreenEmulatorClient() != null && screenEmulatorManager.getScreenEmulatorClient().isLinked()) {
                currentEmulatorLauncher.emulate(isWhithColor);
            }
            currentEmulatorLauncher.addLinkListener();
        }
    }

    public static IScreenEmulatorField ConvertScreenStructure(ScreenPositions.ScreenStructure[] tab, List<IScreenEmulatorField> fields) {
        int tabLength = tab.length;
        ScreenEmulatorField fieldForCursor = null;
        boolean fieldForCursorFound = false;
        ScreenEmulatorField variableFieldForCursor = null;
        boolean firstVariableField = false;
        int i = 0;
        while (i < tabLength) {
            ScreenPositions.ScreenStructure element = tab[i];
            if (element != null) {
                ScreenEmulatorField field = new ScreenEmulatorField();
                field.setLine(element.getPOLEC9());
                field.setColumn(element.getPOCEC9());
                field.setLength(element.getLOLIB());
                PacScreenLabelNatureValues resultL = PacScreenLabelNatureValues.get((String)element.getNARUE());
                if (resultL != null) {
                    if (resultL == PacScreenLabelNatureValues._L_LITERAL) {
                        field.setNature(IScreenEmulatorField.Nature.PROTECTEDNOTRECEIVED);
                    } else if (resultL == PacScreenLabelNatureValues._O_LITERAL) {
                        field.setNature(IScreenEmulatorField.Nature.PROTECTEDNOTRECEIVED);
                    } else if (resultL == PacScreenLabelNatureValues._T_LITERAL) {
                        field.setNature(IScreenEmulatorField.Nature.PROTECTEDNOTRECEIVED);
                    }
                } else {
                    PacScreenFieldNatureValues resultF = PacScreenFieldNatureValues.get((String)element.getNARUE());
                    if (resultF != null) {
                        if (resultF == PacScreenFieldNatureValues._F_LITERAL) {
                            field.setNature(IScreenEmulatorField.Nature.PROTECTEDRECEIVED);
                        } else if (resultF == PacScreenFieldNatureValues._P_LITERAL) {
                            field.setNature(IScreenEmulatorField.Nature.PROTECTEDNOTRECEIVED);
                        } else if (resultF == PacScreenFieldNatureValues._V_LITERAL) {
                            field.setNature(IScreenEmulatorField.Nature.VARIABLE);
                            if (!firstVariableField) {
                                firstVariableField = true;
                                variableFieldForCursor = field;
                            }
                        }
                    }
                }
                PacIntensityAttributeValues resultI = PacIntensityAttributeValues.get((String)element.getATTRI());
                if (resultI != null) {
                    if (resultI == PacIntensityAttributeValues._B_LITERAL) {
                        field.setIntensity(IScreenEmulatorField.Intensity.BRIGHT);
                    } else if (resultI == PacIntensityAttributeValues._D_LITERAL) {
                        field.setIntensity(IScreenEmulatorField.Intensity.DARK);
                    } else if (resultI == PacIntensityAttributeValues._N_LITERAL) {
                        field.setIntensity(IScreenEmulatorField.Intensity.NORMAL);
                    }
                } else {
                    field.setIntensity(IScreenEmulatorField.Intensity.NORMAL);
                }
                PacPresentationAttributeValues resultP = PacPresentationAttributeValues.get((String)element.getATTRP());
                if (resultP != null) {
                    if (resultP == PacPresentationAttributeValues._B_LITERAL) {
                        field.setPresentation(IScreenEmulatorField.Presentation.BLINKING);
                    } else if (resultP == PacPresentationAttributeValues._N_LITERAL) {
                        field.setPresentation(IScreenEmulatorField.Presentation.NORMAL);
                    } else if (resultP == PacPresentationAttributeValues._R_LITERAL) {
                        field.setPresentation(IScreenEmulatorField.Presentation.REVERSEVIDEO);
                    } else if (resultP == PacPresentationAttributeValues._U_LITERAL) {
                        field.setPresentation(IScreenEmulatorField.Presentation.UNDERLINED);
                    }
                } else {
                    field.setPresentation(IScreenEmulatorField.Presentation.NORMAL);
                }
                PacColorAttributeValues resultC = PacColorAttributeValues.get((String)element.getATTRC());
                if (resultC != null) {
                    if (resultC == PacColorAttributeValues._B_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.BLUE);
                    } else if (resultC == PacColorAttributeValues._G_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.GREEN);
                    } else if (resultC == PacColorAttributeValues._NONE_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.NORMAL);
                    } else if (resultC == PacColorAttributeValues._P_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.PINK);
                    } else if (resultC == PacColorAttributeValues._R_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.RED);
                    } else if (resultC == PacColorAttributeValues._T_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.TURQUOISE);
                    } else if (resultC == PacColorAttributeValues._W_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.WHITE);
                    } else if (resultC == PacColorAttributeValues._Y_LITERAL) {
                        field.setColor(IScreenEmulatorField.Color.YELLOW);
                    }
                } else {
                    field.setColor(IScreenEmulatorField.Color.NORMAL);
                }
                field.setLabel(element.getLIBEL());
                if (element.getYPCUR().equals("Y")) {
                    fieldForCursor = field;
                    fieldForCursorFound = true;
                }
                fields.add((IScreenEmulatorField)field);
            }
            ++i;
        }
        if (!fieldForCursorFound) {
            fieldForCursor = variableFieldForCursor;
        }
        Collections.sort(fields, new Comparator<IScreenEmulatorField>(){

            @Override
            public int compare(IScreenEmulatorField arg0, IScreenEmulatorField arg1) {
                if (arg0.getLine() != arg1.getLine()) {
                    return arg0.getLine() - arg1.getLine();
                }
                return arg0.getColumn() - arg1.getColumn();
            }
        });
        return fieldForCursor;
    }

    public static IScreenEmulatorField InitializeFields(PacScreen screen, List<IScreenEmulatorField> fields) {
        ScreenPositions positions = new ScreenPositions();
        positions.analyse(screen, screen.getGenerationParameter());
        ScreenPositions.ScreenStructure[] tab = positions.getAllFields();
        int nbLig = positions.getLineNumber();
        String nbLigS = String.valueOf(nbLig);
        String strL = "00" + nbLigS;
        nbLig2 = strL.substring(strL.length() - 2);
        int nbCol = positions.getColumnNumber();
        String nbColS = String.valueOf(nbCol);
        String strC = "000" + nbColS;
        nbCol3 = strC.substring(strC.length() - 3);
        return ScreenEmulatorLauncher.ConvertScreenStructure(tab, fields);
    }

    private void emulateScreen(boolean withColor) {
        if (this.screen != null && screenEmulatorManager != null && screenEmulatorManager.getScreenEmulator() != null) {
            ArrayList<IScreenEmulatorField> fields = new ArrayList<IScreenEmulatorField>();
            IScreenEmulatorField fieldWithCursor = ScreenEmulatorLauncher.InitializeFields(this.screen, fields);
            screenEmulatorManager.getScreenEmulator().emulate(fields, fieldWithCursor, Integer.parseInt(nbLig2), Integer.parseInt(nbCol3), withColor, false, this.screen.getName());
        }
    }

    public void emulate(final boolean withColor) {
        isWhithColor = withColor;
        if (this.screen != null) {
            if (this.flatEditor.getEditorData().isEditable()) {
                this.adapter = new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        if (ScreenEmulatorLauncher.this.screen != null && screenEmulatorManager != null && screenEmulatorManager.getScreenEmulatorClient() != null && screenEmulatorManager.getScreenEmulatorClient().isLinked()) {
                            ScreenEmulatorLauncher.this.emulateScreen(withColor);
                        }
                    }
                };
                this.screen.eAdapters().add((Object)this.adapter);
            }
            if (this.flatEditor != null) {
                this.emulateScreen(withColor);
            }
        }
    }

    private void addLinkListener() {
        if (screenEmulatorManager != null && screenEmulatorManager.getScreenEmulatorClient() != null) {
            if (this.linkListener != null) {
                screenEmulatorManager.getScreenEmulatorClient().removeScreenEmulatorClientLinkListener(this.linkListener);
            }
            this.linkListener = new IScreenEmulatorClientLinkListener(){

                public void linkChanged(boolean isChecked) {
                    if (isChecked) {
                        ScreenEmulatorLauncher.this.emulate(isWhithColor);
                    }
                }
            };
            screenEmulatorManager.getScreenEmulatorClient().addScreenEmulatorClientLinkListener(this.linkListener);
        }
    }

    private void unregister() {
        if (this.screen != null && screenEmulatorManager != null) {
            this.screen.eSetDeliver(false);
            if (this.adapter != null) {
                this.screen.eAdapters().remove((Object)this.adapter);
            }
            this.screen.eSetDeliver(true);
            this.screen = null;
            if (this.linkListener != null && screenEmulatorManager.getScreenEmulatorClient() != null) {
                screenEmulatorManager.getScreenEmulatorClient().removeScreenEmulatorClientLinkListener(this.linkListener);
            }
        }
    }
}

