/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.tablesegment.pattern;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.interfaces.IGeneratorLauncher;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDataUnit;
import com.ibm.pdp.mdl.pacbase.PacDataUnitTypeValues;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.generator.AbstractPacbasePattern;
import com.ibm.pdp.pacbase.tablesegment.generator.TableSegmentGeneratorLauncher;
import com.ibm.pdp.pacbase.tablesegment.pattern.Messages;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TableSegmentPattern
extends AbstractPacbasePattern {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAC_TABLESEGMENT_EXTENSION = ".dataaggregate";
    private static final String TABLESEGMENT_GENERATION = Messages.PacbaseTableSegmentPattern_TABLESEGMENT_GENERATION;

    public String getName() {
        return "com.ibm.pdp.pacbase.tablesegment";
    }

    public boolean canGenerate(String entryPoint) {
        return this.isOsSupported() && entryPoint.endsWith(PAC_TABLESEGMENT_EXTENSION) && this.isTableDataStructure(entryPoint);
    }

    public String getGenerationMenuName() {
        return TABLESEGMENT_GENERATION;
    }

    public IGeneratorLauncher getGeneratorLauncher() {
        return new TableSegmentGeneratorLauncher(this.getName());
    }

    protected boolean isTableDataStructure(String entryPoint) {
        RadicalEntity re = PTEditorService.getSharedResource((IPath)new Path(entryPoint));
        if (re instanceof DataAggregate) {
            DataAggregate da = (DataAggregate)re;
            DataUnit du = (DataUnit)PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)re, (String)da.getName().substring(0, 2), (String)"dataunit");
            return TableSegmentPattern.isTableDataStructure(du);
        }
        return false;
    }

    public static boolean isTableDataStructure(DataUnit du) {
        Object typDataUnit = null;
        if (du != null) {
            Iterator ext = du.getExtensions().iterator();
            while (ext.hasNext()) {
                try {
                    PacDataUnit pdu = (PacDataUnit)ext.next();
                    typDataUnit = pdu.getDataStructureType();
                }
                catch (Exception exception) {}
            }
        }
        return typDataUnit != null && (typDataUnit.equals(PacDataUnitTypeValues._G_LITERAL) || typDataUnit.equals(PacDataUnitTypeValues._T_LITERAL) || typDataUnit.equals(PacDataUnitTypeValues._M_LITERAL) || typDataUnit.equals(PacDataUnitTypeValues._N_LITERAL));
    }
}

