/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.tablesegment.dataaggregate;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataUnit;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.tablesegment.dataaggregate.DT00PacbaseAndKernelVisitor;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class TableSegmentGenerationDA {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DT00PacbaseAndKernelVisitor dt00pkvisitor;
    private String project;
    private DataAggregate dataAggregate;
    private PacbaseLinksEntitiesService ples;
    private String patternName;

    public TableSegmentGenerationDA(String proj, DataAggregate da, String patternName) {
        this.project = proj;
        this.dataAggregate = da;
        this.patternName = patternName;
        this.transformToW1Model();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        try {
            this.writeTableSegmentTmp();
        }
        catch (Exception e) {
            this.handleException(e);
            Util.rethrow((Throwable)e);
        }
    }

    private void scanPacbaseModel() {
        this.dt00pkvisitor = new DT00PacbaseAndKernelVisitor(this.getPacLinksEntitiesService(), this.dataAggregate);
        this.dt00pkvisitor.setNameOfProject(this.project);
        try {
            if (this.dataAggregate != null) {
                for (Object object : this.dataAggregate.getExtensions()) {
                    if (!(object instanceof PacDataAggregate)) continue;
                    PacDataAggregate da = (PacDataAggregate)object;
                    PacLibrary libDa = da.getGenerationParameter();
                    if (libDa == null) {
                        String nameOfDataUnit = this.dataAggregate.getName().substring(0, 2);
                        RadicalEntity objRA = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.dataAggregate, (String)nameOfDataUnit, (String)"dataunit", (PacbaseLinksEntitiesService)this.ples);
                        DataUnit du = null;
                        PacDataUnit pdu2 = null;
                        if (objRA instanceof DataUnit) {
                            du = (DataUnit)objRA;
                        }
                        for (PacDataUnit pdu2 : du.getExtensions()) {
                            libDa = pdu2.getGenerationParameter();
                        }
                    }
                    this.dt00pkvisitor.doSwitch((EObject)libDa);
                    this.dt00pkvisitor.doSwitch((EObject)this.dataAggregate);
                }
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void writeTableSegmentTmp() {
        File file = PacbaseModelService.getInstance().createTmpFileForGeneration("table", true);
        if (System.getProperty("pactableGeneration.W1.junit.process") != null) {
            System.setProperty("pactableGeneration.W1.junit.process", file.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(file);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List l = this.dt00pkvisitor.getExtractLines();
            for (String lineX : l) {
                w1OutStream.write(String.valueOf(lineX) + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void handleException(Exception exc) {
        System.out.println("*** ERROR ***");
        exc.printStackTrace();
        System.out.println("*** ***** ***");
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    public DT00PacbaseAndKernelVisitor getformatedLines() {
        return this.dt00pkvisitor;
    }
}

